/**
 * Class: Page
 */

/**
 * Method: new
 */
function Page(config) {}

/**
 * Method: init
 */
Page.prototype.init = function(config){
	var _config = {
		api_url:	'/api/mobile/',
		index_view:	'index',
		title:		'EASYGTM'
	};
	
	this.config = config || {};
	
	for (k in _config) if(!this.config[k]) this.config[k] = _config[k];
	
	try {
		this.name = this.my_name();
	} catch(e) {
		throw 'Important! No my_name method added for Page.prototype extension!'
	}
	
}

/**
 * Method: open
 */
Page.prototype.open = function(){
	
	this.before_open();
	
	var buttons_top = [];
	if (!this.config.no_back) {
		buttons_top.push({pos:0, name:"", cssclass:"back image", click:function(){ pager.back(); } });
	}
	
	var ret={
		top: {
			buttons:	buttons_top,
			title: 		this.config.title,
		},
		html: this.get_view('index')
	};
	
	return ret;
}

/**
 * Method: before_open
 */
Page.prototype.before_open = function(v){
	// TO REDEFENITION
}

/**
 * Method: get_view
 */
Page.prototype.get_view = function(view_name){
	return lnrr.View(this.get_view_path(view_name));
}

/**
 * Method: get_view_path
 */
Page.prototype.get_view_path = function(view_name){
	return 'mobile/' + this.name + '/' +(this.config[view_name+'_view'] || view_name);
}

/**
 * Method: on_page_added
 */
Page.prototype.on_page_added = function(v){
	this.init_html();
	this.to_center();
	this.after_page_added();
}

/**
 * Method: init_html
 */
Page.prototype.init_html = function(){
	
	this.html = pager.get_html(this.page_index);
	this.page = pager.get_page(this.page_index);
	
	this.blocks = {
		log:	$('._page_log',this.html),
		error:	$('._page_error',this.html),
		loader:	$('.LNMPager-top .title',this.page),
		state:  $('._page_state',this.html),
		result:  $('._page_result',this.html),
		_centered:$('._to_center',this.html),
	};
	
	this.timers = {
		log: 		 1500,
		error:		 5000,
		aftersubmit: 2500
	};
	
}

/**
 * Method: to_center
 */
Page.prototype.to_center=function(v){
	if (!this.blocks._centered.length) return;
	var m_height = this.html.height();
	var c_height = this.blocks._centered.height();
	
	var top;
	if (c_height < m_height) top = (m_height - c_height)/2;
	this.blocks._centered.css({ 'margin-top' : top || 'initial' })
}

/**
 * Method: on_page_added_custom
 */
Page.prototype.after_page_added=function(v){
	// TO REDEFENITION
}

/**
 * Method: request
 */
Page.prototype.request = function(mode,data,success,error){
	
	if (!mode) throw 'No mode';
	
	var t = this;
	
	if (this.pending) {
		this.error('Загрузка не завершена');
		return;
	}
	
	var request_data = this.fill_request_data(data);
	
	this.set_pending(1, true);
	
	$.ajax({
		url:		this.get_api_url(mode),
		method:		'POST',
		dataType:	'json',
		data:		request_data,	// todo -> send auth data?
		success: 	function(r){
			console.log('response data -> ',r);
			t.set_pending(0, true);
			if (success) success(r,data);
		},
		error: function(e){
			console.log('response error -> ',e);
			t.set_pending(0);
			t.error('Не удалось загрузить данные <br> ' + e.responseText, 1);
			if (error) error(e,data);
		}
	})
}

/**
 * Method: error
 */
Page.prototype.error=function(text, clear_log){
	
	var t = this;
	
	this.blocks.error.html(text);
	clearTimeout(this.error_tid);
	
	this.error_tid = setTimeout(function(){
		t.blocks.error.html('');
	},this.timers.error);
	
	if (clear_log) this.log('');
}


/**
 * Method: log
 */
Page.prototype.log = function(text,clear_error){
	
	var t = this;
	
	clearTimeout(this.log_tid);
	this.blocks.log.html(text);
	
	this.log_tid = setTimeout(function(){
		console.log('setTimeout');
		t.blocks.log.html('');
	},this.timers.log);
	
	if (clear_error) this.error('');
}


/**
 * Method: fill_request_data
 */
Page.prototype.fill_request_data = function(data){
	
	data = data || {};
	
	data.ajaj = 1;
	
	if (data.need_auth) {		
		data.login = localStorage.getItem('login');
		data.password = localStorage.getItem('password');
		data['do-login'] = 1;
	}
	
	return data;
}

/**
 * Method: set_pending
 */
Page.prototype.set_pending=function(v,need_log){
	this.pending = v;
	this.blocks.loader[!this.pending ? 'removeClass' : 'addClass']('A');
	if (need_log) this.log(this.pending ? 'Загрузка данных началась' : 'Загрузка данных завершена', 1);
}

/**
 * Method: get_api_url
 */
Page.prototype.get_api_url = function(api){
	return lnrr.server + this.config.api_url + api + '/';
}


/**
 * Method: on_page_focus
 */
Page.prototype.on_page_focus = function(){
	
	if (this.config.refresh_on_focus) {
		this.before_open();
		pager.set_html(this.page_index,this.get_view('index'));
		this.init_html();
	} else this.refresh();
	
	this.to_center();
}

/**
 * Method: refresh
 */
Page.prototype.refresh = function(){
	// TO REDEFENITION
}



