/**
 * Class: SaveValues
 */

/**
 * Method: new
 */
function SaveValues(){
	this.init({ title:'Сохранение значений' });
}

SaveValues.prototype=new Page();


/**
 * Method: my_name
 */
SaveValues.prototype.my_name = function(){
	return 'SaveValues';
}

/**
 * Method: before_open
 */
SaveValues.prototype.before_open = function(){
	lnrr.values = JSON.parse(window.localStorage.getItem('values'));
}

/**
 * Method: after_page_added
 */
SaveValues.prototype.after_page_added = function(){
	this.refresh();
}

/**
 * Method: refresh
 */
SaveValues.prototype.refresh = function(){
	this.refresh_state();
}

/**
 * Method: refresh_state
 */
SaveValues.prototype.refresh_state=function(){
	
	var arr = [];
	var hash = {};
	var values = window.localStorage.getItem("values");
	
	
	var data = JSON.parse(localStorage.getItem("data"));
	
	if (values) {
		var sensors = JSON.parse(values).sensors;
		for(sid in sensors) {
			if(!hash[sid]) hash[sid] = [];
			for(date_use in sensors[sid]) for(type in sensors[sid][date_use]) hash[sid].push(sensors[sid][date_use][type]);
			arr.push({
				name:	data.hash.sensors[sid].name,
				items:	hash[sid]
			});
		}
	}
	
	lnrr.values = arr;
	
	this.blocks.state.html(this.get_view('state'));
}

/**
 * Method: clear_data
 */
SaveValues.prototype.clear_data=function(){
	window.localStorage.setItem('values','');
}

/**
 * Method: load_data
 */
SaveValues.prototype.send=function(tag) {
	
	var t = this;
	
	var params = {
		need_auth:	1,
		values:		localStorage.getItem('values')
	}
	
	this.request('save_values', params, function(ret){
		t.clear_data(ret);
		setTimeout(function(){ pager.back(); },1500);
	});
}
