package PgWrapperProxy;

use strict;
use utf8;
use Encode;
use IO::Socket::INET;
use IO::Socket::UNIX;
use IO::Select;
#use PgWrapper;
use Time::HiRes qw (tv_interval gettimeofday);
use Storable qw (freeze thaw);

################################################################################################################
sub new {
	my ($class,$login,$password,$db,$driver,$host,$port)=@_;
#	my $self={
#		sql=>new PgWrapper($login,$password,$db,$driver),
#		counters=>{}
#	};
	my $sock;
	if ($port) {
		$sock=new IO::Socket::INET(PeerAddr=>$host,PeerPort=>$port,Proto=>"tcp") or die "Could not connect to PgWrapperServer!\n";
	} else {
		$sock=new IO::Socket::UNIX(Peer=>$host) or die "Could not connect to PgWrapperServer!\n";
	}
	my $self={sock=>$sock};
	bless ($self,$class);
	return $self;
}

################################################################################################################
sub send {
	my ($self,$cmd,@args)=@_;
	my $pack=freeze(\@args);
	$self->{sock}->send($cmd." ".length($pack)." ");
	$self->{sock}->send($pack);
	my $r="";
	my $len;
	my $skip=0;
#	warn "Sending data to server, $cmd, pack length=".length($pack)."\n";
	while ($skip==0 || length($r)<$len+$skip) {
		my $tmp;
		$self->{sock}->recv($tmp,1500);
		die "$!" unless length $tmp;
		$r.=$tmp;
		if ($skip==0) {
			if ($r=~/^OK (\d+) /) {
				$len=$1;
				$skip=2+1+length($1)+1;
			}
		}
	}
	my $packed=substr($r,$skip,$len);
	my $ret=thaw($packed);
	if ($cmd=~/_one$/) {
		return $ret->[0];
	}
	return @$ret;
}

################################################################################################################
sub DESTROY {my $self=shift @_; }
sub commit 									{my $self=shift @_;$self->send("commit"); }
#sub set_paths 								{my $self=shift @_;$self->{sql}->set_paths(@_); }
#sub last_insert_id							{my $self=shift @_;$self->{sql}->last_insert_id(@_); }
#sub read_file								{my $self=shift @_;$self->{sql}->read_file(@_); }
#sub rebuild									{my $self=shift @_;$self->{sql}->rebuild(@_); }
#sub rebuild_hash							{my $self=shift @_;$self->{sql}->rebuild_hash(@_); }
#sub fetch									{my $self=shift @_;$self->{sql}->fetch(@_); }
#sub bind									{my $self=shift @_;$self->{sql}->bind(@_); }
#sub bind_error								{my $self=shift @_;$self->{sql}->bind_error(@_); }
sub execute									{my $self=shift @_;$self->send("execute",@_); }
sub execute_and_fetch						{my $self=shift @_;$self->send("execute_and_fetch",@_); }
sub execute_and_fetch_one					{my $self=shift @_;$self->send("execute_and_fetch_one",@_); }
sub execute_and_fetch_h						{my $self=shift @_;$self->send("execute_and_fetch_h",@_); }
sub execute_and_fetch_h_real				{my $self=shift @_;$self->send("execute_and_fetch_h_real",@_); }
sub execute_and_fetch_rev_h					{my $self=shift @_;$self->send("execute_and_fetch_rev_h",@_); }
sub execute_bind							{my $self=shift @_;$self->send("execute_bind",@_); }
sub execute_bind_and_fetch					{my $self=shift @_;$self->send("execute_bind_and_fetch",@_); }
sub execute_bind_and_fetch_one				{my $self=shift @_;$self->send("execute_bind_and_fetch_one",@_); }
sub execute_bind_and_fetch_single			{my $self=shift @_;$self->send("execute_bind_and_fetch_single",@_); }
sub execute_bind_and_fetch_h				{my $self=shift @_;$self->send("execute_bind_and_fetch_h",@_); }
sub execute_bind_and_fetch_tree				{my $self=shift @_;$self->send("execute_bind_and_fetch_tree",@_); }
sub execute_bind_and_fetch_single_recurse	{my $self=shift @_;$self->send("execute_bind_and_fetch_single_recurse",@_); }
sub execute_bind_single 					{my $self=shift @_;$self->send("execute_bind_single",@_); }

################################################################################################################

1;

