#!/usr/bin/perl -w

use strict;

use DBI;

{
	die "Usage:\n$0 driver user/password\@database file_to_load\n" unless @ARGV==3;
	my $driver=$ARGV[0];
	$ARGV[1]=~/^(.+)\/(.+)\@(.+)$/ or die "Can not parse arg2\n";
	my ($login,$password,$db)=($1,$2,$3);
	my $dbh;
	open IN, $ARGV[2] or die "Can not open $ARGV[2]\n";
	$dbh=DBI->connect("dbi:$driver:$db",$login,$password,{RaiseError=>1,AutoCommit=>0});
	$dbh->{LongTruncOk}=1;
	$dbh->{LongReadLen}=262144;
	my $sth;
	my $sth_test;
	my $sth_del;
	my $sth_now;
	my @args;
	my $i;
	my $cnt;
	my $sth_p;
	while (<IN>) {
		chomp;
		next if $_ eq "";
		if (/^\#/) {
			if (/^\#\!(.+)$/) {
				$sth=$dbh->prepare($1);
				$sth->{LongTruncOk}=1;
				$sth->{LongReadLen}=262144;
				$sth_test="";
				$sth_del="";
			}
			$sth_test=$dbh->prepare($1) if /^\#\?(.+)$/;
			$sth_del=$dbh->prepare($1) if /^\#\-(.+)$/;
			if (/^\#\>(.+)$/) {
				$sth_now=$dbh->prepare($1);
				warn "$1;\n";
			}
			if (/^\#\< '(.*?)' (.*)$/) {
				my $file=$1;
				my $sql=$2;
				my $sth=$dbh->prepare($2);
				$sth->execute();
				my $i=$sth->fetchrow_arrayref();
				open OUT,">$file";
				print OUT $i->[0];
				close OUT;
				warn "$sql => writing '".$i->[0]."' to $file\n";
			}
			if (/^\#P (.*)$/) {
				$sth_p=$1;
			}
			if ($sth_now) {
				$sth_now->execute();
				$sth_now=undef;
			}
		} else {
			die "No sth !\n" unless $sth || $sth_p;
			@args=split(/\s*\,/,$_);
			$i=0;
			while ($i!=@args) {
				my @tmp=($args[$i]=~/(\')/g);
				$cnt=@tmp;
				if (int($cnt/2)*2!=$cnt) {
					die "String $_ is invalid !\n" if @args==$i+1;
					$args[$i].=','.splice(@args,$i+1,1);
				} else {
					$i++;
				}
			}
			foreach (@args) {
				if (/^\@(.+)$/) {
					open IN2,$1 or die "Can not open $1\n";
					{local $/;$_=<IN2>;}
					close IN2;
				} else {
					s/^\s*(.*?)\s*$/$1/g;
					s/^\'(.*)\'$/$1/;
				}
			}
			print "Adding ".join(",",map {/\n/?"Multy-string":$_} @args)."\n";
			if ($sth_test) {
				$sth_test->execute($args[0]);
				if ($sth_test->fetchrow_hashref()) {
					if ($sth_del) {
						warn "Removing old entry\n";
						$sth_del->execute($args[0]);
						$sth->execute(@args);
					} else {
						warn "Skipping !\n";
					}
					$sth_test->finish();
				} else {
					$sth->execute(@args);
				}
			} elsif ($sth_p) {
				my $p=$sth_p;
				$p=~s/\$(\d+)/$args[$1-1]/ge;
				warn "$p\n";
			} else {
				$sth->execute(@args);
			}
		}
	}
	close IN;
	$dbh->commit();
	$dbh->disconnect();

}
