var fs=require('fs');
exports.add=[
{
	_type:"controller",
	_config_details: {	
	},
	_config: {
		path:"adminpanel/",
		name:"AdminModelGenerator",
		admin:1,
		role_code:"settings"
	},
	
	_admin_nav: [
		{section:"hardsettings",name:"Model generator",mode:"index"}
	],

	/**
	 * Controller: AdminModelGenerator._init_mg
	 */
	_init_mg: function(config) {
		var mg=new this.system.LNModelGenerator(this.site.sql,this.views);
		if (this.site.systemwide_models) {
			mg.init(system.getcwd()+"/database/config.js",this.system.paths.sql,this.system.paths.ssjs);

		} else if (this.site.subsystemwide_models) {
			if (!(this.system.paths.sql.length>1)) return "Cannot make subsystemwide_models";
			mg.init(this.system.paths.database[0]+"/config.js",this.system.paths.sql[0],this.system.paths.ssjs[0]);
			for (var i=1;i<this.system.paths.sql.length;i++) {
				mg.add_parent(this.system.paths.database[i]+"config.js",this.system.paths.sql[i],this.system.paths.ssjs[i]);
			}
		} else {
			var dir=new fs.Directory(this.site.paths.database);
			if (!dir.exists()) {
				if (!dir.create()) return "Directory "+this.site.paths.database+" is not writable!";
			}
			mg.init(this.site.paths.database+"/config.js",this.site.paths.sql,this.site.paths.ssjs);
			for (var i=0;i<this.system.paths.database.length;i++) {
				mg.add_parent(this.system.paths.database[i]+"config.js",this.system.paths.sql[i],this.system.paths.ssjs[i]);
			}
		}
		return mg;
	},

	/**
	 * Controller: AdminModelGenerator.index 
	 *
	 * Returns:
	 *		HTML
	 */
	index: function(config) {
		var mg=this.CC("_init_mg");
		this.models=mg.config;
		return this.Cview();
	},

	/**
	 * Controller: AdminModelGenerator.tune
	 *
	 * Returns:
	 *		HTML
	 */
	tune: function(config) {
		var t=this;
		var mg=this.CC("_init_mg");
		this.model=mg.find(this.fields.name);

		for (var i=0;i<this.model.patches.lists.length;i++) {
			var l=this.model.patches.lists[i];
			var file;
			if (this.site.systemwide_models) file=system.getcwd()+"/code/sql/"; else file=this.site.paths.sql;
			file+="_models/"+this.model.folder+"/"+l.name+".sql";
			var f=new fs.File(file);
			if (f.exists()) {
				f.open("r");
				l.preview=f.read().toString("utf-8");
				f.close();
			} else {
				l.preview="No file found:\n"+file;
			}
		}
		this.modelcopy={
			columns:mg.gen_patched_columns(this.model,"columns"),
			columns_l10n:mg.gen_patched_columns(this.model,"columns_l10n"),
			extra_fields: []
		};
		function extra_fields(p,arr,l10n)
		{
			if (!arr) return;
			for (var i=0;i<arr.length;i++) p.push({name:arr[i].name,datatype:arr[i].datatype,l10n:l10n});
		}
		extra_fields(this.modelcopy.extra_fields,this.model.patches.extra_fields,0);
		extra_fields(this.modelcopy.extra_fields,this.model.patches.extra_fields_l10n,1);
		return this.Cview();
	},

	/**
	 * Controller: AdminModelGenerator.tune_save 
	 *
	 * Returns:
	 *		JSON Object
	 */
	tune_save: function(config) {
		var t=this;
		var mg=this.CC("_init_mg");
		var obj=mg.find(this.fields.id);
		obj.patches.lists=[];
		for (var k in this.fields) {
			if (k.match(/^model_listinfo_/)) obj.patches.lists.push(JSON.parse(this.fields[k]));
		}
		["enabled","role","section","label","cols_through","listname","listhelperfunc","edithelperfunc","savehelperfunc","prehelperfunc","impexphelperfunc","list_fk_column"].forEach(function(a) {obj.adminpanel[a]=t.fields["adminpanel_"+a];});

		["columns","columns_l10n"].forEach(function(ct) {
			var h=JSON.parse(t.fields["grid_"+ct]);
			for (var k in h) {
				var arr=k.match(/(\w+)-changed_(\w+)/);
				if (!arr) continue;
				mg.set_column_patch_parameter(obj,ct,arr[1],arr[2],h[k]);
//				throw [obj.patches,ct,arr[1],arr[2],h[k]];
			}
		});
		var h=JSON.parse(this.fields.extra_fields);
		obj.patches.extra_fields=[];
		obj.patches.extra_fields_l10n=[];
		for (var k in h) {
			var arr=k.match(/^(\w+)-L10N$/);
			if (!arr) continue;
			var f={name:h[arr[1]+"-name"],datatype:h[arr[1]+"-datatype"]};
			if (h[k]=="0") obj.patches.extra_fields.push(f); else obj.patches.extra_fields_l10n.push(f);
		}
		mg.save_config();
		return JSON.stringify({redirect:{url:this.action}});
	},

	/**
	 * Controller: AdminModelGenerator.reparse_all
	 *
	 * Returns:
	 *		HTML
	 */
	reparse_all: function(config) {
		var mg=this.CC("_init_mg");
		var ret=mg.parse_all();
		if (!ret) mg.save_config();
		this.ret=ret;
		return this.Cview();
	},

	/**
	 * Controller: AdminModelGenerator.build_all
	 *
	 * Returns:
	 *		HTML
	 */
	build_all: function(config) {
		var mg=this.CC("_init_mg");
		var ret=mg.build_all();
		this.ret=ret;
		return this.Cview();
	},

	/**
	 * Controller: AdminModelGenerator.edit
	 *
	 * Returns:
	 *		HTML
	 */
	edit: function(config) {
		this.model={};
		if (this.fields.name) {
			var mg=this.CC("_init_mg");
			this.model=mg.find(this.fields.name);
		}
		return this.Cview();
	},

	/**
	 * Controller: AdminModelGenerator.edit_save
	 *
	 * Returns:
	 *		HTML
	 */
	edit_save: function(config) {
		var mg=this.CC("_init_mg");
		if (this.fields.id && this.fields.id.length) {
			var obj=mg.find(this.fields.id);
			obj.name=this.fields.name;
			obj.table=this.fields.table;
			obj.folder=this.fields.folder;
		} else {
			var obj=mg.add({table:this.fields.table,name:this.fields.name,folder:this.fields.folder});
			mg.parse(obj);
		}
		mg.save_config();
		return JSON.stringify({redirect:{url:this.action}});
	},

	/**
	 * Controller: AdminModelGenerator.delete
	 *
	 * Returns:
	 *		HTML
	 */
	"delete": function(config) {
		var mg=this.CC("_init_mg");
		this.model=mg.find(this.fields.name);
		return this.Cview();
	},

	/**
	 * Controller: AdminModelGenerator.delete2
	 *
	 * Returns:
	 *		HTML
	 */
	delete2: function(config) {
		var mg=this.CC("_init_mg");
		if (this.fields.id) {
			mg.del(this.fields.id);
		}
		mg.save_config();
		return JSON.stringify({redirect:{url:this.action}});
	}
}];

