var fs=require("fs");
var process=require("process");

function encode(val)
{
	if (val==null) return "";
	return val.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;");
}


exports.add=[
{
	_type:"controller",
	_config_details: {	
	},
	_config: {
		path:"adminpanel/",
		name:"AdminSpreadsheets",
		admin:1,
		role_code:"files"
	},
	
	_admin_nav: [
//		{section:"modules",name:"Market",mode:"index"}
	],

	/**
	 * Controller: AdminSpreadsheets.index
	 *
	 * Returns:
	 *		HTML
	 */
	index: function(config) {
		this.spreadsheets=this.site.models.Spreadsheet.List();
		return this.Cview();
	},

	/**
	 * Controller: AdminSpreadsheets.view
	 *
	 * Returns:
	 *		HTML
	 */
	view: function(config) {
		this.spreadsheet=this.site.models.Spreadsheet.Get(this.fields.spreadsheet_id);
		
		this.worksheets=this.site.models.Worksheet.List("list_of_spreadsheet",{spreadsheet_id:this.spreadsheet.id});
		this.active_worksheet=this.worksheets[0];
		if (this.fields.worksheet_id) {
			for (var i=0;i<this.worksheets.length;i++) {
				if (this.fields.worksheet_id==this.worksheets[i].id) this.active_worksheet=this.worksheets[i];
			}
		}
		this.active_worksheet.active=1;
		var minmax=this.site.sql.execute_and_fetch_one("cells/get_minmax",{worksheet_id:this.active_worksheet.id});
		var data="";
		
		for (var y=0;y<minmax.maxy+1;y++) {
			data+="<tr>";
			var row=this.site.sql.execute_and_fetch("cells/list_row",{worksheet_id:this.active_worksheet.id,y:y});
			var pos=0;
			for (var x=0;x<minmax.maxx+1;x++) {
				while (pos<row.length && row[pos].x<x) pos++;
				if (pos>=row.length || row[pos].x!=x) {
					data+="	<td></td>\n";
				} else {
					data+="	<td>"+encode(row[pos].value)+"</td>\n";
				}
			}
			data+="</tr>\n";
		}
		this.data=data;
		return this.Cview();
	},

	/**
	 * Controller: AdminSpreadsheets.delete
	 */
	"delete": function(config) {
		return this.Cview();
	},

	/**
	 * Controller: AdminSpreadsheets.delete2
	 */
	"delete2": function(config) {
		var t=this;
		this.site.models.Worksheet.List("list_of_spreadsheet",{spreadsheet_id:this.fields.spreadsheet_id}).forEach(function(ws) {
			t.site.sql.execute_single("delete from Tcells where worksheet_id=:worksheet_id",{worksheet_id:ws.id});
			ws.Delete();
		});
		this.site.models.Spreadsheet.Get(this.fields.spreadsheet_id).Delete();
		return JSON.stringify({redirect:{url:"/admin-AdminSpreadsheets/"}});
	},

	/**
	 * Controller: AdminSpreadsheets.export
	 */
	"export": function(config) {
		return this.F("Spreadsheets","echo_xlsx", fs, process, this.fields.spreadsheet_id);
	},

	/**
	 * Controller: AdminSpreadsheets.upload
	 */
	upload: function(config) {
		return this.Cview();
	},

	/**
	 * Controller: AdminSpreadsheets.upload2
	 */
	upload2: function(config) {
		var fileinfo=this.req.files.file;
		var ext=fileinfo.originalName.match(/\.(\w+)$/)[1];
		var file=new fs.File("/tmp/lattenoir-upload-"+Math.floor(Math.random()*1000000)+"."+ext.toLowerCase());
		file.open("w");
		file.write(fileinfo.data);
		file.close();
		var p=new process.Process();
        p.system(system.getcwd()+"/files/xls_import.pl "+this.site.database.login+" "+this.site.database.password+" "+this.site.database.database+" "+file.toString());
		file.remove();
		this.site.sql.execute_single("update Tspreadsheets set name=:name where id in (select max(id) from Tspreadsheets)",{name:fileinfo.originalName});
		return JSON.stringify({redirect:{url:"/admin-AdminSpreadsheets/"}});
	}
}];

