var http=require("http");
var base64=require("base64");

exports.add=[{
	_type:"controller",
	_config:{
		name:"ApiPaymentServices",
	},

	ok_callback: function() {

	},

	/**
	 * Controller: ApiPaymentServices.fotostrana_withdraw_redirect
	 */
	fotostrana_withdraw_redirect: function() {
		// https://pnd666.ru/shop/?result=success&sessionKey=57284f707ba9dad6fc39e1733cc01946696a4f192eef18&authKey=8ccd73fc1cdae929e8de460bcde6fc00&appId=pnd&viewerId=84209538&apiUrl=http%3A%2F%2Ffotostrana.ru%2Fapifs.php&money=0.1
		var ret=this.F("ApiPaymentServices","fotostrana_withdraw",{money:this.fields.money,psi_id:this.fields.extra});
		this.ln_response.render_303_redirect(this.psi.redirect);
		return "";
	},

	/**
	 * Controller: ApiPaymentServices.fotostrana_withdraw_json
	 */
	fotostrana_withdraw_json: function() {
		var ret=this.F("ApiPaymentServices","fotostrana_withdraw",{money:this.fields.money,psi_id:this.fields.psi_id});	
		return JSON.stringify({ok:1});
	},

	xsolla_callback: function() {
		var json=JSON.parse(this.req.post_unparsed.toString("utf-8"));
		switch (json.notification_type) {
			case "user_validation":
				var u=this.site.models.User.Get(json.user.id);
				this.jsng_response.render_http_error(this,u?204:404,u?"No Content":"Not found");
				return "";
				break;
			case "payment":
				this.F("ApiPaymentServices","invoice_pay",json.custom_parameters.psi_id,json.purchase.checkout.amount,{pay_json:json});
				return "";
				break;
		}
		this.jsng_response.render_http_error(this,404,"Unknown mode");
		return "Unknown mode";
	},

	xsolla_thankyou: function() {

	},

	yandex_check: function() {

	},

	yandex_aviso: function() {

	}

},{
	_type:"functions",
	_section:"ApiPaymentServices",

	/**
	 * Function: ApiPaymentServices.invoice_create
	 * Parameters:
	 *		config.user_id typeof Integer		-
	 *		config.amount typeof Numeric		-
	 *		config.module_name typeof String	-
	 *		config.module_fid typeof Integer	-
	 *		config.module_json typeof Object	-
	 *		config.service_name typeof String	-
	 *		config.service_json typeof Object	-
	 *		config.redirect typeof String		-
	 */
	invoice_create: function(config) {
		var psi=this.site.models.PaymentServiceInvoice.Create();
		psi.amount				=config.amount;
		psi.user_id				=config.user_id||this.uid;
		psi.module_name			=config.module_name;
		psi.module_fid			=config.module_fid;
		psi.module_json			=config.module_json || {};
		psi.service_name		=config.service_name;
		psi.service_json		=config.service_json || {};
		psi.redirect			=config.redirect;
		psi.payed				=0;
		psi.ask_remote_addr		=system.env.REMOTE_ADDR;
		psi.ask_user_agent_id	=this.F("Functions","user_agent_id");
		this.F("ApiPaymentServices","invoice_create_pre__"+config.service_name,psi,config);
		psi.SaveAll();
		this.psi=psi;
		var ret=this.F("ApiPaymentServices","invoice_create_post__"+config.service_name,psi,config);
		this.site.sql.commit();
		return {action:ret,psi:psi};
	},

	/**
	 * Function: ApiPaymentServices.invoice_create_pre__xsolla
	 */
	invoice_create_pre__xsolla: function(psi,config) {

		psi.SaveAll();
		var request=new http.ClientRequest("https://api.xsolla.com/merchant/merchants/"+this.site.userprofile.xsolla_merchant_id+"/token");
		var h={
			user: {
				id: {value: this.uid,hidden: true},
//	            email: {value: this.user.login },
	            country: { value: "RU", allow_modify: true},
	        },
			purchase: { checkout: { amount: psi.amount,currency: psi.service_json.currency }, description: { value: psi.module_json.description} },
	        settings: {project_id: this.site.userprofile.xsolla_project_id, language: "ru", mode: this.site.userprofile.xsolla_test?"sandbox":"" },
			custom_parameters: { psi_id: psi.id},
		};
//		throw h;
		request.post=JSON.stringify(h);
		request.header({
			"Accept": "application/json",
    		"Content-Type": "application/json",
			"Authorization": "Basic "+base64.encode(this.site.userprofile.xsolla_merchant_id+":"+this.site.userprofile.xsolla_merchant_key).toString("utf-8"), //-u your_merchant_id:merchant_api_key \
		});
		request.method="POST";
		var response = request.send(true);
/*		throw {
			data:response.data.toString('utf-8'),
			response_status:response.status,
			up:base64.encode(this.site.userprofile.xsolla_merchant_id+":"+this.site.userprofile.xsolla_merchant_key).toString("utf-8")
		};*/
		var ret=JSON.parse(response.data.toString('utf-8'));
		psi.service_json.token=ret.token;
	},

	/**
	 * Function: ApiPaymentServices.invoice_create_post__xsolla
	 */
	invoice_create_post__xsolla: function(psi,config) {
		return {html:this.View("system/ApiPaymentServices/invoice_create_actions/xsolla")};
	},

	/**
	 * Function: ApiPaymentServices.invoice_create_pre__yandex
	 */
	invoice_create_pre__yandex: function(config) { },

	/**
	 * Function: ApiPaymentServices.invoice_create_post__yandex
	 */
	invoice_create_post__yandex: function(config) { return {html:this.View("system/ApiPaymentServices/invoice_create_actions/yandex")}; },

	/**
	 * Function: ApiPaymentServices.invoice_get
	 */
	invoice_get: function(id) {
		var ap=this.site.models.PaymentServiceInvoice.Get(id);
		return ap;
	},

	/**
	 * Function: ApiPaymentServices.invoice_pay_error
	 * Parameters:
	 *		id typeof Integer					-
	 *		amount typeof Numeric				-
	 *		config typeof Object				-
	 *		psi typeof PaymentServiceInvoice	-
	 *		error typeof String					-
	 */
	invoice_pay_error: function(id,amount,config,psi,error) {
		var pse=this.site.models.PaymentServiceError.Create();
		pse.psi_id				=id;
		pse.amount				=amount;
		pse.error				=error;
		pse.pay_remote_addr		=system.env.REMOTE_ADDR;
		pse.pay_user_agent_id	=this.F("Functions","user_agent_id");
		pse.pay_json			=config.pay_json||{};
		pse.SaveAll();
		this.site.sql.commit();
		return error;
	},

	/**
	 * Function: ApiPaymentServices.invoice_pay
	 * Parameters:
	 *		id typeof Integer				-
	 *		amount typeof Numeric			-
	 *		config typeof Object			-
	 *		config.pay_json typeof Object	-
	 */
	invoice_pay: function(id,amount,config) {
		var psi=this.psi=this.site.models.PaymentServiceInvoice.Get(id);
		if (!psi) return this.F("ApiPaymentServices","invoice_pay_error",id,amount,config,psi,"PSI does not exist");
		if (psi.payed) return this.F("ApiPaymentServices","invoice_pay_error",id,amount,config,psi,"Already payed");
		if (Math.abs(psi.amount-amount)>0.01) return this.F("ApiPaymentServices","invoice_pay_error",id,amount,config,psi,"Amounts differ");
		psi.payed				=1;
		psi.pay_remote_addr		=system.env.REMOTE_ADDR;
		psi.pay_user_agent_id	=this.F("Functions","user_agent_id");
		psi.pay_json			=config.pay_json||{};
		psi.SaveAll();
		this.site.sql.commit();
		try {
			this.F("ApiPaymentServices",psi.module_name,psi);
		} catch(e) {
			this.F("ApiPaymentServices","invoice_pay_error",id,amount,config,psi,e);
		}
		return undefined;
	},

	/**
	 * Function: ApiPaymentServices.fotostrana_genurl_spend_money
	 */
	fotostrana_genurl_spend_money: function(amount,ret_url) {
		var sn=this.site.models.SocialNetwork.Get("get_by_code",{code:"fotostrana"});
		var sna=this.site.models.SocialNetworkAccount.Get("get_by_network_and_user",{network_id:sn.id,user_id:this.uid});
		var params={
			method		:'MobEvents.spendMoney',
			amount		:amount,
			"return"	:ret_url,
			sessionKey	:sna.access_token,
			viewerId	:sna.fid,
		};
		var url=this.F("UserProfile","_fotostrana_genurl_request",params,sna.fid,"http://m.fotostrana.ru/applications");
		return url;
	},

	/**
	 * Function: ApiPaymentServices.fotostrana_withdraw
	 * Parameters:
	 *		options.money
	 *		options.psi_id
	 *
	 * Returns:
	 *		typeof String		- Error, null if OKAY
	 */
	fotostrana_withdraw: function(options) {
		var sn=this.site.models.SocialNetwork.Get("get_by_code",{code:"fotostrana"});
		var sna=this.site.models.SocialNetworkAccount.Get("get_by_network_and_user",{network_id:sn.id,user_id:this.uid});

		var ret=this.F("UserProfile","_fotostrana_request",{
				method	:"Billing.withDrawMoneySafe",
				userId	:sna.fid,
				money	:options.money
			},sna.fid);
		if (ret.response && ret.response.transferred) {
			return this.F("ApiPaymentServices","invoice_pay",options.psi_id,ret.response.transferred,{pay_json:ret});
		} else {
			return "ERROR\n"+this.F("ApiPaymentServices","invoice_pay_error",options.psi_id,0,{pay_json:ret},this.site.models.PaymentServiceInvoice.Get(options.psi_id),"ERROR");
		}
	},

}];
