exports.add=[{
	_type:"controller",
	_config_details: {
		
	},
	_config: {
		name: "Guestbook",
		guestbook_code:"",
		preview:"8C",
		avatar_upload:false,
		short_limit: 5,
		short_url: "/guestbook/"
	},
	/**
	 * Controller: Guestbook.index
	 *
	 * Returns:
	 *		HTML
	 */
	index: function(config) {
		this.configGuestbook=config;
		this.guestbook=this.site.models.Guestbook.List("get_by_code",{code:config.guestbook_code})[0];

		var listname=this.guestbook.premoderated?"list_of_guestbook_moderated_limited":"list_of_guestbook_limited";
		this.guestbook_messages=this.site.models.GuestbookMessage.List(listname,{guestbook_id:this.guestbook.id,limit:100000});
		return this.Cview();
	},
	/**
	 * Controller: Guestbook.short
	 *
	 * Returns:
	 *		HTML
	 */
	"short": function(config) {
		this.configGuestbook=config;
		this.guestbook=this.site.models.Guestbook.List("get_by_code",{code:config.guestbook_code})[0];
		this.guestbook_messages=this.site.models.GuestbookMessage.List("list_of_guestbook_moderated_limited",{guestbook_id:this.guestbook.id,limit:config.limit_short});
		return this.Cview();
	},
	/**
	 * Controller: Guestbook.save
	 *
	 * Returns:
	 *		HTML
	 */
	write: function(config) {
		var gb=this.guestbook=this.site.models.Guestbook.List("get_by_code",{code:config.guestbook_code})[0];
		
		var errors={};
		
		if (this.fields.captcha!="127") errors.captcha=this.F("Views","L","controllers/Guestbook","not a human",1);

		if (this.fields.user_q_name.length<2) {
			errors.user_q_name=this.F("Views","L","controllers/Guestbook","Too short",1);
		} else if (this.fields.user_q_name.match(/[^\wа-яА-Я \-\_\']/)) {
			errors.user_q_name=this.F("Views","L","controllers/Guestbook","Incorrect characters",1);
		} else if (this.fields.user_q_name.length>64) {
			errors.user_q_name=this.F("Views","L","controllers/Guestbook","Toolong",1);
		}
		
		
		if (this.fields.user_q_phone.length<2) {
			errors.user_q_phone=this.F("Views","L","controllers/Guestbook","Too short",1);
		} else if (this.fields.user_q_phone.match(/[^\wа-яА-Я \-\_\'\(\)\+\.]/)) {
			errors.user_q_phone=this.F("Views","L","controllers/Guestbook","Incorrect characters",1);
		} else if (this.fields.user_q_phone.length>64) {
			errors.user_q_phone=this.F("Views","L","controllers/Guestbook","Toolong",1);
		}
		
		if (this.fields.nophone && !this.fields.user_q_phone) delete errors.user_q_phone;

		if (this.fields.user_q_email.length<2) {
			errors.user_q_email=this.F("Views","L","controllers/Guestbook","Too short",1);
		} else if (this.fields.user_q_email.match(/[^\w\.\-\_\@]/)) {
			errors.user_q_email=this.F("Views","L","controllers/Guestbook","Incorrect characters",1);
		} else if (this.fields.user_q_email.length>64) {
			errors.user_q_email=this.F("Views","L","controllers/Guestbook","Toolong",1);
		}

		if (this.fields.question.length<2) {
			errors.question=this.F("Views","L","controllers/Guestbook","Too short",1);
		}

		var flag=0;
		for (var k in errors) flag=1;
		if (flag) return JSON.stringify({call:"GuestbookFuncs.write_error",errors:errors});

		var gbm=this.site.models.GuestbookMessage.Create();
		gbm.guestbook_id=gb.id;
		gbm.user_q_name=this.fields.user_q_name;
		gbm.user_q_phone=this.fields.user_q_phone;
		gbm.user_q_email=this.fields.user_q_email;
		// gbm.user_q_avatar_id= // TODO avatar
		gbm.user_a_id=config.default_user_a_id;
		gbm.question=this.fields.question;
		gbm.moderated=0;
		var date = new Date();
		date = pad(date.getDate()) + "." + pad(date.getMonth() + 1) + "." + date.getFullYear() + " " + pad(date.getHours()) + ":" + pad(date.getMinutes()) + ":" + pad(date.getSeconds());
		
		function pad(n) {
			return (n < 10) ? ("0" + n) : n;
		}
		gbm.date_question = date;
		gbm.SaveAll();

		this.msg=gbm;

		// Отсылка email сотруднику
		//this.F("Functions","send_mail","guestbook_manager_send",{},0);
		for (var i=1;i<3;i++) {
			if (!gb["mail_template"+i+"_id"]) continue;
			var mt=this.site.models.MailTemplate.Get(gb["mail_template"+i+"_id"]);
			this.F("Functions","send_mail",mt.code,0);
		}
		

		return JSON.stringify({call:"GuestbookFuncs.written"});
	}
}];

