var http=require("http");
var hash=require("hash");
var mail=require("mail")

var default_check_register={
		login:{type:"email_exists",min:1,max:128},
		password1:{type:"password1",min:1,max:128},
		password2:{type:"password2",min:1,max:128},
		first_name:{min:1,max:128},
		second_name:{min:0,max:128},
		last_name:{min:1,max:128},
		phone:{min:0,max:128},
};

var default_check_update={
		first_name:{min:1,max:128},
		second_name:{min:0,max:128},
		last_name:{min:1,max:128},
		phone:{min:0,max:128},
};



exports.add=[{
	_type:"controller",
	_config: {
		name:"UserProfile",
	},

	/**
	 * Controller: UserProfile.index
	 *		Shows user info and possible actions such as change password and such
	 */
	index: function(config) {
		this.configUserprofile=config;
		config.tab="index";
		if (!this.uid) return this.C("UserProfile","login_register");
		return this.Cview();
	},

	/**
	 * Controller: UserProfile.change_password
	 */
	change_password: function(config) {
		this.configUserprofile=config;
		config.tab="change_password";
		return this.Cview();
	},
	
	/**
	 * Controller: UserProfile.change_password2
	 */
	change_password2: function(config) {
		if (!this.user.PasswordOk(this.fields.old_password)) return JSON.stringify({call:"UserProfileFuncs.change_password_error",errors:{old_password:this.LC("Pasword incorrect")}});
		var check_chpass={
			password1:{type:"password1",min:1,max:128},
			password2:{type:"password2",min:1,max:128},
		};
		var errors=this.F("UserAuth","register_check",check_chpass);
		if (errors) return JSON.stringify({call:"UserProfileFuncs.change_password_error",errors:errors});
		this.user.PasswordSet(this.fields.password1,1);
		this.user.SaveAll();

		return JSON.stringify({redirect: {url:this.action+"?mode=change_password3"}});
	},

	/**
	 * Controller: UserProfile.change_password3
	 */
	change_password3: function(config) {
		this.configUserprofile=config;
		config.tab="change_password";
		return this.Cview();
	},

	/**
	 * Controller: UserProfile.change_info
	 */
	change_info: function(config) {
		this.configUserprofile=config;
		config.tab="change_info";
		return this.Cview();
	},
	
	/**
	 * Controller: UserProfile.change_info2
	 */
	change_info2: function(config) {
		var h=this.F("UserAuth","join_checks","check_update",config,default_check_update);
		var errors=this.F("UserAuth","register_check",h);
		if (errors) return JSON.stringify({call:"UserProfileFuncs.change_info_error",errors:errors});
		var u=this.site.models.User.Get(this.uid);
		for (var k in h) {
			u[k]=this.fields[k];
		}
		this.user=u;
		if (this.req.files.avatar) {
			var fid=this.F("Files","user_upload_file",{inputname:"avatar",ff_id:this.site.models.FileFolder.Get("get_by_code",{code:"avatars"}).id});
			if (fid) u.avatar_id=fid;
		}
		u.SaveAll();
		return JSON.stringify({redirect: {url:this.action+"?mode=change_info3"}});
	},

	/**
	 * Controller: UserProfile.change_info3
	 */
	change_info3: function(config) {
		this.configUserprofile=config;
		config.tab="change_info";
		return this.Cview();
	},

	/**
	 * Controller: UserProfile.login_register
	 */
	login_register: function() {
		return this.Cview();
	},

	/**
	 * Controller: UserProfile.register_auto
	 */
	register_auto: function() {
		// TODO automatically register user as some 'guest'
	},

    /**
	 * Controller: UserProfile.forgot_password
	 */
    forgot_password: function(config){
        //var user = this.site.sql.execute_and_fetch_one_single('select 1 from tusers where lower(login)=:login',{ login:email });

        var email = (this.fields.login || '').toLowerCase();
        var user = this.site.models.User.Get('get_of_login_cased',{ login:email });

        if (!user) return JSON.stringify({
            call:   "UserProfileFuncs.forgot_error",
            errors: {
                login:'User not exist'
            }
        });
        var pass = this.F('UserAuth', 'mk_password');
        user.PasswordSet(pass);
        try {
            this.F('Functions','send_mail','forgot_password',{ to:email, user:user , password: pass});
            user.SaveAll();
            return JSON.stringify({ call:"UserProfileFuncs.send_email_ok" });
        } catch(e){            
            return JSON.stringify({
                call:   "UserProfileFuncs.forgot_error",
                errors: {
                    login:'server error'
                }
            });        
        }
    },

	/**
	 * Controller: UserProfile.register_direct
	 */
	register_direct: function(config) {
		var errors=this.F("UserAuth","register_check",this.F("UserAuth","join_checks","check_register",config,default_check_register));

/*		if (!errors) errors={};
		var u2 = this.site.models.User.Get('get_of_login',{login:this.fields.login});
		if (u2) errors.login=this.LC('Login already exists');

		if (this.fields.password1!=this.fields.password2) errors.password2=this.LC("Passwords differ");
		var flag;
		for (var k in errors) flag=1;*/
		if (errors) return JSON.stringify({call:"UserProfileFuncs.register_direct_error",errors:errors});

		var u=this.site.models.User.Create();
		u.PreCreate();
		u.login			=this.fields.login;
		u.email			=this.fields.email;
		u.first_name	=this.fields.first_name;
        u.second_name	=this.fields.second_name;
		u.last_name		=this.fields.last_name;
		u.phone			=this.fields.phone;
		u.enabled		=1;
		u.PasswordSet(this.fields.password1);
		u.SaveAll();
		u.StartSession();

		this.user=u;
		this.uid=u.id;

		this.F("UserProfile","after_register");
		if (this.fields.onsuccess_response) return this.fields.onsuccess_response;
		return JSON.stringify({refresh:1});
	},

	/**
	 * Controller: UserProfile.register_fb
	 */
	register_fb: function(config) {
		var json=JSON.parse(this.fields.json);
		config.network_code="fb";
		config.json=json;
		var r=this.F("UserProfile","socnet_login",config);
		if (r.ok) return JSON.stringify({refresh:1,info:r});
		return JSON.stringify({error:"register_fb() - ERROR"});
	},

	/**
	 * Controller: UserProfile.backlink_fb
	 */
	backlink_fb: function(config) {
		this.F("UserProfile","register_fb",{code:this.fields.code});
		this.redirect=this.site.userprofile.backlink_redirect;
		return this.View("system/redirect");
	},

	/**
	 * Controller: UserProfile.backlink_vk
	 */
	backlink_vk: function(config) {
		this.F("UserProfile","register_vk",{code:this.fields.code});
		this.redirect=this.site.userprofile.backlink_redirect;
		return this.View("system/redirect");
	},

	/**
	 * Controller: UserProfile.backlink_ok
	 */
	backlink_ok: function(config) {
		this.F("UserProfile","register_ok",{code:this.fields.code});
		this.redirect=this.site.userprofile.backlink_redirect;
		return this.View("system/redirect");
	},

	/**
	 * Controller: UserProfile.register_gmail
	 */
	register_gmail: function() {
		// TODO login/register using gmail
	},

	/**
	 * Controller: UserProfile.update_fb
	 */
	update_fb: function() {
		// TODO update using fb
	},

	/**
	 * Controller: UserProfile.update_vk
	 */
	update_vk: function() {
		// TODO update using vk
	},

	/**
	 * Controller: UserProfile.update_ok
	 */
	update_ok: function() {
		// TODO update using ok
	},

	/**
	 * Controller: UserProfile.fetch_friends_gmail
	 */
	fetch_friends_gmail: function() {
		// TODO fetch friends using gmail
	},
	/**
	 * Controller: UserProfile.fetch_friends_fb
	 */
	fetch_friends_fb: function() {
		// TODO fetch friends using fb
	},

	/**
	 * Controller: UserProfile.fetch_friends_vk
	 */
	fetch_friends_vk: function() {
		// TODO fetch friends using vk
	},

	/**
	 * Controller: UserProfile.fetch_friends_ok
	 */
	fetch_friends_ok: function() {
		// TODO fetch friends using ok
	},

	/**
	 * Controller: UserProfile.fetch_friends_gmail
	 */
	fetch_friends_gmail: function() {
		// TODO fetch friends using gmail
	},

},{
	_type:"functions",
	_section:"UserProfile",

	/**
	 * Structure: json
	 * Parameters:
	 *		json typeof Object
	 *		json.friends typeof Array
	 *		json.friends[i].date_birth typeof String		- "8.4.1988"
	 *		json.friends[i].city							- TODO
	 *		json.friends[i].country							- TODO
	 *		json.friends[i].first_name						- "Анна"
	 *		json.friends[i].last_name						- "Хереш"
	 *		json.friends[i].lists							- Array[1]
	 *		json.friends[i].nickname typeof String			- ""
	 *		json.friends[i].online typeof Integer			- 0
	 *		json.friends[i].avatar_url typeof String		- "http://cs619531.vk.me/v619531339/13e9/rSmuQuQcMJI.jpg"
	 *		json.friends[i].avatar_url_fetch typeof String	- "http://cs619531.vk.me/v619531339/13e9/rSmuQuQcMJI.jpg"
	 *		json.friends[i].sex_id typeof Integer			- 1/2/null
	 *		json.friends[i].fid typeof String				- 2339
	 */


	/**
	 * Function: UserProfile.socnet_apply_info
	 *		Update user info based on social network information
	 *
	 * Parameters:
	 *		u typeof User				- 
	 *		json typeof Object			- 
	 *		network_id typeof Integer	-
	 */
	socnet_apply_info: function(u,json,network_id,force) {
		var flag=0;
		var arr=["first_name","second_name","last_name","date_birth","sex_id"];
		for (var i=0;i<arr.length;i++) {
			var fld=arr[i];
			if (json[fld] && (!u[fld] || force)) {
				u[fld]=json[fld];
				flag=1;
			}
		}
		// TODO gender, sex_id !!!!
		return flag;
	},

	/**
	 * Function: UserProfile.avatar_folder_of_user
	 */
	avatar_folder_of_user: function(user_id) {
		return 1;
	},

	/**
	 * Function: UserProfile.socnet_apply_avatar
	 *		Updates user avatar based on social network information
	 *
	 * Parameters:
	 *		u typeof User				-
	 *		json typeof Object			-
	 *		network_id typeof Integer	-
	 */
	socnet_apply_avatar: function(u,json,network_id,force) {
		if (!json.avatar_url || !json.avatar_url.match(/\.(png|jpe?g)$/)) return 0;
		var file_id=this.F("Files","download_file",{file_folder_id:this.F("UserProfile","avatar_folder_of_user",u.id),store_as:json.avatar_url,fetch_url:json.avatar_url_fetch});
		if (!file_id) return 0;
		u.avatar_id=file_id;
		return 1;
	},

	/**
	 * Function: UserProfile.social_add_account
	 */
	social_add_account: function(user_id,json,network_id) {
		var sna=this.site.models.SocialNetworkAccount.Create();
		sna.user_id			=user_id;
		sna.network_id		=network_id;
		sna.fid				=json.fid;
		sna.fid2			=json.id;
		sna.access_token	=json.access_token;
		sna.do_publish		=0;
		sna.SaveAll();
		return sna;
	},

	/**
	 * Function: UserProfile.socnet_login
	 *
	 * Parameters:
	 *		config typeof Object
	 *		config.json typeof Object
	 *		config.network_code typeof String		- vk, fb and such
	 *		config.update_info typeof Boolean		- 
	 *		config.update_avatar typeof Boolean		- 
	 *		config.update_friends typeof Integer	- 0/1/2 - no/yes/delayed
	 *		config.get_friends typeof Integer		- 0/1/2 - no/yes/delayed
	 *		config.password_mask typeof String		-
	 */
	socnet_login: function(config) {
		var t=this;
		var json=config.json;
		var u;
		var sna;
		var i=0;
		var network_id=this.site.models.SocialNetwork.Get("get_by_code",{code:config.network_code}).id;
//		var searchhash={};
//		searchhash[type+"_user_id"]=json.user_id;
		if (!json.email && json.fid) json.email=json.fid+"";

		/*
		 * User already exists with this network
		 */
		sna=this.sna=this.site.models.SocialNetworkAccount.Get("get_by_network_and_fid",{network_id:network_id,fid:json.fid,fid2:json.fid2});
		if (sna) {
			u=this.site.models.User.Get(sna.user_id);
			u.StartSession();
			i+=this.F("UserProfile","socnet_apply_info",u,json,network_id,config.update_info);
			i+=this.F("UserProfile","socnet_apply_avatar",u,json,network_id,config.update_avatar);
			if (i) u.SaveAll();
			this.uid=u.id;
			this.user=u;
			if (this.update_friends) i+=this.F("UserProfile","socnet_apply_friends",sna.id,json,network_id);
			return {ok:1,auth:1};
		}
		/*
		 * There is already a user with this email but no such social network. Connecting.
		 */
		u=this.site.models.User.Get("get_of_login",{login:json.email.toLowerCase()});
		if (u) {
			u.StartSession();
			i+=this.F("UserProfile","socnet_apply_info",u,json,network_id,config.update_info);
			i+=this.F("UserProfile","socnet_apply_avatar",u,json,network_id,config.update_avatar);
			u.SaveAll();
			this.uid=u.id;
			this.user=u;
			sna=this.sna=this.F("UserProfile","social_add_account",u.id,json,network_id);
			if (config.get_friends) i+=this.F("UserProfile","socnet_apply_friends",sna.id,json,network_id);
			return {ok:1,add:1};
		}
		/*
		 * Creating new user
		 */
		var u=this.site.models.User.Create();
		u.PreCreate();
		u.login=u.email=json.email.toLowerCase();
		u.password=this.F("Admin","mk_password",config.password_mask);
		i+=this.F("UserProfile","socnet_apply_info",u,json,network_id,config.update_info);
		u.SaveAll();
		u.StartSession();
		i=0;
		i+=this.F("UserProfile","socnet_apply_avatar",u,json,network_id,config.update_avatar);
		if (i) u.SaveAll();
		this.uid=u.id;
		this.user=u;
		sna=this.sna=this.F("UserProfile","social_add_account",u.id,json,network_id);
		if (config.get_friends) i+=this.F("UserProfile","socnet_apply_friends",sna.id,json,network_id);
		if (this.site.userprofile.after_create) this.site.userprofile.after_create(this);
		return {ok:1,create:1};
	},
	
	/**
	 * Function: UserProfile.socnet_apply_friends
	 *
	 * Parameters:
	 *		account_id
	 *		json
	 *		network_id
	 */
	socnet_apply_friends: function(account_id,json,network_id) {
		if (!json.friends) return;
		var ff=this.site.models.FileFolder.Get("get_by_parent_and_name",{parent_id:1,name:"socnet-"+network_id});
		if (!ff) {
			ff=this.site.models.FileFolder.Create();
			ff.FetchLocales();
			ff.parent_id=1;
			ff.user_cr_id=this.uid;
			ff.l10ns[1].name="socnet-"+network_id;
			ff.SaveAll();
		}

		var errors=[];
		for (var i=0;i<json.friends.length;i++) {
			var friend=json.friends[i];
			switch (type) {
				case "fb":
					break;
				case "vk":
					break;
				case "gmail":
					if (!friend.email) { errors.push("UserProfile.apply_possible_friends() - gmail friend.email is empty\n"+this.Dumper(friend)); continue; }
					break;
			}
			var file_id=this.F("Files","download_file",{file_folder_id:ff.id,store_as:friend.avatar_url,fetch_url:friend.avatar_url_fetch});
			if (!friend.calc_fullname) {
				friend.calc_fullname=[friend.first_name,friend.last_name].filter(function(a) { return a?1:0; }).join(" ");
			}
			var h={
				account_id:account_id,
				fid:friend.fid
			};
			var item=this.site.models.SocialNetworkAccountFriend.Get("get_existing",h);
			if (!item) {
				item=this.site.models.SocialNetworkAccountFriend.Create(h);
			}
			item.name=friend.calc_fullname;
			item.sex_id=friend.sex_id;
			item.date_birth=friend.date_birth;
			item.avatar_id=friend.avatar_id;
			item.SaveAll();
			this.site.sql.commit();
		}
	},

	/**
	 * Function: UserProfile.access_token_oauth
	 */
	access_token_oauth: function(url,params,method) {
		var request;
		if (method=="POST") {
			request=new http.ClientRequest(url);
			request.post=params;
			request.method="POST";
		} else {
			request=new http.ClientRequest(this.F("Functions","url_builder",url,params));
		}
		var response = request.send(true);
		var data;
		try {
			data=JSON.parse(response.data.toString("utf-8"));
		} catch(e) {
			data={error:e.toString()};
			try { data.response=response.data.toString("utf-8"); } catch(e2) {}
		}
		if (response.status!=200 || data.error) throw "UserProfile.access_token_oauth() - ERROR\n"+(this.site.userprofile.debug?"\nurl="+url+"\nparams=\n"+this.Dumper(params)+"\nresponse.status="+response.status+"\nDUMP:\n"+this.Dumper(data):"");
		return data;
	},

	/**
	 * Function: UserProfile.access_token_fb
	 */
	access_token_fb: function(code,prefix) {
		var url="https://graph.facebook.com/v2.8/oauth/access_token";
		var params={
			"client_id":this.site.userprofile[prefix+"_client_id"],
			"client_secret":this.site.userprofile[prefix+"_client_secret"],
			"code":code,
			"redirect_uri":this.site.userprofile[prefix+"_backlink"]
		};
		return this.F("UserProfile","access_token_oauth",url,params,"GET");
	},

	/**
	 * Function: UserProfile.access_token_vk
	 */
	access_token_vk: function(code,prefix) {
		var url="https://api.vk.com/oauth/access_token";
		var params={
			"client_id":this.site.userprofile[prefix+"_client_id"],
			"client_secret":this.site.userprofile[prefix+"_client_secret"],
			"code":code,
			"redirect_uri":this.site.userprofile[prefix+"_backlink"]
		};
		return this.F("UserProfile","access_token_oauth",url,params,"GET");
	},

	/**
	 * Function: UserProfile.access_token_ok
	 */
	access_token_ok: function(code) {
		var url="https://api.odnoklassniki.ru/oauth/token.do";
		var params={
			"client_id":this.site.userprofile.ok_client_id,
			"client_secret":this.site.userprofile.ok_client_secret,
			"code":code,
			"redirect_uri":this.site.userprofile.ok_backlink,
			"grant_type":"authorization_code"
		};
		return this.F("UserProfile","access_token_oauth",url,params,"POST");
	},

	/**
	 * Function: UserProfile.fix_json
	 *
	 * Parameters:
	 *		network_code
	 *		json
	 */
	fix_json: function(network_code,json) {
		switch(network_code) {
			case "vk":
				json.avatar_url_fetch=json.avatar_url=json.photo_max_orig;
				json.name=[json.first_name,json.last_name].filter(function(a) { return a?1:0; }).join(" ");
				json.fid=json.id;
				json.date_birth=json.bdate;
				if (json.sex) json.sex_id=3-json.sex;
				json.avatar_url=json.photo_max_orig;
				break;

			case "fb":
				json.fid=json.uid;
				if (json.picture && json.picture.data && json.picture.data.url) {
					json.avatar_url=json.picture.data.url;
				} else if (json.avatar) {
					json.avatar_url=json.avatar.url;
				}
				json.avatar_url_fetch=json.avatar_url.replace(/\?.*/,"");
				if (json.gender=="male") json.sex_id=1;
				if (json.gender=="female") json.sex_id=2;
				json.fid=json.email;
				json.fid2=json.id;
				break;

			case "gmail":
				json.avatar_url=json.photo;
				json.fid=json.email;
				json.fid2=json.id;
				break;

			case "ok":
				var tmp=json.birthday.match(/^(\d\d\d\d)-(\d\d)-(\d\d)$/);
				if (tmp) json.date_birth=tmp[3]+"."+tmp[2]+"."+tmp[1];
				if (json.gender=="male") json.sex_id=1;
				if (json.gender=="female") json.sex_id=2;
				json.avatar_url=json.pic1024x768;
				json.fid=json.uid;
				break;

			case "fotostrana":
				json.fid=json.user_id;
				var tmp=(json.birthday||"").match(/^(\d\d\d\d)-(\d\d)-(\d\d)$/);
				if (tmp) json.date_birth=tmp[3]+"."+tmp[2]+"."+tmp[1];
				json.avatar_url=json.photo_big.replace(/\?\d+$/,"");
				switch (json.sex) {
					case "w":
						json.sex_id=2;
						break;
					case "m":
						json.sex_id=1;
						break;
				}
				var a=json.user_name+" "+json.user_lastname;
				var tmp=a.match(/^(\S+)\s+(\S.*)$/);
				if (tmp) {
					json.first_name=tmp[1];
					json.last_name=tmp[2];
				} else {
					json.last_name=config.user_lastname;
					json.first_name=config.user_name;
				}
				break;
			default:
				throw "UserProfile.fix_json() - TODO network_code="+network_code;
		}
	},

	/**
	 * Function: UserProfile.register_fb
	 *
	 * Parameters:
	 *		config
	 *		config.prefix typeof String, default 'fb'
	 *		config.at_data
	 *		config.at_data.user_id			-
	 *		config.at_data.access_token		-
	 *		config.at_data.email			-
	 *		config.code typeof String		-
	 */
	register_fb: function(config) {
		var prefix=config.prefix||"fb";
	 	config.network_code="fb";
		var at_data=config.at_data;
		if (!at_data) at_data=this.F("UserProfile","access_token_fb",config.code,prefix);
		var request=new http.ClientRequest("https://graph.facebook.com/v2.8/me/?fields=last_name,first_name,email,gender,birthday,cover,picture.type(large),link&access_token="+at_data.access_token);
		var response = request.send(true);
		var data;
		try { data=JSON.parse(response.data.toString("utf-8")); } catch(e) { data={error:e.toString() }; }
		if (response.status!=200 || data.error) throw "UserProfile.register_fb() - ERROR 1\n"+(this.site.userprofile.debug?this.Dumper(data):"");
		config.json=data;
		config.json.access_token=at_data.access_token;
		this.F("UserProfile","fix_json","fb",config.json);
		var r=this.F("UserProfile","socnet_login",config);
		return r;
	},


	/**
	 * Function: UserProfile.register_vk
	 *
	 * Parameters:
	 *		config
	 *		config.prefix typeof String, default 'vk'
	 *		config.at_data
	 *		config.at_data.user_id			-
	 *		config.at_data.access_token		-
	 *		config.at_data.email			-
	 *		config.code typeof String		-
	 */
	register_vk: function(config) {
		var prefix=config.prefix||"vk";
	 	config.network_code="vk";
		var at_data=config.at_data;
		if (!at_data) at_data=this.F("UserProfile","access_token_vk",config.code,prefix);
		var request=new http.ClientRequest("https://api.vk.com/method/users.get?user_id="+at_data.user_id+"&v=5.37&access_token="+at_data.access_token+"&fields=sex,bdate,city,country,photo_max_orig,domain,last_seen");
		var response = request.send(true);
		var data;
		try { data=JSON.parse(response.data.toString("utf-8")); } catch(e) { data={error:e.toString() }; }
		if (response.status!=200 || data.error) throw "UserProfile.register_vk() - ERROR 1\n"+(this.site.userprofile.debug?this.Dumper(data):"");
		config.json=data.response[0];
		config.json.email=at_data.email||(at_data.user_id+"@vk.com");
		config.json.access_token=at_data.access_token;
		this.F("UserProfile","fix_json","vk",config.json);
/*
				email:
				access_token:
				bdate: "17.10.1979"
				city: {
					id: ...
					title: ...
				}
				country: {
					id: ...
					title: ...
				}
				domain: "vahvarh"
				first_name: "Владимир"
				id: 898897
				last_name: "Оленин"
				last_seen: {
					platform: ...
					time: ...
				}
				photo_max_orig: "http://cs559.vk.me/u898897/a_c1d01656.jpg"
				sex: 2
*/
		var r=this.F("UserProfile","socnet_login",config);
		return r;
	},

	/**
	 * Function: UserProfile.md5_ok
	 */
	md5_ok: function(params,access_token,secret) {
		if (!secret) secret=this.site.userprofile.ok_client_secret;
		var args=[];
		for (var k in params) args.push(k);
		args.sort();
		var str="";
		for (var i=0;i<args.length;i++) {
			str+=args[i]+"="+params[args[i]];
		}
		str+=hash.md5(access_token + secret).toLowerCase();
		this.tmp=str;
		return hash.md5(str).toLowerCase();
	},

	/**
	 * Function: UserProfile.register_ok
	 *
	 * Parameters:
	 *		config
	 *		config.code typeof String		-
	 */
	register_ok: function(config) {
	 	config.network_code="ok";
		var at_data=this.F("UserProfile","access_token_ok",config.code);
		
		var params={
			format:"JSON",
			application_key:this.site.userprofile.ok_public_key,
			method:"users.getCurrentUser",
			fields:"user.uid,user.locale,user.first_name,user.last_name,user.name,user.gender,user.age,user.birthday,user.has_email,user.current_status,user.current_status_id,user.current_status_date,user.online,user.pic1024x768,user.location,user.email"
		};
		params.sig=this.F("UserProfile","md5_ok",params,at_data.access_token);
		params.access_token=at_data.access_token;
		var request=new http.ClientRequest(this.F("Functions","url_builder","http://api.ok.ru/fb.do",params));
		var response = request.send(true);
		var data;
		try { data=JSON.parse(response.data.toString("utf-8")); } catch(e) { data={error:e.toString() }; }
		if (response.status!=200 || data.error || data.error_code) throw "UserProfile.register_ok() - ERROR\n"+this.Dumper({at_data:at_data,data:data,tmp:this.tmp,params:params});
/*
{
	age: 36
	birthday: "1979-10-17"
	first_name: "Владимир"
	gender: "male"
	has_email: true
	last_name: "Оленин"
	locale: "ru"
	location: {
		city: "Москва"
		country: "RUSSIAN_FEDERATION"
		countryCode: "RU"
		countryName: "Россия"
	}
	name: "Владимир Оленин"
	online: "web"
	pic1024x768: "https://uld3.mycdn.me/image?id=174609671721&bid=174609671721&t=3&plc=API&viewToken=2gCiJkANhBuIsRh3J19HKw&tkn=*DnpIds-eNgQc64hSCSjkEqG1dbY"
	uid: "831204649"
}
*/
		throw data;//"EMAIL TODO";
		config.json=data;
		config.json.access_token=at_data.access_token;
		this.F("UserProfile","fix_json","ok",config.json);

		var r=this.F("UserProfile","socnet_login",config);
		return r;
	},

	_fotostrana_is_server_method:function(method) {
		switch (method) {
			case 'User.giveFBAchievment':
			case 'User.sendNotification':
			case 'Userphoto.checkAccess':
			case 'Billing.getUserBalanceAny':
			case 'Billing.withDrawMoneySafe':
			case 'User.sendAppEmail':
			case 'User.giveAchievment':
			case 'User.getAuthInfo':	
			case 'User.getProfiles':
				return 1;
		}
		return 0;// TODO
	},

	/**
	 * Function: UserProfile._fotostrana_genurl_request
	 */
	_fotostrana_genurl_request: function(params,user_id,baseurl) {
		params.timestamp=1;
		params.rand=Math.floor(Math.random()*1000000);
		params.appId=this.site.userprofile.fotostrana_appId;
		params.format=1;

		var fields_keys=[];
		for (var k in params) fields_keys.push(k);
		fields_keys.sort();

		var fields_str="";
		var fields_sig=this.F("UserProfile","_fotostrana_is_server_method",params.method)?"":""+user_id;
		for (var i=0;i<fields_keys.length;i++) {
			var k=fields_keys[i];
			fields_str+="&"+k+"="+encodeURIComponent(params[k]);
			fields_sig+=k+"="+params[k];
		}
		fields_sig+=this.F("UserProfile","_fotostrana_is_server_method",params.method)?this.site.userprofile.fotostrana_server_key:this.site.userprofile.fotostrana_client_key;

//		throw fields_sig;
//		throw "is_server("+params.method+")="+this.F("UserProfile","_fotostrana_is_server_method",params.method);

		var url=(baseurl||"https://fotostrana.ru/apifs.php")+"?sig="+hash.md5(fields_sig)+fields_str;
		return url;
	},

	/**
	 * Function: UserProfile._fotostrana_request
	 */
	_fotostrana_request: function(params,user_id,baseurl) {
		var url=this.F("UserProfile","_fotostrana_genurl_request",params,user_id,baseurl);
		var req=new http.ClientRequest(url);
		req.method="GET";
		var resp=req.send(true);
		return JSON.parse(resp.data.toString("utf-8"));
	},

	/**
	 * Function: UserProfile.register_fotostrana
	 *
	 * Parameters:
	 *		config
	 *		config.user_id typeof Integer		- user id in fotostrana
	 *		config.access_token typeof String	- sessionKey 
	 *		config.export_token typeof String	- authKey
	 */
	register_fotostrana: function(config) {
		config.network_code="fotostrana";
		var data=this.F("UserProfile","_fotostrana_request",{
  			method:"User.getProfiles",
			userIds:config.user_id,
			fields:"user_name,user_lastname,user_link,sex,birthday,photo_big,photo_box,pet_id,city_id,city_name,slogan,vip_end,is_payable",
		});
//		try { data=JSON.parse(response.data.toString("utf-8")); } catch(e) { data={error:e.toString() }; }
//		if (response.status!=200 || data.error || data.error_code) throw "UserProfile.register_ok() - ERROR\n"+this.Dumper({at_data:at_data,data:data,tmp:this.tmp,params:params});
/*
{
	"response": {
		"86250521":{
			"birthday":"1990-01-11",
			"city_id":1,
			"city_name":"Москва",
			"is_payable":0,
			"pet_id":0,
			"photo_big":"https:\/\/i10.fotocdn.net\/s18\/19\/user_m\/286\/2511412498.jpg?20160327182602",
			"photo_box":"https:\/\/i10.fotocdn.net\/s18\/19\/user_m\/286\/2511412498.jpg?20160327182602",
			"sex":"w",
			"slogan":"",
			"user_id":"86250521",
			"user_lastname":"",
			"user_link":"https:\/\/fotostrana.ru\/user\/86250521",
			"user_name":"Анастасия Шангина",
			"vip_end":0
		}
	}
}
*/
		config.json=data.response[config.user_id];
//		config.json.access_token=at_data.access_token;
		this.F("UserProfile","fix_json","fotostrana",config.json);

		var r=this.F("UserProfile","socnet_login",config);
		if (config.access_token) this.sna.access_token=config.access_token;
		if (config.export_token) {
			this.sna.export_token=config.export_token;
/*			var d=new Date();
			d.setDate(d.getDate()+1);
			this.sna.export_expires=this.F("Date","to_str_timestamp",d);*/
		}
		this.sna.SaveAll();
		return r;
	},
	
	after_register: function() {

	}

}];
