exports.add=[{
	_type:"functions",
	_section:"Cart",

	/**
	 * Function: Cart.get
	 *
	 *
	 * Returns:
	 *		typeof Cart
	 */
	get: function(id) {

	},

	/**
	 * Function: Cart.get_user_fill
	 *
	 *
	 * Returns:
	 *		typeof Cart
	 */
	get_user_fill: function() {
		var c;
		if (this.uid) {
			c=this.site.sql.execute_and_fetch_one("carts/get_fill_by_user",{user_id:this.uid});
		} else {
			c=this.site.sql.execute_and_fetch_one("carts/get_fill_by_sid",{sid:this.req.cookie.marketsid});
		}
		if (c) return this.site.models.Cart.Get(c.id);
		var c=this.site.models.Cart.Create();
		if (this.uid) {
			c.InitForUser(this.uid);
		} else {
			c.InitForAnonymous();
		}
		return c;
	},

	auth: function() {
		var c=this.site.sql.execute_and_fetch_one("carts/get_fill_by_sid",{sid:this.req.cookie.marketsid});
		if (!c) c=this.F("Cart","get_user_fill"); else c=this.site.models.Cart.Get(c.id);
		if (!c.user_id) c.Authorize(this.uid);
		c.SaveAll();
		return c;
	},

	/**
	 * Function: mail_template_code
	 *
	 * Parameters:
	 *		type typeof String		- one of 'fast_cart_checkout', 'cart_checkout'
	 *		side typeof String		- one of 'user', 'manager'
	 */
	mail_template_code: function(type,side) {
		switch (type+"-"+side) {
			case "fast_cart_checkout-user":
				return "fast_cart_user_send";

			case "fast_cart_checkout-manager":
				return "cart_manager_send";
			
			case "cart_checkout-user":
				return "cart_user_send";

			case "cart_checkout-manager":
				return "cart_manager_send";
		}
	},

	profile_user_update_fields: function(u) {
		if (!u.id) {
			u.login=u.email=this.fields.login;
			u.password=this.fields.password1;
			u.enabled=1;
		}
		u.first_name=this.fields.first_name;
		u.last_name=this.fields.last_name;
		u.second_name=this.fields.second_name;
		u.phone=this.fields.phone;
	},

	
	profile_cart_update_fields: function(cart) {
		for (var k in this.fields) {
			if (k.match(/^(address.*|required_change)$/)) cart[k]=this.fields[k];
		}
		cart.address_phone=this.fields.phone;
		cart.payment_method_id=this.fields.payment_method_id;
		cart.payment_method_name="";
		if (this.fields.payment_method_id) cart.payment_method_name=this.site.models.CartPaymentMethod.Get(this.fields.payment_method_id).name;
	},

	after_register: function() {

	},

	after_cart_checkout: function() {

	}
}];

