var fs=require("fs");
var http=require("http");
var gd=require("gd");
var base64=require("base64");
exports.add=[{
	_type:"functions",
	_section:"Functions",

	/**
	 * Function: Functions.track_visit
	 */
	track_visit: function() {
		var user_agent_id=this.F("Functions","user_agent_id");
		var baseurl=this.action_src;
		if (baseurl=="/client-side-views/") return;
		var params="";
		for (var k in this.fields) {
			if (k.match(/^(do-login|password|no-session|foreach_i)$/)) continue;
			if (this.std_rewrite_fields && this.std_rewrite_fields[k]) continue;
			if (params) params+="&";
			var v=this.fields[k].toString();
			if (v.length>300) v=v.substr(0,300)+"...";
			params+=encodeURIComponent(k)+"="+encodeURIComponent(v);
		}
		var ip=system.env.REMOTE_ADDR;
		if (params.length>1000) params=params.substr(0,1000);
		if (baseurl.length>1000) baseurl=baseurl.substr(0,1000);
		this.site.sql.execute("visits/insert",{user_id:this.uid||null,anon_id:this.anon_id,baseurl:baseurl,params:params,ip:ip,user_agent_id:user_agent_id});
	},

	/**
	 * Function: Functions.user_agent_id
	 */
	user_agent_id: function(uaname) {
		if (!uaname) uaname=system.env.HTTP_USER_AGENT;
		if (!uaname) uaname="-missing-";
		if (uaname.length>1000) uaname=uaname.substr(0,999);
		var ua=this.site.models.UserAgent.Get("get_by_name",{name:uaname});
		if (!ua) {
			ua=this.site.models.UserAgent.Create();
			ua.name=uaname;
			ua.is_robot=(uaname.match(/robot/i))?1:0;
			ua.device_type=0;
			if (uaname.match(/(tablet|ipad|iPad)/)) ua.device_type=1;
			if (!ua.device_type && uaname.match(/(mobile|android|ios)/i)) ua.device_type=2;
			ua.SaveAll();
		}
		return ua.id;
	},

	/*
	 * Function: functions.mksid
	 *		Generates a unique SID
	 * Returns:
	 *		A string length of 48 symbols
	 */
	mksid: function(len) {
		if (!len) len=48;
		var sid_items="1234567890qwertyuiopasdfghjklzxcvbnm";
		var r="";
		for (var i=0;i<len;i++) {
			r+=sid_items.substr(Math.floor(Math.random()*sid_items.length),1);
		}
		return r;
	},

	/**
	 * Function: Functions.table_rows_merge
	 * Parameters:
	 *		config
	 *		config.table
	 *		config.column
	 *		config.values
	 *		config.new_value
	 */
	table_rows_merge: function(config) {
		var sqlq2=""+
			"update "+config.table+"\n"+
			"	set "+config.column+"=:new_id\n"+
			"where\n"+
			"	"+config.column+"=:old_id";
		var sqlq3="delete from "+config.table+" where id=:id";

		var min_i=0;
		var new_value=config.new_value;
		if (!new_value) {new_value=config.values[0];min_i=1;}
		if (!config.check) {
			for (var i=min_i;i<config.values.length;i++) {
				var old_value=config.values[i];
				this.site.sql.execute_single(sqlq2,{old_id:old_value,new_id:new_value});
			}
			return;
		}	
		var arr=config.check.split(/,/);
		var sqlq1=""+
			"select\n"+
			"	t1.id as old_id,\n"+
			"	t2.id as new_id\n"+
			"from\n"+
			"	"+config.table+" t1,\n"+
			"	"+config.table+" t2\n"+
			"where\n"+
			"	t1."+config.column+"=:old_id and\n"+
			"	t2."+config.column+"=:new_id";
		for (var i=0;i<arr.length;i++) {
			sqlq1+=" and\n	t1."+arr[i]+"=t2."+arr[i];
		}
		sqlq2+=" and\n	id not in (\n	"+sqlq1.replace(/\n/g,"\n\t").replace(/,\n\t\tt2.id as new_id/,"")+"\n)";
		var vals1={};
		var tmp=this.site.sql.execute_and_fetch_single(sqlq1,{id:config.new_value});
		for (var i=min_i;i<config.values.length;i++) {
			var old_value=config.values[i];
			var existing=this.site.sql.execute_and_fetch_single(sqlq1,{old_id:old_value,new_id:new_value});
			if (existing.length) {
				for (var j=0;j<existing.length;j++) {
					if (config.merge==="delete") {
						this.site.sql.execute_single(sqlq3,{id:existing[j].new_id});
					} else {
						config.merge(existing[j].new_id,existing[j].old_id);
					}
				}
			}
			this.site.sql.execute_single(sqlq2,{old_id:old_value,new_id:new_value});
		}
	},
	/**
	 * Function: Functions.send_sms_iqsms
	 */
	send_sms_iqsms: function(phone,text) {
		var url = "http://gate.iqsms.ru/send/?phone="+encodeURIComponent(phone)+"&text="+encodeURIComponent(text)+"&login="+this.site.iqsms.login+"&password="+this.site.iqsms.password+(this.site.iqsms.sender?"&sender="+this.site.iqsms.sender:"");
		var http=require("http");
		var request=new http.ClientRequest(url);
		var response = request.send(true);
		if (this.site.iqsms.debug) {
			var f=new fs.File(this.site.paths.basepath+"logs/sms.log");
			f.open("a");
			f.write(""+(new Date())+"\nSMS to "+phone+"\nresult ("+response.status+"):\n");
			f.write(response.data);
			f.write("\n");
			f.close();
		}
		return "";
	},

	/**
	 * Function: Functions.send_sms_db
	 */
	send_sms_db: function(phone,text) {
		var sms = this.site.models.SmsMessage.Create();

		sms.phone_to = phone;
		sms.body = text;
		sms.status_id = 1;
		sms.sender = this.site.iqsms.sender || null;

		sms.SaveAll();

		return sms;
	},

	/**
	 * Function: Functions.send_telegram
	 */ 
	send_telegram: function(code,chat_id,body) {
		var request=new http.ClientRequest("http://127.0.0.1:19099/send/");
		request.method="POST";
		request.post={code:code,body:body,chat_id:chat_id};
		request.send(true);
	},

	/**
	 * Function: Functions.send_sms_from_db
	 */
	send_sms_from_db: function() {
		var t=this;
		var smses=this.site.sql.execute_and_fetch_single("select * from Tsms_messages where status_id=1");
		smses.forEach(function(sms) {
			t.site.sql.execute_single("update Tsms_messages set date_mo=now(),status_id=:status_id where id=:id",{status_id:3,id:sms.id});
		});
		smses.forEach(function(sms) {
			
			t.site.sql.execute_single("update Tsms_messages set date_mo=now(),status_id=:status_id where id=:id",{status_id:3,id:sms.id});
		});
	},

	/**
	 * Function: Functions.send_mail
	 * Parameters:
	 *		hash.to			typeof Array of String		-
	 *		hash.from		typeof String				-
	 *		hash.rewriter	typeof Function				-
	 */
	send_mail: function(code,hash,quiet,files) {
		if (!hash) hash={};
		var mail=this.site.models.MailTemplate.List("get_by_code",{code:code})[0];
		if (!mail) {
			if (quiet) return;
			throw new Error("No mail template "+code+" found in database");
		}
		if (!hash.from) hash.from=mail.default_from;
		if (!hash.to) {
			if (!mail.default_to) {
				if (quiet) return;
				throw new Error("No recipient and no default recipient given");
			}
			hash.to=mail.default_to.split(/\s*[;,]\s*/);
		}
		
		if (!hash.from) hash.from="no-reply@"+this.site.names[0];
		var headers = {
			From: hash.from,
			"Content-Type": 'text/plain; charset="UTF-8"'
		};
		if (hash.to.constructor!=Array) hash.to=[hash.to];
		this.mail=hash;
		var subject=this.views.apply(mail.subject,this);
		var body=this.views.apply(mail.body,this);
		if (body[0]=="<") {
			body="<html>\n<head>\n</head>\n<body>\n"+body+"</body>\n</html>\n";
		}
		if (hash.rewriter) {
			var tmp=hash.rewriter(subject,body);
			subject=tmp.subject;
			body=tmp.body;
		}
		var bodytext=body.replace(/<(\/h\d+|\/p|\/div|br|br\s*\/)\s*>\s*/gi,"\n").replace(/<.*?>/g,"");
		var rm=require("mail");
			
		//subject="=?utf-8?B?"+base64.encode(subject)+"?=";
		headers["Content-Type"]='text/html; charset="UTF-8"';
		for (var i=0;i<hash.to.length;i++) {
			var arr=hash.to[i].match(/^\{\{(.*)\}\}$/);
			if (arr) {
				eval("hash.to[i]=this."+arr[1]+";");
			}
			//if (hash.to[i].match(/\w@\w/)) rm.mail(hash.to[i],subject,bodytext,headers,undefined,[{data:body,"Content-Type":"text/html; chartset=\"UTF-8\""}]);
			if (hash.to[i].match(/\w@\w/)) rm.mail(hash.to[i],subject,body,headers,undefined,files);
		}
	},

	/**
	 * Function: Functions.gen_page_numbers
	 *		Generates page numbers
	 * Parameters:
	 *		nowpage typeof Integer		- Current page, in 0 .. (pagescount-1)
	 *		pagescount typeof Integer	- Number of pages
	 * Returns:
	 *		typeof Array
	 *			item typeof Object		- { i: 0, page: i+1, active: 0 or 1 }
	 *			item typeof Object		- { split: 1 }
	 */
	gen_page_numbers:function(nowpage,pagescount) {
		var pages=[];
		function add_pages(start,end) {
			for (var i=start;i<end;i++) {
				pages.push({i:i,page:i+1,active: nowpage==i?1:0});
			}
		}
		if (pagescount<=10) {
			add_pages(0,pagescount);
		} else {
			if (nowpage<5) {
				add_pages(0,6);pages.push({split:1});add_pages(pagescount-1,pagescount);
			} else if (nowpage>=pagescount-5) {
				add_pages(0,1);pages.push({split:1});add_pages(pagescount-6,pagescount);
			} else {
				add_pages(0,1);pages.push({split:1});add_pages(nowpage-3,nowpage+4);pages.push({split:1});add_pages(pagescount-1,pagescount);
			}
		}
		return pages;
	},

	/**
	 * Function: Functions.url_builder
	 */
	url_builder: function(base,params) {
		var r="";
		for (var k in params) {
			if (k=="foreach_i") continue;
			r+=r?"&":"?";
			r+=encodeURIComponent(k)+"="+encodeURIComponent(params[k]);
		}
		return base+r;
	},

	/**
	 * Function: Functions.recursor
	 */
	recursor: function(arr,func) {
		var level=1;
		while (arr.length) {
			var tmp=arr;
			arr=[];
			for (var i=0;i<tmp.length;i++) {
				var r=func(tmp[i],level);
				if (r) arr=arr.concat(r);
			}
			level++;
		}
	},

	/**
	 * Function: Functions.up_to
	 */
	up_to: function(mod,length) {
		var arr=[];
		var i=length%mod;
		while (i && i!=mod) {
			arr.push({});
			i++;
		}
		return arr;
	}

}];

