var Socket=require("socket").Socket;
var fs=require("fs");
var Buffer = require("binary").Buffer;

var cltsocket;

/**
 * Class: GenericTcpClient
 */
/**
 * Method: new
 */
function GenericTcpClient(options)
{

}

GenericTcpClient.prototype.init=function(options)
{
	this.socket=options.socket;
	this.server=options.server;
}

/**
 * Method: action
 *		Called each time socket has anything to do
 *
 * Returns:
 *		0 - if okay
 * 		1 - if client is dead
 */
GenericTcpClient.prototype.action=function()
{
	var buffer = this.socket.receive(5000);
	system.stdout.writeLine("GenericTcpClient.action() - got some data - "+(buffer?(buffer.length+" bytes"):"undefined"));
	if (!buffer) return 1;
	if (buffer.length==0) return 1;

	var oldlength;
	if (this.buffer) {
		oldlength=this.buffer.length;
		var b=new Buffer(this.buffer.length+buffer.length);
		b.copyFrom(this.buffer,0,0,this.buffer.length);
		b.copyFrom(buffer,0,this.buffer.length,this.buffer.length+buffer.length);
		this.buffer=b;
	} else {
		this.buffer=buffer;
		oldlength=0;
	}
	var searchpos=oldlength;
//	if (searchpos<0) searchpos=0;
	searchpos=0;// TODO

	var cycling=1;
	var r=0,ret=-1,done_some=0;
	while (cycling) {
		var mlens=this.search_message(searchpos);
		if (!mlens) {
			cycling=false;
			ret=0;
		} else {
			try {
				var r=this.work(mlens.payload_start,mlens.payload_length);
			} catch(e) {
				system.stdout.writeLine("********************************************************************************");
				system.stdout.writeLine("GenericTcpClient.action() - error thrown");
				system.stdout.writeLine(e);
				system.stdout.writeLine("********************************************************************************");
				system.stdout.writeLine("");
				r=0;
			}
			if (r==1) {
				cycling=true;
				done_some=1;
				this.buffer=new Buffer(this.buffer,mlens.full,this.buffer.length);
			} else {
				cycling=false;
				ret=1;
			}
		}
		searchpos=0;
	}
	system.stdout.writeLine("  GenericTcpClient.prototype.action() - work() as is, done_some="+done_some+", ret="+ret);
	return ret;
}

/**
 * Method: search_message_prefix_bytes
 *
 * Returns:
 *		undefined				- nothing found
 *		Object.payload_start	- message start in buffer
 *		Object.payload_length	- message length
 *		Object.full				- 
 */
GenericTcpClient.prototype.search_message_prefix_bytes=function(searchpos)
{
//	system.stdout.write("GenericTcpClient.search_message_prefix_bytes() - buffer=[ ");
//	for (var i=0;i<this.buffer.length;i++) system.stdout.write(this.buffer[i]+" ");
//	system.stdout.writeLine("]\n");
	system.stdout.writeLine("  GenericTcpClient.search_message_prefix_bytes() - searchpos="+searchpos+", this.buffer.length="+this.buffer.length);
	if (this.buffer.length<4) return undefined;
	var a=this.buffer[0]+(this.buffer[1]<<8)+(this.buffer[2]<<16)+(this.buffer[3]<<24);
	system.stdout.writeLine("  GenericTcpClient.search_message_prefix_bytes() - searchpos="+searchpos+", this.buffer.length="+this.buffer.length+", a="+a);
	if (this.buffer.length<a+4) return undefined;
	return {payload_start:4,payload_length:a,full:a+4};
}

/**
 * Method: search_message_slash_n
 *		searches for \n starting from position searchpos
 *		if found, does work and removes data from this.buffer
 *
 * Returns:
 *		undefined				- nothing found
 *		Object.payload_start	- message start in buffer
 *		Object.payload_length	- message length
 *		Object.full				- 
 */
GenericTcpClient.prototype.search_message_slash_n=function(searchpos)
{
//	system.stdout.writeLine("  GenericTcpClient.search_message_slash_n() - searchpos="+searchpos+", this.buffer.length="+this.buffer.length);
	for (var j=0;j<this.buffer.length;j++) {
		if (this.buffer[j]==10) {
			var len=j;
			while (j<this.buffer.length && (this.buffer[j]==10 || this.buffer[j]==13)) j++;
			return {payload_start:0,payload_length:len,full:j};
		}
	}
	return undefined;
}

/**
 * Method: work
 *
 * Returns:
 *		0 - some error, please close connection
 *		1 - ok
 */

/**
 * Class: GenericTcpServer
 */

/**
 * Method: new
 */
function GenericTcpServer(options,clients)
{
	this.clients=clients;
	this.options=options;
}

/**
 * Method: init
 */
GenericTcpServer.prototype.init=function()
{
	system.stdout.writeLine("GenericTcpServer() - starting server at "+this.options.address+":"+this.options.port);
	this.socket=new Socket(Socket.PF_INET, Socket.SOCK_STREAM, Socket.IPPROTO_TCP);
	this.socket.setOption(Socket.SO_REUSEADDR, true);
	this.socket.bind(this.options.address,this.options.port);
	this.socket.listen(10);
}

/**
 * Method: accept 
 *		Called each time socket has anything to do
 */
GenericTcpServer.prototype.accept=function()
{
	system.stdout.writeLine("GenericTcpServer.action() - some client came");
	this.clients.push(new this.options.client({socket:this.socket.accept(),server:this}));
}

/**
 * Method: remove_client
 *		
 */
GenericTcpServer.prototype.remove_client=function(j)
{
	system.stdout.writeLine("GenericTcpServer.remove_client("+j+")");
	this.clients[j].socket.close();
	this.clients.splice(j,1);
}

/**
 * Method: remove_client_by_socket
 *		
 */
GenericTcpServer.prototype.remove_client_by_socket=function(socket)
{
	var j=0;
	while (j<this.clients.length) {
		if (this.clients[j].socket===socket) this.remove_client(j); else j++;
	}
}

/**
 * Function: _local_.run
 */
function run(options)
{
	var clients=[];
	var server=new options.server(options,clients);
	server.init();
	while(1) {
		var sockets=[server.socket];
		for (var i=0;i<clients.length;i++) sockets.push(clients[i].socket);
		//if (sockets.length) system.stdout.writeLine("main() - sockets.length="+sockets.length+" before select");
		var result=Socket.select(sockets,[],[],1000);
		if (!result) continue;
		//if (sockets.length) system.stdout.writeLine("main() - sockets.length="+sockets.length+" after select");
		for (var i=0;i<sockets.length;i++) {
			var s=sockets[i];
			if (s===server.socket) {
				server.accept();
				break;
			}
			for (var j=0;j<clients.length;j++) {
				var clt=clients[j];
				if (!(clt.socket===s)) continue;
				if (!clt.action()) continue;
				server.remove_client_by_socket(clt.socket);
			}
		}
	}
}

var BINARY_STRING=1;
var BINARY_INT32=2;
var BINARY_FLOAT=3;
var BINARY_ARRAY=4;
var BINARY_HASH=5;
var BINARY_NULL=6;
var BINARY_UNDEFINED=7;

exports.add=[{
	_type:"functions",
	_section:"GenericTcpServer",

	template: function() {
		return {
			server:GenericTcpServer,
			client:GenericTcpClient,
			runner:run
		};
//		run();
	},

},
{
	_type:"functions",
	_section:"GenericTcp",

	binary_msg_parse: function(data,offset,length) {
		var t=this;
		if (!offset) offset=0;
		if (!length) length=data.length;
		var r;
	
		var pos=offset;
		function get_int32()
		{
			var r;
			r=data[pos];
			r+=data[pos+1]<<8;
			r+=data[pos+2]<<16;
			r+=data[pos+3]<<24;
			pos+=4;
			return r;
		}
		function get_buffer(len)
		{
			var r=new Buffer(data,pos,pos+len);
			pos+=len;
			return r;
		}
		function work()
		{
			var r;
			var type=get_int32();
			switch (type) {
				case BINARY_INT32:
					r=get_int32();
					break;
				case BINARY_STRING:
					var len=get_int32();
					var b=get_buffer(len);
					r=b.toString("utf-8");
					break;
				case BINARY_ARRAY:
					var len=get_int32();
					var r=[];
					for (var i=0;i<len;i++) r.push(work());
					break;
				case BINARY_HASH:
					var len=get_int32();
					var r={};
					for (var i=0;i<len;i++) {
						var k=work();
						var v=work();
						r[k]=v;
					}
					break;
				case BINARY_NULL:
					r=null;
					break;
				case BINARY_UNDEFINED:
					r=null;
					break;
				default:
					throw "binary_msg_parse() - unknown type="+type+" at pos="+(pos-4);
			}
			return r;
		}
		var ret=work();
//		system.stdout.writeLine(t.Dumper(ret));
		return ret;
	},

	binary_msg_create: function(obj) {
		var buffer_len=0;
		var buffer_pos=0;
		var buffer=new Buffer(1000);
//		system.stdout.writeLine("binary_msg_create() buffer="+buffer);

		function enlarge_by(len)
		{
//			system.stdout.writeLine("enlarge_by() buffer="+buffer);
			if (buffer_len+len<buffer.length) return;
			var tmp=buffer;
			buffer=new Buffer(buffer_len+len+500);
			buffer.copyFrom(tmp,0,0,buffer_len);
		}

		function set_int32(v,pos)
		{
			var pos1=(pos===undefined || pos===null)?buffer_len:pos;
			buffer[pos1  ]=v&255;
			buffer[pos1+1]=(v>> 8)&255;
			buffer[pos1+2]=(v>>16)&255;
			buffer[pos1+3]=(v>>24)&255;
			if (pos===undefined || pos===null) buffer_len+=4;
		}

		function set_buffer(v)
		{
			buffer.copyFrom(v,0,buffer_len,v.length);
			buffer_len+=v.length;
		}

		function work(a)
		{
			switch (typeof a) {
				case "number":
					// TODO check if it is int32
					set_int32(BINARY_INT32);
					set_int32(a);
					break;

				case "string":
					var b=new Buffer(a,"utf-8");
					enlarge_by(b.length+8);
					set_int32(BINARY_STRING);
					set_int32(b.length);
					set_buffer(b);
					break;

				case "object":
					if (a.constructor===Array) {
						enlarge_by(8);
						set_int32(BINARY_ARRAY);
						set_int32(a.length);
						for (var i=0;i<a.length;i++) work(a[i]);
					} else {
						enlarge_by(8);
						set_int32(BINARY_HASH);
						var tmppos=buffer_len;
						var cnt=0;
						set_int32(0);
						for (var k in a) {
							cnt++;
							work(k);
							work(a[k]);
						}
						set_int32(cnt,tmppos);
					}
					break;
				case "null":
					set_int32(BINARY_NULL);
					break;
				case "undefined":
					set_int32(BINARY_UNDEFINED);
					break;
				default:
					throw "binary_msg_create() - Unknown typeof "+(typeof a);
			}
		}
		work(obj);
		var ret=new Buffer(buffer,0,buffer_len);
/*		var f=new fs.File("/tmp/binary_msg_create.log");
		f.open("a");
		f.write(ret);
		f.close();*/
		return ret;
	},
},
{
	_type:"functions",
	_section:"GenericTcpClient",

	connect: function(address,port) {
		if (cltsocket && cltsocket.address==address && cltsocket.port==port) return;
		if (cltsocket) this.F("GenericTcpClient","disconnect");
		cltsocket={
			address:address,
			port:port,
			socket:new Socket(Socket.PF_INET, Socket.SOCK_STREAM, Socket.IPPROTO_TCP)
		};
		cltsocket.socket.connect(address,port);
	},

	disconnect: function() {
		if (cltsocket) {
			cltsocket.socket.close();
			cltsocket=undefined;
		}
	},

	send: function(data) {
		cltsocket.socket.send(data);
	},

	send_binary_msg: function(data,socket) {
		if (!socket) socket=cltsocket.socket;
		var b=new Buffer(4);
		var len=data.length;
		b[0]=(len)&255;
		b[1]=(len>> 8)&255;
		b[2]=(len>>16)&255;
		b[3]=(len>>24)&255;
		socket.send(b);
		socket.send(data);
	},

	get_message_prefix_bytes: function() {
		if (!cltsocket) throw "GenericTcpClient.get_message_prefix_bytes() - cltsocket is not defined!";
		while (1) {
			if (cltsocket.buffer && cltsocket.buffer.length>=4) {
				var a=cltsocket.buffer[0]+(cltsocket.buffer[1]<<8)+(cltsocket.buffer[2]<<16)+(cltsocket.buffer[3]<<24);
				if (cltsocket.buffer.length>=a+4) {
					var r=new Buffer(cltsocket.buffer,4,a+4);
					cltsocket.buffer=new Buffer(cltsocket.buffer,a+4,cltsocket.buffer.length);
					return r;
				}
			}
//			system.stdout.writeLine("GenericTcpClient.get_message_prefix_bytes() - recv");
			var buffer = cltsocket.socket.receive(5000);
//			system.stdout.writeLine("GenericTcpClient.get_message_prefix_bytes() - got some data - "+(buffer?(buffer.length+" bytes"):"undefined"));
			if (!buffer) throw "GenericTcpClient.get_message_prefix_bytes() - buffer is undefined";
			if (buffer.length==0) throw "GenericTcpClient.get_message_prefix_bytes() - buffer.length==0";
		
			//var oldlength;
			if (cltsocket.buffer) {
			//	oldlength=cltsocket.buffer.length;
				var b=new Buffer(cltsocket.buffer.length+buffer.length);
				b.copyFrom(cltsocket.buffer,0,0,cltsocket.buffer.length);
				b.copyFrom(buffer,0,cltsocket.buffer.length,cltsocket.buffer.length+buffer.length);
				cltsocket.buffer=b;
			} else {
				cltsocket.buffer=buffer;
			//	oldlength=0;
			}
//			system.stdout.write("GenericTcpClient.get_message_prefix_bytes() - buffer=[ ");
//			for (var i=0;i<cltsocket.buffer.length;i++) system.stdout.write(cltsocket.buffer[i]+" ");
//			system.stdout.writeLine("]\n");
		}
	}
}];
