var fs=require("fs");
var gd = require("gd");

exports.add=[{
	 _type:"model_methods",
	_config: {name:"File"},
	AfterFetchCustom: function() {
		var rr=this._SQL().fallback_href2;
		var path=rr.F("Files","file_folder_path",this.file_folder_id);
		this.url=path+this.id+"."+this.ext;
		switch (this.type_id) {
			case 1:
				this.icon=this.url;
				break;
			case 2:
				this.icon=path+this.id+".jpg";
				break;
			default:
				this.icon=rr.F("Files","guess_icon",this.ext);
				break;
		}
	},

	AfterDeleteCustom: function() {	
		var rr=this._SQL().fallback_href2;
		var t=this;
		var path=rr.F("Files","file_folder_path",this.file_folder_id,1);
		var d=new fs.Directory(path);
		d.listFiles().forEach(function(filename) {
			var arr=filename.match(/^(\d+)(|-preview\d+\w*\d*)\.\w+$/);
			if (!arr) return;
			if (arr[1]!=t.id) return;
			f=new fs.File(path+filename);
			f.remove();
		});
	},

	AfterSaveCustom: function() {
		this.AfterFetchCustom();
	},

	MoveToFolder: function(fld_id) {
		if (fld_id==this.file_folder_id) return;
		var rr=this._SQL().fallback_href2;
		var t=this;
		var oldpath=rr.F("Files","file_folder_path",this.file_folder_id,1);
		this.file_folder_id=fld_id;
		var newpath=rr.F("Files","file_folder_path",this.file_folder_id,1);

		var d=new fs.Directory(oldpath);
		d.listFiles().forEach(function(filename) {
			var arr=filename.match(/^(\d+)(|-preview\d+\w*\d*)\.\w+$/);
			if (!arr) return;
			if (arr[1]!=t.id) return;
			f=new fs.File(oldpath+filename);
			try {
				rr.F("Files","mkdir_rec",newpath);
				f.move(newpath+filename);
			} catch(e) {
				throw new Error("Cannot move file from "+oldpath+filename+" to "+newpath+filename+" - error "+e);
			}
		});
	},
	
	// GD resize methods next
	
	StatePreview: function(param){
		
		var mode = [
			'preview',
			'crop'
		][0];
		
		var rr = this.GetRR();
		
		var preivew_index = parseInt(param);
		if (preivew_index == NaN ) throw 'Wrong preview param! ' + param;
		
		var basepath = rr.site.paths.html;
		var previews = rr.site.previews||this.system.previews;
		
		if (!previews[preivew_index]) throw new Error("Preview size "+preivew_index+" does not exist in configuration file");
		
		var state = this.ParseState();
		if (!state) return {error:1, text:'no state' };
		
		var k = (state.size/1000);
		
		if (state.y>0) {
			state.H-=state.y*k;
			state.y = 0;
		}
		
		if ((this.height - state.y)*k < state.H) {
			state.H = (this.height - state.y)*k;
		}
		
		if (state.x>0) {
			state.W-=state.x*k;
			state.x = 0;
		}
		
		if ((this.width - state.x)*k < state.W) {
			state.H = (this.width - state.x)*k;
		}
				
		var previewW = previews[preivew_index][0];
		var previewH = previews[preivew_index][1];
		
		var file_path = basepath.replace(/\/$/,'')+this.url;
		var preview_path = file_path.replace(/\/(\d+)\./,function(p,p1){
			return '/' + p1+'-state'+param+ '.'; 
		});
		
		var preview_url = this.url.replace(/\/(\d+)\./,function(p,p1){
			return '/' + p1+'-state'+param+ '.'; 
		});
		
		var f = new fs.File(file_path);
		if (!f.isFile()) return {error:1, text:'file not found' };
		
		var image_type = rr.F("Files","gd_image_type_by_ext",this.ext);
		
		var image = new gd.Image(image_type,file_path);
		//var dstimage = new gd.Image(gd.Image.TRUECOLOR, previewW, previewH);
		var dstimage = new gd.Image(gd.Image.TRUECOLOR, state.W, state.H);
		
		dstimage.alphaBlending(false);
		dstimage.saveAlpha(true);
		
		var params = [
			
			image,
			
			0,		//dstx
			0,		//dsty
			
			-state.x,	//srcx
			-state.y,	//srcy
			
			state.W,	//dstw
			state.H,	//dsth
			
			state.W / k,	//srcw
			state.H / k		//srch
			
		];
		
	//	throw {params:params,state:state};
				
		dstimage.copyResampled.apply(dstimage,params);
		dstimage.save(image_type,preview_path);	
				
		return preview_url;
	},
	
	ParseState: function(){
		return {"size":410,"x":-274,"y":-263,"W":301,"H":600}; // tmp
		return this.state && JSON.parse(this.state);
	},
	
	StateCss: function(){
		
		var state = this.ParseState();
		if (!state) return;
		
		var pos = this.CalcStatePos(state);
		
		var styles = [
			'background-repeat:no-repeat',
			'background-position-x:' + pos.x + 'px',
			'background-position-y:' + pos.y + 'px',
			'background-size:' + pos.width+'px '+pos.height+'px',
			'background-image: url(' + this.url + ')'
		];
		
		return styles.join(';');
	},
	
	CalcStatePos: function(state){
		var k = state.size/1000;
		return {
			x		:	state.x  	* k,
			y		:	state.y  	* k,
			width	:	this.width  * k,
			height	:	this.height * k
		}
	},
	
	// ...resize methods end
	
}];

