/**
 * Class: LNResponse
 *		Class used to generate http-response output
 *
 * Properties:
 *		output typeof String			- output text, i.e. '<html><body>.....'
 *		res typeof HttpResponse			- teajs response object
 *		response_headers typeof Object	- a map of http headers, i.e. {"Content-Type": 'text/html; charset=utf-8'}
 *		silent typeof Boolean			- return anything or not i.e. everything needed already was returned earlier (usually not recomended behavior)
 *		status_code typeof Integer		- HTTP status code, i.e. 200
 */

/**
 * Method: Constructor
 *
 * Parameters:
 *		res typeof HttpResponse - teajs response object
 */
function LNResponse(res)
{
	this.res=res;
	this.response_headers={"Content-Type": 'text/html; charset=utf-8'};
	this.silent=false;
	this.status_code=200;
}

/**
 * Method: render_http_error
 *
 * Parameters:
 *		RR typeof LNRR
 *		status_code typeof Integer	- http error code, i.e. 500
 *		error_code typeof String	- error code description, to be fetched from views/system/errors/ folder
 *		details typeof String
 */
LNResponse.prototype.render_http_error=function(rr,status_code,error_code,details)
{
	this.status_code=status_code;
	var ret="";
	if (rr) {
		try {
			rr.status_code=status_code;
			rr.error_code=rr.F("Views","L","system/errors",error_code,2);
			rr.details=details;
			if (!rr.pageinfo) rr.pageinfo={};
			if (rr.fields.ajaj) return this.output=JSON.stringify({error:{error_title:rr.error_code,error:rr.details||rr.error_code},error_code:error_code});
			rr.body=rr.view("system/errors/"+status_code);
			this.output=rr.view((rr.fields.ajaj)?"system/errors/page_ajaj":"system/errors/page");
			this._render_http_error=1;
			return this.output;
		} catch(e) {
			this.F("Admin","send_error_notification",e);
		}
	}
	this.output='<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">\n'+
		'<html xmlns="http://www.w3.org/1999/xhtml">\n'+
		'<head>\n'+
			'<title>Error '+error_code+'</title>\n'+
			'<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>\n'+
		'</head>\n'+
		'<body>\n'+
			'<h1>Error '+status_code+'</h1>\n'+
			'<h3>Error description: '+error_code+'</h3>\n'+
			(details?"<pre>"+details+"</pre>\n":"")+
			'<hr/>\n'+
			'<p><a href="http://www.lattenoir.org/">lattenoir</a> CMS&amp;Framework</p>'+
		'</body>\n'+
		'</html>\n';
	return this.output;
}

/**
 * Method: output
 *
 * Parameters:
 *		rr typeof LNRR, optional		-
 */
LNResponse.prototype.send=function(rr)
{
	if (rr && rr.site && rr.site.postprocess) {
		rr.site.postprocess(rr,this);
	}
	if (!this.silent) {
		this.res.status(this.status_code);
		this.res.header(this.response_headers);
		this.res.write(this.output);
	}
/*	if (site.paths) {
		try {
			var f=new File(site.paths.cache+"last.html");
			f.open("w");
			f.write(ret);
			f.write("\n\n");
			for (var k in site) {
				if (typeof space[k] == "function") {f.write("space."+k+"=function ...\n");continue;}
				f.write("space."+k+"="+space[k]+"\n");
			}
			f.write("get="+Dumper(space.req.get));
			f.write("post="+Dumper(space.req.post));
			f.write("files="+Dumper(space.req.files));
			f.close();
		} catch(e) {
		}
	}*/
}

/**
 * Method: render_500_error
 */
LNResponse.prototype.render_500_error=function(action,body)
{
	this.status_code=500;
	this.output="<html><body><div style='border: 1px dotted gray; padding: 5px;'><h1>HTTP ERROR 500</h1><div><b>Trying to render page "+action+"</b></div><pre>"+body+"</pre></div></body></html>";
}

/**
 * Method: render_301_redirect
 * Moved permanently HTTP/1.1
 */
LNResponse.prototype.render_301_redirect=function(url)
{
	this.status_code=301;
	this.response_headers["Location"] = url;
	this.output="";
}

/**
 * Method: render_303_redirect
 * See Other HTTP/1.1
 */
LNResponse.prototype.render_303_redirect=function(url)
{
	this.status_code=303;
	this.response_headers["Location"] = url;
	this.output="";
}

/**
 * Method: render_307_redirect
 * Temporary Redirect HTTP/1.1
 */
LNResponse.prototype.render_307_redirect=function(url)
{
	this.status_code=307;
	this.response_headers["Location"] = url;
	this.output="";
}

/**
 * Method: set_no_cache
 */
LNResponse.prototype.set_no_cache=function()
{
	this.response_headers["Cache-Control"]="no-cache, no-store, must-revalidate";
	this.response_headers["Pragma"]="no-cache";
	this.response_headers["Expires"]="0";
}

exports.LNResponse=LNResponse;
