select
	n.nspname as "schema",
	c.relname as "name",
	pg_catalog.pg_get_userbyid(c.relowner) as "owner"
from
	pg_catalog.pg_class c
	left join pg_catalog.pg_namespace n on n.oid = c.relnamespace
where
	c.relkind in ('r','') and
	n.nspname <> 'pg_catalog' and
	n.nspname <> 'information_schema' and
	n.nspname !~ '^pg_toast' and
	pg_catalog.pg_table_is_visible(c.oid)
order by 1,2

