var tmpl="1234567890qwertyuiopasdfghjklzxcvbnm";

function mksid()
{
	var a="";
	for (var i=0;i<15;i++) a+=tmpl[Math.floor(Math.random()*(tmpl.length-1))];
	return a;
}

function LNComet()
{
	this.clients={};
	this.channels={};
	this.connected={};
}

LNComet.prototype.create_id=function(socket)
{
	var clientid=mksid();
	this.create_id_helper(clientid);
	system.stdout.writeLine("	LNComet -     created clientid="+clientid);
	return JSON.stringify({ok:1,clientid:clientid});
}

LNComet.prototype.create_id_helper=function(clientid)
{
	this.clients[clientid]={date:new Date(),channels:{}};
}

LNComet.prototype.send=function(socket,clientid,data)
{
	
}

LNComet.prototype.send_to=function(clientid,data,request)
{
	var c=this.connected[clientid];
	if (!c) return;
	c.request.reply_headers["Content-Type"]="application/json; charset=utf-8";
	c.request.reply("200",JSON.stringify(data));
	c.request.server.remove_client_by_socket(c.socket);
}

LNComet.prototype.alive=function(clientid)
{

}

LNComet.prototype.check_old=function()
{
	
}

LNComet.prototype.connect=function(socket,clientid,request)
{
	this.connected[clientid]={socket:socket,request:request};
}

LNComet.prototype.disconnect=function(socket)
{
	for (var k in this.connected) {
		if (this.connected[k].socket===socket) delete this.connected[k];
	}
}

LNComet.prototype.subscribe=function(socket,clientid,channelid)
{
	system.stdout.writeLine("	LNComet -   subscribe clientid="+clientid+"   to channel "+channelid);
	if (!this.clients[clientid]) this.create_id_helper(clientid);
	this.alive(clientid);

	if (this.clients[clientid].channels[channelid]) {
		return JSON.stringify({ok:1,notify:"Already subscribed"});
	}

	this.clients[clientid].channels[channelid]=1;
	if (!this.channels[channelid]) this.channels[channelid]={count:0,clients:{}};
	this.channels[channelid].count++;
	this.channels[channelid].clients[clientid]=1;
	return JSON.stringify({ok:1,task:"subscribe"});

}

LNComet.prototype.unsubscribe=function(socket,clientid,channelid)
{
	system.stdout.writeLine("	LNComet - unsubscribe clientid="+clientid+" from channel "+channelid);
	if (!this.clients[clientid]) this.create_id_helper(clientid);
	this.alive(clientid);
	if (!this.clients[clientid].channels[channelid]) {
		return JSON.stringify({ok:1,notify:"Not subscribed"});
	}
	delete this.clients[clientid].channels[channelid];
	this.channels[channelid].count--;
	delete this.channels[channelid].clients[clientid];
	if (this.channels[channelid].count==0) delete this.channels[channelid];
	return JSON.stringify({ok:1,task:"unsubscribe"});
}

LNComet.prototype.notify=function(socket,channelid,message,request)
{
	system.stdout.writeLine("	LNComet - notify to channel "+channelid);
//	var name=json.name;
///	var message=JSON.stringify(json.message);
//	system.stdout.writeLine("CLT"+client+" notifies about "+name+" with message "+message);
	if (this.channels[channelid]) {
		for (var k in this.channels[channelid].clients) {
//			system.stdout.writeLine("CLT"+client+" notifies about "+name+" CLT"+this.clients[k].id);
			this.send_to(k,{channelid:channelid,data:message},request);
		}
	}
	return JSON.stringify({ok:1,task:"notify"});
}



exports.LNComet=LNComet;

