exports.config=[
	{
		"table": "Tadmin_start_widgets",
		"name": "AdminStartWidget",
		"folder": "admin_start_widgets",
		"patches": {
			"columns": {
				"fullscreen": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.fullscreen desc,main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "controller_name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "controller_mode",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "fullscreen",
				"not_null": 1,
				"default_value": "0",
				"datatype": "integer"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			}
		],
		"columns_l10n": [],
		"has_ordering": true,
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": ""
		}
	},
	{
		"table": "Tarticles",
		"name": "Article",
		"folder": "articles",
		"patches": {
			"columns": {
				"featured": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "count",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.id",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "count",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_category_enabled",
					"where": "main.enabled=1 and\nmain.category_id=:category_id",
					"order_by": "main.date_use desc",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_category",
					"where": "main.category_id=:category_id",
					"order_by": "main.date_use desc",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_by_calc_code",
					"where": "main.calc_code=:calc_code",
					"order_by": "main.id",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_category_enabled_limited",
					"where": "main.category_id=:category_id and\nmain.enabled=1",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_enabled_limited",
					"where": "main.enabled=1",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_groupcode_enabled_limited",
					"where": "main.enabled=1 and\nexists (select 1 from Tarticle_categories ac where groupcode=:category_groupcode and ac.id=main.category_id)",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_category_enabled_featured_limited",
					"where": "main.category_id=:category_id and\nmain.enabled=1 and\nmain.featured=1",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_groupcode_enabled_featured_limited",
					"where": "main.enabled=1 and\nmain.featured=1 and\nexists (select 1 from Tarticle_categories ac where groupcode=:category_groupcode and ac.id=main.category_id)",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_enabled_featured_limited",
					"where": "main.enabled=1 and\nmain.featured=1",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_category_enabled_visible_limited",
					"where": "main.category_id=:category_id and\nmain.enabled=1 and\n(main.date_show_start is null or main.date_show_start<=now()) and\n(main.date_show_end is null or main.date_show_end>=date_trunc('DAY',now()))",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_category_enabled_hidden_limited",
					"where": "main.category_id=:category_id and\nmain.enabled=1 and\n(\n  (main.date_show_start is not null and main.date_show_start>now()) or\n  (main.date_show_end is not null and main.date_show_end<date_trunc('DAY',now()))\n)",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_category_enabled_past_limited",
					"where": "main.category_id=:category_id and\nmain.enabled=1 and\n(main.date_show_end is not null and main.date_show_end<date_trunc('DAY',now()))\n",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_category_enabled_future_limited",
					"where": "main.category_id=:category_id and\nmain.enabled=1 and\n(main.date_show_start is null or main.date_show_start>date_trunc('DAY',now())) ",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_category_enabled_featured_visible_limited",
					"where": "main.category_id=:category_id and\nmain.enabled=1 and\n(main.date_show_start is null or main.date_show_start<=now()) and\n(main.date_show_end is null or main.date_show_end>=date_trunc('DAY',now())) and\nmain.featured=1",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_category_enabled_future_n_featured_limited",
					"where": "main.category_id=:category_id and\nmain.enabled=1 and\n(main.date_show_end is not null and main.date_show_end>date_trunc('DAY',now()))\n",
					"order_by": "main.date_use desc limit :limit offset :offset",
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_by_min_id",
					"where": "main.enabled=1 and\nmain.id > :min_id ",
					"order_by": "main.id",
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_image1",
					"where": "main.image1_id = :image1_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_name",
					"where": "coalesce(mainl1.name,mainl2.name) = :name",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"columns_l10n": {
				"disabled_l10n": {
					"datatype": "boolean"
				},
				"abstract": {
					"datatype": "wysiwyg"
				},
				"body": {
					"datatype": "wysiwyg"
				}
			},
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "date_cr",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "date_use",
				"not_null": 0,
				"datatype": "date"
			},
			{
				"name": "category_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tarticle_categories",
				"fkid": "t__category"
			},
			{
				"name": "calc_code",
				"not_null": 1,
				"skip_edit": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "image1_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image1"
			},
			{
				"name": "image2_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image2"
			},
			{
				"name": "folder_id",
				"not_null": 0,
				"datatype": "file_folder",
				"table": "Tfile_folders",
				"fkid": "t__folder"
			},
			{
				"name": "enabled",
				"not_null": 1,
				"datatype": "boolean"
			},
			{
				"name": "featured",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "date_show_start",
				"not_null": 0,
				"datatype": "date"
			},
			{
				"name": "date_show_end",
				"not_null": 0,
				"datatype": "date"
			},
			{
				"name": "image3_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image3"
			},
			{
				"name": "user_cr_id",
				"not_null": 0,
				"skip_edit": 1,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user_cr"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "4000"
			},
			{
				"name": "abstract",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "disabled_l10n",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "title",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "4000"
			},
			{
				"name": "meta_abstract",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "4000"
			},
			{
				"name": "meta_description",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "4000"
			}
		],
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"adminpanel": {
			"enabled": "1",
			"role": "articles",
			"section": "",
			"label": "",
			"cols_through": "category_id",
			"listname": "list_of_category",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": ""
		}
	},
	{
		"table": "Tarticle_categories",
		"name": "ArticleCategory",
		"folder": "article_categories",
		"patches": {
			"columns": {
				"has_abstract": {
					"datatype": "boolean"
				},
				"has_image1": {
					"datatype": "boolean"
				},
				"has_image2": {
					"datatype": "boolean"
				},
				"has_gallery": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "get_by_code",
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_of_groupcode",
					"where": "main.groupcode=:groupcode",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": [],
			"columns_l10n": {
				"abstract": {
					"datatype": "wysiwyg"
				},
				"body": {
					"datatype": "wysiwyg"
				}
			}
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "has_abstract",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "has_image1",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "has_image2",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "has_gallery",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "image1_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image1"
			},
			{
				"name": "image2_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image2"
			},
			{
				"name": "groupcode",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "abstract",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"adminpanel": {
			"enabled": "1",
			"role": "articles",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": ""
		},
		"code_column": "main.code"
	},
	{
		"table": "Tcarts",
		"name": "Cart",
		"folder": "carts",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "count",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_state",
					"where": "main.state_id=:state_id",
					"order_by": "main.id desc",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "count_of_state",
					"where": "main.state_id=:state_id",
					"order_by": "",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "count",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_state_limited",
					"where": "main.state_id=:state_id",
					"order_by": "main.id desc limit :limit offset :offset",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_previous_of_user",
					"where": "(:cart_id::bigint is null or main.id<:cart_id) and\nmain.user_id=:user_id",
					"order_by": "main.id desc limit 1",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_state_and_date_sent_between",
					"where": "main.state_id=:state_id and\n(:date_start::varchar is null or date_cr>=to_date(:date_start,'DD.MM.YYYY')) and\n(:date_end::varchar is null or date_cr<=to_date(:date_end,'DD.MM.YYYY'))\n",
					"order_by": "main.id",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_by_user_and_state",
					"where": "main.user_id = :user_id and\nmain.state_id = :state_id \n",
					"order_by": "main.id",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_by_user",
					"where": "main.user_id = :user_id",
					"order_by": "main.id",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "user_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user"
			},
			{
				"name": "state_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tcart_states",
				"fkid": "t__state"
			},
			{
				"name": "date_cr",
				"not_null": 0,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "date_mo",
				"not_null": 0,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "payment_method_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tcart_payment_methods",
				"fkid": "t__payment_method"
			},
			{
				"name": "manager_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__manager"
			},
			{
				"name": "calc_summ",
				"not_null": 1,
				"skip_edit": 1,
				"default_value": "0",
				"datatype": "numeric"
			},
			{
				"name": "sid",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "calc_items",
				"not_null": 1,
				"skip_edit": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "calc_amount",
				"not_null": 1,
				"skip_edit": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "address_postalindex",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "16"
			},
			{
				"name": "address_city",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "address_street",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "address_phone",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "address_comments",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "4000"
			},
			{
				"name": "real_payed",
				"not_null": 1,
				"default_value": "0",
				"datatype": "numeric"
			},
			{
				"name": "address_nearest",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "address_flat",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "address_porch",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "address_floor",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "address_password",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "required_change",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "date_sent",
				"not_null": 0,
				"datatype": "timestamp"
			},
			{
				"name": "date_state_change",
				"not_null": 0,
				"datatype": "timestamp"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "1",
			"role": "market",
			"section": "",
			"label": "",
			"cols_through": "state_id",
			"listname": "list_of_state",
			"edithelperfunc": "Admin.cart_helper",
			"savehelperfunc": "Admin.cart_helper",
			"listhelperfunc": "",
			"prehelperfunc": ""
		}
	},
	{
		"table": "Tcart_items",
		"name": "CartItem",
		"folder": "cart_items",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "list_of_cart",
					"where": "main.cart_id=:cart_id",
					"order_by": "main.market_item_id,main.other_ftype,main.other_fid",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "cart_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tcarts",
				"fkid": "t__cart"
			},
			{
				"name": "market_item_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tmarket_items",
				"fkid": "t__market_item"
			},
			{
				"name": "amount",
				"not_null": 1,
				"default_value": "1",
				"datatype": "bigint"
			},
			{
				"name": "other_ftype",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "other_fid",
				"not_null": 0,
				"datatype": "bigint"
			},
			{
				"name": "price",
				"not_null": 1,
				"default_value": "0",
				"datatype": "numeric"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": ""
		}
	},
	{
		"table": "Tcart_payment_methods",
		"name": "CartPaymentMethod",
		"folder": "cart_payment_methods",
		"patches": {
			"columns": {
				"prepay": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"variant": "count"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "prepay",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "func",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "enabled",
				"not_null": 1,
				"default_value": "1",
				"datatype": "boolean"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"adminpanel": {
			"enabled": "1",
			"role": "settings",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": ""
		},
		"code_column": "main.code"
	},
	{
		"table": "Tcart_states",
		"name": "CartState",
		"folder": "cart_states",
		"patches": {
			"columns": {
				"do_calc_money": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "get_by_code",
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "cssclass",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "do_calc_money",
				"not_null": 1,
				"datatype": "bigint"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"adminpanel": {
			"enabled": "1",
			"role": "settings",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": ""
		},
		"code_column": "main.code"
	},
	{
		"table": "Tcells",
		"name": "Cell",
		"folder": "cells",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				}
			]
		},
		"columns": [
			{
				"name": "worksheet_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tworksheets",
				"fkid": "t__worksheet"
			},
			{
				"name": "x",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "y",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "value",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"adminpanel": {}
	},
	{
		"table": "Tcontent_boxes",
		"name": "ContentBox",
		"folder": "content_boxes",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_group_enabled",
					"where": "main.enabled=1 and\nmain.group_id=:group_id",
					"order_by": "main.ordering limit coalesce(:limit,10000) offset coalesce(:offset,0)",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_group",
					"where": "main.group_id=:group_id",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_group_and_image",
					"where": "main.group_id=:group_id and\nmain.image_id=:image_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_group_and_name",
					"where": "main.group_id=:group_id and\ncoalesce(mainl1.name,mainl2.name)=:name",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "group_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tcontent_boxes_groups",
				"fkid": "t__group"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "image_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image"
			},
			{
				"name": "enabled",
				"not_null": 1,
				"datatype": "boolean"
			},
			{
				"name": "image2_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image2"
			}
		],
		"columns_l10n": [
			{
				"name": "override_image_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "tl__override_image"
			},
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "name2",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "name3",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "url",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			}
		],
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"has_ordering": true,
		"adminpanel": {
			"enabled": "1",
			"role": "pages",
			"section": "",
			"label": "",
			"cols_through": "group_id",
			"listname": "list_of_group",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": ""
		}
	},
	{
		"table": "Tcontent_boxes_groups",
		"name": "ContentBoxGroup",
		"folder": "content_boxes_groups",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.name",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "get_by_code",
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "code",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "1",
			"role": "pages",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": ""
		},
		"code_column": "main.code"
	},
	{
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_file_folder",
					"where": "file_folder_id=:file_folder_id",
					"order_by": "main.ordering",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "count",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_random_image",
					"where": "main.file_folder_id=:file_folder_id and\nmain.type_id=1",
					"order_by": "random() limit 1",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_first_image",
					"where": "main.file_folder_id=:file_folder_id and\nmain.type_id=1",
					"order_by": "main.ordering limit 1",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "count_of_file_folder",
					"where": "file_folder_id=:file_folder_id",
					"order_by": "",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "count",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_file_folder_limited",
					"where": "file_folder_id=:file_folder_id",
					"order_by": "main.ordering limit :limit offset coalesce(:offset,0)",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_file_folder_and_user",
					"where": "main.file_folder_id=:file_folder_id and\nmain.user_cr_id=:user_id",
					"order_by": "main.ordering",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_file_folder_and_name",
					"where": "main.file_folder_id=:file_folder_id and\nmainl1.name=:name",
					"order_by": "main.id",
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_last_in_file_folder",
					"where": "main.file_folder_id=:file_folder_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.ordering desc limit 1"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_file_folder_and_orig_filename",
					"where": "main.file_folder_id=:file_folder_id and\nmain.orig_filename=:orig_filename",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [
				{
					"name": "url",
					"datatype": "varchar"
				},
				{
					"name": "icon",
					"datatype": "varchar"
				}
			],
			"extra_fields_l10n": []
		},
		"table": "Tfiles",
		"name": "File",
		"folder": "files",
		"columns": [
			{
				"name": "type_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tfile_types",
				"fkid": "t__type"
			},
			{
				"name": "file_folder_id",
				"not_null": 1,
				"datatype": "file_folder",
				"table": "Tfile_folders",
				"fkid": "t__file_folder"
			},
			{
				"name": "user_cr_id",
				"not_null": 0,
				"skip_edit": 1,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user_cr"
			},
			{
				"name": "date_cr",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "date_mo",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "orig_filename",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "ext",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "16"
			},
			{
				"name": "width",
				"not_null": 0,
				"datatype": "bigint"
			},
			{
				"name": "height",
				"not_null": 0,
				"datatype": "bigint"
			},
			{
				"name": "filesize",
				"not_null": 0,
				"datatype": "bigint"
			},
			{
				"name": "seconds",
				"not_null": 0,
				"datatype": "bigint"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"has_ordering": true,
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		},
		"name_column": "coalesce(mainl1.name,mainl2.name)"
	},
	{
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "list_level",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0)",
					"order_by": "main.ordering",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "count",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_level",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0)",
					"order_by": "",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "count",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_level_desc",
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0)",
					"order_by": "main.ordering desc",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_by_parent_and_name",
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0) and\nmainl1.name=:name",
					"order_by": "main.id",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_code",
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select",
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "with_recurse",
					"skip": {},
					"where": "",
					"start_with": "",
					"connect_by": "",
					"order_by": "init.ordering",
					"variant": "recurse",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"table": "Tfile_folders",
		"name": "FileFolder",
		"folder": "file_folders",
		"columns": [
			{
				"name": "code",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "parent_id",
				"not_null": 0,
				"datatype": "file_folder",
				"table": "Tfile_folders",
				"fkid": "t__parent"
			},
			{
				"name": "user_cr_id",
				"not_null": 1,
				"skip_edit": 1,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user_cr"
			},
			{
				"name": "date_cr",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "date_mo",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"has_hier": true,
		"has_ordering": true,
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": ""
		},
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"code_column": "main.code"
	},
	{
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			]
		},
		"table": "Tfile_types",
		"name": "FileType",
		"folder": "file_types",
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "16"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"columns_l10n": [],
		"adminpanel": {},
		"name_column": "main.name",
		"code_column": "main.code"
	},
	{
		"table": "Tforms",
		"name": "Form",
		"folder": "forms",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "get_by_code",
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "fields_not_null",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "func_error",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "func_ok",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "mail_template1_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tmail_templates",
				"fkid": "t__mail_template1"
			},
			{
				"name": "mail_template2_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tmail_templates",
				"fkid": "t__mail_template2"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "1",
			"role": "settings",
			"section": "modules",
			"label": "Forms",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": ""
		},
		"code_column": "main.code"
	},
	{
		"table": "tgalleries",
		"name": "Gallery",
		"folder": "galleries",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_fid",
					"where": "main.fid_id = :fid_id and\nmain.fid_name = :fid_name",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "folder_id",
				"not_null": 0,
				"datatype": "file_folder",
				"table": "Tfile_folders",
				"fkid": "t__folder"
			},
			{
				"name": "style_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tgallery_styles",
				"fkid": "t__style"
			},
			{
				"name": "animation_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tgallery_animations",
				"fkid": "t__animation"
			},
			{
				"name": "fid_name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "fid_id",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": ""
		},
		"name_column": "main.name"
	},
	{
		"table": "tgallery_animations",
		"name": "GalleryAnimation",
		"folder": "gallery_animations",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"variant": "count"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			]
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "code",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "image_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image"
			},
			{
				"name": "enabled",
				"not_null": 0,
				"datatype": "boolean"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"code_column": "main.code",
		"adminpanel": {}
	},
	{
		"table": "tgallery_styles",
		"name": "GalleryStyle",
		"folder": "gallery_styles",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"variant": "count"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			]
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "code",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "image_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image"
			},
			{
				"name": "enabled",
				"not_null": 0,
				"datatype": "boolean"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"code_column": "main.code",
		"adminpanel": {}
	},
	{
		"table": "Tguestbooks",
		"name": "Guestbook",
		"folder": "guestbooks",
		"patches": {
			"columns": {
				"premoderated": {
					"datatype": "boolean"
				},
				"users_can_post": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "get_by_code",
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "premoderated",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "users_can_post",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "mail_template1_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tmail_templates",
				"fkid": "t__mail_template1"
			},
			{
				"name": "mail_template2_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tmail_templates",
				"fkid": "t__mail_template2"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "1",
			"role": "guestbooks",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": ""
		},
		"code_column": "main.code"
	},
	{
		"table": "Tguestbook_messages",
		"name": "GuestbookMessage",
		"folder": "guestbook_messages",
		"patches": {
			"columns": {
				"moderated": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "list_of_guestbook",
					"where": "main.guestbook_id=:guestbook_id",
					"order_by": "main.date_question desc",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_of_guestbook_moderated_limited",
					"where": "main.guestbook_id=:guestbook_id and\nmain.moderated=1",
					"order_by": "main.date_question desc limit :limit",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_of_guestbook_limited",
					"where": "main.guestbook_id=:guestbook_id",
					"order_by": "main.date_question desc limit :limit",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "guestbook_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tguestbooks",
				"fkid": "t__guestbook"
			},
			{
				"name": "user_q_name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "user_q_phone",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "user_q_email",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "user_q_avatar_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__user_q_avatar"
			},
			{
				"name": "user_a_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user_a"
			},
			{
				"name": "question",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "answer",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "date_question",
				"not_null": 0,
				"datatype": "timestamp"
			},
			{
				"name": "date_answer",
				"not_null": 0,
				"datatype": "timestamp"
			},
			{
				"name": "moderated",
				"not_null": 1,
				"datatype": "bigint"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "1",
			"role": "guestbooks",
			"section": "",
			"label": "",
			"cols_through": "guestbook_id",
			"listname": "list_of_guestbook",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": ""
		}
	},
	{
		"patches": {
			"columns": {
				"code": {},
				"name": {},
				"is_default": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"table": "Tl10n",
		"name": "L10N",
		"folder": "l10n",
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "16"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "160"
			},
			{
				"name": "is_default",
				"not_null": 1,
				"datatype": "bigint"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "1",
			"role": "settings",
			"section": "hardsettings",
			"label": "Site languages"
		},
		"name_column": "main.name",
		"code_column": "main.code"
	},
	{
		"table": "Tmail_templates",
		"name": "MailTemplate",
		"folder": "mail_templates",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "get_by_code",
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "get_by_signature",
					"where": "main.signature=:signature",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": [],
			"columns_l10n": {
				"body": {
					"datatype": "wysiwyg"
				}
			}
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "default_from",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "default_to",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "signature",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"columns_l10n": [
			{
				"name": "subject",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "1",
			"role": "settings",
			"section": "settings",
			"label": "Mail templates",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": ""
		},
		"code_column": "main.code"
	},
	{
		"table": "Tmarket_categories",
		"name": "MarketCategory",
		"folder": "market_categories",
		"patches": {
			"columns": {
				"is_featured": {
					"datatype": "boolean"
				},
				"is_new": {
					"datatype": "boolean"
				},
				"is_recomended": {
					"datatype": "boolean"
				},
				"has_abstract": {
					"datatype": "boolean"
				},
				"has_body2": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "list_level",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0)",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "list_level_enabled",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0) and\nmain.enabled=1",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_level",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0)",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "countt_level_enabled",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0) and\nmain.enabled=1",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_level_enabled",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0) and\nmain.enabled=1",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_by_code",
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_level_of_manufacturer_enabled",
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0) and\nmain.enabled=1 and\nexists (\n  select 1\n  from Tmarket_items i\n  where\n    i.manufacturer_id=:manufacturer_id and\n    i.category_id=main.id and\n    i.enabled=1\n)",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_manufacturer_enabled",
					"where": "main.enabled=1 and\nexists (\n  select 1\n  from Tmarket_items i\n  where\n    i.manufacturer_id=:manufacturer_id and\n    i.category_id=main.id and\n    i.enabled=1\n)",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_by_name",
					"where": "main.name=:name",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "with_recurse",
					"skip": {},
					"where": "",
					"start_with": "",
					"connect_by": "",
					"order_by": "init.ordering",
					"variant": "recurse",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": ""
				},
				{
					"name": "with_recurse_enabled",
					"skip": {},
					"where": "",
					"start_with": "init.enabled=1",
					"connect_by": "init.enabled=1",
					"order_by": "init.ordering",
					"variant": "recurse",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_enabled_featured",
					"where": "main.enabled=1 and\nmain.is_featured = 1",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.ordering"
				}
			],
			"columns_l10n": {
				"abstract": {
					"datatype": "wysiwyg"
				},
				"body": {
					"datatype": "wysiwyg"
				},
				"body2": {
					"datatype": "wysiwyg"
				}
			},
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "parent_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tmarket_categories",
				"fkid": "t__parent"
			},
			{
				"name": "image1_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image1"
			},
			{
				"name": "image2_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image2"
			},
			{
				"name": "enabled",
				"not_null": 1,
				"default_value": "1",
				"datatype": "boolean"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "fid",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "is_featured",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "is_new",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "is_recomended",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "has_abstract",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "has_body2",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "abstract",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "body2",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "title",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "4000"
			},
			{
				"name": "meta_abstract",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "4000"
			},
			{
				"name": "meta_description",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "4000"
			}
		],
		"has_hier": true,
		"adminpanel": {
			"enabled": "1",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		},
		"has_ordering": true,
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"code_column": "main.code"
	},
	{
		"table": "Tmarket_fields",
		"name": "MarketField",
		"folder": "market_fields",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "list_of_group",
					"where": "main.group_id=:group_id",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_of_group_and_search_level_between",
					"where": "main.group_id=:group_id and\nmain.search_level_id>=(select id from Tmarket_search_levels where code=:search_level_min_code) and\nmain.search_level_id<=(select id from Tmarket_search_levels where code=:search_level_max_code)",
					"order_by": "main.ordering",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "group_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tmarket_field_groups",
				"fkid": "t__group"
			},
			{
				"name": "datatype_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tmarket_field_datatypes",
				"fkid": "t__datatype"
			},
			{
				"name": "view_level_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tmarket_view_levels",
				"fkid": "t__view_level"
			},
			{
				"name": "search_level_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tmarket_search_levels",
				"fkid": "t__search_level"
			},
			{
				"name": "enabled",
				"not_null": 1,
				"datatype": "boolean"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "cid",
				"not_null": 0,
				"datatype": "bigint"
			},
			{
				"name": "fid",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			}
		],
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"has_ordering": true,
		"adminpanel": {
			"enabled": "1",
			"role": "market",
			"section": "",
			"label": "",
			"cols_through": "group_id",
			"listname": "list_of_group",
			"edithelperfunc": "",
			"savehelperfunc": ""
		}
	},
	{
		"table": "Tmarket_field_datatypes",
		"name": "MarketFieldDatatype",
		"folder": "market_field_datatypes",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			]
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "prefix",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "crsql",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "has_l10n",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "has_enum",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "view_code",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {},
		"code_column": "main.code"
	},
	{
		"table": "Tmarket_field_enums",
		"name": "MarketFieldEnum",
		"folder": "market_field_enums",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "get_by_value",
					"where": "main.value=:value",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "get_by_field_and_value",
					"where": "main.field_id=:field_id and\nlower(main.value)=lower(:value)",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_of_field",
					"where": "main.field_id=:field_id",
					"order_by": "lower(main.value)",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "field_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tmarket_fields",
				"fkid": "t__field"
			},
			{
				"name": "value",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2000"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": "",
			"prehelperfunc": ""
		}
	},
	{
		"table": "Tmarket_field_enumsl",
		"name": "MarketFieldEnuml",
		"folder": "market_field_enumsl",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				}
			]
		},
		"columns": [
			{
				"name": "field_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tmarket_fields",
				"fkid": "t__field"
			},
			{
				"name": "l10n_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tl10n",
				"fkid": "t__l10n"
			},
			{
				"name": "value",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2000"
			}
		],
		"columns_l10n": [],
		"adminpanel": {}
	},
	{
		"table": "Tmarket_field_groups",
		"name": "MarketFieldGroup",
		"folder": "market_field_groups",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "list_of_category",
					"where": "coalesce(main.category_id,0)=coalesce(:category_id,0)",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_of_empty_category",
					"where": "main.category_id is null",
					"order_by": "main.ordering",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "enabled",
				"not_null": 1,
				"datatype": "boolean"
			},
			{
				"name": "category_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tmarket_categories",
				"fkid": "t__category"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			}
		],
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"has_ordering": true,
		"adminpanel": {
			"enabled": "1",
			"role": "market",
			"section": "",
			"label": "",
			"cols_through": "category_id",
			"listname": "list_of_category",
			"edithelperfunc": "",
			"savehelperfunc": ""
		}
	},
	{
		"table": "Tmarket_items",
		"name": "MarketItem",
		"folder": "market_items",
		"patches": {
			"columns": {
				"in_stock": {
					"datatype": "boolean"
				},
				"is_new": {
					"datatype": "boolean"
				},
				"is_recomended": {
					"datatype": "boolean"
				},
				"is_featured": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "list_category_enabled",
					"where": "main.enabled=1 and\nmain.category_id=:category_id",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "count_category_enabled",
					"where": "main.enabled=1 and\nmain.category_id=:category_id",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "list_category_enabled_recomended",
					"where": "main.enabled=1 and\nmain.category_id=:category_id and\nmain.is_recomended=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_category_enabled_featured",
					"where": "main.enabled=1 and\nmain.category_id=:category_id and\nmain.is_featured=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_category_enabled_new",
					"where": "main.enabled=1 and\nmain.category_id=:category_id and\nmain.is_new=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_enabled_new",
					"where": "main.enabled=1 and\nmain.is_new=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_of_category",
					"where": "main.category_id=:category_id",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "get_by_code",
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_enabled_recomended",
					"where": "main.enabled=1 and\nmain.is_recomended=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_enabled_featured",
					"where": "main.enabled=1 and\nmain.is_featured=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_category_enabled_by_price",
					"where": "main.enabled=1 and\nmain.category_id=:category_id",
					"order_by": "main.price nulls last",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "get_by_name_and_category_and_manufacturer",
					"where": "coalesce(mainl1.name,mainl2.name)=:name and\nmain.category_id=:category_id and\nmain.manufacturer_id=:manufacturer_id",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "count_of_category",
					"where": "main.category_id=:category_id",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "list_for_admin_search",
					"where": "(\n  (lower(coalesce(main.fid,'---')) like '%'||lower(:name_or_fid)||'%') or\n  (lower(coalesce(mainl1.name,mainl2.name)) like '%'||lower(:name_or_fid)||'%') or\n  (lower(main.code) like '%'||lower(:name_or_fid)||'%')\n)",
					"order_by": "coalesce(mainl1.name,mainl2.name),main.code",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "get_by_fid",
					"where": "main.fid=:fid",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"columns_l10n": {
				"abstract": {
					"datatype": "wysiwyg"
				},
				"body": {
					"datatype": "wysiwyg"
				},
				"body2": {
					"datatype": "wysiwyg"
				}
			},
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "date_cr",
				"not_null": 0,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "image1_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image1"
			},
			{
				"name": "image2_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image2"
			},
			{
				"name": "group_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tmarket_item_groups",
				"fkid": "t__group"
			},
			{
				"name": "category_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tmarket_categories",
				"fkid": "t__category"
			},
			{
				"name": "manufacturer_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tmarket_manufacturers",
				"fkid": "t__manufacturer"
			},
			{
				"name": "enabled",
				"not_null": 1,
				"datatype": "boolean"
			},
			{
				"name": "in_stock",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "price",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "fid",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "is_new",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "is_recomended",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "is_featured",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "file_folder_id",
				"not_null": 0,
				"datatype": "file_folder",
				"table": "Tfile_folders",
				"fkid": "t__file_folder"
			},
			{
				"name": "old_price",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "base_price",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "discount_value",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "in_stock_count",
				"not_null": 0,
				"datatype": "bigint"
			},
			{
				"name": "fid2",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "abstract",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "body2",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"has_ordering": true,
		"adminpanel": {
			"enabled": "1",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "category_id",
			"listname": "list_of_category",
			"edithelperfunc": "Admin.market_item_helper",
			"savehelperfunc": "Admin.market_item_helper",
			"listhelperfunc": "",
			"prehelperfunc": ""
		},
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"code_column": "main.code"
	},
	{
		"table": "Tmarket_item_groups",
		"name": "MarketItemGroup",
		"folder": "market_item_groups",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "get_by_name",
					"where": "coalesce(mainl1.name,mainl2.name)=:name",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "enabled",
				"not_null": 1,
				"datatype": "boolean"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"adminpanel": {
			"enabled": "1",
			"role": "market",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": ""
		},
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"has_ordering": true
	},
	{
		"table": "Tmarket_item_view_levels",
		"name": "MarketItemViewLevel",
		"folder": "market_item_view_levels",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_use",
					"where": "main.item_id=:item_id and\nmain.l10n_id=:l10n_id and\nmain.view_level_id=:view_level_id",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_use_by_code",
					"where": "main.item_id=:item_id and\nmain.l10n_id=:l10n_id and\nmain.view_level_id in (select id from Tmarket_view_levels where code=:view_level_code)",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_item",
					"where": "main.item_id=:item_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "item_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tmarket_items",
				"fkid": "t__item"
			},
			{
				"name": "l10n_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tl10n",
				"fkid": "t__l10n"
			},
			{
				"name": "view_level_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tmarket_view_levels",
				"fkid": "t__view_level"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tmarket_manufacturers",
		"name": "MarketManufacturer",
		"folder": "market_manufacturers",
		"patches": {
			"columns": {
				"is_featured": {
					"datatype": "boolean"
				},
				"is_new": {
					"datatype": "boolean"
				},
				"is_recomended": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "get_by_code",
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_enabled_recomended",
					"where": "main.enabled=1 and\nmain.is_recomended=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_enabled_not_recomended",
					"where": "main.enabled=1 and\nmain.is_recomended=0",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_enabled_featured",
					"where": "main.enabled=1 and\nmain.is_featured=1",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_enabled_not_featured",
					"where": "main.enabled=1 and\nmain.is_featured=0",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_of_category_enabled",
					"where": "main.enabled=1 and\nexists (select 1 from Tmarket_items i where i.enabled=1 and i.category_id=:category_id and i.manufacturer_id=main.id)",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "get_by_name",
					"where": "coalesce(mainl1.name,mainl2.name)=:name",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "get_by_fid",
					"where": "main.fid=:fid",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_enabled_by_name",
					"where": "main.enabled=1",
					"order_by": "coalesce(mainl1.name,mainl2.name) ",
					"variant": "select"
				},
				{
					"skip": {},
					"name": "list_enabled_having_items",
					"where": "main.enabled=1 and\nexists (select 1 from Tmarket_items mi where mi.manufacturer_id=main.id and mi.enabled=1)",
					"order_by": "main.ordering",
					"variant": "select"
				}
			],
			"columns_l10n": {
				"abstract": {
					"datatype": "wysiwyg"
				},
				"body": {
					"datatype": "wysiwyg"
				},
				"body2": {
					"datatype": "wysiwyg"
				}
			},
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "image1_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image1"
			},
			{
				"name": "image2_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image2"
			},
			{
				"name": "enabled",
				"not_null": 1,
				"datatype": "boolean"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "fid",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "is_featured",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "is_new",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "is_recomended",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "abstract",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "body2",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "title",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "4000"
			},
			{
				"name": "meta_abstract",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "4000"
			},
			{
				"name": "meta_description",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "4000"
			}
		],
		"has_ordering": true,
		"adminpanel": {
			"enabled": "1",
			"role": "market",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": "",
			"prehelperfunc": ""
		},
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"code_column": "main.code"
	},
	{
		"table": "Tmarket_search_levels",
		"name": "MarketSearchLevel",
		"folder": "market_search_levels",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			]
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "32"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			}
		],
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"adminpanel": {},
		"code_column": "main.code"
	},
	{
		"table": "Tmarket_view_levels",
		"name": "MarketViewLevel",
		"folder": "market_view_levels",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			]
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "32"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			}
		],
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"adminpanel": {},
		"code_column": "main.code"
	},
	{
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.ordering",
					"variant": "select"
				}
			]
		},
		"table": "Tmediums",
		"name": "Medium",
		"folder": "mediums",
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "16"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"columns_l10n": [],
		"has_ordering": true,
		"adminpanel": {},
		"name_column": "main.name",
		"code_column": "main.code"
	},
	{
		"table": "Tpages",
		"name": "Page",
		"folder": "pages",
		"patches": {
			"columns": {
				"show_in_nav": {
					"datatype": "boolean"
				},
				"hide_anon": {
					"datatype": "boolean"
				},
				"hide_reg": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "list_level",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0)",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_by_alias",
					"where": "main.alias=:alias",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_nav_level",
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0) and\nmain.show_in_nav=1 and\n(main.hide_anon=0 or :user_id<>0) and\n(main.hide_reg=0 or :user_id=0) and\n(main.role_id is null or exists (select 1 from Tusers_enrolled ue where ue.role_id=main.role_id and ue.user_id=:user_id))",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_level",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0)",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "count_of_template",
					"where": "main.template_id=:template_id",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_nav_level_all",
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0) and\n(main.hide_anon=0 or :user_id<>0) and\n(main.hide_reg=0 or :user_id=0) and\n(main.role_id is null or exists (select 1 from Tusers_enrolled ue where ue.role_id=main.role_id and ue.user_id=:user_id))",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "with_recurse",
					"skip": {},
					"where": "",
					"start_with": "",
					"connect_by": "",
					"order_by": "init.ordering",
					"variant": "recurse",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						"Tpages p2 on p2.id=:id"
					],
					"name": "get_next_sibling",
					"where": "main.parent_id=p2.parent_id and\nmain.ordering>p2.ordering",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.ordering limit 1"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						"Tpages p2 on p2.id=:id"
					],
					"name": "get_prev_sibling",
					"where": "main.parent_id=p2.parent_id and\nmain.ordering<p2.ordering",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.ordering desc limit 1"
				}
			],
			"columns_l10n": {
				"disabled_l10n": {
					"datatype": "boolean"
				}
			},
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "parent_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tpages",
				"fkid": "t__parent"
			},
			{
				"name": "alias",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "template_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Ttemplates",
				"fkid": "t__template"
			},
			{
				"name": "prerun",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "prerun_param",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "show_in_nav",
				"not_null": 1,
				"default_value": "1",
				"datatype": "bigint"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "role_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Troles",
				"fkid": "t__role"
			},
			{
				"name": "hide_anon",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "hide_reg",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "cssclass",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "title",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "meta_description",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "meta_keywords",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "disabled_l10n",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			}
		],
		"has_hier": true,
		"has_ordering": true,
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		},
		"name_column": "coalesce(mainl1.name,mainl2.name)"
	},
	{
		"table": "Tpayment_service_errors",
		"name": "PaymentServiceError",
		"folder": "payment_service_errors",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				}
			]
		},
		"columns": [
			{
				"name": "psi_id",
				"not_null": 0,
				"datatype": "bigint"
			},
			{
				"name": "amount",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "error",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "pay_remote_addr",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "pay_user_agent_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tuser_agents",
				"fkid": "t__pay_user_agent"
			},
			{
				"name": "pay_data",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"adminpanel": {}
	},
	{
		"table": "Tpayment_service_invoices",
		"name": "PaymentServiceInvoice",
		"folder": "payment_service_invoices",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				}
			]
		},
		"columns": [
			{
				"name": "date_cr",
				"not_null": 0,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "date_pay",
				"not_null": 0,
				"datatype": "timestamp"
			},
			{
				"name": "ask_remote_addr",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "ask_user_agent_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tuser_agents",
				"fkid": "t__ask_user_agent"
			},
			{
				"name": "amount",
				"not_null": 1,
				"datatype": "numeric"
			},
			{
				"name": "user_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user"
			},
			{
				"name": "module_name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "module_fid",
				"not_null": 0,
				"datatype": "bigint"
			},
			{
				"name": "module_data",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "redirect",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "payed",
				"not_null": 1,
				"datatype": "integer"
			},
			{
				"name": "service_name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "service_data",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "pay_remote_addr",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "pay_user_agent_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tuser_agents",
				"fkid": "t__pay_user_agent"
			},
			{
				"name": "pay_data",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"adminpanel": {}
	},
	{
		"table": "Trewrites",
		"name": "Rewrite",
		"folder": "rewrites",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.regexp",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "get_by_signature",
					"where": "signature=:signature",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "regexp",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "fields",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "page_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tpages",
				"fkid": "t__page"
			},
			{
				"name": "controller_name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "controller_mode",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "signature",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "1",
			"role": "settings",
			"section": "settings",
			"label": "Rewrites",
			"cols_through": "",
			"listname": ""
		}
	},
	{
		"table": "Troles",
		"name": "Role",
		"folder": "roles",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_code",
					"where": "main.code=:code",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "32"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"adminpanel": {
			"enabled": "1",
			"role": "users",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		},
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"code_column": "main.code"
	},
	{
		"table": "Tseomps",
		"name": "Seomp",
		"folder": "seomps",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "page_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tpages",
				"fkid": "t__page"
			},
			{
				"name": "name_template",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "page_title",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "page_meta_description",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "page_meta_keywords",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "list_title",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "list_meta_description",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "list_meta_keywords",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "page_url_suffix",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"code_column": "main.code",
		"adminpanel": {
			"enabled": "1",
			"role": "articles",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tseomp_blocks",
		"name": "SeompBlock",
		"folder": "seomp_blocks",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_seomp_and_place",
					"where": "main.seomp_id=:seomp_id and\nmain.place_id=:place_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_seomp",
					"where": "main.seomp_id=:seomp_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "seomp_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tseomps",
				"fkid": "t__seomp"
			},
			{
				"name": "place_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Ttemplate_places",
				"fkid": "t__place"
			},
			{
				"name": "body_src",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "body_parsed",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tseomp_placeholders",
		"name": "SeompPlaceholder",
		"folder": "seomp_placeholders",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_seomp",
					"where": "main.seomp_id=:seomp_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.code"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_seomp_and_code",
					"where": "main.seomp_id=:seomp_id and\nmain.code=:code",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "seomp_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tseomps",
				"fkid": "t__seomp"
			},
			{
				"name": "code",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "image_tpl1",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "image_tpl2",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "image_tpl3",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "image_minsize1",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "image_minsize2",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "image_minsize3",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"columns_l10n": [],
		"code_column": "main.code",
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tseomp_placeholder_values",
		"name": "SeompPlaceholderValue",
		"folder": "seomp_placeholder_values",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_placeholder",
					"where": "main.placeholder_id=:placeholder_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.groupname,main.name"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "placeholder_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tseomp_placeholders",
				"fkid": "t__placeholder"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "image1_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image1"
			},
			{
				"name": "image2_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image2"
			},
			{
				"name": "image3_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image3"
			},
			{
				"name": "groupname",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "1",
			"role": "articles",
			"section": "",
			"label": "",
			"cols_through": "placeholder_id",
			"listname": "list_of_placeholder",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"table": "Tsexes",
		"name": "Sex",
		"folder": "sexes",
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "16"
			}
		],
		"columns_l10n": [
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"adminpanel": {
			"enabled": "1",
			"role": "settings",
			"section": "",
			"label": ""
		},
		"name_column": "coalesce(mainl1.name,mainl2.name)",
		"code_column": "main.code"
	},
	{
		"table": "Tsocial_networks",
		"name": "SocialNetwork",
		"folder": "social_networks",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_code",
					"where": "main.code=:code",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "32"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "can_post",
				"not_null": 1,
				"datatype": "integer"
			},
			{
				"name": "can_auth",
				"not_null": 1,
				"datatype": "integer"
			},
			{
				"name": "can_friends",
				"not_null": 1,
				"datatype": "integer"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"code_column": "main.code",
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tsocial_network_accounts",
		"name": "SocialNetworkAccount",
		"folder": "social_network_accounts",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_network_and_fid",
					"where": "main.network_id=:network_id and\n(\n  main.fid=:fid or\n  coalesce(main.fid2,'----111')=coalesce(:fid2,'----222')\n)",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_network_and_user",
					"where": "main.network_id=:network_id and\nmain.user_id=:user_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "user_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user"
			},
			{
				"name": "network_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tsocial_networks",
				"fkid": "t__network"
			},
			{
				"name": "fid",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "access_token",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "512"
			},
			{
				"name": "fid2",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "export_token",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1000"
			},
			{
				"name": "export_info",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "export_expires",
				"not_null": 0,
				"datatype": "timestamp"
			},
			{
				"name": "do_publish",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "date_cr",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "date_mo",
				"not_null": 0,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tsocial_network_account_friends",
		"name": "SocialNetworkAccountFriend",
		"folder": "social_network_account_friends",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_existing",
					"where": "main.account_id=:account_id and\nmain.fid=:fid",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "fid",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "email",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "date_birth",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "avatar_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__avatar"
			},
			{
				"name": "sex_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tsexes",
				"fkid": "t__sex"
			},
			{
				"name": "account_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tsocial_network_accounts",
				"fkid": "t__account"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tspreadsheets",
		"name": "Spreadsheet",
		"folder": "spreadsheets",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "get_by_generator_and_fid",
					"where": "main.generator=:generator and\nmain.fid=:fid",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1000"
			},
			{
				"name": "file_id",
				"not_null": 0,
				"datatype": "bigint"
			},
			{
				"name": "date_cr",
				"not_null": 0,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "generator",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "fid",
				"not_null": 1,
				"datatype": "bigint"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": ""
		}
	},
	{
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_code",
					"where": "main.code=:code",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"table": "Ttemplates",
		"name": "Template",
		"folder": "templates",
		"columns": [
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "code",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "256"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": ""
		},
		"name_column": "main.name",
		"code_column": "main.code"
	},
	{
		"table": "Ttemplate_places",
		"name": "TemplatePlace",
		"folder": "template_places",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "list_of_template",
					"where": "main.template_id=:template_id",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "count_of_template",
					"where": "main.template_id=:template_id",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_template_and_code",
					"where": "main.template_id=:template_id and\nmain.code=:code",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.ordering",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "template_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Ttemplates",
				"fkid": "t__template"
			},
			{
				"name": "place_type_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Ttemplate_place_types",
				"fkid": "t__place_type"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "admin_height",
				"not_null": 1,
				"default_value": "20",
				"datatype": "bigint"
			},
			{
				"name": "templatewide",
				"not_null": 1,
				"default_value": "0",
				"datatype": "bigint"
			},
			{
				"name": "preprocess",
				"not_null": 1,
				"datatype": "bigint"
			},
			{
				"name": "href",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			}
		],
		"columns_l10n": [],
		"has_ordering": true,
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": ""
		},
		"name_column": "main.name",
		"code_column": "main.code"
	},
	{
		"table": "Ttemplate_place_types",
		"name": "TemplatePlaceType",
		"folder": "template_place_types",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select"
				}
			]
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "16"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			}
		],
		"columns_l10n": [],
		"adminpanel": {},
		"name_column": "main.name",
		"code_column": "main.code"
	},
	{
		"table": "Tusers",
		"name": "User",
		"folder": "users",
		"patches": {
			"columns": {
				"calc_no_roles": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_of_login",
					"where": "main.login=:login",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						"case when main.date_last_page is null or main.date_last_page<now() - interval '5 minutes' then 1 else 0 end as date_last_page_needs_update"
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_by_calc_full_name",
					"where": "main.calc_full_name=:calc_full_name",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"name": "get_by_session",
					"where": "exists (select 1 from Tuser_sessions us where us.sid=:sid and main.id=us.user_id)",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						"case when main.date_last_page is null or main.date_last_page<now() - interval '5 minutes' then 1 else 0 end as date_last_page_needs_update"
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_of_login_cased",
					"where": "lower(main.login)=trim(lower(:login))",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "login",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "first_name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "second_name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "last_name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "calc_full_name",
				"not_null": 0,
				"skip_edit": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "password",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "enabled",
				"not_null": 1,
				"datatype": "boolean"
			},
			{
				"name": "email",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "calc_no_roles",
				"not_null": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "sex_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tsexes",
				"fkid": "t__sex"
			},
			{
				"name": "date_cr",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "date_birth",
				"not_null": 0,
				"datatype": "date"
			},
			{
				"name": "im_icq",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "16"
			},
			{
				"name": "im_jabber",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "48"
			},
			{
				"name": "im_msn",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "48"
			},
			{
				"name": "im_skype",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "48"
			},
			{
				"name": "phone",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "48"
			},
			{
				"name": "date_last_page",
				"not_null": 0,
				"datatype": "timestamp"
			},
			{
				"name": "avatar_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__avatar"
			},
			{
				"name": "about",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "regsid",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "prefer_l10n_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tl10n",
				"fkid": "t__prefer_l10n"
			},
			{
				"name": "im_telegram",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "1",
			"role": "users",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "Admin.user_helper",
			"savehelperfunc": "Admin.user_helper",
			"listhelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		},
		"name_column": "main.calc_full_name"
	},
	{
		"table": "Tuser_agents",
		"name": "UserAgent",
		"folder": "user_agents",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_name",
					"where": "main.name=:name",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "1000"
			},
			{
				"name": "is_robot",
				"not_null": 1,
				"datatype": "integer"
			},
			{
				"name": "device_type",
				"not_null": 1,
				"datatype": "integer"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tusers_enrolled",
		"name": "UserEnrolled",
		"folder": "users_enrolled",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "count"
				},
				{
					"skip": {},
					"name": "list_of_user",
					"where": "main.user_id=:user_id",
					"order_by": "main.id",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "select"
				},
				{
					"skip": {},
					"name": "count_of_user",
					"where": "main.user_id=:user_id",
					"order_by": "",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"variant": "count"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_of_user_and_role",
					"where": "main.user_id=:user_id and main.role_id=:role_id",
					"order_by": "main.id",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "user_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user"
			},
			{
				"name": "role_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Troles",
				"fkid": "t__role"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"listhelperfunc": "",
			"prehelperfunc": ""
		}
	},
	{
		"table": "Tworksheets",
		"name": "Worksheet",
		"folder": "worksheets",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"order_by": "",
					"variant": "count"
				},
				{
					"skip": {},
					"name": "list_of_spreadsheet",
					"where": "main.spreadsheet_id=:spreadsheet_id",
					"order_by": "main.ordering",
					"variant": "select"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "spreadsheet_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tspreadsheets",
				"fkid": "t__spreadsheet"
			},
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1000"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"has_ordering": true,
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"edithelperfunc": "",
			"savehelperfunc": ""
		}
	}
]