create table Tpage_subblock_styles (
	id			bigserial primary key,
	template_id	bigint not null,
	code		varchar(32) not null,
	name		varchar(128) not null
);
create unique index Ipage_subblock_styles on Tpage_subblock_styles(template_id,code);

create table Tpage_subblocks (
	id			bigserial primary key,
	page_id		bigint not null,
	ordering	bigserial unique,
	foreign key	(page_id) references Tpages
);

create table Tpage_subblocks_l10n (
	id			bigserial primary key,
	fid_id		bigint not null,
	l10n_id		bigint not null,
	body1		text,
	body2		text,
	body3		text,
	body4		text,
	body5		text,
	image1_id	bigint,
	image2_id	bigint,
	image3_id	bigint,
	image4_id	bigint,
	image5_id	bigint,
	foreign key	(fid_id) references Tpage_subblocks,
	foreign key	(l10n_id) references Tl10n,
	foreign key	(image1_id) references Tfiles,
	foreign key	(image2_id) references Tfiles,
	foreign key	(image3_id) references Tfiles,
	foreign key	(image4_id) references Tfiles,
	foreign key	(image5_id) references Tfiles
);
create unique index Ipage_subblocks_l10n on Tpage_subblocks_l10n(fid_id,l10n_id);



create table Tsubpageblocks (
	id				bigserial primary key,
	page_id			bigint not null,
	body			text,
	is_iphone		integer not null,
	image_id		bigint,
	image_height	integer,
	image_offset	integer,
	ordering		bigserial unique,
	foreign key		(page_id) references Tpages,
	foreign key		(image_id) references Tfiles
);


