#!/usr/bin/perl -w

BEGIN {
	push(@INC,"/home/modules/");
};
use strict;
use utf8;
use Excel::Writer::XLSX;
use Text::Iconv;
use Encode;
use DBI;
use Cwd 'abs_path';
use JSON;
use Data::Dumper;
abs_path($0)=~/^(.*[\\\/])/;
my $logpath="$1/logs/json_to_xlsx.log";
sub mywarn {
	open OUT,">>$logpath" or print STDERR "Could not write to $logpath\n";
	foreach (@_) {
		print OUT $_;
		print OUT "\n" unless $_=~/\n$/;
#		print STDERR $_;
#		print STDERR "\n" unless $_=~/\n$/;
	}
	close OUT;
}

sub mydie {
	mywarn(@_);
	exit(1);
}

# Parameters - login, password, database, ss_id, $output_filename

{
	$SIG{__WARN__}=\&mywarn;
	$SIG{__DIE__}=\&mydie;
	$SIG{INT}=\&mydie;

	warn "\n\n".localtime()."\n";
	warn $0." ".join(" ",@ARGV)."\n";
	die "Wrong parameters\n" unless @ARGV==1;
	my ($jsonfile)=@ARGV;
	
	my $xlsfile=$jsonfile;
	$xlsfile=~s/\.json$/.xlsx/;
	
	my $data;
	my $rows;
	my $merges;
	open IN,$jsonfile or die "Can not open $jsonfile";
	{local $/;$data=<IN>;}
	close IN;
	$data=decode_json($data);
	
	
	sub range {

		my ( $from_row, $from_col ) = @{ $_[0] };
		my ( $to_row, $to_col ) = @{ $_[1] };
	 
		die "Expecting to go from top-left to bottom-right"
			if $from_row > $to_row || $from_col > $to_col;
	 
		return join '', alpha( $from_row ), $from_col, ':', alpha( $to_row ), $to_col;
	}
	 
	sub alpha {
		my $row = 'A';
		$row++ for 1 .. +shift;
		return $row;
	}

	# $data->{string}
	# $data->{$string}
	# $data->[$id]
	# $data->{rows}->[0]->[1]
	
	# my $length=@{ $data->{rows} };  # Преобразовать в массив, а массив в скаляр. массив в скаляре - его размер
	# my @arr=@{ $data->{rows} };
	
	# die Dumper($data);

	$rows=$data->{rows};
	$merges=$data->{merges};
	if (-f $xlsfile) {
		unlink($xlsfile) or die "Can not delete $xlsfile";
	}
	my $workbook = Excel::Writer::XLSX->new($xlsfile);
	my $worksheet = $workbook->add_worksheet("export");
	
	my $merges_hash={};
	for (my $m=0;$m<@$merges;$m++) {
		my $row=$merges->[$m]->{row};
		my $col=$merges->[$m]->{col};
		unless($merges_hash->{$row}) {
			$merges_hash->{$row}={};
		};
		$merges_hash->{$row}->{$col}=$merges->[$m];
	}
	
	# die Dumper($merges_hash);
	
	for (my $y=0;$y<@$rows;$y++) {
		for (my $x=0;$x<@{$rows->[$y]};$x++) {
			my $value=$rows->[$y]->[$x];
			Encode::_utf8_on($value);
			
			my $format2 = $workbook->add_format(
				border    => 1,
				underline => 1,
				color     => 'blue',
				align     => 'center',
				valign    => 'vcenter',
			);
			
			unless ($merges_hash->{$y}->{$x}->{colspan}) {				
				unless ($merges_hash->{$y}->{$x}->{rowspan}) {				
					$worksheet->write($y,$x,$value);
				}
			} else {
			
				my $rowspan=$merges_hash->{$y}->{$x}->{rowspan};
				my $colspan=$merges_hash->{$y}->{$x}->{colspan};
				
				my $range = range([ $y, $x ],[ $y+$rowspan, $x+$colspan ]);
				
				$worksheet->write($y,$x,$range);
				
				#die Dumper($range);
				#$worksheet->merge_range( $range, $value, $format2 );
				
			}
			#$worksheet->merge_range( ,$value,$format);
			#$worksheet->write($y,$x,$value,$format);
			
			
			
			#my $format=$workbook->add_format(
			#	merge   => $merges_hash->{$y}->{$x}->{colspan}
			#);
			#unless ($merges_hash->{$y}->{$x}->{colspan}) {
			#	$worksheet->write($y,$x,$value);
			#} else {
			#	$worksheet->write($y,$x,$value,$format);
			#}
		}
	}
	
}

