(function( $, undefined ) {

$.widget("ui.ajajform_model_listinfo",$.ui.ajajform_widget, {
	options: {
		cssclass: "afw-model-listinfo"
	},
	
	_create: function() {
		var t=this;
		this.element.addClass(this.options.cssclass);
		this.element.empty();
		this.render();
	},

	refreshValue: function() {
		var skip="";
		var add="";
		var leftjoins="";

		if (this.options.value.add) add=this.options.value.add.join(",\n");
		if (this.options.value.leftjoins) var leftjoins=this.options.value.leftjoins.join("\n");
		for (var k in this.options.value.skip) {if (skip) skip+=",";skip+=k;}

		$("pre",this.element).text(this.options.value.preview);
		$(".skip",this.element).val(skip);
		$(".add",this.element).val(add);
		$(".name",this.element).val(this.options.value.name);
		$(".where",this.element).val(this.options.value.where);
		$(".with",this.element).val(this.options.value["with"]);
		$(".start_with",this.element).val(this.options.value.start_with);
		$(".connect_by",this.element).val(this.options.value.connect_by);
		$(".leftjoins",this.element).val(leftjoins);
		$(".order_by",this.element).val(this.options.value.order_by);
		$("select.variant",this.element).val(this.options.value.variant);
		this.variantChanged();
	},

	render: function() {
		var t=this;
		this.element.empty();
		this.element.html(
			"<table class='model-listinfo'>"+
			"<tr><td style='width:200px;'>Name</td><td><input type='text' class='name' style='width:930px'/></td>"+
								"<td rowspan='7'><div style='width:20px; height:20px;'></div></td>"+
								"<td rowspan='7' class='preview'>Last version on disk:<br/><pre style='font-size: 12px; border: 1px solid #d0d0d0; width: 600px; white-space: pre-wrap; height:380px; overflow: auto;'></pre></td></tr>"+
			"<tr><td>Skip columns</td><td><input type='text' class='skip' style='width:930px'/></td></tr>"+
			"<tr><td>Add columns</td><td><textarea class='add' style='width:930px;height:50px;'></textarea></td></tr>"+
			"<tr><td>Extra left joins</td><td><textarea class='leftjoins' style='width:930px;height:50px;'></textarea></td></tr>"+
			"<tr class='with'><td>with</td><td><textarea class='with' style='width: 930px; height:100px;'></textarea></td></tr>"+
			"<tr class='start_with'><td>start with</td><td><textarea class='start_with' style='width: 930px; height:50px;'></textarea></td></tr>"+
			"<tr class='connect_by'><td>connect by</td><td><textarea class='connect_by' style='width: 930px; height:50px;'></textarea></td></tr>"+
			"<tr><td>Where</td><td><textarea class='where' style='width: 930px; height:100px;'></textarea></td></tr>"+
			"<tr class='orderby'><td>Order by</td><td><input type='text' class='order_by' style='width:930px'/></td></tr>"+
			"<tr><td>Variant</td><td><select class='variant'><option value='select'>regular select</option><option value='count'>count lines</option><option value='with'>use WITH block</option><option value='recurse'>use WITH RECURSE block</option></select></td></tr>"+
			"<tr><td></td><td><input type='button' class='delete' value='Delete'/></td></tr>"+
			"</table>");
		$(".delete",this.element).button().bind("click",function() {t.deleteClicked();});
		$("select.variant",this.element).bind("change",function() { t.variantChanged(); });

		this.refreshValue();
	},

	variantChanged: function() {
		var variant=$("select.variant",this.element).val();
		switch (variant) {
			case "select":
				$('tr.orderby',this.element).show();
				$('tr.with',this.element).hide();
				$('tr.start_with',this.element).hide();
				$('tr.connect_by',this.element).hide();
				break;
			case "count":
				$('tr.orderby',this.element).hide();
				$('tr.with',this.element).hide();
				$('tr.start_with',this.element).hide();
				$('tr.connect_by',this.element).hide();
				break;
			case "with":
				$('tr.startwith',this.element).show();
				$('tr.orderby',this.element).show();
				$('tr.with',this.element).show();
				$('tr.start_with',this.element).hide();
				$('tr.connect_by',this.element).hide();
				break;
			case "recurse":
				$('tr.with',this.element).hide();
				$('tr.start_with',this.element).show();
				$('tr.connecy_by',this.element).show();
				$('tr.orderby',this.element).show();
				break;
		}
	},

	deleteClicked: function(div) {
	},
	
	commit: function() {
		var skip={};
		var arr=$("input.skip",this.element).val().split(/,/);
		for (var i=0;i<arr.length;i++) if (arr[i]!="") skip[arr[i]]=1;
		this.options.value.skip=skip;
		this.options.value.add=$("textarea.add",this.element).val().split(/,[\n\s]*/);
		this.options.value.leftjoins=$("textarea.leftjoins",this.element).val().split(/\n+/);

		this.options.value.name=$("input.name",this.element).val();
		this.options.value.where=$("textarea.where",this.element).val();
		this.options.value["with"]=$("textarea.with",this.element).val();
		this.options.value.start_with=$("textarea.start_with",this.element).val();
		this.options.value.connect_by=$("textarea.connect_by",this.element).val();
		this.options.value.variant=$("select.variant",this.element).val();
		this.options.value.order_by=$("input.order_by",this.element).val();
	},

	postvalue: function(r) {
		this.commit();
		r[this.options.name]=JSON.stringify(this.options.value);
	}
});

})( jQuery );

