ajajform_htmltemplates.password={
		htmltemplate: '<div class="af-label"></div><div class="af-edit"><input type="text"/><button  class="encrypt" style="display: none;"></button><button class="change" style="display:none;"></button><div class="af-error"></div></div><div style="clear: both;"></div>'
};

(function( $, undefined ) {
$.widget("ui.ajajform_password",$.ui.ajajform_widget, {
	/**
	 * Class: ui.ajajform_password
	 *		Создает однострочное поле ввода текста без форматирования 
	 *
	 * Properties:
	 *		options typeof Object 					- Настройки ajajform_password
	 *		options.cssclass typeof String, default 'afw-password' 	- CSS класс добавляемый к DIV формы
	 *		options.value typeof String				- введенный текст, значение
	 *		options.minsize typeof integer, default 0		- минимум введенных симовлов
	 *		options.maxsize typeof integer, default undefined	- максимум введенных симовлов
	 *		options.password typeof boolean, default 'false'	- является ли поле паролем
	 *		options.label typeof String				- заголовок поля
	 *		options.placeholder typeof Function, default null		- placeholder
	 *		options.width typeof integer, default null		- ширина поля в пикселях
	 *		options.readonly typeof boolean, default false		- нельзя менять
	 *		options.htmltemplate typeof HtmlString			- шаблон
	 *		options.autocomplete typeof Function, default null	- функция автозаполнения
	 *		options.add_decimals typeof Function, default null	- функция (?)
	 *		options.iscode typeof boolean, default false		- является ли вводимый текст кодом (видимо для автозаполнения ?)
	 *		options.isnumber typeof boolean, default false		- является ли вводимый текст числом
	 *		options.validate typeof Function, default null		- функция валидации
	 *		options.change typeof Function, default null		- функция при событии change
	 */
	options: {
		// \type cssclass
		cssclass: "afw-password",
		// \type text
		value: "",
		minsize: 0,
		maxsize: undefined,
		// \type boolean
		password: false,
		// \type text
		label: "",
		// \type integer
		width: null,
		readonly: false,
		// \type html
		htmltemplate: null,//'<div class="af-label"></div><div class="af-edit"><input type="text"/><div class="af-error"></div></div><div style="clear: both;"></div>',
		// \type any
		// \skip 1
		autocomplete: null,
		add_decimals:null,
		isnumber: false,
		iscode: false,
		validate: null,
		// \type: function
		change: null,
		anychange:null
	},
	i18n: {
		en: {
			too_long: "Field is too long",
			too_short: "Field is too short",
			not_number: "Not a number",
			not_code: "Only letters, digits, '_' and '-' allowed",
			change: "Change",
			encrypt: "Encrypt"
		},
		ru: {
			too_long: "Слишком длинное",
			too_short: "Слишком короткое",
			not_number: "Не число",
			not_code: "Разрешены только латинские буквы, цифры, '_' и '-'",
			change: "Сменить",
			encrypt: "Зашировать"
		}
	},
	_create: function() {
		if (this.options.password) this.genericCreate(function(x) {return x.replace('type="text"','type="password"')}); else this.genericCreate();
		this.initButtons();
		this.refreshLabel();
		this.refreshInput();
		this.refreshValue();
		this.refreshAutocomplete();
		this.refreshChange();
		this.refreshAnychange();
		this.refreshShow_autocomplete();
		this.refreshReadonly();
	},
	initButtons: function() {
		var t=this;
		$("button.encrypt",this.element).text(this.gettext("encrypt")).bind("click",function() {
			t.buttonEncryptClicked();
			return false;
		});
		$("button.change",this.element).text(this.gettext("change")).bind("click",function() {
			t.buttonChangeClicked();
			return false;
		});
	},
	buttonEncryptClicked: function() {
		var t=this;
		$.ajax({
			method:"POST",
			url:"/admin-AdminUser/",
			data: {
				ajaj:1,
				mode:"encrypt",
				value: $("input",this.element).val()
			},
			dataType:"json",
			success: function(ret) {
				t.options.value=ret.value;
				t.refreshValue();
			}
		});
	},
	buttonChangeClicked: function() {
		this.options.value="";
		this.refreshValue();
	},
	refreshPassword: function() {
	},
	refreshShow_autocomplete: function() {
		var t=this;
		$(".af-label .af-autocomplete",this.element).remove();
		if (!this.options.show_autocomplete) return;
		var ac=$("<div class='af-autocomplete'></div>").appendTo($(".af-label",this.element));
		var s=this.options.autocomplete.source;
		for (var i=0;i<s.length;i++) {
			$("<div class='af-ac-item'></div>").text(s[i]).appendTo(ac).bind("click",{d:s[i]},function(e) {t.option("value",e.data.d);});
		}
	},
	refreshAutocomplete: function() {
		var i=$("input",this.element);
		if (this.options.autocomplete) {
			i.addClass("has-autocomplete");
			i.autocomplete(this.options.autocomplete);
		} else {
			if (i.hasClass("has-autocomplete")) {
				i.autocomplete("destroy");
				i.removeClass("has-autocomplete");
			}
		}
	},
	refreshValue: function() {
		var i=$("input[type='text']",this.element);
		fmtd=this.options.value;
		if (fmtd===undefined || fmtd===null) fmtd="";
		if (this.options.add_decimals && fmtd!==null && fmtd!==undefined && fmtd.toString().match(/^\d+$/)) fmtd+=this.options.add_decimals;
		i.val(fmtd);
		if (fmtd.toString().match(/^\$\w+\$.+/)) {
			$("button.encrypt",this.element).hide();
			$("button.change",this.element).show();
			this.options.readonly=true;
		} else {
			$("button.encrypt",this.element).show();
			$("button.change",this.element).hide();
			this.options.readonly=false;
		}
		this.refreshReadonly();
	},
	refreshInput: function() {
		var i=$("input[type='text']",this.element);
		i.addClass("ui-corner-all af-edit");
		if(this.options.placeholder)i.attr('placeholder',this.options.placeholder);
		i.width(this.options.width);
		i.bind("focus",function(e) { $(this).addClass("ui-state-highlight"); });
		if (this.options.validate) {
			i.bind("blur",this,function(e) {
                console.log(e);
				$(this).removeClass("ui-state-highlight");
				e.data.validate();
			});
		} else {
			i.bind("blur",function(e) { $(this).removeClass("ui-state-highlight"); });
		}
		
		if (this.options.format) {
			var t = this;
			var format_func = function(v){return v;}
			if (this.options.format=='thousands') format_func = function(v){
				var s='';
				v = v.replace(/\s/g,'');
				for (var k = 0;k<v.length;k++) s = v[v.length-k-1]+((k%3==0 && k)?' ':'')+s;
				return s;
			}
			
			i.on("keyup",function(e) {
				clearTimeout(t.formating_interval);
				t.formating_interval = setTimeout(function(){
					i.val(format_func(i.val())); 	
				},200)				
			});
		}
		
	},
	refreshChange: function() {
		var i=$("input",this.element);
		if (!this.options.change) {
			if (this.oldBind) {i.unbind("change",this.oldBind);this.oldBind=null;}
			return;
		}
		if (this.oldBind) i.unbind("change",this.oldBind);
		this.oldBind=this.options.change;
		i.bind("change",{tag:i},this.oldBind);
	},
	refreshAnychange: function() {
		this.genericRefreshAnychange(
					"input",
					function(t) {t.options.value=$("input",t.element).val();},
					function(t) {return t.options.value;}
					);
		
	},
	refreshReadonly: function() {
		$("input",this.element).attr("readonly",this.options.readonly);
		if (this.options.readonly) this.element.addClass("ro");
		else this.element.removeClass("ro");
	},
	destroy: function() {
	},
	validate: function() {
		var vd=this.options.validate;
		var inp=$("input",this.element);
		var val=inp.val();
		var r;
		if (vd && !(/boolean|number|string/).test(typeof vd)) r=vd(val);
		if (!r) {
			if (val.length<this.options.minsize) r=this.gettext("too_short");
			if (this.options.maxsize && val.length>this.options.maxsize) r=this.gettext("too_long");
			if (this.options.isnumber && !(val.match(/^(|\+|\-)(|\d+|\.\d+|\d+\.|\d+\.\d+)$/))) r=this.gettext("not_number");
			if (this.options.iscode && !(val.match(/^[\w\-]*$/))) r=this.gettext("not_code");
		}
		if (r) inp.addClass("ui-state-error"); else inp.removeClass("ui-state-error");
		this.refreshError(r);
		return r?true:false;
	},
	postvalue: function(r) {
		var v = $("input",this.element).val();
		if (this.options.format=='thousands' && v) v = v.replace(/\s/g,'');
		r[this.options.name]=v;
	}
});

})( jQuery );
