ajajform_htmltemplates.checkbox={
		htmltemplate: '<div class="af-label"></div><div class="af-edit"><input type="checkbox" value="1"/><div class="af-error"></div></div><div style="clear: both;"></div>'
};
(function( $, undefined ) {
$.widget("ui.ajajform_checkbox",$.ui.ajajform_widget, {
	/**
	 *	Class: ui.ajajform_checkbox
	 *		Создает Флажок выбора да/нет.
	 * Properties:
	 *		options typeof Object 					- Настройки ajajform_checkbox
	 *		options.cssclass typeof String, default 'afw-checkbox' 	- CSS класс добавляемый к DIV формы
	 *		options.value typeof String				- значение
	 *		options.htmltemplate typeof HtmlString			- шаблон
	 *		options.validate typeof Function, default null		- функция валидации
	 *		options.label typeof String				- заголовок
	 *		options.readonly typeof boolean, default false		- без отправки
	 */
	options: {
		cssclass: "afw-checkbox",
		value: "",
		htmltemplate: null,//'<div class="af-label"></div><div class="af-edit"><input type="checkbox" value="1"/><div class="af-error"></div></div><div style="clear: both;"></div>',
		label: "",
		validate: null,
		readonly: false
	},
	/**
	 * Method: _create
	 *		Добавляет класс элементу this,
	 *		вставляет в него html-шаблон из this.options.htmltemplate,
	 *		заполняет заголовок, выставляет значение виджета, свойства ввода
	 * Parameters:
	 * Returns:
	 */
	_create: function() {
		this.element.addClass(this.options.cssclass);
		var t=this.getHtmlTemplate("htmltemplate");
		this.element.append(t);
		this.refreshLabel();
		this.refreshValue();
		this.refreshReadonly();
	},
	/**
	 * Method: refreshReadonly
	 *		Обновляет свойство readonly
	 * Parameters:
	 * Returns:
	 */	
	refreshReadonly: function() {
		$("input",this.element).prop('readonly',this.options.readonly);
		if (this.options && this.options.click) {
			var t = this;
			$("input",this.element).change(function(){ t.options.click($("input",t.element).prop("checked")); });
		}
		
	},
	/**
	 * Method: refreshValue
	 *		Берет значение this.options.value текущего виджета и меняет на него свойство checked
	 * Parameters:
	 * Returns:
	 */
	refreshValue: function() {
		console.log('cb refreshValue');
		var sel=$("input",this.element);
		if (this.options.value && this.options.value!="0") sel.prop("checked",true); else sel.prop("checked",false);
	},
	/**
	 * Method: refreshError
	 *		Обновляет отображение ошибки
	 * Parameters:
	 * 		e typeof String - текст ошибки
	 * Returns:
	 */
	refreshError: function(e) {
		$(".af-error",this.element).text(e==null?"":e);
	},
		/**
	 * Method: refreshLabel
	 *		Обновляет заголовок
	 * Parameters:
	 * Returns:
	 */
	refreshLabel: function() {
		$(".af-label",this.element).text(this.options.label);
	},
	/**
	 * Method: destroy
	 *	 не используется
	 * Parameters:
	 * Returns:
	 */
	destroy: function() {
	},
	/**
	 * Method: validate
	 *	 валидация виджета функцией this.options.validate;
	 * Parameters:
	 * Returns:
	 *  	typeof boolean
	 */
	validate: function() {
		var vd=this.options.validate;
		var inp=$("input",this.element);
		if (!vd) return false;
		var r=vd(inp.prop("checked"));
		if (r) inp.addClass("ui-state-error"); else inp.removeClass("ui-state-error");
		this.refreshError(r);
		return r?true:false;
	},
	/**
	 * Method: postvalue
	 *	 	сохранение значения чекбокса в объекте r
	 * Parameters:
	 * 		r typeof Object - объект с данными отправляемыми формой
	 * Returns:
	 */
	postvalue: function(r) {
		var sel=$("input",this.element);
		if (sel.prop("checked")) r[this.options.name]=sel.val(); else r[this.options.name]=0;
	}
});

})( jQuery );
