ajajform_htmltemplates.checkbox2={
		htmltemplate_float: '<div class="onoff"></div>',
		htmltemplate_full: '<div class="af-label"></div><div class="af-edit"><div class="onoff"></div><div class="af-description"></div><div class="cl"></div><div class="af-error"></div></div><div style="clear: both;"></div>'
};
(function( $, undefined ) {
$.widget("ui.ajajform_checkbox2",$.ui.ajajform_widget, {
	/**
	 *	Class: ui.ajajform_checkbox2
	 *		Создает Флажок выбора да/нет.
	 * Properties:
	 *		options typeof Object 					- Настройки ajajform_checkbox2
	 *		options.cssclass typeof String, default 'afw-checkbox' 	- CSS класс добавляемый к DIV формы
	 *		options.value typeof String				- значение
	 *		options.floatright typeof boolean, default 'false'	- выравнивание по правому краю
	 *		options.htmltemplate_float typeof HtmlString		- шаблон чекбокса
	 *		options.htmltemplate_full  typeof HtmlString		- шаблон блока с чекбоксом
	 *		options.validate typeof Function, default null		- функция валидации
	 *		options.label typeof String				- заголовок
	 *		options.readonly typeof boolean, default false		- без отправки
	 *		options.description_on typeof String	 		- описание при включенном чекбоксе
	 *		options.description_off typeof String			- описание при выключенном чекбоксе
	 *		options.descshowwidgets typeof  Function		- описание при выключенном чекбоксе
	 *		options.hidewidgets typeof Function			- описание при выключенном чекбоксе
	 *		options.html_description typeof boolean, default 'false' - повзоляет писать описания в html
	 */
	options: {
		// \type cssclass
		cssclass: "afw-checkbox2",
		// \type text
		// \name ru Значение
		// \description ru Значение, 0 или 1
		value: "",
		// \type text
		floatright: false,
		htmltemplate_float: null,//'<div class="onoff"></div>',
		htmltemplate_full: null,//'<div class="af-label"></div><div class="af-edit"><div class="onoff"></div><div class="af-description"></div><div class="cl"></div><div class="af-error"></div></div><div style="clear: both;"></div>',
		label:"",
		description_on: "",
		description_off: "",
		// \type function
		validate: null,
		readonly: false,
		showwidgets: null,
		hidewidgets: null
	},
	_create: function() {
		var t=this;
		this.element.addClass(this.options.cssclass);
		if (this.options.floatright) {
			this.element.addClass("awf-checkbox2-float-right");
			this.element.append(this.getHtmlTemplate("htmltemplate_float"));
		} else {
			this.element.append(this.getHtmlTemplate("htmltemplate_full"));
		}
		$(".onoff",this.element).bind("click",function() { t.changeState(); });
		this.refreshLabel();
		this.refreshValue();
		this.refreshReadonly();
		setTimeout(function() {t.toggleWidgets();},10);
	},
	changeState: function() {
		if (this.options.readonly) return;
		this.options.value=this.options.value?0:1;
		this.refreshValue();
		this.toggleWidgets();
		if (this.options.click) this.options.click(this.options.value);
	},
	toggleWidgets: function() {
		this.toggleWidgetsHelper("showwidgets",1);
		this.toggleWidgetsHelper("hidewidgets",0);
	},
	toggleWidgetsHelper: function(name,rule) {
		var tw=this.options[name];
		if (!tw) return;
		var prefix=this.options.tagid.match(/^(\w+-)/)[1];
		for (var i=0;i<tw.length;i++) {
			var n=tw[i].replace(/\./g,"\\.");
			if (this.options.value==rule) $("#"+prefix+n).show(); else $("#"+prefix+n).hide();
		}
	},
	refreshReadonly: function() {
	},
	refreshValue: function() {
		if (!this.options.value || this.options.value=="" || this.options.value=="0") this.options.value=0; else this.options.value=1;
		if (this.options.value) $(".onoff",this.element).addClass("onoffA"); else $(".onoff",this.element).removeClass("onoffA");
		var print_method = this.options.html_description ? "html" : "text";
		$(".af-description",this.element)[print_method](this.options.value?this.options.description_on:this.options.description_off);
	},
	refreshLabel: function() {
		$(".af-label",this.element).text(this.options.label);
	},
	refreshError: function(e) {
		$(".af-error",this.element).text(e==null?"":e);
	},
	destroy: function() {
	},
	validate: function() {
		var vd=this.options.validate;
		if (!vd) return false;
		var r=this.options.value;
		if (r) inp.addClass("ui-state-error"); else inp.removeClass("ui-state-error");
		this.refreshError(r);
		return r?true:false;
	},
	postvalue: function(r) {
		r[this.options.name]=this.options.value;
	}
});

})( jQuery );
