ajajform_htmltemplates.checkboxlist={
	htmltemplate: '<div class="af-label"></div><div class="af-edit"><div class="checkboxes"></div><div class="af-error"></div></div><div style="clear: both;"></div>',
	checkboxtemplate: '<span class="item"><label><input type="checkbox" class="" name="" value="1"/><span class="name"></span></label></span>'
};
(function( $, undefined ) {
$.widget("ui.ajajform_checkboxlist",$.ui.ajajform_widget, {
	/**
	 *	Class: ui.ajajform_checkboxlist
	 *		Создает список чекбоксов 
	 * Properties:
	 *		options typeof Object 						- Настройки ajajform_checkboxlist
	 *		options.cssclass typeof String, default 'afw-checkboxlist' 	- CSS класс добавляемый к DIV формы
	 *		options.available typeof Array, default []			- массив доступных значений
	 *		options.checked typeof Array, default []			- массив выбранных значений
	 *		options.width typeof integer, default '200'			- ширина блока
	 *		options.htmltemplate  typeof HtmlString				- шаблон блока с чекбоксами
	 *		options.checkboxtemplate  typeof HtmlString			- шаблон чекбокса
	 *		options.validate typeof Function, default null			- функция валидации
	 *		options.label typeof String					- заголовок
	 */
	options: {
		cssclass: "afw-checkboxlist",
		available: [],
		checked: [],
		width: 270,
		htmltemplate: null,//'<div class="af-label"></div><div class="af-edit"><div class="checkboxes"></div><div class="af-error"></div></div><div style="clear: both;"></div>',
		checkboxtemplate: null,//'<span class="item"><input type="checkbox" class="" name="" value="1"/><span class="name"></span></span>',
		label: "",
		readonly: false,
		validate: null,
		item_width:undefined
	},
	_create: function() {
		this.element.addClass(this.options.cssclass);
		var t=this.getHtmlTemplate("htmltemplate");
		this.element.append(t);
		this.refreshLabel();
//		this.refreshWidth();
		this.refreshAvailable();
//		this.refreshItemWidth();
		this.refreshChecked();
		this.refreshReadonly();
	},
	refreshWidth: function() {
		this.refreshAvailable();
//		$(".af-edit",this.element).width(this.options.width);
	},

	refreshItemWidth: function() {
		this.refreshAvailable();
/*		if (this.options.item_width===undefined || this.options.item_width>=this.options.width) {
			$(".checkboxes .item",this.element).css("width",undefined);
		} else {
			$(".checkboxes .item",this.element).css("width",this.options.item_width);
		}*/
	},

	refreshReadonly: function() {
		if (this.options.readonly) this.element.addClass("ro");
		else this.element.removeClass("ro");
	},

	refreshAvailable: function() {
		$(".af-edit",this.element).width(this.options.width);
		var cbs=$(".checkboxes",this.element).empty();
		var cbgs;
		if (this.options.item_width===undefined || this.options.item_width>=this.options.width) {
			cbgs=1;
		} else {
			cbgs=Math.floor(this.options.width/this.options.item_width);
		}
		var cbgarr=[];
		if (cbgs==1) {
			cbs.addClass("af-cbg0");
			cbgarr=[cbs];
		} else {
			cbs.removeClass("af-cbg0");
			for (var i=0;i<cbgs;i++) cbgarr.push($("<div class='af-cbg af-cbg"+i+"'></div>").css("width",this.options.item_width||this.options.width).appendTo(cbs));
		}
		for (var i=0;i<this.options.available.length;i++) {
			var cbgn=Math.floor(i*cbgs/this.options.available.length);
			var av=this.options.available[i];
			var cb=$(this.getHtmlTemplate("checkboxtemplate"));
			if (cbgs==0) cbs.append(cb); else cbgarr[cbgn].append(cb);
			$(".name",cb)[this.options.html?'html':'text'](av.name);
			$("input",cb).prop("name",this.options.name+"-"+av.id);
			if (this.options.item_width) cb.css("width",this.options.item_width);
			if (av.level) {
				$(cb).css("padding-left",((av.level-1)*40)+"px");
			}
		}
		cbs.append('<div style="clear: both;"></div>');
	},
	refreshChecked: function() {
		$(".checkboxes input",this.element).prop("checked",false);
		for (var i=0;i<this.options.checked.length;i++) {
			var c=this.options.checked[i];
			$(".checkboxes input[name='"+this.options.name+"-"+c+"']",this.element).prop("checked",true);
		}
	},
	refreshError: function(e) {
		$(".af-error",this.element).text(e==null?"":e);
	},
	refreshLabel: function() {
		$(".af-label",this.element).text(this.options.label);
	},
	destroy: function() {
	},
	validate: function() {
		return false;
	},
	postvalue: function(r) {
		var sel=$(".checkboxes .item input:checked",this.element);
		for (var i=0;i<sel.length;i++) {
			var item=sel[i];
			r[item.name]=1;
		}
	}
});

})( jQuery );
