ajajform_htmltemplates.currencyedit={
		htmltemplate: 	'<div class="af-label"></div>'+
						'<div class="af-edit">'+
							'<input type="text"/ class="integral">'+
							'<div class="integral_currency currency"></div>'+
							'<input type="text"/ class="decimals">'+
							'<div class="decimals_currency currency"></div>'+
							'<div class="af-error"></div>'+
						'</div>'+
						'<div style="clear: both;"></div>',
};

(function( $, undefined ) {
	$.widget("ui.ajajform_currencyedit",$.ui.ajajform_widget, {      
		options: {
			cssclass: "afw-currencyedit",
			integral_width:108,
			decimals_width:16,
			integral_label:'руб.',
			decimals_label:'коп.',
			
			integral_placeholder:'--',
			decimals_placeholder:'--',
			
			integral_size:200,
			decimals_size:2,
		},
		_create: function() {
			var t = this;
			t.genericCreate();
			t.refreshLabel();
			t.initInputs();
			t.refreshInputs();
		},
		initInputs:function(){
			var t = this;
			var integral_input = $('input.integral',t.element);
			var decimals_input = $('input.decimals',t.element);
			
			integral_input.width(t.options.integral_width);
			decimals_input.width(t.options.decimals_width);
			
			integral_input.attr('placeholder',t.options.integral_placeholder);
			decimals_input.attr('placeholder',t.options.decimals_placeholder);
			
			$('.integral_currency',t.element).html(t.options.integral_label);
			$('.decimals_currency',t.element).html(t.options.decimals_label);
			
			
			integral_input.addClass("ui-corner-all af-edit");
			decimals_input.addClass("ui-corner-all af-edit");	
			if(t.options.integral_placeholder) integral_input.attr('placeholder',t.options.integral_placeholder);
			if(t.options.decimals_placeholder) decimals_input.attr('placeholder',t.options.decimals_placeholder);

			integral_input.on("focus",function(e) { $(this).addClass("ui-state-highlight"); });
			decimals_input.on("focus",function(e) { $(this).addClass("ui-state-highlight"); });
			integral_input.on("blur",function(e) { $(this).removeClass("ui-state-highlight"); });
			decimals_input.on("blur",function(e) { $(this).removeClass("ui-state-highlight"); });
			
			integral_input.attr('maxlength',t.options.integral_size);
			decimals_input.attr('maxlength',t.options.decimals_size);
			
			if (this.options.integral_format) {
				var t = this;
				var format_func = function(v){return v;}
				if (this.options.integral_format=='thousands') format_func = function(v){
					var s='';
					v = v.replace(/\s/g,'');
					for (var k = 0;k<v.length;k++) s = v[v.length-k-1]+((k%3==0 && k)?' ':'')+s;
					return s;
				}
				
				integral_input.on("keyup",function(e) {
					clearTimeout(t.formating_interval);
					t.formating_interval = setTimeout(function(){
						integral_input.val(format_func(integral_input.val()));
						integral_input.change();
					},200)				
				});
			}
			
			integral_input.on("keyup",function(e) {
				if($(this).val()) $(this).val($(this).val().replace(/\D/g,'').replace(/^0+/,''));
			});
			decimals_input.on("keyup",function(e) {
				if($(this).val()) $(this).val($(this).val().replace(/\D/g,''));
				//$(this).val(pad($(this).val()));
			});
			
			//integral_input.on("keyup keydown",function(e) {
			//	e = e || window.event;
			//	if (!key_check(e.keyCode)) return false;
			//});
			//decimals_input.on("keyup keydown",function(e) {
			//	e = e || window.event;
			//	if (!key_check(e.keyCode)) return false;
			//});
			
			function key_check(k){
				if (k==16) return true;
				if (k==46) return true;
				if (k==17 || k==91) return true;
				if (k==32 || k==8) return true;
				if (k>=37 && k<=40) return true;
				if (k<48 || k>57) return false;
				return true;
			}
		
		},
		
		
		refreshInputs:function(){
			var t = this;
			
			function pad(n){return n<10?'0'+n:n;}
			
			var integral_input = $('input.integral',t.element);
			var decimals_input = $('input.decimals',t.element);
			
			if (t.options.value) {
				var integral = t.options.value.toString().split('.')[0];
				var decimals = t.options.value.toString().split('.')[1];				
				integral_input.val(integral);
				decimals_input.val(pad(decimals||0));				
			} else {
				integral_input.val('');
				decimals_input.val('');
			}
			
			integral_input.keyup();
			decimals_input.keyup();
			
		},
		
		refreshValue: function() {
			this.refreshInputs();
		},
		
		postvalue: function(r) {
			var t = this;
			console.log('postvalue');
			
			var integral_input = $('input.integral',this.element);
			var decimals_input = $('input.decimals',this.element);
			var i_val = integral_input.val() || 0;
			var d_val = decimals_input.val() || 0;
			this.options.value = i_val+'.'+d_val;
			
			if (t.options.value) t.options.value = t.options.value.replace(/\s/g,'');
			r[t.options.name] = parseFloat(t.options.value) || 0;
		}
	});
})( jQuery );
