ajajform_htmltemplates.datetime={
		htmltemplate: '<div class="af-label"></div><div class="af-edit"><input type="text" class="date" size="11"/> <input type="text" class="time" size="6"/><div class="af-error"></div></div><div style="clear: both;"></div>'
};
(function( $, undefined ) {
$.widget("ui.ajajform_datetime",$.ui.ajajform_widget, {
	/**
	 *	Class: ui.ajajform_datetime
	 *		Создает поля выбора даты+время
	 * Properties:
	 *		options typeof Object 					- Настройки ajajform_date
	 *		options.cssclass typeof String, default 'afw-date' 	- CSS класс добавляемый к DIV формы
	 *		options.width typeof integer, default null		- ширина блока
	 *		options.not_null typeof boolean, default false		- обязателен
	 *		options.htmltemplate  typeof HtmlString			- шаблон
	 *		options.validate typeof Function, default null		- функция валидации
	 *		options.label typeof String				- заголовок
	 *		options.readonly typeof boolean, default false		- без отправки
	 *		options.dateFormat typeof String, default "dd.mm.yy"	- формат даты
	 */
	options: {
		// \type cssclass
		cssclass: "afw-datetime",
		// \type text
		value: "",
		// \type text
		not_null:false,
		label: "",
		// \type integer
		width: null,
		// \type html
		htmltemplate: null,//'<div class="af-label"></div><div class="af-edit"><input type="text" class="date" size="11"/> <input type="text" class="time" size="6"/><div class="af-error"></div></div><div style="clear: both;"></div>',
		// \type function
		validate: null,
		dateFormat: "dd.mm.yy",
		readonly: false
	},
	i18n: {
		en: {
			empty: "Field is empty"
		},
		ru: {
			empty: "Пустое поле"
		}
	},
	_create: function() {
		this.element.addClass(this.options.cssclass);
		var t=this.getHtmlTemplate("htmltemplate");
		this.element.append(t);
		this.refreshLabel();
		this.refreshInput();
		this.refreshReadonly();
	},
	getDatePart: function() {
		if (!this.options.value) return "";
		return this.options.value.split(" ")[0];
	},
	getTimePart: function() {
		if (!this.options.value) return "";
		return this.options.value.split(" ")[1];
	},
	refreshReadonly: function() {
		$("input",this.element).prop('readonly',this.options.readonly);
	},
	refreshInput: function() {
		var i1=$("input.date",this.element);
		i1.addClass("ui-corner-all af-edit");
		i1.width(this.options.width);
		i1.val(this.getDatePart());
		i1.bind("focus",function(e) { $(this).addClass("ui-state-highlight"); });
		i1.datepicker({dateFormat: this.options.dateFormat});
		if (this.options.validate) {
			i1.bind("blur",this,function(e) {
				$(this).removeClass("ui-state-highlight");
				e.data.validate();
			});
		} else {
			i1.bind("blur",function(e) { $(this).removeClass("ui-state-highlight"); });
		}
		var i2=$("input.time",this.element);
		i2.addClass("ui-corner-all af-edit");
		i2.width(this.options.width);
		i2.val(this.getTimePart());
		i2.bind("focus",function(e) { $(this).addClass("ui-state-highlight"); });
		if (this.options.validate) {
			i2.bind("blur",this,function(e) {
				$(this).removeClass("ui-state-highlight");
				e.data.validate();
			});
		} else {
			i2.bind("blur",function(e) { $(this).removeClass("ui-state-highlight"); });
		}
	},
	refreshError: function(e) {
		$(".af-error",this.element).text(e==null?"":e);
	},
	refreshLabel: function() {
		$(".af-label",this.element).text(this.options.label);
	},
	destroy: function() {
	},
	validate: function() {
		var vd=this.options.validate;
		var i1=$("input.date",this.element);
		var i2=$("input.time",this.element);
		var r;
		if (vd) r=vd(i1.val(),i2.val());
		if (!r) {
			if ((i1.val().length==0 || i2.val().length==0) && this.options.not_null) r=this.gettext("empty");
		}
		if (!r) return false;

		if (r) {
			i1.addClass("ui-state-error");
			i2.addClass("ui-state-error");
		} else {
			i1.removeClass("ui-state-error");
			i2.removeClass("ui-state-error");
		}
		this.refreshError(r);
		return r?true:false;
	},
	postvalue: function(r) {
		var i1=$("input.date",this.element);
		var i2=$("input.time",this.element);
		if (i1.val()) r[this.options.name]=i1.val()+" "+i2.val();
	}
});

})( jQuery );
