ajajform_htmltemplates.label={
		htmltemplate: '<div class="af-label"></div><div class="af-value"></div><div style="clear: both;"></div>'
};


(function( $, undefined ) {
$.widget("ui.ajajform_label",$.ui.ajajform_widget, {
	/**
	 * Class: ui.ajajform_label
	 *		Статичная текстовая строка
	 * Properties:
	 *		options typeof Object 						- Настройки ajajform_label
	 *		options.cssclass typeof String, default 'afw-label' 		- CSS класс добавляемый к DIV формы
	 *		options.label typeof String					- заголовок строки
	 *		options.value typeof String					- текст строки
	 *		options.showlabel typeof boolean, default екгу			- отображать заголовок
	 *		options.html typeof boolean, default false			- является ли текст html'ом
	 *		options.htmltemplate typeof HtmlString				- шаблон
	 */
	options: {
		// \type cssclass
		cssclass: "afw-label",
		// \type text
		value: "",
		// \type text
		label: "",
		showlabel: true,
		// \type boolean
		html: false,
		// \type integer
		width: null,
		// \type text
		htmltemplate: null
	},
	_create: function() {
		this.element.addClass(this.options.cssclass);
		this.element.append(this.getHtmlTemplate("htmltemplate"));
		this.refreshLabel();
		this.refreshValue();
		this.refreshShowlabel();
		this.refreshWidth();
	},
	refreshWidth: function() {
		$(".af-value",this.element).width(this.options.width);
	},
	refreshLabel: function() {
		$(".af-label",this.element).text(this.options.label);
	},
	refreshShowlabel: function() {
		if (this.options.showlabel) $(".af-label",this.element).show(); else $(".af-label",this.element).hide();
	},
	refreshValue: function() {
		$(".af-value",this.element)[this.options.html?"html":"text"](this.options.value);
	}
});

})( jQuery );
