ajajform_htmltemplates.select={
		htmltemplate: '<div class="af-label"></div><div class="af-edit"><select/><div class="af-error"></div></div><div style="clear: both;"></div>',
		htmltemplate_disableable: '<div class="af-label"></div><div class="af-disable"></div><div class="af-edit"><select/><div class="af-error"></div></div><div style="clear: both;"></div>'
};
(function( $, undefined ) {
$.widget("ui.ajajform_select",$.ui.ajajform_widget, {
	/**
	 * Class: ui.ajajform_select
	 *		Создает поле выбора из списка вариантов
	 * Properties:
	 *		options typeof Object 					- Настройки ajajform_textedit
	 *		options.cssclass typeof String, default 'afw-select' 	- CSS класс добавляемый к DIV формы
	 *		options.add_null typeof boolean, default false		- добавить "пустой" вариант
	 *		options.not_null typeof boolean, default false		- обязательно ли что-либо выбрать 
	 *		options.value typeof String				- выбранный вариант
	 *		options.htmltemplate typeof HtmlString			- шаблон
	 *		options.htmltemplate_disableable  typeof HtmlString	- шаблон шаблон при Disabled
	 *		options.values typeof  Array				- Массив с вариантами
	 *		options.groupped typeof boolean, default false		- группировка
	 *		options.disabled typeof boolean, default false		- выключен
	 *		options.disableable typeof  boolean, default false	- выключен (?)
	 *		options.readonly typeof boolean, default false		- нельзя менять
	 */
	options: {
		// \type cssclass
		cssclass: "afw-select",
		add_null: false,
		not_null: false,
		// \type text
		// \name Выбранное значение
		value: "",
		// \type html
		htmltemplate: null,//'<div class="af-label"></div><div class="af-edit"><select/><div class="af-error"></div></div><div style="clear: both;"></div>',
		//htmltemplate_disableable: null,//'<div class="af-label"></div><div class="af-disable"></div><div class="af-edit"><select/><div class="af-error"></div></div><div style="clear: both;"></div>',
		// \type array
		// \name Массив возможных значений
		// \skip 1
		values: [],
		group_by: null,
		groupped: false,
		multiple: false,
		height: 300,
		//disabled: false,
		//disableable: false,
		readonly: false,
		anychange: false
	},
	i18n: {
		en: {
			empty: "Field is empty"
		},
		ru: {
			empty: "Поле не заполнено"
		}
	},
	_create: function() {
		this.preconfig();
		this.genericCreate();
		this.refreshLabel();
		this.refreshSelect();
		this.refreshValues();
		this.refreshValue();
		this.refreshChange();
		this.refreshAnychange();
		//this.refreshDisabled();
		this.refreshReadonly();
		this.refreshNotNull();
	},

	preconfig: function () {
		if (this.options.group_by && !this.options.groupped && this.options.values) {
			var values = [];		// [group1, group2,...]
			var group_map = {}; // group_id -> group

			var k_group_id = this.options.group_by + '_id';				// key with group_id
			var k_group_label = this.options.group_by + '_name';	// key with group label
			var group_id;
			var group;

			this.options.values.forEach(function(opt) {
				group_id = opt[k_group_id];

				if (group_map[group_id]) {
					group = group_map[group_id];
				} else {
					group = { id: group_id, label: opt[k_group_label], options: [], };
					group_map[group_id] = group;
					values.push(group);
				}

				group.options.push(opt);
			});

			this.options.values = values;
			this.options.groupped = true;
		}
	},

	refreshNotNull: function() {
		if (this.options.not_null && !this.options.readonly) this.element.addClass("afw-notnull"); else this.element.removeClass("afw-notnull");
	},
	refreshSelect: function() {
		var i=$("select",this.element);
		if (this.options.multiple) {
			i.attr("multiple",true);
			i.height(this.options.height);
		}
		i.addClass("ui-corner-all af-edit");
		i.width(this.options.width);
		i.bind("focus",function(e) { $(this).addClass("ui-state-highlight"); });
		if (this.options.validate) {
			i.bind("blur",this,function(e) {
				$(this).removeClass("ui-state-highlight");
				e.data.validate();
			});
		} else {
			i.bind("blur",function(e) { $(this).removeClass("ui-state-highlight"); });
		}
	},
	refreshReadonly: function() {
		$("select",this.element).prop('disabled',this.options.readonly);
		if (this.options.readonly) this.element.addClass("ro");
		else this.element.removeClass("ro");
	},
	refreshChange: function() {
		var i=$("select",this.element);
		if (!this.options.change) {
			if (this.oldBind) {i.unbind("change",this.oldBind);this.oldBind=null;}
			return;
		}
		if (this.oldBind) i.unbind("change",this.oldBind);
		this.oldBind=this.options.change;
		i.bind("change",{tag:i},this.oldBind);
	},
	refreshValues: function() {
		var cache=[];
		var sel1=$("select",this.element);
		sel1.empty();
		var opt1=this.options.values;
		if (this.options.add_null){
			var null_option = $("<option></option>").prop("value","").text("");
			if (this.options.null_params){
				if (this.options.null_params.name) null_option.text(this.options.null_params.name);
				if (this.options.null_params.cssclass) null_option.addClass(this.options.null_params.cssclass);
				if (this.options.null_params.value) null_option.prop("value",this.options.null_params.value);
			}
			null_option.appendTo(sel1);
		}
		
		function nbsps(l)
		{
			if (l==0) return "";
			if (!cache[l]) {
				var tmp="";
				for (var j=0;j<l*3;j++) tmp+=String.fromCharCode(160);
				cache[l]=tmp;
			}
			return cache[l];
		}
		function add_options(opt,sel,baselevel)
		{
			for (var i=0;i<opt.length;i++) {
				var name=opt[i].name;
				var l=(opt[i].level||1)+baselevel-1;
				var elem = $("<option></option>").appendTo(sel).prop("value",opt[i].id==null?"":opt[i].id).text(nbsps(l)+name);
				if (opt[i].enabled === false || opt[i].enabled === 0 || opt[i].enabled === "0") {
					elem.prop("disabled", true);
				} else {
					elem.attr("data-enabled", JSON.stringify(opt[i].enabled));
				}
			}
		}
		function add_rec(arr,sel,level)
		{
			for (var i=0;i<arr.length;i++) {
				var grp=$("<optgroup></opgroup>").prop("label",nbsps(level)+arr[i].label).appendTo(sel);
				if (arr[i].optgroups) add_rec(arr[i].optgroups,grp,level+1);
				if (arr[i].options) add_options(arr[i].options,grp,level);
			}

		}
		if (this.options.groupped) {
			add_rec(opt1,sel1,0);
		} else {
			add_options(opt1,sel1,0);
		}
	},
	refreshValue: function() {
		$("select",this.element).val(this.options.value);
		/*var v=this.options.value;
		var sel=$("select",this.element)[0];
		var opt=sel.options;
		for (var i=0;i<opt.length;i++) {
			if (opt[i].value==v) sel.selectedIndex=i;
		}*/
	},
	//refreshDisabled: function() {
	//	$("select",this.element).prop("disabled",this.options.disabled);
	//	this.genericRefreshDisabled();
	//},
	destroy: function() {
	},
	validate: function() {
	//	if (this.options.disabled) return false;
		var vd=this.options.validate;
		var inp=$("select",this.element);
//		if (!vd) return false;
		var r;
		if (this.options.not_null) {
			if (inp.val()=="") r=this.gettext("empty");
		}
		if (!r && vd) r=vd(this.options.values[inp.prop("selectedIndex")].id,inp.prop("selectedIndex"),this.options.values);
		if (r) inp.addClass("ui-state-error"); else inp.removeClass("ui-state-error");
		this.refreshError(r);
		return r?true:false;
	},
	refreshAnychange: function() {
		this.genericRefreshAnychange(
					"select",
					function(t) {
						var sel=$("select",t.element)[0];
						var ind=sel.selectedIndex;
						var optlist=sel.options;
						if (optlist.length<=ind) return;
						if (ind==-1) return;
						t.options.value=optlist[ind].value;},
					function(t) {return t.options.value;}
					);
	},
	postvalue: function(r) {
	//	if (this.options.disabled) return;
		var val=$("select",this.element).val();
		/*var ind=sel.selectedIndex;
		var optlist=sel.options;
		if (optlist.length<=ind) return;
		if (ind==-1) return;
		r[this.options.name]=optlist[ind].value;*/
		if (this.options.multiple) {
			r[this.options.name]=(val||[]).join(",");
		} else {
			r[this.options.name]=val;
		}
	}
});

})( jQuery );
