ajajform_htmltemplates.select_imaged={
    htmltemplate: '<div class="af-label"></div><div class="af-edit errored"><div class="images"></div><div class="cl"></div><div class="af-error"></div></div><div style="clear: both;"></div>'//,
};
(function( $, undefined ) {

$.widget("ui.ajajform_select_imaged",$.ui.ajajform_widget, {
	/**
	 * Class: ui.ajajform_select_imaged
	 *		Создает картинки-кнопки с вариантами для выбора (аналог радио-батона)
	 * Properties:
	 *		options typeof Object 					- Настройки ajajform_textedit
	 *		options.cssclass typeof String, default 'afw-select-imaged' 	- CSS класс добавляемый к DIV формы
	 *		options.label typeof String 				- заголовок виджета
	 *		options.value typeof String				- изначально выбранный вариант
	 *		options.htmltemplate typeof HtmlString			- шаблон
	 *		options.values typeof  Array, default 	[]		- Массив с вариантами [{id:"",code:"",name:""},{...},{...},...]
	 *		options.click typeof  Function, default null		- Функция вызываемая при клике на вариант, принимает аргументы t.options.name,t.options.value
	 */        
	options: {
		cssclass: "afw-select-imaged",
                label: "",
                value:"",
                values:[],
                click:null
	},
	_create: function() {
		this.genericCreate();
		this.refreshLabel();
		this.refreshImages();
                this.refreshClick();
	},
        refreshImages: function() {
                var t = this;
		var i=$(".images",t.element);
                var values = t.options.values;
                var cheked;
                if (values.length) values.forEach(function(e){
                        cheked = (e.id==t.options.value) ? "checked":"";
                        $("<div class='img "+e.code+" "+cheked+"' data-id='"+e.id+"' data-code='"+e.code+"' data-name='"+e.name+"'></div>").appendTo(i);                        
                });
                $('<div class="cl"></div>').appendTo(i);  
	},
        refreshClick: function() {
                var t = this;
		var i=$(".images",t.element);
                $('.img',i).bind("click",function(){
                        $('.img.checked').removeClass('checked');
                        $(this).addClass('checked');
                        t.options.value = $(this).attr('data-id');
                        if (t.options.click) t.options.click(t.options.name,t.options.value);
                });
	},
	postvalue: function(r) {
		r[this.options.name]=this.options.value;
	}
});

})( jQuery );
