(function( $, undefined ) {
$.widget("ui.ajajform_widget", {
	/**
	 *	Class: ui.ajajform_widget
	 *		Создает абстрактный виджет для формы
	 * Properties:
	 *		options typeof Object - Настройки ajajform_widget
	 *		options.anychange typeof Function - Функция вызывающаяся при любом изменении, аргументы: (widget, новоеЗначение)
	 */
	options: {
	},
	/**
	 * Method: _create
	 *		Создает виджет
	 * Parameters:
	 * Returns:
	 */	
	_create: function() {
	},
	/**
	 * Method: _setOption
	 *		Обновляет значение в this.options и вызвывает refresh этой опции, если он есть
	 * Parameters:
	 *		key typeof String		- Название параметра
	 *		value				- Значение параметра
	 * Returns:
	 */
	_setOption: function(key,value) {
		this.options[key]=value;
		var k1=key.substr(0,1);
		var k2=key.substr(1);
		var method = "refresh"+k1.toUpperCase()+k2;
		if (this[method]) this[method]();
	},
	/**
	 * Method: refreshError
	 *		Обновляет отображение ошибки
	 * Parameters:
	 *		e typeof String		- Текст ошибки
	 * Returns:
	 */	
	refreshError: function(e) {
		$(".af-error",this.element).text(e==null?"":e);
	},
	/**
	 * Method: refreshLabel
	 *		Обновляет заголовок виджета
	 * Parameters:
	 * Returns:
	 */	
	refreshLabel: function() {
		$(".af-label",this.element).text(this.options.label);
	},
	
	/**
	 * Method: tmpl
	 *		обрабатывает и возвращает шаблон виджета
	 * Parameters:
	 *		tmpl typeof HtmlString		- html шаблона
	 *		hash typeof Object		- Объект содержащий значения для подмены
	 * Returns:
	 */
	
	tmpl: function(tmpl,hash) {
		tmpl=tmpl.replace(/{{(\w+)}}/g,function(p,p1) { return (p1 in hash)?hash[p1]:""; });
		return tmpl;
	},
	/**
	 * Method: gettext
	 *		 Возвращает локализованную строку
	 * Parameters:
	 *		name typeof String		- строка для перевода
	 * Returns:
	 * 		typeof String -  переведенная строка
	 */
	gettext: function(name) {
		var l=ajajform_global_options.language;
		if (!this.i18n) return name;
		if (!this.i18n[l]) return name;
		if (!this.i18n[l][name]) return name;
		return this.i18n[l][name];
	},

	getHtmlTemplate: function(name) {
		var r=this.options[name] || ajajform_htmltemplates[this.options.type][name];
		//console.log({r:r,name:name,type:this.options.type})
		return r;
	},
	
	/**
	 * Method: genericRefreshAnychange
	 * 		Используется для привязки любых событий изменяющих данные
	 *
	 * Parameters:
	 *		path typeof String		- селектор
	 *		savevaluefunc typeof Function	-
	 *		getvaluefunc typeof Function	-
	 *
	 */
	
	genericRefreshAnychange: function(path,savevaluefunc,getvaluefunc) {
		var t = this;
		//console.log("GD.log: genericRefreshAnychange "+path);
		if (!t.options.anychange) return;
		var i=$(path,t.element);
		if (this.anyChangeBinded) return;
		this.anyChangeBinded=1;
		i.bind("keyup mouseup change",function(e) {
			//if (t.options.anychange) {
				savevaluefunc(t);
				t.options.anychange(t,getvaluefunc(t),e);
			//}
		});
	},
	
	/**
	 * Method: genericCreate
	 *		 Генерирует конкретный виджет
	 *		 Добавляет класс(ы) из this.options.cssclass
	 *		 Вставляет шаблон this.options.htmltemplate и если есть обрабатывает его функцией func
	 * Parameters:
	 *		func typeof Function		- функция для обработки шаблона
	 * Returns:
	 */	
	genericCreate: function(func) {
		if (typeof this.options.cssclass =="string") this.element.addClass(this.options.cssclass);
		else for (var i=0,l=this.options.cssclass.length;i<l;i++) this.element.addClass(this.options.cssclass[i]);
		
		//if (this.options.disableable && this.options.htmltemplate_disableable) {
		//	var t=this.options.htmltemplate_disableable;
		//	if (func) t=func(t);
		//	this.element.append(t);
		//	$(".af-disable",this.element).bind("click",{t:this},function(e) {
		//		e.data.t._setOption("disabled",!e.data.t.options.disabled);
		//		e.data.t.refreshDisabled();
		//	});
		//	$(".af-label",this.element).width(180);
		//} else {
			//console.log(this.options);
			var t=this.getHtmlTemplate("htmltemplate");
			if (func) t=func(t);
			this.element.append(t);
		//}
	},
	/**
	 * Method: openDialog
	 *		 Запускает ajajform_dialog (TODO) 
	 * Parameters:
	 *		dialogoptions typeof Object		- параметры диалога
	 *		widgetslist typeof Array		- список виджетов
	 *		hash typeof Object			- hash
	 * Returns:
	 * 		typeof Function				- ajajform_dialog
	 */
	
	openDialog: function(dialogoptions,widgetslist,hash) {
		var widgets=[];
		for (var i=0;i<widgetslist.length;i++) {
			var w={};
			widgets.push(w);
			for (var k in widgetslist[i]) {
				var v=widgetslist[i][k];
				if (typeof v=="string") {
					// TODO TODO TODO Incorrect but works for now
					var a=v.match(/^\{\{(\w+)(?:\.(\w+))*\}\}$/);
					if (a) {
						var tmp=hash;
						var ii=1;
						while (ii<a.length && tmp && a[ii]!=undefined) {
							tmp=tmp[a[ii]];
							ii++;
						}
						w[k]=tmp;
					} else {
						w[k]=v;
					}
				} else {
					w[k]=v;
				}
			}
		}
		var frmoptions={
			header: null
		};
		if (dialogoptions.footerButtons) frmoptions.footerButtons=dialogoptions.footerButtons;
		return ajajform_dialog(dialogoptions,frmoptions,widgets);
	},
	/**
	 * Method: genericRefreshDisabled
	 *		 Обновляет css классы при изменении параметра Disabled
	 * Parameters:
	 * Returns:
	 */	
	genericRefreshDisabled: function() {
		return;
		//if (!this.options.disableable) return;
		//if (this.options.disabled) {
		//	$(".af-disable",this.element).addClass("af-disabled");
		//	$(".af-edit input",this.element).addClass("af-edit-disabled");
		//	$(".af-edit select",this.element).addClass("af-edit-disabled");
		//	$(".af-edit textarea",this.element).addClass("af-edit-disabled");
		//} else {
		//	$(".af-disable",this.element).removeClass("af-disabled");
		//	$(".af-edit input",this.element).removeClass("af-edit-disabled");
		//	$(".af-edit select",this.element).removeClass("af-edit-disabled");
		//	$(".af-edit textarea",this.element).removeClass("af-edit-disabled");
		//}
	},
	/**
	 * Method: postvalue
	 *	 не используется
	 * Parameters:
	 * Returns:
	 */
	postvalue: function(r1,r2) {
	},
	/**
	 * Method: destroy
	 *	 не используется
	 * Parameters:
	 * Returns:
	 */	
	destroy: function() {
	},
	/**
	 * Method: validate
	 *	 не используется
	 * Parameters:
	 * Returns:
	 */
	validate: function() {
		return null;
	},

	setError: function(text) {
		$(".af-error",this.element).text(text);
		$("input,select,textarea,.errored",this.element).addClass("ui-state-error");
	}

});

})( jQuery );

