//"use strict"

/**
 * Class: LNMForms
 */
var LNMForms={};

/**
* Method: validate
* 		This function tests each input in form against its datatype values.
* 		The "datatype" is typeof String, it can contain several instructions, divided by space,
* 		for example "required email" means that:
* 			1. This field is requied (can not be empty)
* 			2. It should be email
* 		Here is the list of possible instruction words:
* 		* required
* 		* email
* 		* extlatin - this field must contain only ASCII latin symbols.
*              
* Parameters:
*              frm typeof HTML Form DOM object
*/         

LNMForms.validate=function(frm,options) {
	var ok=true;
	var t=this;
	var re=new RegExp(options.prefix+" "+options.prefix+"-(\\w+) "+options.prefix+"_(\\w+)");
//	console.log(frm,re);
	$("div."+options.prefix,frm).each(function(i,tag) {
		var cssclass=tag.className;
		var arr=cssclass.match(re);///field field-(\w+) field_(\w+)/;
//		console.log(arr,cssclass);
		if (!arr) return;
		var datatype=arr[1];
		var name=arr[2];
		var a=$(tag).attr("data-validate");// текстовая строка вида 'required email'
		if (!a) return;
		a=a.split(/\s+/);// массив проверок
		// Вытаскиваем данные
		var val=t.get_value(datatype,tag);
//		if (!val) return;
//		console.log("LNMForms.validate() - "+name+"="+val+", validates="+arr.join(","));
		// Проверяем для всех элементов массива проверок
		for (var i=0;i<a.length;i++) {
			if (!t.validate_one(a[i],val,tag,options)) {
				ok=false;
				break;
			}
		}
	});
	return ok;
}


LNMForms.get_value__date=function(datatype,tag) {
	return $("input",tag).val();
}
LNMForms.get_value__textedit=function(datatype,tag) {
	return $("input",tag).val();
}
LNMForms.get_value__numberedit=function(datatype,tag) {
	return $("input",tag).val();
}
LNMForms.get_value__textareaedit=function(datatype,tag) {
	return $("textarea",tag).val();
}
LNMForms.get_value__select=function(datatype,tag) {
	return $("select",tag).val();
}
LNMForms.get_value__radioselect=function(datatype,tag) {
	return $("input:checked",tag).val() || "";
}
LNMForms.get_value__radiogrouped=function(datatype,tag) {
	return $("input:checked",tag).val() || "";
}
LNMForms.get_value__checkbox=function(datatype,tag) {
	return $('.checkbox',tag).hasClass('checkboxA')?1:0;
}
LNMForms.get_value__checkboxlist=function(datatype,tag) {
	var ids = [];
	$('.checkbox',tag).each(function(){
		if ($(this).hasClass('checkboxA')) ids.push($(this).attr('data-id'))
	});
	return ids,join(',');
}

/**
 *
 */
LNMForms.get_value=function(datatype,tag)
{
	if (this["get_value__"+datatype]) {
		return this["get_value__"+datatype](datatype,tag);
	} else {
		console.log('LNMForms.get_value() - unknown datatype - '+datatype);
	}
}

/**
 *	Method: validate_one
 *		Проверяет, допустимое ли значение в поле
 *
 *	Parameters:
 *		validate typeof String		- Вид проверки поля
 *		val typeof Object			- Текущее значение поля
 *		tag typeof jQuery			- div.field
 *		
 *	Returns:
 *		typeof Boolean				- true, если все окей, false - если не подходит
 */
LNMForms.validate_one=function(validate, val, tag,options)
{
	// Сбрасываем .err
	var err=function(e){
		if (e) {
			$('div.'+options.error_prefix, tag).html(lnrr.site.functions.Views.L?lnrr.F("Views","L","LNMForms",e,2):e);
		} else {
			$('div.'+options.error_prefix, tag).html("");
		}
	}
	if (validate) {
		if (this["validate_one__"+validate]) {
			var r=this["validate_one__"+validate](val,err);
			if (r) err('');
			return r;
		} else {
			console.log("LNMForms.validate_one() - unknown validator - "+validate);
		}
	}
	err('');
	return true;
}

LNMForms.validate_one__required=function(val,err) {
	if(val!==undefined && val!==null && val!='') return true;
	err('Заполните поле');
	return false;
}

LNMForms.validate_one__email=function(val,err) {
	var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
	if(re.test(val)) return true;
	err('Некорректный email');
	return false;
}

LNMForms.validate_one__extlatin=function(val,err) {
	if (val.match(/^[a-zA-Z0-9_\-,.\/;'\\\[\]]*$/)) return true;
	err('Может содержать только латинские буквы, цифры и символы');
	return false;
}

LNMForms.validate_one__number=function(val,err) {
	if (val.match(/^(\d*|\d+\.|\.\d+|\d+\.\d+)$/)) return true;
	err('не число');
	return false;
}

/**
 *	Method: get_object
 *		Возвращает объект типа Object, со всеми значениями формы.
 *		Также делает валидацию.
 *		Если форма не валидна - возвращает undefined
 *
 *	Parameters:
 *		el typeof HTMLElement		- любой элемент внутри формы
 *		options.prefix
 *		options.no_check
 *		options.force_el
 *
 */
LNMForms.get_object=function(el,options) {
	if (!options) options={};
	if (!options.prefix) options.prefix="field";
	if (!options.error_prefix) options.error_prefix="err";
	var t=this;
	var frm;
	if (options.force_el) {
		frm=$(el);
	} else if ($(el).hasClass("form")) {
		frm=$(el);
	} else {
		frm=$(el).closest(".form");
	}
	if(!options.no_check && !LNMForms.validate(frm,options)) return undefined;
	var obj={};
	var re=new RegExp(options.prefix+" "+options.prefix+"-(\\w+) "+options.prefix+"_(\\w+)");
	$("div."+options.prefix,frm).each(function(i,tag) {
		var cssclass=tag.className;
		var arr=cssclass.match(re);
		if (!arr) return;
		var datatype=arr[1];
		var name=arr[2];
//		var err=function(e){ $('div.err', tag).html(e); }
//		err('');
		obj[name]=t.get_value(datatype,tag);
	});
	return obj;	
}

LNMForms.error_notification=function(text)
{
	console.log("error_notification() - "+text);
	var notify=new LNMNotify(text,{cssclass:"error"});
}

function LNMNotify(text,options)
{
	var t=this;
	if (!options) options={};
	if (!options.cssclass) options.cssclass="info";
	if (!options.timeout) options.timeout=(options.cssclass=="error")?5000:2000;
	var body=pager.element.parent();
//	if ($(".LNMNotify",body).length) return;
	this.div=$("<div class='LNMNotify "+options.cssclass+"'><div class='text'></div><div class='close'></div></div>").appendTo(body);
	$(".text",this.div).text(text);
	if (options.calc_height) {
		var h = $(".text",this.div).css('height','auto').height();
		this.div.height((h+20)+'px !important');	
	}
	$(".close",this.div).bind("click",function() {
		t.close();
	});
	
	//this.div.animate({height:42});
	setTimeout(function() { t.close(); },options.timeout);
}

LNMNotify.prototype.close=function() {
	var t=this;
	if (this.closing) return;
	this.closing=1;
	//this.div.stop().animate({height:0},undefined,undefined,function() { t.div.remove();});
	this.div.remove();
}
