
	// RESIZATOR DESCRIPTION	
	// Инициализирует или загружает картинку в блоке с возможностью изменения размеров и позиционирования в рамках блока
	// На выходе (метод 'get_data') дает
	/*{
		id: 		id картинки если он есть,
		url: 		url картинки,
		state: {	хеш состояния - по нему можно возобновить редактировние, передав его при инициализации => следует хранить в базе. Все параметры - Integer
			x: 		координата X левого верхнего угла относительно картинки
			y: 		координата Н левого верхнего угла относительно картинки
			size: 	масштаб [0..1000] где 1000 максимальный размер картинки
			W: 		длинна блока (не влияет на инициализацию, нужно тока для генерации на сервере)
			H: 		высота блока (не влияет на инициализацию, нужно тока для генерации на сервере)
		} 
	}*/
	
	// RESIZATOR USAGE
	var options = {
		// параметры доступные также из inline: 'data-id', 'data-url', 'data-state'
		id:				298,
		url:			'/f/6/298.png',
		state:			{x:Integer,y:Integer,size:Integer,W:Integer,H:Integer},
		
		// параметры доступные также из css
		width: 			600,
		height:			480,
		
		// параметры доступные только в options
		after_init:		function(rsz){ console.log(rsz); },
		after_render:	function(rsz){ console.log(res,pos); },
		
		loader:			1,
		loader_tag:		$('#random_tag1'),		
		upload_url:		'/ajaj/upload/',
		inp_file_name:	'avatar',
		data:			{ name:'avatar_id', dst_ff_id:1 },
		success:		function(ret,rsz){ console.log(ret.image); },
		
		blocks: 		1,
		blocks_tag:		$('#random_tag2'),
		
		constraintless: false,
		
		save_state_loc:	1
	}
	
	var tag = $('<div>',{
		'style': 		"width:600; height:480",
		'data-id':		"298",
		'data-url':		"/f/6/298.png",
		'data-state':	"{x,y,size,W,H}" // JSON
	});
	
	// При инициализации параметры берутся из options || inline;
	
	// 1) jQuery 	
		tag.resizator(options);
		var data = tag.resizator('get_data');
	
	// 2) Constructor
		new Resizator(tag,options);
		var data = tag.resizator('get_data');
		
	// 3) Constructor with return
		var res = new Resizator(tag,options);
		var data = res.get_data() | tag.resizator('get_data');
		
		
	// QUICK EXAMPLE
	// just put it in console :)
	var tag = $('<div>',{ 
		style:'position:fixed;top:20px;margin-left:-300px;left:50%;z-index:9999;box-shadow: 0px 0px 5px black;background-color:rgba(255,255,255,0.5);'
	}).resizator({
		id: 			10,
		url:			"https://i.ytimg.com/vi/smVn7L2sTmg/maxresdefault.jpg",
		width:			600,
		height:			480,
		after_init:		function(rsz){ rsz.tag.appendTo('body'); },
		constraintless: 1,
		save_state_loc: 1,
		loader:			1
	});
	tag.resizator('get_data');
	
	
	// RESIZATOR FEATURES	
	
	res.get_data();				// - возвращает  { id, url, state }
	res.center();				// - центрирует картинку
	res.cover(to_center);		// - заполняет блок картинкой и центрирует если to_center
	res.contain(to_center);		// - вмещает картинку в блок и центрирует если to_center
	res.init_new(url,id,state);	// - инициализирует новую картинку
	res.clear();				// - сбросить текущую картинку
	

