$.prototype.resizator = function(options,p1,p2){
	new Resizator(this,options);
	return this;
}

var Resizator = function(tag,options){
	var t = this;
	
	this.tag = tag.addClass('_Resizator').css({
		'background-repeat':'no-repeat',
		'cursor':'all-scroll',
		'-webkit-user-select': 'none'
	});
	this.extend_jq();
	
	this.state_keys = ['x','y','W','H','size'];
	this.acc = 1000; // accuracy
	
	this.options = options || {};
	
	if (this.options.id) this.set_id(this.options.id);
	if (this.options.url) this.set_url(this.options.url);
	
	if (this.options.width) this.tag.width(this.options.width);
	if (this.options.height) this.tag.height(this.options.height);
	
	if (this.options.state) this.set_state(this.options.state);
	
	this.init_resize();
	this.init_blocks();	
	this.init();
	
	if (this.options.loader) this.init_loader();
}

Resizator.prototype.set_option = function(k,v){
	this.options[k] = v;
}

Resizator.prototype.get = function(k){
	return this[k];
}

Resizator.prototype.extend_jq = function(){
	var t = this;
	this.tag.resizator = function(method,p1,p2,p3){ return t[method](p1,p2,p3); }
}

Resizator.prototype.init_resize = function(){
	var t = this;
	$(window).resize(function(){ t.calc_size(); t.refresh_state(); });
}

Resizator.prototype.init_blocks = function(){
	var t = this;
	
	this.blocks = {				
		clear:	$('<div>',{ 'class':'clear'  }).on('click',function(){ t.clear(); }),
		cover:	$('<div>',{ 'class':'cover'  }).on('click',function(){ t.cover(); }),
		center:	$('<div>',{ 'class':'center' }).on('click',function(){ t.center(); }),
		contain:$('<div>',{ 'class':'contain'  }).on('click',function(){ t.contain(); }),
		log:	$('<div>',{ 'class':'log'    }),
		error:	$('<div>',{ 'class':'error'  }),
		shadow:	$('<div>',{ 'class':'shadow' }),
		cliper:	$('<div>',{ 'class':'cliper' }),
	}
	
	if (this.options.blocks) for(k in this.blocks) this.blocks[k].appendTo(this.options.blocks_tag || this.tag);
}

Resizator.prototype.center = function(){
	this.refresh_state({
		x: (this.W/(this.state.size/this.acc)-this.img.width)/2,
		y: (this.H/(this.state.size/this.acc)-this.img.height)/2,
	});
}

Resizator.prototype.contain = function(to_center){
	var R = this.get_ratios();
	this.refresh_state({ size:this.round(R.W<R.H ? R.W : R.H) });
	if (to_center) this.center();
}

Resizator.prototype.cover = function(to_center){
	var R = this.get_ratios();
	this.refresh_state({ size:this.round(R.W>R.H ? R.W : R.H) });
	if (to_center) this.center();
}

Resizator.prototype.init = function(){
	
	var t = this;
	
	var url = this.get_url();
	if (!url) return;
	
	var id = this.get_id();
	
	var state = this.parse_state() ||
				this.get_storage_state() ||
				{ x:0, y:0, size:this.acc/2 };
	
	this.set_state(state);
	this.calc_size();
	
	this.img = new Image();
	this.img.src = url;
	this.img.onload = function(){
		t.set_url(url);
		t.set_id(id);
		t.init_actions();
		t.refresh_state(null,1);
		if (t.options.after_init) t.options.after_init(t);
	}
}

Resizator.prototype.init_new = function(url,id,state){
	this.clear();
	this.set_url(url);
	this.set_id(id);
	this.set_state(state || { size:this.acc, x:0, y:0 });
	this.init();
}

Resizator.prototype.init_actions = function(){
	
	var t = this;
	
	this.tag.on('mousewheel',function(e){
		
		var odd = e.originalEvent.wheelDelta/20;
		if (odd>-1 && odd<0) odd = -1;
		if (odd< 1 && odd>0) odd =  1;
		
		t.inc_state('size',-odd);		
		e.preventDefault();
	});
	
	this.tag.on('mousemove touchmove',function(e){
		
		if (!e.which) {
			delete t.mouse;
			return;
		}
		
		var mouse = {
			X:	e.clientX != undefined ? e.clientX : e.touches[0].pageX,
			Y:	e.clientY != undefined ? e.clientY : e.touches[0].pageY
		};
		
		if (e.which && !t.mouse) t.mouse = mouse;
		
		t.inc_state('x',mouse.X-t.mouse.X);
		t.inc_state('y',mouse.Y-t.mouse.Y);
	
		t.mouse = mouse;
		e.preventDefault();
	});
	
	this.tag.on('click',function(e){
		if (t.options.click) t.options.click(e,t.get_state(),t.calc_pos());
	});
	
	this.options.range_input && this.options.range_input.on('change input',function(e){
		var v = {size:$(this).val()};
		t.refresh_state(v);
	});
}

Resizator.prototype.inc_state = function(k,odd){
	var s = {};
	var state = this.get_state();
	var r = k!='size' ? this.rebuild_size(state.size) : 1;
	if (r) s[k] = state[k] + odd/r;
	this.refresh_state(s);
}

Resizator.prototype.refresh_state = function(state,forced){
	
	var s = this.get_state();
	if (state) for (k in state) s[k] = state[k];
	
	try {
		if(this.correct_state(s)===false) return;	
	} catch(e) {
		return;
	}
	
	if(this.set_state(s) || forced) this.render_state();
}

Resizator.prototype.refresh = function(size){
	this.calc_size();
	this.refresh_state();
}

Resizator.prototype.get_constraint = function(state){
	if (!state) state = this.get_state();
	var R = this.get_ratios();
	var ret = {
		size:	[this.round((this.options.cover?R.W>R.H:R.W<R.H) ? R.W : R.H), this.acc],
		x:		[this.round(this.W/(state.size/this.acc)) - this.img.width,0],
		y:		[this.round(this.H/(state.size/this.acc)) - this.img.height,0]
	};
	return ret;
	
}

Resizator.prototype.correct_state = function(state){
		
	var t = this;
	var pos = this.calc_pos(state);
	
	if (this.options.noresize) state.size = this.acc;
	
	var W = this.W;
	var H = this.H;
	
	if (this.options.constraintless) {
		if (pos.x>0 && pos.x>W) return false;
		if (pos.y>0 && pos.y>H) return false;
		if (pos.x<0 && pos.x<-pos.width) return false;
		if (pos.y<0 && pos.y<-pos.height) return false;
		if (state.size<0) state.size = 0; return true;
	}
	
	var constraint = this.get_constraint(state);
	if (constraint.size[0]>constraint.size[1]) return false;
	
	var correct = function(param,c){
		state[param] = constraint[param][c];
		t.correct_state(state);
	}
	
	if (state.size<constraint.size[0]) return correct('size',0);
	if (state.size>constraint.size[1]) return correct('size',1);
		
	if (pos.width >= W && pos.height >= H) {
		if (state.x<constraint.x[0]) correct('x',0);
		if (state.y<constraint.y[0]) correct('y',0);
		if (state.x>constraint.x[1]) correct('x',1);
		if (state.y>constraint.y[1]) correct('y',1);
	} else {
		var k1 = pos.height<=H ? 'x' : 'y';
		var k2 = k1=='x' ? 'y' : 'x';
		if (state[k1]>constraint[k1][1]) 			    return correct(k1,1);
		if (state[k1]<0 && state[k1]<constraint[k1][0]) return correct(k1,0);
		if (state[k2]>0 && state[k2]>constraint[k2][0]) return correct(k2,0);
		if (state[k2]<0 && state[k2]<constraint[k2][1]) return correct(k2,1);
	}
	
	return true;
}

Resizator.prototype.render_state = function(){
	var pos = this.calc_pos(this.state);
	var cssrule = {
		'background-position-x': pos.x + 'px',
		'background-position-y': pos.y + 'px',
		'background-size': 		 pos.width+'px '+pos.height+'px'
	};
	this.tag.css(cssrule);
	this.blocks.cliper.css(cssrule);
	if (this.options.range_input) {
		var constraint = this.get_constraint();
		this.options.range_input.attr('min',constraint.size[0]);
		this.options.range_input.attr('max',constraint.size[1]);
		this.options.range_input.val(this.state.size);
	}
	if (this.options.after_render) this.options.after_render(this.state,pos);
}


Resizator.prototype.calc_pos = function(state,round){
	if (!state) state = this.get_state();
	var k = this.rebuild_size(state.size);	
	var pos =  {
		x		:	state.x  * k,
		y		:	state.y  * k,
		width	:	this.img.width  * k,
		height	:	this.img.height * k
	}
	if (round) for (k in pos) pos[k] = this.round(pos[k]);
	return pos;
}

Resizator.prototype.rebuild_size = function(size){
	return size/this.acc;
}

Resizator.prototype.calc_size = function(){
	
	this.W = this.tag.width();
	this.H = this.tag.height();
	
	var state = this.get_state();
	if (!state) return;
	
	state.W = this.W;
	state.H = this.H;
	
	this.set_state(state);
}

Resizator.prototype.round = function(v){
	return v = v<0 ? Math.floor(v) : Math.ceil(v);
}

Resizator.prototype.get_ratios = function(reverse){
	var w_r = this.acc*this.W/this.img.width;
	var h_r = this.acc*this.H/this.img.height;
	return {
		W: reverse ? h_r : w_r,
		H: reverse ? w_r : h_r,
	}
}


Resizator.prototype.get_url = function(){
	return this.tag.attr('data-url');
}

Resizator.prototype.set_url = function(url){
	var cssrule = {'background-image':'url('+url+')'};
	this.tag.attr('data-url',url).css(cssrule);
	this.blocks.cliper.css(cssrule);
}

Resizator.prototype.get_id = function(from_url){
	return this.tag.attr('data-id');
}

Resizator.prototype.set_id = function(id){
	this.tag.attr('data-id',id);
}

Resizator.prototype.get_state = function(){
	if (!this.state) return undefined;
	var t = this;
	var s = {};
	this.state_keys.forEach(function(k){ s[k] = t.state[k] || 0; });
	return s;
}

Resizator.prototype.set_state = function(state){
	var need_render = !this.state;
	for (k in state) {		
		state[k] = this.round(state[k]);
		if (!need_render && state[k] != this.state[k]) need_render = 1;
	}
	this.state = state;
	this.tag.attr('data-state',JSON.stringify(this.state));
	if (this.options.save_state_loc) this.save_state();
	return need_render;
}


Resizator.prototype.parse_state = function(){
	var state;
	try { state = JSON.parse(this.tag.attr('data-state')); } catch(e) {}
	return state;
}

Resizator.prototype.get_data = function(state){
	return {
		id: 	this.get_id(),
		url: 	this.get_url(),
		state: 	this.get_state(),
	}
}

Resizator.prototype.error = function(text,clear){
	this.tag[ text ? 'addClass' : 'removeClass']('errored');
	this.blocks.error.html(text);
	clearTimeout(this._error_tid);
	if (clear) this._error_tid = setTimeout(function(){
		t.blocks.error.html('');
	},clear);
}

Resizator.prototype.log = function(text,clear){
	var t = this;
	this.tag[ text ? 'addClass' : 'removeClass']('loged');
	this.blocks.log.html(text);
	clearTimeout(this._log_tid);
	if (clear) this._log_tid = setTimeout(function(){
		t.blocks.log.html('');
	},clear);
}

Resizator.prototype.clear = function(){
	
	this.tag.attr({
		'data-id':		'',
		'data-url':		'',
		'data-state':	''
	}).css({
		'background-image':		 'none',
		'background-size':		 'initial',
		'background-position-x': 'initial',
		'background-position-y': 'initial'
	});
	this.tag.off('mousemove touchmove mousewheel');
	this.init();
}

Resizator.prototype.die = function(){
	delete this.state;
	delete this.options;
	delete this.mouse;
	delete this.img;
	this.tag.remove();
}


Resizator.prototype.save_state = function(){
	
	var id = this.get_id();
	if (!id) return;
	
	if (!localStorage) return;
	
	var data = localStorage.getItem('_Resizator');
	data = data ? JSON.parse(data) : {};
	
	data[id] = this.state;
	localStorage.setItem('_Resizator',JSON.stringify(data));
}

Resizator.prototype.get_storage_state = function(){
		
	var id = this.get_id();
	if (!id) return;
	
	if (!localStorage) return;
	
	var data = localStorage.getItem('_Resizator');
	data = data ? JSON.parse(data) : {};
	
	return data[id];
}

Resizator.prototype.get_pic_pos = function(e){
	var pos = this.calc_pos();
	if (!pos) return undefined;
	return {
		x: e.x - pos.x,
		y: e.y - pos.y
	};
}

Resizator.prototype.get_pic_coords = function(e){
	
	var state = this.get_state();
	var pos = this.calc_pos();
	
	if (!state) return undefined;
	if (!pos) return undefined;
	
	return {
		x: (e.x - pos.x)/(state.size/this.acc),
		y: (e.y - pos.y)/(state.size/this.acc)
	};
	
}

Resizator.prototype.init_loader = function(){
	
	var t = this;
	
	if (!$.prototype.fileupload) {
		t.error("No jquery fileupload");	
		return;
	}
	
	var data = {
		ajaj: 1,
		name: this.options.name || 'image_id',
	};
	
	if (this.options.data) for(k in this.options.data) data[k] = this.options.data[k];
	
	$('<input/>',{
		name:	this.options.inp_file_name || 'file',
		type:	"file"
	})
	.prependTo(this.options.loader_tag || this.tag)
	.fileupload({
		
		url: 		this.options.upload_url || '/ajaj/upload/',
		formData:	data,
		dataType:	'json',
		
		add:function(e,data){
			
			t.log('Начало загрузки');
			
			var file = data.files[0];
			var error;
			
			if (!file) error =  'Нет файла';
			if (!file.name)	error =  'Безымянный файл';
			if (!file.type.match(/jpg|jpeg|gif|png/)) error = 'Недопустимый формат файла! ' + file.type;
			
			if (error) {
				t.error(error);
				return;
			}
			
			data.submit();
		},
		
		done: function (e, data) {
			
			t.log('Завершено',5000);
			
			if (t.options.success) t.options.success(data.result,t);
			
			var image = data.result.image;
			console.log(data.result);
			if (!image || !image.id) { t.error('Ошибка загрузки'); return; }
			
			t.init_new(image.url,image.id);
			
		},
		
		error: function (e, data) {
			t.error('Ошибка загрузки');
		},
		
		progressall: function (e, data) {
			
			var status = parseInt(data.loaded / data.total * 100, 10);//1..100%
			if (status>95) status = 95;
			
			t.log(status+"%");			
		},
		
	})
	.prop('disabled', !$.support.fileInput);
}