var SocialFuncs={};

/**
 * Method: init
 *
 * Parameters:
 *		options.fb_backlink typeof String		- something like http://mysite.com/auth_ok/
 *		options.vk_client_id typeof Integer		-
 *		options.vk_scope typeof String			-
 *		options.vk_display typeof String		- "page", "popup", "mobile"
 *		options.vk_backlink typeof String		- something like http://mysite.com/auth_ok/
 *		options.ok_client_id
 *		options.ok_layout						- "w", "m", "a"
 *		options.ok_backlink typeof String		- something like http://mysite.com/auth_ok/
 */
SocialFuncs.init=function(options)
{
	this.options=options;	
}

SocialFuncs.get_backlink=function(type)
{
	if (this.options[type+"_backlink"]) return this.options[type+"_backlink"];
	return window.location.protocol+"//"+window.location.hostname+"/profile/backlink_"+type+"/";
}

SocialFuncs.auth_oauth_fb=function()
{
	var url="https://www.facebook.com/v2.8/dialog/oauth?client_id=";
	url+=this.options.fb_client_id;
//	url+="&display="+(this.options.fb_display||"page");
	url+="&redirect_uri="+encodeURIComponent(this.get_backlink("fb"));
	url+="&scope="+(this.options.fb_scope||"public_profile,email,user_friends");
	url+="&response_type=code";
	console.log(url);
	StdResponseFuncs.go(url);
}

SocialFuncs.auth_oauth_vk=function()
{
	var url="https://oauth.vk.com/authorize?client_id=";
	url+=this.options.vk_client_id;
	url+="&display="+(this.options.vk_display||"page");
	url+="&redirect_uri="+encodeURIComponent(this.get_backlink("vk"));
	url+="&scope="+(this.options.vk_scope||"email,offline,friends");
	url+="&response_type=code";
	url+="&v=5.37";
	console.log(url);
	StdResponseFuncs.go(url);
}

SocialFuncs.auth_oauth_ok=function()
{
	var url="https://connect.ok.ru/oauth/authorize?client_id=";
	url+=this.options.ok_client_id;
	url+="&scope="+(this.options.ok_scope||"VALUABLE_ACCESS,GET_EMAIL");
	url+="&response_type=code";
	url+="&redirect_uri="+encodeURIComponent(this.get_backlink("ok"));
	url+="&layout="+(this.options.ok_layout||"w");
	console.log(url);
	StdResponseFuncs.go(url);
}

var UserProfileFuncs={};

UserProfileFuncs.register_direct_error=function(ret)
{
	var form=$("form[name='"+(ret.formname||"regfrm")+"']");
	generic_error_fields(ret.errors,form);
}

UserProfileFuncs.change_password_error=function(ret)
{
	var form=$("form[name='change_password_frm']");
	generic_error_fields(ret.errors,form);
}

UserProfileFuncs.change_info_error=function(ret)
{
	var form=$("form[name='change_info_frm']");
	generic_error_fields(ret.errors,form);
}
