var fs=require("fs");
function filelog(s){
	var log_file = new fs.File("/www/vahvarh/erp-gtm.relsyst.ru/html/logs/log.txt");
		log_file.open("a");
		log_file.write(new Date());
		log_file.write(s);
		log_file.close();
}

exports.add=[{
	_type:"controller",
	_config:{
		name:"ApiMobile",
		role_code:"settings"
	},
	
	init: function(){
		
		var t = this;
		
		this.dictionaries = {};
		
		this.dictionaries.SensorModel = this.M['SensorModel'].List();
		this.dictionaries.AllowedModelType = this.M['AllowedModelType'].List();
		this.dictionaries.AllowedValueType = this.M['AllowedValueType'].List();
		this.dictionaries.SensorState = this.M['SensorState'].List();
				
		var sensors_length = 0;
		var sensors_comments_length = 0;
		var sensors_photos_length = 0;
		
		var facilities_length = 0;
		var facilities_comments_length = 0;
		var facilities_photos_length = 0;
		
		var set_mobile = function(el){ el._mobile = 1; return el; }
		
		var fill_comment = function(item,model_name){
			item.photos = t.M[model_name].List('list_of_comment',{comment_id:item.id}).map(set_mobile);
			return item;
		}
		
		var fill_comment_facility = function(item){
			return fill_comment(item,'FacilityCommentImage');
		}
		
		var fill_comment_sensor = function(item){
			return fill_comment(item,'SensorCommentImage');
		}
		
		var fill_sensor = function(sensor){
			
			var list = 'list_of_sensor';
			var params = {sensor_id:sensor.id};
					
			sensors_comments_length += sensor.comments_length;
			sensors_photos_length += sensor.photos_length;
			
			return sensor;
		}
		
		var fill_facility_rec = function(arr){
			if (!arr || !arr.length) return arr;
		
			facilities_length+=arr.length;
			
			return arr.map(function(el){
				
				var list = 'list_of_facility';
				var params = {facility_id:el.id};
				
				facilities_comments_length += el.comments_length;
				facilities_photos_length += el.photos_length;
				
				el.sensors 	= t.M['Sensor'].List(list,params).map(fill_sensor).map(set_mobile);
				
				sensors_length+=el.sensors.length;
				
				el.facilities = fill_facility_rec(t.M['Facility'].List('list_level',{parent_id:el.id}));
				
				return el;
			}).map(set_mobile);
		
		};
		
		var facilities = fill_facility_rec(this.M['Facility'].List('list_level',{parent_id:null}));
		
		var full_data_json = {
			
			sensors_length:				sensors_length,
			sensors_comments_length:	sensors_comments_length,
			sensors_photos_length:		sensors_photos_length,
			
			facilities:					facilities,
			facilities_length:			facilities_length,
			facilities_comments_length:	facilities_comments_length,
			facilities_photos_length:	facilities_photos_length,
			
			
			dictionaries: 		this.dictionaries,
			users:				this.M['User'].List()
		};
		
		return JSON.stringify(full_data_json);
		
	},
	
	save_values: function(){
		filelog(this.Dumper(this.fields));
		try {
			var t = this;
			
			var braid_reg = /^braid_(\d+)$/;
			var own_reg =  /^own_(\d+)$/;
			
			var values = JSON.parse(this.fields.values).sensors;
			
			for (sensor_id in values) {
				var sensor_values = values[sensor_id];
				for (date_use in sensor_values) {
					var date_values = sensor_values[date_use];
					for (value in date_values) { // three  for's? really?
						var params = {
							sensor_id:	sensor_id,
							date_use:	date_use,
							value:		date_values[value].value
						}
						if (value.match(braid_reg)) params.braid_id = value.match(braid_reg)[1];
						if (value.match(own_reg)) 	params.allowed_value_type_id = value.match(own_reg)[1];
						t.F('GTM','save_value',params);
					}
				}
			}
			
			return JSON.stringify({ok:1});
		
		} catch(e) {
			filelog(this.Dumper(e));
			return JSON.stringify({error:1});
		}
		
	},
	
	save_comments: function(){
		
		var t = this;
		
		this._get_comment = 1;
		
		filelog(this.Dumper(this.fields));
		
		try {
			var comments = JSON.parse(this.fields.comments);
		} catch(e) {
			throw 'cannot parse -> ' + this.fields.comments;
		}
		
		var ret = [];
		
		comments.forEach(function(el){
			
			filelog(t.Dumper(el));
			
			if (el.id) {
				ret.push({
					type:	el.type,
					id:		el.id,
					images:	el.images
				});
				return;
			}
			
			var comment;
			t.fields.body = el.body;
			t.fields.images_json = JSON.stringify(el.images);
			
			if (el.type == 'facilities') {
				t.fields.facility_id = el.fid;
				comment = t.C('GTM','save_facility_comment',null,1);
			}
			
			if (el.type == 'sensors') {
				t.fields.sensor_id = el.fid;
				comment = t.C('GTM','save_sensor_comment',null,1);
			}
			
			ret.push({
				type:	el.type,
				id:		comment.id,
				images:	el.images
			});
			
		});
		
		return JSON.stringify(ret);
	},
	
	
	upload_comment_image: function(){
		
		var t = this;
		
		var type = this.fields.type;
		if (!type) throw 'No type!';
		
		var image_path = this.fields.image_path;
		if (!image_path) throw 'No file_path!';
		
		var comment_model_name = this.fields.type=='facilities' ? 'FacilityComment' : 'SensorComment';
		var image_model_name = comment_model_name+'Image';
		
		var comment = this.M[comment_model_name].Get(this.fields.comment_id);
		if (!comment) throw 'No comment!';
		
		var images = JSON.parse(comment.images_json || null) || {};
		
		var inputname = 'file';
		var file = this.req.files[inputname];
		
		if (!file) throw 'No file!';
		if (!file.originalName.match(/\./)) file.originalName += '.jpg';
		
		var img_id = this.F('Files','user_upload_file',{
			ff_id:6,
			inputname: inputname
		});
		
		if (!img_id) throw 'Load failed!';
		
		var img = this.M[image_model_name].Create();
			img.comment_id = this.fields.comment_id
			img.image_id = img_id;
			img.SaveAll();
		
		delete images[image_path];
		
		comment.images_json = JSON.stringify(images);
		comment.SaveAll();
			
		return JSON.stringify({ img:img, type:type, image_path:image_path })
	},
	
	
}];
