var base64 = new require('base64');
var proc = new require('process');

var to_json = function(data){ return JSON.stringify(data); }

exports.add=[{
	_type:	"controller",
	_config:{ name:"GTM" },
	
	init:function(){
		var t = this;
		
		var data = {
			'users':function(){
				return 	{ users:t.M['User'].List() }
			},
			'reference':function(){
				var data = { references:t.M['Reference'].ListHier() };
				if (t.fields.reference_id) data.reference = t.M['Reference'].Get(t.fields.reference_id);
				return 	data;
			},
			'plans':function(){
				t.C('GTM','plans');
				return 	{ plans:t.plans, plan:t.plan, formats:t.formats  }
			},
			'analytics':function(){
				return 	{ tree:t.M['Facilities'].ListHier() }
			},
			'dashboard':function(){
				t.F("Dashboard","fill_dictionaries",[
					"SensorModel",
					"SensorModelType",
					"AllowedModelType",
					"AllowedValueType",
					"SensorState",
					"MeasurementMode",
					"BasePaddingPrinciple",
					"NormativeType",
					"FacilityType",
					"FacilityState",
				]);
				return 	{
					tree:			t.M['Facilities'].ListHier(),
					dictionaries:	t.dictionaries
				}
			},
		}[this.fields.section]();
		
		return to_json(data);
	},
	
	upload_plans: function(){
		
		var plan = this.M['Plan'].Create();
		
		plan.name = this.fields.name;
		plan.format_id = this.fields.format_id;
		
		var pdf_id = '';
		
		plan.dwg_id = this.F('Files','user_upload_file',{
			ff_id:14,
			inputname: 'dwg_plan'
		});
		
		plan.pdf_id = this.F('Files','user_upload_file',{
			ff_id:14,
			inputname: 'pdf_plan'
		});
		
		plan.SaveAll();
			
	},
	
	
	
	
	index: function(){
		
		var o = {};
	//	o.to_json();
		
		this.F("Dashboard","fill_dictionaries",[
			"SensorModel",
			"SensorModelType",
			"AllowedModelType",
			"AllowedValueType",
			"SensorState",
			"MeasurementMode",
			"BasePaddingPrinciple",
			"NormativeType",
			"FacilityType",
			"FacilityState",
		]);
		
		this.facilities = this.M['Facility'].ListHier().map(function(el){ return { id:el.id, name:el.name, level:el.level }});
		
		return this.Cview();	
	},
	
	init_facility: function(){
		var facility = this.M['Facility'].Get(this.fields.id);
		
		facility.facilities = this.M['Facility'].List('list_level',{parent_id:facility.id});
		facility.sensors = this.M['Sensor'].List('list_of_facility',{facility_id:facility.id});
		facility.groups = this.M['FacilityGroup'].List('list_of_facility',{facility_id:facility.id});
		facility.sensors_groups = this.M['SensorGroup'].List('list_of_facility',{facility_id:facility.id});
				
		return ret({ facility:facility });
	},
	
	save_facility: function(){
		var ret = this.C('Dashboard','save_facility');
		if (JSON.parse(ret).error) return ret;
		return this.C('Dashboard','init_facility');	
	},
	
	
	all_values: function(){
		return this.C('Dashboard','all_values');	
	},
	
	save_values: function(){
		return this.C('Dashboard','save_values');	
	},
	
	plans: function(){
		
		this.plan = this.M['Plan'].Get(this.fields.plan_id);
		this.formats = this.M['PlanFormat'].List();
		
		var plans = {  };
		
		this.M['Plan'].List().forEach(function(el){
			if (!plans[el.status_name]) plans[el.status_name] = [];
			plans[el.status_name].push(el);
		});
		
		this.plans = [];
		
		for (k in plans) if (plans[k].length) this.plans.push({ name:k, items:plans[k] });
		
		return this.Cview();
	},
	
	upload_plan: function(){
		
		var inputname = 'plan';
		var file_id = this.F('Files','user_upload_file',{
			ff_id:6,
			inputname: inputname
		});
		
		var file = this.M['File'].Get(file_id);
		if (!file) throw 'Не удалось загрузить';
		
		var plan = this.M['Plan'].Create();
			plan.file_id = file.id;
			plan.name = this.fields.name || file.orig_filename;
			plan.status_name = 'Загружен';
		
		plan.SaveAll();
		
		return this.C('GTM','plans');
	},
	
	upload_screenshot: function(){
		
		if (!this.fields.format_id)  throw 'Нет format_id';
		if (!this.fields.list_index)  throw 'Нет list_index';
		
		var plan = this.M['Plan'].Get(this.fields.plan_id);
		if (!plan) throw 'Не удалось загрузить! (1)';
		
		var inputname = 'screenshot';
		var screenshot_id = this.F('Files','user_upload_file',{
			ff_id:6,
			inputname: inputname
		});
		
		var screenshot = this.M['File'].Get(screenshot_id);
		if (!screenshot) throw 'Не удалось загрузить! (2)';
		
		plan.image_id = screenshot_id;
		
		plan.status_name = 'С изображением';
		plan.log = 'Ожидается ввод параметров';
		
		plan.format_id = this.fields.format_id;
		plan.list_index = this.fields.list_index;
		plan.camera = this.fields.camera;
		
		plan.SaveAll();
		
		this.fields.plan_id = plan.id;
		
		return this.C('GTM','plans');
	},
	
	save_params: function(){
		
		var plan = this.M['Plan'].Get(this.fields.plan_id);
		if (!plan) throw 'Не удалось загрузить! (1)';
		
		plan.width = this.fields.width;
		plan.height = this.fields.height;
		
		plan.status_name = 'Готов к использованию';
		plan.log = 'Завершено';
		
		plan.SaveAll();
		
		return this.C('GTM','plans');
	},
	
	load_plan: function(){
		
		this.plan = this.M['Plan'].Get(this.fields.plan_id);
		var file = this.M['File'].Get(this.plan.file_id);
		
		this.plan.log = this.C('ApiAutodesk','upload_file',file);
		try {
			var r = JSON.parse(this.plan.log);
			this.plan.urn = r.objectId;
			this.plan.urn_encoded = 'urn:' + base64.encode(r.objectId).toString('UTF-8');
			this.plan.status_name = 'Не зарегистрирован';
			this.plan.log = 'Загружен на сервер Autodesk';
		} catch(e) {
			this.plan.log = 'Ошибка загрузки';
		}
		
		this.plan.SaveAll();
		
		return this.C('GTM','plans');
	},
	
	register_plan: function(){
		
		this.plan = this.M['Plan'].Get(this.fields.plan_id);
		
		this.C('ApiAutodesk','register_file',this.plan);
		this.plan.log = this.C('ApiAutodesk','check_register',this.plan);

		try {
			
			var r = JSON.parse(this.plan.log.split('\n\r')[1]);
			
			if (r.status == 'inprogress' || r.status == 'pending') {
				this.plan.status_name = 'Транслируется';
			}
			
			if (r.status == 'success') {
				this.plan.status_name = 'Транслирован';
			}
			
			if (r.status == 'failed') {
				this.plan.status_name = 'Ошибка загрузки';
			}
			
			this.plan.log = r.status + ' / ' + r.progress;
			
		} catch(e) {
			this.plan.status_name = 'Ошибка загрузки';
		}
		
		this.plan.SaveAll();
		
		return this.C('GTM','plans');
	},
	
	delete_plan: function(){
		
		this.plan = this.M['Plan'].Get(this.fields.plan_id).Delete();
		return this.C('GTM','plans');
	},
	
	gat_plan_data: function(){
		this.plan = this.M['Plan'].Get(this.fields.plan_id);		
		return this.C('ApiAutodesk','get_data',this.plan);	
	},
	
	get_plan_thumbnail: function(){		
		this.plan = this.M['Plan'].Get(this.fields.plan_id);		
		return this.C('ApiAutodesk','get_thumbnail',this.plan);	
	},
	
	
	pdfs: function(config){
		
		var path = '/www/vahvarh/erp-gtm.relsyst.ru/';
		var script_path  = path +'scripts/pdf/merge.sh';
		
		var merge_pdf = function(pdf1,pdf2,result) {
			
			var pdf1_path = path + pdf1;
			var pdf2_path = path + pdf2;
			var result_path = path + result;
			
			var command = script_path +' '+ pdf1_path +' '+pdf2_path +' '+result_path;
			
			var pr = new proc.Process();
			var log = pr.system(command);
			
			return command;
		}
		
		merge_pdf(
			'html/test.pdf',
			'html/plans/formats/А4_В.pdf',
			'html/plans/results/А4_В.pdf'
		);
		
		merge_pdf(
			'html/plans/examples/А4_В.pdf',
			'html/plans/results/А4_В.pdf',
			'html/plans/results/А4_В_res.pdf'
		);

		return this.Cview();
	}
	
	
	
}];