var http=require("http");

exports.add=[{
	_type:"functions",
	_section:"AdminHelpers",

	/**
	 * Function: AdminHelper.user_helper
	 */
	user_helper: function(mode,item) {
        var self = this;

		var having_settings={};
		var arr=this.site.sql.execute_and_fetch_single("select user_id from Tusers_enrolled where role_id=4");
		for (var i=0;i<arr.length;i++) having_settings[arr[i].user_id]=1;

        var user_id = item.id;
        function in_admin() {
            return self.action.match(/^\/admin/);
        }

        function is_available_role (role) {
            return in_admin() || role.code.match(/^gtm_/);
        }
        function is_available_enrolled (enrolled) {
            return in_admin() || enrolled.role_code.match(/^gtm_/);
        }

        /**
         * проверить, есть ли роль у пользователя
         * @param role
         * @returns {boolean}
         */
        function has_role(role) {
            return user_enrolled.some(function(enrolled) { return enrolled.role_id==role.id; });
        }
        /**
         * проверить, что роль должна быть у пользователя
         * @param role
         * @returns {boolean}
         */
        function must_have_role(role) {
            return income_roles.some(function(income_role) { return income_role.id==role.id; });
        }

        switch (mode) {
			case "list":
				if (!in_admin()) {
					var i=0;
					while (i<this.items.length) {
						if (having_settings[this.items[i].id]) {
							this.items.splice(i,1);
						} else {
							i++;
						}
					}
				}
				break;
			case "edit":
                this.roles={
                    available:this.site.models.Role.List().filter(is_available_role),
                    checked: this.site.models.UserEnrolled.List("list_of_user",{user_id:item.id}).filter(is_available_enrolled).map(function(enrolled) {return enrolled.role_id})
                };
				return this.View("controllers/adminpanel/AutoAdminUser/edit_helper");
				break;
            case "save":
                var all_roles = this.site.models.Role.List().filter(is_available_role);
                var user_enrolled = this.site.models.UserEnrolled.List("list_of_user",{user_id:item.id}).filter(is_available_enrolled);
                var user_enrolled_hash = {}; user_enrolled.forEach(function(enrolled) { user_enrolled_hash[enrolled.role_id] = enrolled; });
                var income_roles = all_roles.filter(function(role) {
                    return self.fields['roles-' + role.id] == 1;
                });

                var roles_to_enroll = income_roles.filter(function (role) {
                    return !has_role(role);
                });
                var roles_to_unenroll = all_roles.filter(function(role) {
                    return has_role(role) && !must_have_role(role);
                });

                roles_to_enroll.forEach(function(role) {
                    var c=self.site.models.UserEnrolled.Create();
                    c.user_id=user_id;
                    c.role_id=role.id;
                    c.SaveAll();
                });

                roles_to_unenroll.forEach(function (role) {
                    user_enrolled_hash[role.id].Delete();
                });
				item.SaveAll();
                break;
			case "export_start":
				var i=0;
				while (i<item.models.length) {
					if (having_settings[item.models[i].id]) {
						item.models.splice(i,1);
					} else {
						i++;
					}
				}
				break;
			case "export_end":
				break;
			case "import":
				break;
 			default:
				throw new Error("user_helper - unknown mode="+mode);
		}
	},

	sensor_model_measurer_helper: function(mode,item) {
		switch(mode) {
			case "pre":
				if (this.fields.sensor_model_id) return this.C(this._cinfo.config.name,"index");
				this.sensor_models=this.site.models.SensorModel.List();
				break;
			case "list":
			case "edit":
			case "save":
				break;
			default:
				throw new Error("street_helper - unknown mode="+mode);

		}
	},
}];

