select
	v.*,
	d.d::date as d
from
	(
		select
			v.date_use,
			v.sensor_id,
			v.value
		from
			tsensor_values as v,
			tsensors as s
		where
			s.facility_id = :facility_id and
			case when :models::text<>'{}'
				then s.sensor_model_id = any((:models::text)::int[])
				else true
			end and
			v.sensor_id=s.id
	) as v
	right join generate_series(
		to_date(:date,'DD.MM.YYYY'),
		to_date(:date,'DD.MM.YYYY') + (interval '1 day')*:interval - interval '1 day' ,
		'1 day') as d on d.d=v.date_use

	