select
	val.value,
	val.deep,
	val.allowed_value_type_id,
	d.d::date as date
from
	(
		select
			v.date_use,
			v.allowed_value_type_id,
			v.value,
			b.deep
		from
			tbraids as b
			left join tsensor_values as v on v.braid_id = b.id
		where
			b.sensor_id = :sensor_id and
			b.enabled=1
	) as val right join generate_series(
	to_date(:date_to,'YYYY-MM-DD') - (interval '1 day')*(:days-1),
	to_date(:date_to,'YYYY-MM-DD'),
	'1 day') as d on d.d=val.date_use