create table Tmeasurer_value_types (
	id				bigserial primary key,
	code			varchar(128) not null unique,
	name			varchar(256) not null unique
);

create table Tsensor_models (
	id				bigserial primary key,
	code			varchar(128) not null unique,
	name			varchar(256) not null unique,
	icon_id			bigint not null,
	foreign key		(icon_id) references Tfiles
);

create table Tsensor_model_measurers (
	id				bigserial primary key,
	sensor_model_id	bigint not null,
	value_type_id	bigint not null,
	name			varchar(128),
	ordering		bigserial unique,
	foreign key		(sensor_model_id) references Tsensor_models,
	foreign key		(value_type_id) references Tmeasurer_value_types
);

create table Tfacilities (
	id				bigserial primary key,
	parent_id		bigint,
	name			varchar(256) not null,
	ordering		bigserial unique,
	image_id		bigint,
	foreign key		(image_id) references Tfiles
);

create table Tsensors (
	id				bigserial primary key,
	facility_id		bigint not null,
	sensor_model_id	bigint not null,
	foreign key		(facility_id) references Tfacilities,
	foreign key		(sensor_model_id) references Tsensor_models
);

create table Tsensor_locations (
	id				bigserial primary key,
	sensor_id		bigint not null,
	facility_id		bigint not null,
	x				numeric(30,2),
	y				numeric(30,2),
	comments		text,
	foreign key		(facility_id) references Tfacilities,
	foreign key		(sensor_id) references Tsensors
);

create table Tsensor_values (
	id				bigserial primary key,
	sensor_id		bigint not null,
	date_cr			timestamp default now() not null,
	sensor_model_measurer_id	bigint not null,
	value			numeric(30,4),
	foreign key		(sensor_id) references Tsensors,
	foreign key		(sensor_model_measurer_id) references Tsensor_model_measurers
);

create table Tfacility_comments (
	id				bigserial primary key,
	facility_id		bigint not null,
	date_cr			timestamp default now() not null,
	user_cr_id		bigint not null,
	body			text,
	foreign key		(facility_id) references Tfacilities,
	foreign key		(user_cr_id) references Tusers
);

create table Tfacility_photos (
	id				bigserial primary key,
	facility_id		bigint not null,
	date_cr			timestamp default now() not null,
	user_cr_id		bigint not null,
	image_id		bigint not null,
	body			text,
	foreign key		(facility_id) references Tfacilities,
	foreign key		(image_id) references Tfiles,
	foreign key		(user_cr_id) references Tusers
);

create table Tsensor_comments (
	id				bigserial primary key,
	sensor_id		bigint not null,
	date_cr			timestamp default now() not null,
	user_cr_id		bigint not null,
	body			text,
	foreign key		(sensor_id) references Tsensors,
	foreign key		(user_cr_id) references Tusers
);

create table Tsensor_photos (
	id				bigserial primary key,
	sensor_id		bigint not null,
	date_cr			timestamp default now() not null,
	user_cr_id		bigint not null,
	image_id		bigint not null,
	body			text,
	foreign key		(sensor_id) references Tsensors,
	foreign key		(image_id) references Tfiles,
	foreign key		(user_cr_id) references Tusers
);



