exports.config=[
	{
		"table": "tallowed_model_types",
		"name": "AllowedModelType",
		"folder": "allowed_model_types",
		"patches": {
			"columns": {
				"has_braid": {
					"datatype": "boolean"
				},
				"has_own_values": {
					"datatype": "boolean"
				},
				"can_be_retranslator": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						"t__sensor_model.name_short as sensor_model_name_short"
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "sensor_model_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tsensor_models",
				"fkid": "t__sensor_model"
			},
			{
				"name": "sensor_model_type_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tsensor_model_types",
				"fkid": "t__sensor_model_type"
			},
			{
				"name": "code",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "has_braid",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "has_own_values",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "ordering",
				"not_null": 0,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "integer"
			},
			{
				"name": "can_be_retranslator",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "braid_measurer_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tmeasurer_value_types",
				"fkid": "t__braid_measurer"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "1",
			"role": "pages",
			"section": "modules",
			"label": "Типы моделей",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		},
		"code_column": "main.code",
		"has_ordering": true,
		"name_column": "main.name"
	},
	{
		"table": "tallowed_value_types",
		"name": "AllowedValueType",
		"folder": "allowed_value_types",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_by_allowed_model",
					"where": "main.allowed_model_type_id = :allowed_model_type_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "measure_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tmeasurer_value_types",
				"fkid": "t__measure"
			},
			{
				"name": "allowed_model_type_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tallowed_model_types",
				"fkid": "t__allowed_model_type"
			},
			{
				"name": "code",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "accuracy",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "1",
			"role": "settings",
			"section": "modules",
			"label": "Типы значений",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": "name + measure_name"
		},
		"code_column": "main.code",
		"name_column": "main.name",
		"has_ordering": true
	},
	{
		"table": "tbase_padding_principles",
		"name": "BasePaddingPrinciple",
		"folder": "base_padding_principles",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "1",
			"role": "pages",
			"section": "modules",
			"label": "Принципы",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tbraids",
		"name": "Braid",
		"folder": "braids",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_by_sensor",
					"where": "main.sensor_id=:sensor_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.deep"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_deep_n_sensor",
					"where": "main.sensor_id=:sensor_id and\nmain.deep = :deep",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_by_sensor_enabled",
					"where": "main.sensor_id=:sensor_id and\nmain.enabled = 1",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.deep"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_sensor",
					"where": "main.sensor_id=:sensor_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "sensor_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tsensors",
				"fkid": "t__sensor"
			},
			{
				"name": "deep",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "enabled",
				"not_null": 0,
				"datatype": "boolean"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tedit_histories",
		"name": "EditHistory",
		"folder": "edit_histories",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_by_facility",
					"where": "main.facility_id = :facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "model_name",
				"not_null": 0,
				"datatype": "name"
			},
			{
				"name": "text",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "data",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "facility_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tfacilities",
				"fkid": "t__facility"
			},
			{
				"name": "date_cr",
				"not_null": 0,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "user_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user"
			},
			{
				"name": "model_id",
				"not_null": 0,
				"datatype": "integer"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "texplications",
		"name": "Explication",
		"folder": "explications",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_facility",
					"where": "main.facility_id = :facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "facility_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tfacilities",
				"fkid": "t__facility"
			},
			{
				"name": "field01",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "field02",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "field03",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "field04",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "field05",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "field06",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "field07",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "field08",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "field09",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "field10",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "field11",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "field12",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tfacilities",
		"name": "Facility",
		"folder": "facilities",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"name": "list_level",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0)",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "with_recurse",
					"skip": {},
					"where": "",
					"start_with": "",
					"connect_by": "",
					"order_by": "init.ordering",
					"variant": "recurse",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": ""
				},
				{
					"name": "count_level",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0)",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_facility",
					"where": "main.parent_id = :facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "with_recurse_by_facility",
					"where": "main.id = :facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "recurse",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_level_existed",
					"where": "coalesce(main.parent_id,0) = coalesce(:parent_id,0) and\nmain.deleted is null",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.ordering"
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_by_plan_exists",
					"where": "main.plan_id = :plan_id and\nmain.deleted is null",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "parent_id",
				"not_null": 0,
				"datatype": "bigint"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "image_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image"
			},
			{
				"name": "code",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "address",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1280"
			},
			{
				"name": "load_capacity",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "protection",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "base_type",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "base_construction",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "base_principle_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tbase_padding_principles",
				"fkid": "t__base_principle"
			},
			{
				"name": "location_x",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "location_y",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "state_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tfacility_states",
				"fkid": "t__state"
			},
			{
				"name": "width",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "height",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "foundation_depth",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "frozen_depth",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "clipmap",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "dumping_depth",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "plan_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tplans",
				"fkid": "t__plan"
			},
			{
				"name": "view_data",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "table_x",
				"not_null": 0,
				"default_value": "1",
				"datatype": "numeric"
			},
			{
				"name": "table_y",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "element_size",
				"not_null": 0,
				"default_value": "1.00",
				"datatype": "numeric"
			},
			{
				"name": "table_size",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "deleted",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "date_cr",
				"not_null": 0,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "date"
			},
			{
				"name": "allowed_temperature",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "allowed_deformation",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "show_explication",
				"not_null": 0,
				"default_value": "0",
				"datatype": "integer"
			},
			{
				"name": "show_convention",
				"not_null": 0,
				"default_value": "0",
				"datatype": "integer"
			},
			{
				"name": "convention_x",
				"not_null": 0,
				"default_value": "0",
				"datatype": "integer"
			},
			{
				"name": "convention_y",
				"not_null": 0,
				"default_value": "0",
				"datatype": "integer"
			},
			{
				"name": "type",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "stamp_data",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "responsibility_level",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			},
			{
				"name": "negative_process",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"has_hier": true,
		"has_ordering": true,
		"adminpanel": {
			"enabled": "0",
			"role": "settings",
			"section": "ИАС",
			"label": "Объекты",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		},
		"code_column": "main.code"
	},
	{
		"table": "Tfacility_comments",
		"name": "FacilityComment",
		"folder": "facility_comments",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_facility",
					"where": "main.facility_id = :facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.date_cr"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "facility_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tfacilities",
				"fkid": "t__facility"
			},
			{
				"name": "date_cr",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "user_cr_id",
				"not_null": 1,
				"skip_edit": 1,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user_cr"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "images_json",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tfacility_comment_images",
		"name": "FacilityCommentImage",
		"folder": "facility_comment_images",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_comment",
					"where": "main.comment_id = :comment_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "comment_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tfacility_comments",
				"fkid": "t__comment"
			},
			{
				"name": "image_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tfacility_groups",
		"name": "FacilityGroup",
		"folder": "facilities_groups",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_facility",
					"where": "main.facility_id = :facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "facility_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tfacilities",
				"fkid": "t__facility"
			},
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tfacility_photos",
		"name": "FacilityPhoto",
		"folder": "facility_photos",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_facility",
					"where": "main.facility_id = :facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.date_cr"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "facility_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tfacilities",
				"fkid": "t__facility"
			},
			{
				"name": "date_cr",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "user_cr_id",
				"not_null": 1,
				"skip_edit": 1,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user_cr"
			},
			{
				"name": "image_id",
				"not_null": 1,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tfacility_stats",
		"name": "FacilityStat",
		"folder": "facility_stats",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_facility_n_date",
					"where": "main.facility_id = :facility_id and\nmain.date = :date",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "facility_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tfacilities",
				"fkid": "t__facility"
			},
			{
				"name": "date",
				"not_null": 0,
				"datatype": "date"
			},
			{
				"name": "data",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tfacility_states",
		"name": "FacilityState",
		"folder": "facility_states",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "1",
			"role": "settings",
			"section": "modules",
			"label": "Статусы объектов",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		},
		"has_ordering": true
	},
	{
		"table": "tfacility_types",
		"name": "FacilityType",
		"folder": "facility_types",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				}
			]
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {}
	},
	{
		"table": "tmeasurement_modes",
		"name": "MeasurementMode",
		"folder": "measurement_modes",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				}
			]
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {}
	},
	{
		"table": "tmeasurement_periods",
		"name": "MeasurementPeriod",
		"folder": "measurement_periods",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_model_n_facility",
					"where": "main.sensor_model_id = :sensor_model_id and\nmain.facility_id = :facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_by_facility",
					"where": "main.facility_id = :facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "facility_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tfacilities",
				"fkid": "t__facility"
			},
			{
				"name": "sensor_model_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tsensor_models",
				"fkid": "t__sensor_model"
			},
			{
				"name": "value",
				"not_null": 0,
				"datatype": "integer"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tnormatives",
		"name": "Normative",
		"folder": "normatives",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_by_facility",
					"where": "main.facility_id = :facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_facility_n_type",
					"where": "main.facility_id = :facility_id and\nmain.type_id = :type_id\n",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "facility_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tfacilities",
				"fkid": "t__facility"
			},
			{
				"name": "type_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tnormative_types",
				"fkid": "t__type"
			},
			{
				"name": "value",
				"not_null": 0,
				"datatype": "numeric"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "settings",
			"section": "ИАС",
			"label": "Нормативы",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tnormative_types",
		"name": "NormativeType",
		"folder": "normative_types",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "0",
			"role": "settings",
			"section": "ИАС",
			"label": "Типы нормативов",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tplans",
		"name": "Plan",
		"folder": "plans",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_exists",
					"where": "main.deleted is null",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1204"
			},
			{
				"name": "dwg_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__dwg"
			},
			{
				"name": "pdf_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__pdf"
			},
			{
				"name": "jpg_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__jpg"
			},
			{
				"name": "format_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tplan_formats",
				"fkid": "t__format"
			},
			{
				"name": "view_data",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "width",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "height",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "status",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "urn",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "urn_encoded",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "log",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "calc_pdf_id",
				"not_null": 0,
				"skip_edit": 1,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__calc_pdf"
			},
			{
				"name": "deleted",
				"not_null": 0,
				"datatype": "integer"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tplan_formats",
		"name": "PlanFormat",
		"folder": "plan_formats",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "width",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "height",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "dwg_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__dwg"
			},
			{
				"name": "pdf_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__pdf"
			},
			{
				"name": "explication_data",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "1",
			"role": "modules",
			"section": "ИАС",
			"label": "Форматы PDF",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "treferences",
		"name": "Reference",
		"folder": "references",
		"patches": {
			"columns": {
				"body": {
					"datatype": "wysiwyg"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"name": "list_level",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0)",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "with_recurse",
					"skip": {},
					"where": "",
					"start_with": "",
					"connect_by": "",
					"order_by": "init.ordering",
					"variant": "recurse",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": ""
				},
				{
					"name": "count_level",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0)",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "list_level_enabled",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0) and\nmain.enabled=1",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_level_enabled",
					"skip": {},
					"where": "coalesce(main.parent_id,0)=coalesce(:parent_id,0) and\nmain.enabled=1",
					"order_by": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "with_recurse_enabled",
					"skip": {},
					"where": "",
					"start_with": "init.enabled=1",
					"connect_by": "init.enabled=1",
					"order_by": "init.ordering",
					"variant": "recurse",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": ""
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "parent_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "treferences",
				"fkid": "t__parent"
			},
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "enabled",
				"not_null": 0,
				"datatype": "boolean"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"has_hier": true,
		"has_ordering": true,
		"adminpanel": {
			"enabled": "1",
			"role": "pages",
			"section": "ИАС",
			"label": "Документация",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tsensors",
		"name": "Sensor",
		"folder": "sensors",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_facility",
					"where": "main.facility_id=:facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.name"
				},
				{
					"skip": {},
					"add": [
						"t__sensor_model.name_short as sensor_model_name_short"
					],
					"leftjoins": [
						""
					],
					"name": "get_full",
					"where": "main.id = :id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_name",
					"where": "main.name = :name",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "facility_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tfacilities",
				"fkid": "t__facility"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "location_x",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "location_y",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "location_comments",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "measurement_mode_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tmeasurement_modes",
				"fkid": "t__measurement_mode"
			},
			{
				"name": "allowed_model_type_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "tallowed_model_types",
				"fkid": "t__allowed_model_type"
			},
			{
				"name": "state_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "tsensor_states",
				"fkid": "t__state"
			},
			{
				"name": "is_retranslator",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "deep",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "deep_step",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "image_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image"
			},
			{
				"name": "angle",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "deleted",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "pr_sensor_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tsensors",
				"fkid": "t__pr_sensor"
			},
			{
				"name": "measurement_period",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			},
			{
				"name": "reference_date",
				"not_null": 0,
				"datatype": "date"
			},
			{
				"name": "clipmap",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "2048"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "1",
			"role": "modules",
			"section": "ИАС",
			"label": "Элементы",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		},
		"name_column": "main.name"
	},
	{
		"table": "Tsensor_comments",
		"name": "SensorComment",
		"folder": "sensor_comments",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_sensor",
					"where": "main.sensor_id = :sensor_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "sensor_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tsensors",
				"fkid": "t__sensor"
			},
			{
				"name": "date_cr",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "user_cr_id",
				"not_null": 1,
				"skip_edit": 1,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user_cr"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "images_json",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tsensor_comment_images",
		"name": "SensorCommentImage",
		"folder": "sensor_comment_images",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_comment",
					"where": "main.comment_id = :comment_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "image_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image"
			},
			{
				"name": "comment_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tsensor_comments",
				"fkid": "t__comment"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tsensor_groups",
		"name": "SensorGroup",
		"folder": "sensor_groups",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_sensor",
					"where": "main.sensor_id = :sensor_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_facility",
					"where": "t__sensor.facility_id = :facility_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_group_n_sensor",
					"where": "main.sensor_id = :sensor_id and\nmain.group_id = :group_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "sensor_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tsensors",
				"fkid": "t__sensor"
			},
			{
				"name": "group_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tfacility_groups",
				"fkid": "t__group"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tsensor_models",
		"name": "SensorModel",
		"folder": "sensor_models",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "name_short",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "24"
			},
			{
				"name": "has_braid",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "has_own_values",
				"not_null": 0,
				"datatype": "integer"
			},
			{
				"name": "has_angle",
				"not_null": 0,
				"datatype": "integer"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"code_column": "main.code",
		"adminpanel": {
			"enabled": "1",
			"role": "settings",
			"section": "modules",
			"label": "Типы датчиков",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tsensor_model_measurers",
		"name": "SensorModelMeasurer",
		"folder": "sensor_model_measurers",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.ordering",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_sensor_model",
					"where": "main.sensor_model_id=:sensor_model_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.ordering"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "sensor_model_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tsensor_models",
				"fkid": "t__sensor_model"
			},
			{
				"name": "value_type_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tmeasurer_value_types",
				"fkid": "t__value_type"
			},
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "ordering",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_admin_list": 1,
				"skip_edit": 1,
				"datatype": "bigint"
			},
			{
				"name": "accuracy",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "24"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"has_ordering": true,
		"adminpanel": {
			"enabled": "0",
			"role": "",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tsensor_model_normatives",
		"name": "SensorModelNormative",
		"folder": "sensor_model_normatives",
		"patches": {
			"columns": {
				"for_group": {
					"datatype": "boolean"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "sensor_model_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tsensor_models",
				"fkid": "t__sensor_model"
			},
			{
				"name": "normative_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tnormative_types",
				"fkid": "t__normative"
			},
			{
				"name": "value",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "for_group",
				"not_null": 0,
				"datatype": "integer"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "settings",
			"section": "ИАС",
			"label": "Нормативы моделей",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "tsensor_model_types",
		"name": "SensorModelType",
		"folder": "sensor_model_types",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				}
			]
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "1024"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {}
	},
	{
		"table": "Tsensor_photos",
		"name": "SensorPhoto",
		"folder": "sensor_photos",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select"
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count"
				}
			]
		},
		"columns": [
			{
				"name": "sensor_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tsensors",
				"fkid": "t__sensor"
			},
			{
				"name": "date_cr",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "user_cr_id",
				"not_null": 1,
				"skip_edit": 1,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user_cr"
			},
			{
				"name": "image_id",
				"not_null": 1,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__image"
			},
			{
				"name": "body",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"adminpanel": {}
	},
	{
		"table": "tsensor_states",
		"name": "SensorState",
		"folder": "sensor_states",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "code",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"code_column": "main.code",
		"adminpanel": {
			"enabled": "0",
			"role": "settings",
			"section": "ИАС",
			"label": "Состояние датчиков",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tsensor_values",
		"name": "SensorValue",
		"folder": "sensor_values",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_sensor",
					"where": "main.sensor_id = :sensor_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.date_cr"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_sensor_n_measure",
					"where": "main.sensor_id = :sensor_id and\nmain.sensor_model_measurer_id = :sensor_model_measurer_id",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.date_cr"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_sensor_n_measure_n_date",
					"where": "main.sensor_id = :sensor_id and\nmain.sensor_model_measurer_id = :sensor_model_measurer_id and\nmain.date_use::date = to_date(:date_use,'DD.MM.YYYY')",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.date_cr"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_braid_n_date",
					"where": "main.braid_id = :braid_id and\nmain.date_use = :date_use",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_sensor_n_date",
					"where": "main.sensor_id = :sensor_id and\nmain.date_use = :date_use",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_sensor_n_date_n_avt_only",
					"where": "main.sensor_id = :sensor_id and\nmain.date_use = :date_use and\nmain.allowed_value_type_id = :allowed_value_type_id and\nmain.braid_id is null",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "sensor_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tsensors",
				"fkid": "t__sensor"
			},
			{
				"name": "date_cr",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "value",
				"not_null": 0,
				"datatype": "numeric"
			},
			{
				"name": "date_use",
				"not_null": 0,
				"datatype": "date"
			},
			{
				"name": "braid_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tbraids",
				"fkid": "t__braid"
			},
			{
				"name": "allowed_value_type_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "tallowed_value_types",
				"fkid": "t__allowed_value_type"
			}
		],
		"columns_l10n": [],
		"adminpanel": {
			"enabled": "0",
			"role": "settings",
			"section": "ИАС",
			"label": " Показания датчиков",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tmeasurer_value_types",
		"name": "SensorValueMeasure",
		"folder": "measurer_value_types",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"name": "get_by_code",
					"skip": {},
					"where": "main.code=:code",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "code",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"code_column": "main.code",
		"adminpanel": {
			"enabled": "0",
			"role": "gtm_settings",
			"section": "ИАС",
			"label": "Измеряемые значения",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	},
	{
		"table": "Tusers",
		"name": "User",
		"folder": "users",
		"patches": {
			"columns": {},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "login",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "first_name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "second_name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "last_name",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "calc_full_name",
				"not_null": 0,
				"skip_edit": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "password",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "enabled",
				"not_null": 1,
				"datatype": "boolean"
			},
			{
				"name": "email",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "calc_no_roles",
				"not_null": 1,
				"skip_edit": 1,
				"datatype": "integer"
			},
			{
				"name": "sex_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tsexes",
				"fkid": "t__sex"
			},
			{
				"name": "date_cr",
				"not_null": 1,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "date_birth",
				"not_null": 0,
				"datatype": "date"
			},
			{
				"name": "im_icq",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "16"
			},
			{
				"name": "im_jabber",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "48"
			},
			{
				"name": "im_msn",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "48"
			},
			{
				"name": "im_skype",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "48"
			},
			{
				"name": "phone",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "48"
			},
			{
				"name": "date_last_page",
				"not_null": 0,
				"datatype": "timestamp"
			},
			{
				"name": "avatar_id",
				"not_null": 0,
				"datatype": "file",
				"table": "Tfiles",
				"fkid": "t__avatar"
			},
			{
				"name": "about",
				"not_null": 0,
				"datatype": "text"
			},
			{
				"name": "regsid",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "64"
			},
			{
				"name": "prefer_l10n_id",
				"not_null": 0,
				"datatype": "fk",
				"table": "Tl10n",
				"fkid": "t__prefer_l10n"
			},
			{
				"name": "im_telegram",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "32"
			}
		],
		"columns_l10n": [],
		"name_column": "main.calc_full_name",
		"adminpanel": {
			"enabled": "1",
			"role": "gtm_settings",
			"section": "",
			"label": "",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "AdminHelpers.user_helper",
			"edithelperfunc": "AdminHelpers.user_helper",
			"savehelperfunc": "AdminHelpers.user_helper",
			"prehelperfunc": "AdminHelpers.user_helper",
			"impexphelperfunc": "AdminHelpers.user_helper",
			"list_fk_column": ""
		}
	}
]