///ANALYTICS PAGE

GTM.init_analytics = function(){
	this.render_left();
	this.render('right',null,'analytics/right');
}

GTM.render_left = function(facility_id){
	this.render('left',{ facilities:this.tree, facility:this.get('facilities',this.current_facility_id) || {} },'analytics/left');
}

GTM.choose_facility = function(facility_id){
	var t = this;
	if (!facility_id) {
		this.init_facility();
	} else {
		this.request('get_facility',{ facility_id:facility_id });
	}
}

GTM.init_facility = function(facility_id){
	this.current_facility_id = facility_id;
	delete this.blocks['days'];
	delete this.blocks['date_to'];
	this.render_left();
}

// FULL STAT

GTM.add_full_stat = function(){
	lnrr.facilities = this.tree;
	Popup('add_full_stat',{ title:'Добавить статистику'});	
}

GTM.get_full_stat = function(tag){
	
	var params = this.get_data(tag);
	
	var facilities = [];
	var states = [];
	var models = [];
	
	for (k in params) {
		var arr;
		if (arr=k.match(/^facility_(\d+)$/)) if(params[k]) facilities.push(arr[1]);
		if (arr=k.match(/^sensor_model_(\d+)$/)) if(params[k]) models.push(arr[1]);
		if (arr=k.match(/^sensor_state_(\d+)$/)) if(params[k]) states.push(arr[1]);
	}
	
	if (!params.date_to) {
		this.error('Не указана дата');
		return;
	}
	
	var r = {
		date_to:	this.date_to_bd(this.date_to_js(params.date_to)),
		models:		models.join(','),
		states:		states.join(','),
		facilities:	facilities.join(',')
	};
	
	this.request('get_full_stat',r);
}

GTM.rebuild_full_stat = function(stats,ms){
	
	this.full_stat = {};
	
	var models = {};
	
	var stat = {};
	
	for (date in stats){
		if (!stat[date]) stat[date] = {};
		for (facility_id in stats[date]){
			if (!stat[date][facility_id]) stat[date][facility_id] = stats[date][facility_id];
		}
	}
	
	stats = stat;
	
	lnrr.dictionaries.AllowedModelType.forEach(function(el){
		if(!models[el.sensor_model_id]) models[el.sensor_model_id] = [];
		models[el.sensor_model_id].push(el.id);
	});
	
	var hash = {};
	
	for (date in stats){
		hash[date] = {};
		for(m_id in models){
			if (ms && !ms[m_id]) continue;
			hash[date][m_id] = {};				
			for(facility_id in stats[date]){
				var s = stats[date][facility_id];
				hash[date][m_id][facility_id] = {stats:{}}
				models[m_id].forEach(function(el){
					hash[date][m_id][facility_id].stats[el] = s.allowed_model_types[el];
				});
			}
		}
	}
	
	for (k in hash) this.full_stat[k] = hash[k];
}

GTM.render_full_stat = function(){

	var t = this;
		
	var tag = this.block('table');
	tag.html('');
	
	if(!this.full_stat) return;
	
	var models = {};
	
	lnrr.dictionaries.AllowedModelType.forEach(function(el){
		if(!models[el.sensor_model_id]) models[el.sensor_model_id] = []
		models[el.sensor_model_id].push(el.id);
	});

	for (date in this.full_stat){
		tag.append('<h2>Статистика на ' + date + '</h2>');
		for(m_id in models){
			
			var rows = [];
			t.get_stat_header(m_id).rows.forEach(function(el){
				rows.push(el);
			});
			
			var flag = 0;
			
			for(facility_id in this.full_stat[date][m_id]){
				flag = 1;
				var row  = t.get_stat_row(m_id,this.full_stat[date][m_id][facility_id]);
				row.unshift(t.get('facilities',facility_id).name);
				rows.push(row);
			}
			
			if (!flag) continue;
			
			tag.append('<h3>' +  GTM.get('SensorModel',m_id).name + '</h3>');
			
			var table_tag = $('<div></div>');
				table_tag.css({
					'height':'auto',
					'position':'relative',	
				});
				tag.append(table_tag);
			
			var table_config = t.get_stat_header(m_id);
			
			// todo -> use main.create_table
			
			var table = Funcs.create_table(table_tag[0],{ rows:rows, table_values:{}, merges:table_config.merges, render_funcs:table_config.render_funcs });
				table.render();
		}
		
	}	
	
}

GTM.get_stat_row = function(sensor_model_id,data){
	
	var row = [];
		
	var stats = {
		count:0,
		retranslators:0,
		states:{},
		types:{}
	}
	
	for (k in data.stats) {
		var types = data.stats[k];
		stats.types[k] = types;
		stats.count+=data.stats[k].count;
		stats.retranslators+=data.stats[k].retranslators;
		for (s in types.states) {
			if (!stats.states[s]) stats.states[s] = 0;
			stats.states[s] += types.states[s];
		}
	}
	
	if (sensor_model_id == 8) row = [
		stats.count,
		stats.states['2'],
		stats.states['3'],
		stats.states['5'],
		stats.states['6'],
		stats.states['1'],
	];
	
	if (sensor_model_id == 9  ||
		sensor_model_id == 10 ||
		sensor_model_id == 14) row = [
		stats.count,
		stats.states['2'],
		stats.states['3'],
		stats.states['4'],
		stats.states['5'],
		stats.states['6'],
		stats.states['1'],
		stats.retranslators,
	];
	
	if (sensor_model_id == 13){
		console.log(stats);
		row = [
			stats.types['6'].count,
			stats.types['5'].count,
			stats.types['7'].count,
			stats.count,
			stats.states['2'],
			stats.states['3'],
			stats.states['4'],
			stats.states['5'],
			stats.states['6'],
			stats.types['6'].states[1],
			stats.types['5'].states[1],
			stats.types['7'].states[1],
			stats.states['1'],
			stats.retranslators,
		];
	}
	
	return row;
}

GTM.get_stat_header = function(sensor_model_id){
	
	var rows = [];
	var merges = [];
	
	var render_funcs = {
		"0" : function(ins,td){ $(td).addClass('custheader'); },
		"1" : function(ins,td){ $(td).addClass('custheader'); }
	}
	
	if (sensor_model_id == 8) {
		rows = [
			[
				'Номер и наименование позиции (подобъект)',
				'Общее количество (по проекту)',
				'Состояние элемента',
				'','','',''
			],
			[
				'','',
				'Повреждены',
				'Не смонтированы',
				'Не доступны для замера',
				'Демонтированы',
				'Рабочие'
			]
		];
		merges.push({row: 0, col: 2, rowspan:1, colspan:5 });
	}
	
	if (sensor_model_id == 9  ||
		sensor_model_id == 10 ||
		sensor_model_id == 14) {
			rows = [
			[
				'Номер и наименование позиции (подобъект)',
				'Общее количество (по проекту)',
				'Состояние элемента',
				'','','','','',
				'Дополнительное оборудование'
			],
			[
				'','',
				'Повреждены',
				'Не смонтированы',
				'Не оборудованы',
				'Не доступны для замера',
				'Демонтированы',
				'Рабочие',
				''
			]
		];
		merges.push({row: 0, col: 2, rowspan:1, colspan:6 });		
	}
	
	if (sensor_model_id == 13) {
		rows = [
			[
				'Номер и наименование позиции (подобъект)',
				'Общее количество (по проекту)',
				'','','',
				'Состояние элемента',
				'','','','','','','','',
				'Дополнительное оборудование'
			],
			[
				'','','','','',
				'Повреждены',
				'Не смонтированы',
				'Не оборудованы',
				'Не доступны для замера',
				'Демонтированы',
				'Рабочие',
				'','','',''
			],
			[
				'',
				'Наварные',
				'Краской',
				'Инклинометрические',
				'Всего',
				'','','','','',
				'Наварные',
				'Краской',
				'Инклинометрические',
				'Всего',
				''
			]
		];
		
		merges.push({row: 0, col: 1, rowspan:2, colspan:4 });
		merges.push({row: 0, col: 5, rowspan:1, colspan:9 });
		merges.push({row: 0, col: 14, rowspan:2, colspan:1 });
		merges.push({row: 1, col: 10, rowspan:1, colspan:4 });
		
		render_funcs[2] = function(ins,td){$(td).addClass('custheader');}
	}
	
	return { rows:rows, merges:merges, render_funcs:render_funcs };
	
}

// GRAPHS

GTM.get_values = function(){
	var params = this.gen_params_for_data();
	console.log(params);
	this.request('all_values',params);
}

GTM.render_values = function(){
	
	this.block('table').html('');
	
	if (!this.values.length) {
		delete this.table;
		return;
	}
	
	var table_data = this.prepare_data_for_table(this.values);
	if (!table_data) {
		delete this.table;
		return;
	}
		
	var table = this.gen_table(table_data);
	
	this.table = table;
	this.render_table();
		
};


GTM.render_table = function(){
	if (this.table) this.table.render();
	else this.block('table').html('');
}
/*
 *	Рисует один большой график по всем данным
 *	
 */
GTM.render_graph = function(){ 
	
	var t = this;
	
	if (!this.values || !this.values.length) return null;
		
	var t = this;
		
	var filters = this.gen_filters();
		
	var values = this.values.map(function(el){
		el.sensor = t.get('sensors',el.sensor_id);
		return el;
	}).filter(function(el){
		return t.check(filters,el.sensor,'sensor');
	});
	
	if (!values.length) return null;
	
	console.log('GRAPH',values);
	
	var dates = this.values[0].dates;
	var series = {own:[],braid:[]};
	var filters = this.gen_filters();
	var braids = [];
	var deeps = {};
		
	var frozen_depth;

	values.forEach(function(data){
		
		if (data.type=='braid') {
			data.values.forEach(function(el){
				if(!deeps[el[0]])deeps[el[0]]=[];
				deeps[el[0]].push(el);
			});
			braids.push(data);
			return;
		}
		
		var avts = data.avts;
		var l = data.avts.length;
		var hash = {};
		
		data.values.forEach(function(el,i){
			if(!hash[avts[i%l]]) hash[avts[i%l]] = [];
			hash[avts[i%l]].push(el);
		});
		
		for (k in hash) {
			var arr = hash[k];
			if (!arr.some(function(el){return el})) continue;
			if (!frozen_depth) frozen_depth = arr;
			series.own.push({
				type: 'column',
				name:	data.sensor.name + ': ' + t.get('AllowedValueType',k).name,
				data:arr
			});
		}
	});
	
	
	if (frozen_depth && false) {
		var frozen_depth = frozen_depth.map(function(){ return t.get('facilities',t.current_facility_id).frozen_depth });
		series.own.push({
			type: 'spline',
			name: 'Мощность СМС',
			data: frozen_depth,
			tooltip: {
				valueSuffix: 'м'
			}
		});
	}
	
	var deeps_arr = [];
	for (d in deeps) deeps_arr.push(d);
	deeps_arr = deeps_arr.sort(function(a,b){return a-b;});
	
	braids.forEach(function(data){
		data.dates.forEach(function(date,i){
			var arr = [];
			data.values.forEach(function(v){
				arr.push([v[0],v[i+1]])	
			});
			if (!arr.some(function(el){return el[1]})) return;
			series.braid.push({
				name: data.sensor.name+' на ' +date,
				data:arr.filter(function(el){ return el[1]!=null; })
			});
		});
	});
	
	this.block('graph_braid').html('');
	this.block('graph_own').html('');
	
//	$('.graph.braid,.graph.own').html('');
	console.log(series,deeps_arr);
	
	if (series.own.length) this.block('graph_own').highcharts({
		
		title: {
			text: 'Значения элементов',
		},
		subtitle: {
//			text: 'Собственнные значение',
		},
		yAxis: {
			title: { text: 'Значения' },
		},
		xAxis: {
			categories: dates,
			crosshair: true
		},
		legend: {
			layout: 'vertical',
			align: 'right',
			verticalAlign: 'middle',
			borderWidth: 0
		},
		series: series.own.filter(function(el){ return el; })

	});
	
	if (series.braid.length)  this.block('graph_braid').highcharts({
		chart: {
			type: 'spline',
			inverted: true
		},
		title: {
			text: 'Значения датчиков',
		},
		subtitle: {
			text:  'Температуры по глубинам',
		},
		yAxis: {
			title: {
				text: 'Температура'
			},
		},
		xAxis: {
			title: {
				text: 'Глубина'
			},
		},
		tooltip: {
			valueSuffix: '°C'
		},
		legend: {
			layout: 'vertical',
			align: 'right',
			verticalAlign: 'middle',
			borderWidth: 0
		},
		series: series.braid
	});		
};


/*
 *	Раскидывает данные на каждый график отдельно
 *	
 */
GTM.render_graphs = function(){
		
	var t = this;
	
	var tag = this.block('graphs');
	tag.html('');
	
	if (!this.values || !this.values.length) return;
	
	var ps_mode = $('select[name=ps_mode]').val() || 'single_date';// || 'single_sensor'; 
	var ps = [];
	
	this.values.forEach(function(el){
		
		el.sensor = t.get('sensors',el.sensor_id);
		
		var type;
		
		if (el.sensor.allowed_model_type_id==2 && ps_mode=='single_date') {
			ps.push(el);
			return;
		}
		
//		if (el.sensor.allowed_model_type_id==2 && ps_mode=='single_sensor') type = 'simple_ps';
		
		if (el.sensor.allowed_model_type_id==5 ||
			el.sensor.allowed_model_type_id==6) type = 'simple_dm';
		
		
		if (el.sensor.allowed_model_type_id==8  ||
			el.sensor.allowed_model_type_id==9  ||
			el.sensor.allowed_model_type_id==11) type = 'braid';
		
		if (!type) return;
		if (type=='braid') {
			el.dates.forEach(function(date,i){ t.render_single_graph(tag,type,el,date,i); });
		} else t.render_single_graph(tag,type,el);
		
	});
	
	if (!ps.length) return;
	
	t.render_single_graph(tag,'ps',ps);
	t.render_single_graph(tag,'ps_date',ps);
	
}

/*
 *	Рисует графики для каждого типа отдельно
 *	
 */
GTM.render_single_graph = function(tag, type, data, date, date_index){
		
	var t = this;	
	
	var series = [];
	
	var table_config = {
		title: {},
		subtitle: {},
	};
	
	var filters = this.gen_filters();		
	
	if (type=='ps' || type=='ps_date') {
		data = data.filter(function(el){
			return t.check(filters,el.sensor,'sensor');
		});
		if (!data.length) return;			
	} else if((filters && !t.check(filters,data.sensor,'sensor')) || !data.values.some(function(el){ return el!=undefined; })) return;
				
	//if (type == 'simple_ps') {
	//	
	//	table_config.xAxis = {
	//		categories: data.dates,
	//		crosshair: true
	//	};
	//				
	//	table_config.title.text = 'Значения элемента ' + data.sensor.name;
	//	table_config.subtitle.text = t.get('AllowedModelType',data.sensor.allowed_model_type_id).name;
	//
	//	series.push({
	//		type: 'column',
	//		name: data.sensor.name,
	//		data: data.values
	//	});
	//}
	
	if (type == 'simple_dm') {
		
		table_config.xAxis = {
			categories: data.dates,
			crosshair: true
		};			
		
		table_config.yAxis = {
			title: { text: 'Высота, мм' },
		};
		
		table_config.title.text = 'Значения элемента ' + data.sensor.name;
		table_config.subtitle.text = t.get('AllowedModelType',data.sensor.allowed_model_type_id).name;
		console.log(t.get('AllowedModelType',data.sensor.allowed_model_type_id));
		series.push({
			type: 'column',
			name: data.sensor.name,
			data: data.values.map(function(el){
				return el - (data.sensor.reference_value||0);
			})
		});
		
	}
	
	if (type == 'braid') {
		
		table_config.chart = {
			type: 'spline',
			inverted: true
		};
		
		var arr = data.values.map(function(el){
			return [el[0],el[date_index+1]];
		}).filter(function(el){
			return el[1]!=null;
		});
		
		if (!arr.some(function(el){ return el[1]!=undefined; })) return;
		
		table_config.title.text = 'Значения элементы ' + data.sensor.name + ' на ' + date;
		table_config.subtitle.text = 'Температуры по глубинам';
		table_config.yAxis = {
			title: { text: 'Температура, °С' },
		};
		table_config.xAxis = {
			title: { text: 'Глубина, м' },
		};
		table_config.tooltip = {
			valueSuffix: '°C'
		};
		
		series.push({
			name: data.sensor.name,
			data: arr
		});
		
		var dd = t.get('facilities',t.current_facility_id).dumping_depth;
		var max = arr.reduce(function(acc,el){			
			if (acc==undefined) acc = el[1];
			if (acc<el[1]) acc = el[1];
			return acc;
		},undefined);
		var min = arr.reduce(function(acc,el){
			if (acc==undefined) acc = el[1];
			if (acc>el[1]) acc = el[1];
			return acc;
		},undefined);
		
		var dd_arr = [[dd,min],[dd,max]];
		
		var m_serie = {
			type: 'spline',
			name: 'Мощность СМС',
			data: dd_arr,//series[0].data.map(function(){ return t.get('facilities',t.current_facility_id).dumping_depth }),
			tooltip: {
				valueSuffix: 'м'
			}
		}
		
		series.push(m_serie);
	}
	
	if (type == 'ps') {
		table_config.xAxis = {
			categories: data[0].dates,
			crosshair: true
		};
		
		table_config.title.text = 'Значения ПС';
		//table_config.subtitle.text = data.sensor.allowed_model_type_code; //todo name
		table_config.yAxis = {
			title: { text: 'УГВ, м' },
		};
		table_config.tooltip = {
			valueSuffix: 'м'
		};
		data.forEach(function(el){
			if (!el.values.some(function(el){ return el!=undefined; })) return;
			series.push({
				type: 'column',
				name: el.sensor.name,
				data: el.values
			});
		});
		
	}
	
	if (type == 'ps_date') {
		
		var date_index = data[0].dates.length-1;
		var date = data[0].dates[date_index];
		
		table_config.xAxis = {
			categories: data.map(function(el){ return el.sensor.name; }),
			crosshair: true
		};
		
		table_config.title.text = 'Значения ПС на ' + date;
		//table_config.subtitle.text = data.sensor.allowed_model_type_code; //todo name
		table_config.yAxis = {
			title: { text: 'УГВ, м' },
		};
		table_config.tooltip = {
			valueSuffix: 'м'
		};
		series.push({
			type: 'column',
			name: 'УГВ',
			data: data.map(function(el){
				return el.values[date_index];
			})
		});		
	}
	
	if (type == 'simple_ps' && series.length) {
		table_config.yAxis = {
			title: { text: 'УГВ, м' },
		};
		table_config.tooltip = {
			valueSuffix: 'м'
		};
		//series.push({
		//	type: 'spline',
		//	name: 'Мощность СМС',
		//	data: series[0].data.map(function(){ return t.get('facilities',t.current_facility_id).dumping_depth }),
		//	tooltip: {
		//		valueSuffix: 'м'
		//	}
		//});
	}

	table_config.series = series;
	
	var block = $('<div></div>');
	tag.append(block);
	block.highcharts(table_config);	
	
}

GTM.refresh_filters = function(){
	this.filter_sensors();	
}


// HTTP
GTM.request = function(mode,data,cb){
	
	var t = this;
	
	var handler = {		
		'get_facility': function(r){
			t.init_facility(r.facilities[0].id);
		},
		'get_full_stat': function(stat){
			var ms = data.models ? data.models.split(',').reduce(function(h,el){h[el]=1;return h;},{}) : '';
			t.rebuild_full_stat(stat,ms);
			t.render_full_stat();
			Popup.close();
		},
		'all_values':function(r){
			t.values = r;
			t.render_values(t.values);
			t.render_graph();
			t.render_graphs();
		},
	}[mode] || function(){ console.log('No handler',mode,data); }
	
	var callback = function(r){
		t.init_data(r);
		handler(r);
		if (cb) cb(r);
	}	

	this.ajax(mode,data,callback);
}

