///DASHBOARD PAGE
GTM.init_dashboard = function(){
	
	this.render('right',this.data,'dashboard/right');
	this.block('right').removeClass('scrollH');
	this.render_facilities();
	
	this.block('pdf').on('contextmenu',function(e){
		Context.show(e);
		e.stopPropagation();
		return false;
	});
	
	this.states = {};
	
	lnrr.table = {
		def_y: 50,
		def_x:1300,
		row_height: '30',
		txt_height: '20',
		col1_width: '50',
		txt1_x: '5',
		txt2_x: '55',
		col2_width: '200',
	};
	
	this.init_pdf();
//	this.init_dwg();
	
	this.refresh_view_mode();
	
	this.move_mode = 1;
	this.clip_mode = 1;
	
	this.switch_clip_mode();
	this.switch_move_mode();
}

// FACILITY

GTM.new_facility = function(parent_id,config){
	config = config || {};
	console.log('new_facility',arguments);
	Popup('new_facility',{ title:config.title || 'Новый объект/площадка', tree:this.tree, parent_id:parent_id });
}

GTM.save_new_facility = function(tag){
	var params = this.get_data(tag);
	this.request('save_new_facility',params);
}

GTM.save_facility = function(tag){
	var params = this.get_data(tag);
	params.facility_id = this.current_facility_id;
	this.request('save_facility',params);
}

GTM.save_facility_coords = function(id, coords){
	this.request('save_coords',{ model_name:'Facility', model_id:id, facility_id:id, location_x:coords.x, location_y:coords.y, type:'element' });
}


GTM.choose_facility = function(facility_id){
	
	var t = this;
	
	if (!facility_id) {
		this.render_facilities();
		this.select_tab();
		return;
	} 
	
	var facility = this.get('facilities',facility_id);
		
	if (!facility) this.request('get_facility',{facility_id:facility_id});
	else this.init_facility(facility_id);
	
}

GTM.init_facility = function(facility_id){
	
	lnrr.facility = this.get('facilities',facility_id);
	
	this.block('pdf_actions').hide();
	
	this.refresh_tabs(facility_id);
	this.select_tab(facility_id);
	
	this.current_facility_id = facility_id;
	this.render_facility();
	
	this.refresh_values();
	this.render_views();
	
}

GTM.delete_facility = function(tag){
	var t = this;
	var params = this.get_data(tag);
	var data = { id:params.id };
	this.request('delete_facility',data,function(){
		$('.tab[data-id="'+data.id+'"]').remove();
		t.choose_facility();
	});

}
// history

GTM.get_history = function(){
	this.request('get_history',{ facility_id:this.current_facility_id });
}

GTM.show_history = function(data){
	lnrr.history = data.history;
	Popup('history',{title:'История изменений'});
}

// stamp

GTM.edit_stamp = function(){
	var t = this;
	Popup('stamp', {title:'Наполнение штампа'},function(tag){ t.render_stamp_edit(tag); });	
}

GTM.get_current_stamp = function(){
	var f = this.get('facilities',this.current_facility_id);
	return  (JSON.parse(f.stamp_data||'0')) || (function(){
		var rows = [];
		for (var y=0;y<11;y++) {
			rows[y] = [];
			for (var x=0;x<8;x++) {
				rows[y][x] = undefined;
			}	
		}
		return rows;
	})();
}

GTM.render_stamp_edit = function(tag){
	
	var rows = this.get_current_stamp();
	
	var merges = [
		
		{row: 0, col: 4, rowspan:2, colspan:4 },
		{row: 2, col: 4, rowspan:3, colspan:4 },
		{row: 5, col: 4, rowspan:3, colspan:1 },
		
		{row: 6, col: 5, rowspan:2, colspan:1 },
		{row: 6, col: 6, rowspan:2, colspan:1 },
		{row: 6, col: 7, rowspan:2, colspan:1 },
		
		{row: 8, col: 4, rowspan:3, colspan:1 },
		{row: 8, col: 5, rowspan:3, colspan:3 },	
		
		
	];
	
	this.stamp_table = new Handsontable( $('#popuptable')[0], {
		colWidths: ['11%', '13%', '6.5%', '5%', '38%', '8%', '7.5%','11%'],
		data: 		rows,
		height:		'270',
		width:		'800',
		colHeaders: false,
		rowHeaders: false,
		stretchH: 	'all',
		mergeCells:	merges,
		cells: function (row, col, prop) {
			cellProperties = {};
			cellProperties.renderer = function (instance, td, row, col, prop, value, cellProperties) {
				Handsontable.renderers.NumericRenderer.apply(this, arguments);
				$(td).css('font-size','0.8rem');
				if ([0,1,2,3,5,6,7].some(function(el){ return el==col; })) { $(td).css('text-align','left'); }
				if (col==4) { $(td).css({'text-align':'center', 'vertical-align':'middle' }); }
				if (col==5 && row==8) { $(td).css({'text-align':'center', 'vertical-align':'middle' }); }
				if (col>=5 && row==6) { $(td).css({'text-align':'center', 'vertical-align':'middle' }); }
			};
			return cellProperties;
		},
		className: "htRight",
	});
	
	this.stamp_table.render();
	
	Popup.render();
}

GTM.save_stamp = function(tag){
	var params = {
		data:			JSON.stringify(this.stamp_table.getData()),
		facility_id:	this.current_facility_id
	}
	this.request('save_stamp',params);
}

// SENSOR

GTM.add_sensor = function(data){
	
	lnrr.sensor = data = data||{};
	
	lnrr.sensor.location_x = this.pdf.last_coords.ox || 0;
	lnrr.sensor.location_y = this.pdf.last_coords.oy || 0;
	
	if (!data.sensor_model_id) {
		Popup('models',{title:'Выбор модели'});
	} else {
		this.prepare_allowed(data.sensor_model_id);
		var sm = this.get('SensorModel',data.sensor_model_id);
		lnrr.sensor.has_braid = sm.has_braid
		lnrr.sensor.has_angle = sm.has_angle
		lnrr.sensor.can_be_retranslator = 1;
		Popup('sensor',{title:'Добавление элемента'});
	}
}

GTM.add_sensor_model = function(tag){
	var params = this.get_data(tag);
	this.add_sensor({sensor_model_id:params.sensor_model_id});
}

GTM.save_sensor = function(tag){
	var params = this.get_data(tag);
	params.facility_id = this.current_facility_id;
	this.request('save_sensor',params);
}

GTM.save_sensor_coords = function(id,coords){
	this.request('save_coords',{ model_name:'Sensor', model_id:id, facility_id:this.current_facility_id, location_x:coords.x, location_y:coords.y, type:'element' });
}

GTM.centered_item = function(item){
	var f = this.get('facilities',this.current_facility_id);
	this.pdf.centered_map({
		x:item.location_x + (f.element_size||1)*this.pdf.size*25/2,
		y:item.location_y + (f.element_size||1)*this.pdf.size*25/2,
	});
}

GTM.edit_sensor = function(id){
	
	var sensor = lnrr.sensor = this.get('sensors',id);
	this.centered_item(sensor);
	
	var amt = this.get('AllowedModelType',sensor.allowed_model_type_id);
	['has_braid','can_be_retranslator'].forEach(function(k){ lnrr.sensor[k]=amt[k]; });
	lnrr.sensor.has_angle = this.get('SensorModel',amt.sensor_model_id).has_angle;
	
	this.prepare_allowed(amt.sensor_model_id);
	lnrr.sensor.groups = ''
	
	if (this.hash['sensor_groups']) for (k in this.hash['sensor_groups'][sensor.id]) {
		lnrr.sensor.groups += this.get('groups',k).name;
	}
	
	lnrr.sensor.groups = '';
	
	Popup('sensor',{title:'Редактирование элемента'});
}

GTM.delete_sensor = function(tag){
	var params = this.get_data(tag);
	var data = { id:params.id };
	this.request('delete_sensor',data);
}

GTM.edit_braid = function(id){
	this.request('get_braid',{sensor_id:id});
}

GTM.add_braid = function(data){
	lnrr.braid = data || {};
	Popup('braid', {title:'Редактирование косы'});
}

GTM.save_enable_braid = function(tag){
	var params = this.get_data(tag);
	this.request('save_enable_braid',{ braids:JSON.stringify(params) });
}


// EXPORT / IMPORT

GTM.export_sensor_values = function(id){
	var params = this.gen_params_for_data();
	var s = '/GTM/export_values/?id='+id;
	for (k in params) s+='&'+k+'='+params[k];
	window.location = s;
},

GTM.import_xlsx = function(id){
	lnrr.sensor = this.get('sensors',id);
	Popup('import_xlsx',{title:'Импорт данных для '+lnrr.sensor.name});
}

GTM.load_xlsx = function(tag){
	
	var t = this;
	var form = new FormData(tag.closest('.params').find('form')[0]);
	
	if (this.pending) {
		this.log('Загрузка не завершена!');
		return;
	}
	
	this.set_loader('Началась загрузка');
	this.pending = 1;
		
	$.ajax({
		url: "/GTM/import_values/",
		type: "POST",
		data: form,
		dataType: 'json',
		enctype: 'multipart/form-data',
		processData: false,
		contentType: false,
		success: function (data) {
			t.pending = 0;
			t.set_loader();
			$('.import_result').html(data.string);
			Popup.render();
		},
		error:function(err){
			t.pending = 0;
			t.set_loader();
			if (err && err.responseText) t.error(err.responseText);
		}
	});
}


// GROUP

GTM.add_group = function(){
	lnrr.group = {};
	Popup('group',{title:'Добавление группы'});
}

GTM.edit_group = function(id){
	lnrr.group = this.get('groups',id);
	Popup('group',{title:'Редактирование группы'});
}

GTM.save_group = function(tag,id){
	var params = this.get_data(tag);
	params.facility_id = this.current_facility_id;
	this.request('save_group',params);
}

GTM.add_to_group = function(tag){
	var t = this;
	var params = this.get_data(tag);
	var id = params.id;
	lnrr.sensor = this.get('sensors',id);
	var groups = this.get('sensor_groups',id) || {};
	lnrr.groups = this.get('facilities',this.current_facility_id).groups.map(function(el){
		el.enabled = groups[el.id];
		return el;
	});
	Popup('add_to_group',{title:'Добавление элемента <b>"'+lnrr.sensor.name+'"</b> в группу'});
}

GTM.save_sensor_group = function(tag){
	var params = this.get_data(tag);
	this.request('save_sensor_group',params);
}

// COMMENTS

GTM.edit_comments = function(type,id){
	var params = {type:type};
	if (type=='facility') params.facility_id = id;
	if (type=='sensor') params.sensor_id = id;
	this.request('get_'+type+'_comments',params);
}

GTM.add_comments = function(data){
	lnrr.comments = [];
	lnrr.comments_type = data.type;
	lnrr.id = data.id;
	data.comments.forEach(function(el){
		el.images = data.images[el.id]||[];
		lnrr.comments.push(el);
	});
	Popup('comments',{title:'Комментарии'});
}

GTM.save_comment = function(tag){
	
	var t = this;
	var form = new FormData(tag.closest('.params').find('form')[0]);
	
	var params = this.get_data(tag);
	if (params.type=='sensor') form.sensor_id = params.id;
	if (params.type=='facility') form.facility_id = params.id;
	
	if (this.pending) {
		this.log('Загрузка не завершена!');
		return;
	}
	
	this.set_loader('Началась загрузка');
	this.pending = 1;
	
	console.log(form);
		
	$.ajax({
		url: '/GTM/save_'+params.type+'_comment/',
		type: "POST",
		data: form,
		dataType: 'json',
		enctype: 'multipart/form-data',
		processData: false,
		contentType: false,
		success: function (data) {
			t.pending = 0;
			t.set_loader();
			t.add_comments(data);
		},
		error:function(err){
			t.pending = 0;
			t.set_loader();
			if (err && err.responseText) t.error(err.responseText);
		}
	});
}

//convention/explication

GTM.save_convention_coords = function(coords){
	this.request('save_coords',{
		model_name:'Facility',
		model_id:this.current_facility_id,
		facility_id:this.current_facility_id,
		convention_x:coords.x,
		convention_y:coords.y,
		type:'convention'
	});
}

GTM.save_explication_coords = function(coords){
	this.request('save_coords',{
		model_name:'Facility',
		model_id:this.current_facility_id,
		facility_id:this.current_facility_id,
		table_x:coords.x,
		table_y:coords.y,
		type:'explication'
	});
}


// TABLE
GTM.refresh_values = function(){
	var t = this;
	var params = t.gen_params_for_data();
	this.request('all_values',params,function(data){ t.render_values(); });	
}

GTM.render_values = function(){
	
	if (!this.values.length) {
		delete this.table;
		return;
	}
	
	var table_data = this.prepare_data_for_table(this.values);
	if (!table_data) {
		delete this.table;
		return;
	}
		
	var table = this.gen_table(table_data);
	
	this.table = table;
	this.render_table();
}

GTM.render_table = function(){
	if (this.table) this.table.render();
	else this.block('table').html('');
}

// VALUES

GTM.save_data = function(cells){
	var t = this;
	
	if (!cells||!cells.length) return;
	if (!this.values_to_save) this.values_to_save = [];
	
	var arr = [];
	
	cells.forEach(function(c){
		var v = t.table_values[c[0]+'_'+c[1]];
		if (!v) return;
		var params = {
			sensor_id: 	v.sensor_id,
			braid_id:	v.braid_id,
			date_use:	v.date_use,
			value: c[3],
			allowed_value_type_id: v.allowed_value_type_id
		};
		console.log(params);
		arr.push(params);
	});
	this.values_to_save.push(JSON.stringify(arr));
	this.save_values();
}

GTM.save_values = function(){
	
	if (this.values_pending) return;
	this.values_pending = 1;
	
	var t = this;
	this.log('Идет сохранение значений...');
	
	var data = this.values_to_save.shift();
	if (data) $.ajax({
		url:'/GTM/save_values/',
		method:'POST',
		dataType:'json',
		data:{ data:data, ajaj:1 },
		error:function(e){			
			t.last_error = e;			
			t.values_pending = 0;
			t.refresh_values();
			Popup('error',{ title:'Ошибка сохранения',text:e.responseText});
		},
		success:function(){			
			t.values_pending=0;
			t.save_values();
		}
	}); else {
		this.values_pending = 0;
		this.request('all_values',this.gen_params_for_data());
		this.log('Значения сохранены');
	}
}

// MAPS
GTM.render_views = function(){
	var t = this;
	this.get_original_size(function(viewport){
		t.pdf.W = viewport.width;
		t.pdf.H = viewport.height;
		t.render_pdf();
		t.render_dwg();
	});
	
}

// DWG
GTM.render_dwg = function(cb){
	var t = this;
	var facility = this.get('facilities',this.current_facility_id);
	if (facility.urn_encoded) this.dwg.load(facility.urn_encoded);
}

// PDF

GTM.inc_pdf_size = function(v){
	this.pdf.size += v * 0.1;
	if (this.pdf.size>50) this.pdf.size = 50;
	if (this.pdf.size<0.01) this.pdf.size = 0.01;
	this.render_pdf();
}

GTM.render_pdf = function(cb,get_size){
	
	if (this.pdf.pending) return;
	this.pdf.pending = 1;
	
	var t = this;
	
	var facility = this.get('facilities',this.current_facility_id);
	if (!facility) return;
	
	var doc = PDFJS.getDocument(facility.calc_pdf_url || facility.pdf_url);
	
	doc.promise.then(function(pdf){
		console.log('GD',pdf);
		pdf.getPage(1).then(function(page){
			var s = t.pdf.size;
			var viewport = page.getViewport(t.pdf.size);
						
			t.pdf.canvas.height = viewport.height;
			t.pdf.canvas.width = viewport.width;
			
			var renderContext = {
				canvasContext:	t.pdf.context,
				viewport:		viewport
			};
			
			t.render_pdf_elements();
			t.render_pdf_clips();
			
			var pageRendering = page.render(renderContext);
			var completeCallback = pageRendering._internalRenderTask.callback;
			
			pageRendering._internalRenderTask.callback = function (error) {
				completeCallback.call(this, error);
				t.pdf.pending = 0;
				t.block('pdf_actions').show();
				if (s!=t.pdf.size) {
					t.render_pdf(cb,get_size);
				} else if (cb) cb();
			};
			
		});				
	});
}

GTM.get_original_size = function(cb){
	var facility = this.get('facilities',this.current_facility_id);
	var doc = PDFJS.getDocument(facility.calc_pdf_url);
	doc.promise.then(function(pdf){
		pdf.getPage(1).then(function(page){
			cb(page.getViewport(1));
		});				
	});	
}

GTM.save_view = function(){
	var f = this.get('facilities',this.current_facility_id);
	var view_data = JSON.parse(f.view_data||'0') || {
		sensor_size:	1,
		row_size:		1,
		table_x:		10,
		table_y:		10,
	};
}

GTM.render_pdf_elements = function(){
	
	var t = this;
	
	if (!this.current_facility_id) return;
	
	var size = this.pdf.size;
	var f = this.get('facilities',this.current_facility_id);
	if (!f) return;	
		
	var view_data = {
		sensor_size:	f.element_size || 1,
		row_size:		0.65,
		table_x:		f.table_x || 10,
		table_y:		f.table_y || 10,
	};
	
	var sensor_size = size * view_data.sensor_size;
	var row_size = 	  size * view_data.row_size;
	
	lnrr.table.x = view_data.table_x * size;
	lnrr.table.y = view_data.table_y * size;	
	lnrr.table.on = f.show_explication;
	
	var filters = this.gen_filters();
	
	var sensors = f.sensors.map(function(el){ el.type='sensor'; return el; });
	var facilities = f.facilities.map(function(el){ el.type='facility'; return el; });
	
	var conventions  = {};
	
	var items = sensors.concat(facilities).filter(function(el){ return t.check(filters,el,el.type); }).map(function(el,i){
		var pos = t.pdf.get_pos({
			x:el.location_x,
			y:el.location_y
		});
		el.x = pos.x - 50*sensor_size/2;
		el.y = pos.y - 50*sensor_size/2;
		el.a = el.angle || 0;
		if (el.type=='sensor') {
			el.table_y = lnrr.table.row_height*i;
		}
		var code = el.allowed_model_type_code ? (el.allowed_model_type_code + '_' + el.state_code) : 'f';
		var v;
		if (el.allowed_model_type_id) {
			var m = t.get('AllowedModelType',el.allowed_model_type_id);
			var s = t.get('SensorState',el.state_id);
			v = m.sensor_model_name+' '+m.sensor_model_type_name+', '+s.name;
		} else v =  'Объект';
		conventions[code] = v;
		return el;
	});
	
	lnrr.conventions = [];
	
	for (k in conventions) {
		var arr = k.match(/(\w+)_(\w+)/);
		var code = state = '';
		if (arr && arr.length) { code = arr[1]; state = arr[2]; }
		else code = 'f';
		if (code=='f') continue;
		lnrr.conventions.push({ code:code, state:state, name:conventions[k] })
	}
	
	lnrr.conventions.x = f.convention_x * size;
	lnrr.conventions.y = f.convention_y * size;
	
	if (!f.show_convention) delete lnrr.conventions;
	
	
	// stamp fill 
	
	var format = this.get('PlanFormat',f.plan.format_id);
	var explication_data = JSON.parse(format.explication_data);
	
	lnrr.expl = {
		size:		0.65 * t.pdf.size,
		x:			explication_data.x * t.pdf.size,
		y:			explication_data.y * t.pdf.size,
		textcss: 	'style="stroke:none; fill:#000; text-anchor:left; font-weight:100; stroke-linecap:null; stroke-linejoin:null; stroke-dasharray:null;"',
		textcss_centered: 	'style="stroke:none; fill:#000; text-anchor:left; font-weight:100; stroke-linecap:null; stroke-linejoin:null; stroke-dasharray:null;text-anchor: middle; dominant-baseline: central;"',
		rows:		this.get_current_stamp(),
	};
	
	this.render('pdf_elements',{
		size:			size,		
		sensor_size:	sensor_size,
		row_size:		row_size,		
		width:  		this.pdf.canvas.width,
		height: 		this.pdf.canvas.height,
		items:			items
		
	},'dashboard/svg');
	
	this.block('pdf_elements').find('.element,.convention,.explication').on('mousedown',function(){
		if (!t.pdf.click) t.pdf.click = {
			coords: t.pdf.last_coords,
			target: $(this),
			type: $(this).attr('data-type')
		}
	});
		
	this.block('pdf_elements').find('.figure').on('mouseover mouseout',function(event){
		var type = $(this).attr('data-type');
		var id = $(this).attr('data-id');
		$('.clipmap[data-type='+type+'][data-id='+id+']')[event.type=='mouseover'?'addClass':'removeClass']('hover');
		if (type=='sensor') type = 'sensors';
		if (type=='facility') type = 'facilities';
		$('.list[data-f='+type+']').find('.item[data-id='+id+']')[event.type=='mouseover'?'addClass':'removeClass']('hover');
		
	});
		
}

GTM.render_pdf_clips = function(){
	
	var t = this;

	this.block('pdf_clips').html('').css({
		width:	this.pdf.W*this.pdf.size,
		height:	this.pdf.H*this.pdf.size,
	});
	
	var size = this.pdf.size;
	var f = this.get('facilities',this.current_facility_id);
	if (!f) return;
	
	var filters = this.gen_filters();
	
	var sensors = f.sensors.map(function(el){ el.type='sensor'; return el; });
	var facilities = f.facilities.map(function(el){ el.type='facility'; return el; });	
	var items = sensors.concat(facilities).filter(function(el){ return t.check(filters,el,el.type); });
	
	var get_polygon = function(clipmap){
		if (!clipmap) return;
		var arr = clipmap.split(';');
		if (!arr || arr.length<1) return;
		
		var clips = [];
		
		arr.forEach(function(coords){
			
			if (!coords) return;
			
			var pos = coords.split(',').reduce(function(h,el,i){
				h[!i?'x':'y'] = parseFloat(el);
				return h;
			},{});
			
			var x = ((pos.x/t.pdf.W) * 100).toFixed(4);
			var y = ((pos.y/t.pdf.H) * 100).toFixed(4);
			
			clips.push( [x,y].map(function(el){ return el+'%'; } ).join(' ') );
		});
		
		var polygon = clips.join(',');
		return polygon;
	}
	
	var add_clipmap = function(polygon,item){
		var styles = item.type=='clipmap' ? 'cov abs op greenB clipmap alpha5' : 'cov abs cp oph blueB clipmap';
		var clipmap = $('<div>',{ class:styles })
			.css({
				'-webkit-clip-path': 'polygon('+polygon+')'
			})
			.attr({
				'data-id':item.id,
				'data-type':item.type,
			})
			.appendTo(t.block('pdf_clips'));
			
		if (item.type=='clipmap') polygon.split(',').forEach(function(el){
			t.block('pdf_clips').append('<div class="abs cov blueB dot" style="-webkit-clip-path: circle(2px at '+el+');"></div>');
		})
	}
	
	items.forEach(function(el){
		var polygon = get_polygon(el.clipmap);		
		if (!polygon) return;
		add_clipmap(polygon,el);
	});
	
	if (this.clip_mode) {
		var s = this.block('clipmap').val();
		var polygon = get_polygon(s);
		if (polygon) add_clipmap(polygon,{id:'',type:'clipmap'});
	} else {
		this.block('clipmap').val('');
	}
	
	this.block('pdf_clips').find('.clipmap').on('mouseover mouseout',function(event){
		var type = $(this).attr('data-type');
		var id = $(this).attr('data-id');
		$('g.figure[data-id='+id+'][data-type='+type+']').attr('class','figure '+(event.type=='mouseover'?'hover':''));
		if (type=='sensor') type = 'sensors';
		if (type=='facility') type = 'facilities';
		$('.list[data-f='+type+']').find('.item[data-id='+id+']')[event.type=='mouseover'?'addClass':'removeClass']('hover');
	}).on('click',function(){
		var type = $(this).attr('data-type');
		var id = $(this).attr('data-id');
		if (type=='sensor') type = 'sensors';
		if (type=='facility') type = 'subfacilities';
		console.log();
		t.centered_item(t.get(type,id));
	});
		
	return;
}

GTM.set_clip = function(model_name,id){
	this.clip = {
		model_name:model_name,
		id:id
	};
	this.log('Назначьте область и нажмите Enter, для отмены нажмите Esc')
	this.switch_clip_mode(1);
}

GTM.save_clip = function(type,id){
	if(!this.clip) return;
	var clipmap = this.block('clipmap').val();
	this.request('save_clip', { model_name:this.clip.model_name, clipmap:clipmap,  id:this.clip.id, facility_id:this.current_facility_id });
	this.switch_clip_mode(0);
}

GTM.gen_pdf = function(){
	var t = this;
	var filters = this.gen_filters();
	this.get_original_size(function(viewport){
		t.request('pdfs', {
			
			facility_id:	t.current_facility_id,
			
			width:			viewport.width,
			height:			viewport.height,
			
			tx:				parseFloat(t.block('_tx').val()) || lnrr.table.def_x,
			ty:				parseFloat(t.block('_ty').val()) || lnrr.table.def_y,
			
			sensor_size:	parseFloat(t.block('_ss').val()) || 1,
			row_size:		parseFloat(t.block('_rs').val()) || 1,
			
			filters:		JSON.stringify(filters),
			
		}, function(url){
			window.open(url);
		});
	});
}

// PANEL

GTM.switch_view_mode = function(view_mode){	
	if (view_mode) this.view_mode = view_mode;
	else this.view_mode = this.view_mode!='pdf' ? 'pdf' : 'dwg';
	
	this.block('view_mode').html(this.view_mode);
	this.block('dwg').css({'z-index':this.view_mode=='dwg'?65:45});
	
	//this.block('pdf').css({'z-index':45});
	//this.block('dwg').css({'z-index':45});
	//
	//this.block(this.view_mode).css({'z-index':55});
	
}

GTM.switch_clip_mode = function(mode){
	this.clip_mode = mode!==undefined ? mode : !this.clip_mode;
	
//	this.block('clipmode').removeClass('whiteT blueB whiteB blueT bF');
//	var styles = this.clip_mode ? 'whiteT blueB' : 'whiteB blueT bF';
//	this.block('clipmode').addClass(styles);
//	this.block('clipmap')[ this.clip_mode ? 'show' : 'hide']();
	
	this.block('pdf')[ this.clip_mode ? 'addClass' : 'removeClass']('selection');
	if (!this.clip_mode) delete this.clip;
	
	this.render_pdf_clips();
}


GTM.switch_move_mode = function(){
	this.move_mode = !this.move_mode;
	this.block('movemode').removeClass('whiteT blueB whiteB blueT bF');
	var styles = this.move_mode ? 'whiteT blueB' : 'whiteB blueT bF';
	this.block('movemode').addClass(styles);
}

GTM.refresh_view_mode = function(view_mode){	
	this.switch_view_mode(this.view_mode);
}

GTM.switch_values_panel = function(view_mode){	
	this.block('values').toggleClass('cov');
	this.render_table();
}

GTM.refresh_tabs = function(facility_id){
	if (!this.block('tabs').find('[data-id='+facility_id+']').length) {
		this.block('tabs').prepend(this.view('dashboard/tab'));
	}
}

GTM.select_tab = function(facility_id){
	this.block('tabs').find('.tab').removeClass('A');
	if (facility_id) this.block('tabs').find('[data-id='+facility_id+']').addClass('A');
}

GTM.render_facility = function(){
	lnrr.facilities = null;
	lnrr.facility = this.get('facilities',this.current_facility_id);
	this.render('left',this.data,'dashboard/left');
	this.init_hovers();
	this.apply_state();
	this.filter_sensors();
}

GTM.init_hovers = function(){
	this.block('left').find('.list[data-f]').each(function(){
		var type = $(this).attr('data-f');
		var type_s = type=='sensors' ? 'sensor' : 'facility';
		$(this).find('.item').on('mouseover mouseout',function(event){
			var id = $(this).attr('data-id');
			$('g.figure[data-id='+id+'][data-type='+type_s+']').attr('class','figure '+(event.type=='mouseover'?'hover':''));
			$('.clipmap[data-type='+type_s+'][data-id='+id+']')[event.type=='mouseover'?'addClass':'removeClass']('hover');
		});
	});
}

GTM.render_facilities = function(){	
	this.render('left',{ facilities:this.tree, facility:{} },'dashboard/left');
}

GTM.refresh_filters = function(){	
	this.render_values();
	this.filter_sensors();
	this.render_pdf_elements();
	this.render_pdf_clips();
	this.save_state();
}


// STATES

GTM.save_state = function(){
	
	var toggle = [];
	
	$('.toggle,.dn').each(function(i){
		toggle[i] = {
			A: $(this).hasClass('A')	
		};
	});
	
	this.states[this.current_facility_id] = {
		toggle:toggle,
		filters:this.gen_filters()
	}
}

GTM.apply_state = function(){
	
	var t = this;
	if (!this.states[this.current_facility_id]) return;
	
	var state = this.states[this.current_facility_id];
	
	$('.toggle,.dn').each(function(i){
		var a = state.toggle[i].A ? 'addClass' : 'removeClass';
		$(this)[a]('A');
	});
	
	var f  = state.filters;
		
	if (f.ret) $('input[data-id=ret]').prop('checked',1);
	if (f.states) for(k in f.states) $('[data-f=states] input[data-id='+k+']').prop('checked',f.states[k]);
	if (f.models) for(k in f.models) $('[data-f=models] input[data-id='+k+']').prop('checked',f.models[k]);
	if (f.facilities) for(k in f.facilities) $('[data-f=facilities] input[data-id='+k+']').prop('checked',f.facilities[k]);
	if (f.sensors) for(k in f.sensors) $('[data-f=sensors] input[data-id='+k+']').prop('checked',f.sensors[k]);
	if (f._groups) for(k in f._groups) $('[data-f=groups] input[data-id='+k+']').prop('checked',f._groups[k]);
}


// GEN PDF

// HTTP
GTM.request = function(mode,data,cb){
	
	var t = this;
	
	var handler = {		
		'save_new_facility':function(r){
			t.render_facilities();
			Popup.close();
		},
		'save_coords':function(r){
			t.render_pdf_elements();
		},
		'save_clip':function(r){
			t.render_pdf_clips();
		},
		'save_facility':function(r){
			t.render_facility();
			t.render_pdf();
			Popup.close();
		},
		'get_facility': function(r){
			t.init_facility(r.facilities[0].id);
		},
		'save_sensor': function(r){
			if (data.justcoords) {
				t.render_pdf_elements();
				return;
			}
			t.render_facility();
			t.render_pdf();
			Popup.close();
		},
		'delete_sensor': function(r){
			t.render_facility();
			Popup.close();
		},
		'save_group': function(r){
			t.render_facility();
			Popup.close();
		},
		'save_sensor_group': function(r){
			t.render_facility();
			Popup.close();
		},
		'get_facility_comments':function(data){
			t.add_comments(data);
		},
		'get_sensor_comments':function(data){
			t.add_comments(data);
		},
		'get_history':function(data){
			t.show_history(data);
		},
		'save_explication':function(data){
			t.render_pdf_elements();
			Popup.close();
		},
		'get_braid':function(data){
			t.add_braid(data);
		},
		'save_enable_braid':function(data){
			Popup.close();
		},
		'save_stamp':function(data){
			t.render_pdf_elements();
			Popup.close();
		},
		'all_values':function(data){
			t.values = data;
		},
	}[mode] || function(){ console.log('No handler',mode,data); }
	
	var callback = function(r){
		t.init_data(r);
		handler(r);
		if (cb) cb(r);
	}
	
	var errfunc = {
		'save_facility':function(){ t.init_facility(t.current_facility_id); },
		'save_coords':function(){ t.init_facility(t.current_facility_id); },
		'save_clip':function(){ t.init_facility(t.current_facility_id); },
		'save_new_facility':function(){ t.render_facilities(); },
		'save_sensor':function(){ t.init_facility(t.current_facility_id); },
		'delete_sensor':function(){ t.init_facility(t.current_facility_id); },
		'save_group':function(){ t.init_facility(t.current_facility_id); },
		'save_sensor_group':function(){ t.init_facility(t.current_facility_id); },
		'save_stamp':function(){ t.init_facility(t.current_facility_id); },
	}[mode] || function(){ console.log('No error handler',mode,data); }
	
	this.ajax(mode,data,callback,errfunc);
}
