var GTM = {
	
	// parameters
	blocks:{},
	hash:{},
	data:{},
	tabs:[],
	
	log_timeout:4500,
	
	// work	
	start: function(section,fields){
		
		var t = this;
		
		lnrr.dictionaries = {};
		fields.section = section;
		
		lnrr.views.after_loaded(function(){
			
			t.render('index',{ section:	section, only_ref:window.location.hostname=='erp-gtm.relsyst.ru' && section=="reference", fields:fields },'main/index');
			
			if(!section) {
				t.log('Выберите раздел');
				return;
			}
			
			t.ajax('init',fields,function(data){
				t.init(section,data);
			});
		});
		
	},
	
	init:function(section,data){
		console.log('Init page - ',section,data);
		var t = this;
		this.init_data(data);
		this['init_'+section](data);
		Context.init();
		
		$('body').on('click',function(){ Context.hide(); })
		
		window.onresize = function(){ Popup.render(); }
		
		$('body').on('keyup',function(e){
			
			if(e.keyCode==27) Popup.close();
			if(e.keyCode==27) { t.log(''); t.switch_clip_mode(0); }
			
			var is_input = e.target && (e.target.tagName == 'INPUT' || e.target.tagName == 'TEXTAREA');
			
			if(e.keyCode==66 &&  t.switch_move_mode && !is_input) t.switch_move_mode();
			if(e.keyCode==77 &&  t.switch_clip_mode && !is_input) t.switch_clip_mode();
			if((e.keyCode==107 || e.keyCode==187) && t.inc_pdf_size && !is_input) t.inc_pdf_size(1);
			if((e.keyCode==109 || e.keyCode==189) && t.inc_pdf_size && !is_input) t.inc_pdf_size(-1);
			
			if (is_input && e.keyCode==13) $(e.target).closest('.params').find('._action').click();
			if (e.keyCode==13 && t.clip) t.save_clip();
		})
	},
	
	// http
	ajax:function(mode,data,callback,errfunc){
		
		var t = this;
		
		if (this.pending) {
			this.log('Загрузка не завершена!');
			return;
		}
		
		data = data||data;
		data.ajaj = 1;
		
		this.set_loader('Началась загрузка');
		this.pending = 1;
		
		$.ajax({
			url:'/GTM/'+mode+'/',
			data: data,
			dataType:'json',
			method:'POST',
			success: function(data){
				t.pending = 0;
				t.set_loader();
				t.log('Загрузка завершена');
				if (data.error) {
					t.error(data.error);
					if (errfunc) errfunc();
					return;
				}
				if(callback) callback(data);
			},
			error: function(err){
				t.pending = 0;
				t.set_loader();
				t.error(err.responseText);
				if (errfunc) errfunc();
			}
		});
		
	},
	
	// data
	init_data: function(data){
		
		var t = this;
		
		this.data = data;		
		if (!data) return;
		
		var k_sg =  'group_sensors';
		var k_gs = 'sensor_groups';
		
		if(!t.hash[k_sg]) t.hash[k_sg] = {};
		if(!t.hash[k_gs]) t.hash[k_gs] = {};
				
		if (data.dictionaries) for (k in data.dictionaries)  {
			lnrr.dictionaries[k] = data.dictionaries[k];
			data.dictionaries[k].forEach(function(d){ t.save_to_hash(k,d); });
		}
		
		if (data.facilities) data.facilities.forEach(function(f){
			
			t.save_to_hash('facilities',f);
			
			f.facilities.forEach(function(sf){ t.save_to_hash('subfacilities',sf); });
			f.sensors.forEach(function(s){ t.save_to_hash('sensors',s); delete t.hash[k_gs][s.id]; });
			f.groups.forEach(function(g){ t.save_to_hash('groups',g); delete t.hash[k_sg][g.id]; });
			
			f.sensors_groups.forEach(function(sg){
				if(!t.hash[k_sg][sg.group_id]) t.hash[k_sg][sg.group_id]={};
				if(!t.hash[k_gs][sg.sensor_id]) t.hash[k_gs][sg.sensor_id]={};
				t.hash[k_sg][sg.group_id][sg.sensor_id] = 1;
				t.hash[k_gs][sg.sensor_id][sg.group_id] = 1;
			});
			
		});
		
		if (data.sensor) t.save_to_hash('sensors',data.sensor);
		
		if (data.tree) this.tree = data.tree;
		
		if (data.users) data.users.forEach(function(u){ t.save_to_hash('users',u); });
		
		if (data.plans) data.plans.forEach(function(u){ t.save_to_hash('plans',u); });
		
		if (data.references) data.references.forEach(function(r){ t.save_to_hash('references',r); });
		
	},
	
	save_to_hash:function(code,item,k){
		if (!this.hash[code]) this.hash[code] = {};
		this.hash[code][item[k?k:'id']] = item;
	},
	
	get:function(code,k){
		return this.hash[code] && this.hash[code][k];
	},
	
	prepare_allowed: function(sensor_model_id){
		lnrr.allowed_model_types = [];
		for (k in this.hash.AllowedModelType)
			if (this.hash.AllowedModelType[k].sensor_model_id==sensor_model_id)
				lnrr.allowed_model_types.push(this.hash.AllowedModelType[k]);
		
		lnrr.allowed_model_types = lnrr.allowed_model_types.sort(function(a,b){ return a.ordering-b.ordering > 0 ? 1 : -1; })
	},
	
	// helpers
	log:function(text,error){
		var t = this;
		this.block('log').html(text)[ error ? 'addClass' : 'removeClass' ]('error');
		clearTimeout(this.log_tid);
		this.log_tid = setTimeout(function(){ t.block('log').html(''); },this.log_timeout);
	},
	
	set_loader:function(v){
		if (typeof v === 'string') this.log(v);
		this.block('log')[ v ? 'addClass' : 'removeClass' ]('A');
		this.block('index')[ v ? 'addClass' : 'removeClass' ]('_loading');
	},
	
	error:function(text){
		var popup_err = $('#popuperror');
		if (popup_err.length) {
			popup_err.html(text);
			Popup.render();
		} else {
			console.log(text);
			Popup('error',{ title:'Ошибка', text:text });
		}
		//this.log(text,1);
	},
	
	// html
	block: function(name){
		if (!this.blocks[name]) this.blocks[name] = $('#'+name);
		return this.blocks[name];
	},
	
	view: function(name,data){
		var path = 'website/GTM/' + (name || 'main/index');
		if (data) for (k in data) lnrr[k] = data[k];
		return lnrr.View(path);
	},
	
	render: function(block_name, data, view_name){
		if (!view_name) view_name = block_name;
		this.block(block_name).html(this.view(view_name,data));
	},
	
	get_data: function(tag){
		var data = {};
		tag.closest('.params').find('input,select,textarea').each(function(){
			var inp = $(this);
			var name = inp.attr('name');
			var type = inp.attr('type');
			if (!name) return;
			if (type=='checkbox') {
				data[name] = inp.prop('checked')?1:0;
			} else {
				data[name] = inp.val();
			}
		});
		tag.closest('.params').find('.loader').each(function(){
			var name = $(this).attr('data-name');
			var ids = $(this).attr('data-id');
			data[name] = ids;
		});
		console.log('get form data',data);
		return data;
	},
	
	gen_params_for_data : function(){
		var params = { facility_id:this.current_facility_id };
		var date = this.block('date_to').val();
		if (!date) date = this.date_to_bd(new Date());
		else date = this.date_to_bd(this.date_to_js(date));
		params.days = this.block('days').val() || 5;
		params.date_to = date;
		return params;	
	},
		
	toggleTab: function(tag){
		tag.next().toggleClass('A');
		tag.toggleClass('A');
		if(this.save_state) this.save_state();
	},
	
	// PDF
	init_pdf: function(){
		
		PDFJS.workerSrc = '/3rdparty/pdf/pdf.worker.js';
		var t = this;
		var tag = this.block('pdf_canvas')[0];
		
		this.pdf = {
			
			canvas:		tag,
			context:	tag.getContext('2d'),
			size:		1,
			
			get_coords: function(pos,no_int){
				var x =  pos.x / t.pdf.size;
				var y =  pos.y / t.pdf.size;
				var ox =  pos.ox / t.pdf.size;
				var oy =  pos.oy / t.pdf.size;
				return {
					x:  no_int ? x : parseInt(x),
					y:  no_int ? y : parseInt(y),
					ox:  no_int ? ox : parseInt(ox),
					oy:  no_int ? oy : parseInt(oy),
				}
			},
			
			get_pos: function(coords){
				return {
					x:	coords.x*t.pdf.size,
					y:	coords.y*t.pdf.size,
				}
			},
			
			centered_map: function(pos){
				
				var W = t.block('pdf').width();
				var H = t.block('pdf').height();
				
				var scroll = {
					scrollTop:	pos.y * t.pdf.size - H/2,
					scrollLeft:	pos.x * t.pdf.size - W/2
				};
				
				t.block('pdf').animate(scroll,500);
			},
			
			update_coords: function(event){
				var pos = t.pdf.get_coords({ x:event.clientX, y:event.clientY, ox:event.offsetX, oy:event.offsetY });
				t.pdf.last_coords = pos;
				t.pdf.show_coords(pos);
			},
			
			show_coords: function(pos){
				t.block('coords').html('['+pos.ox+','+pos.oy+']');	
			},
			
			get_click_item: function(){
				
				var _type = t.pdf.click.target.attr('data-type');
				
				var figure = t.pdf.click.target.closest('.figure');
				var type = figure.attr('data-type')=='sensor' ? 'sensors' : 'subfacilities';
				
				if (_type=='element') return {
					data:	t.get(type,figure.attr('data-id')),
					tag:	figure,
					type: 	figure.attr('data-type')=='sensor' ? 'sensors' : 'subfacilities',
					_type: _type
				}
				if (_type=='convention' || _type=='explication') return {
					data:	t.get('facilities',t.current_facility_id),
					tag:	t.pdf.click.target,
					_type: _type
				}
			},
					
			move: function(){
				var item = t.pdf.get_click_item();
				var f = t.get('facilities',t.current_facility_id);
				var item_pos;
				if (item._type=='element') item_pos = t.pdf.get_pos({x:item.data.location_x,y:item.data.location_y});
				if (item._type=='convention') item_pos = t.pdf.get_pos({x:item.data.convention_x,y:item.data.convention_y});
				if (item._type=='explication') item_pos = t.pdf.get_pos({x:item.data.table_x,y:item.data.table_y});
				var sensor_size = (f.element_size || 1)*t.pdf.size;
				var table_size = 0.65*t.pdf.size;
				var pos = {
					x:	item_pos.x + (t.pdf.last_coords.x - t.pdf.click.coords.x) * t.pdf.size - ( item._type=='element' ? 50*sensor_size/2 : 0),
					y:	item_pos.y + (t.pdf.last_coords.y - t.pdf.click.coords.y) * t.pdf.size - ( item._type=='element' ? 50*sensor_size/2 : 0)
				};
				item.tag.attr('transform','translate('+pos.x+' '+pos.y+') scale(' + ( item._type=='element' ? sensor_size : table_size) + ')');
			},
			
			save: function(){
				var item = t.pdf.get_click_item();
				var item_pos;
				if (item._type=='element') item_pos = t.pdf.get_pos({x:item.data.location_x,y:item.data.location_y});
				if (item._type=='convention') item_pos = t.pdf.get_pos({x:item.data.convention_x,y:item.data.convention_y});
				if (item._type=='explication') item_pos = t.pdf.get_pos({x:item.data.table_x,y:item.data.table_y});
				var pos = {
					x:	item_pos.x + (t.pdf.last_coords.x - t.pdf.click.coords.x) * t.pdf.size,
					y:	item_pos.y + (t.pdf.last_coords.y - t.pdf.click.coords.y) * t.pdf.size
				};
				var coords = t.pdf.get_coords(pos);
				if (item._type=='element' && coords.x==item.data.location_x && coords.y==item.data.location_y) {
					t.centered_item(item.data);
					return false;
				}
				if (item.type=='sensors') t.save_sensor_coords(item.data.id,coords);
				if (item.type=='subfacilities') t.save_facility_coords(item.data.id,coords);
				if (item._type=='convention') t.save_convention_coords(coords);
				if (item._type=='explication') t.save_explication_coords(coords);
			},
			
			get_point: function(event){
				var pos = t.pdf.get_coords({ x:event.offsetX, y:event.offsetY },1);
				return pos.x.toFixed(3)+','+pos.y.toFixed(3)+';';
			},
			
			set_point: function(event){
				var string = (t.block('clipmap').val() || '') + t.pdf.get_point(event);
				t.block('clipmap').val( string ).change();
			}
		};
		
		this.block('clipmap').change(function(){ t.render_pdf_clips(); });
		
		this.block('screen').on('mousemove',function(event){
			t.pdf.update_coords(event);
			t.pdf.click && !t.move_mode && t.pdf.move();
		});
		
		$('body').on('mouseup',function(event){
			if (t.pdf.click) {
				!t.move_mode && t.pdf.save();
				delete t.pdf.click;
				event.stopPropagation();
				event.preventDefault();
				return false;
			};
		});
		
		t.block('pdf').on('click',function(event){
			t.pdf.set_point(event);
		});
		
	},
	
	// DWG
	
	init_dwg: function(){
		
		var t = this;
		var tag = this.block('dwg');	
		
		var	getToken = function() {
			var xmlHttp = new XMLHttpRequest();
			xmlHttp.open("GET", "/api/autodesk/get_access_token/",false);
			xmlHttp.send(null);
			var token = xmlHttp.responseText
			console.log('Autodesc token:',token);
			return token;
		};
		
		this.dwg = {			
			options: {
				'env':'AutodeskProduction',
				'getAccessToken': getToken,
				'refreshToken': getToken,
			},			
			tag: tag,			
			load: function(plan,index){
				var tt = this;
				if (tt.plan==plan) return;
				tt.plan = plan;
				Autodesk.Viewing.Document.load(
					plan,
					function(doc) {						
						tt.geometryItems = Autodesk.Viewing.Document.getSubItemsWithProperties(doc.getRootItem(), {
							'type':'geometry',
							'role':'2d'
						}, true);
						if (tt.target) {
							tt.target.finish();
							delete tt.target;
						};
						tt.target = new Autodesk.Viewing.Private.GuiViewer3D(tt.tag[0], {
							extensions: ['BasicExtension']
						});
						tt.target.initialize();
						tt.target.load(doc.getViewablePath(tt.geometryItems[1]));						
					},
					function(errorCode,errorMsg) {
						//t.error(errorMsg);
						console.log('dwg.load error:',errorMsg);
					}
				);
			}
		};				
		Autodesk.Viewing.Initializer(this.dwg.options);	
	},
	
	// FILTERS
	gen_filters: function(){
		var filters = {};
		
		$('[data-f]').each(function(){
			var tag = $(this);
			var f = $(this).attr('data-f');
			filters[f] = {};
			tag.find('input[type=checkbox]').each(function(){
				filters[f][$(this).attr('data-id')] = $(this).prop('checked');
			});
			
			if (f=='models' && filters[f]['ret']) {
				delete filters[f]['ret'];
				filters.ret = 1;
			}
			
			var flag = 0;
			for (k in filters[f]) if(filters[f][k]) flag = 1;
			if (!flag) delete filters[f];
		});
		
		if (filters.groups) {
			filters._groups = filters.groups;
			var h = {};
			for (gid in filters.groups) if(filters.groups[gid]) {
				var g = this.get('group_sensors',gid) || {};
				for (sid in g) h[sid] = 1;
			}
			filters.groups = h;
		}
		
		return filters;
	},
	
	check: function(filters,item,type){
		if (!type) type='sensor';
		if (type=='sensor') {
			var model_id = this.get('AllowedModelType',item.allowed_model_type_id).sensor_model_id;
			if (filters.ret && !item.is_retranslator) return false;
			if (filters.states && !filters.states[item.state_id]) return false;
			if (filters.models && !filters.models[model_id]) return false;
			if (filters.sensors && !filters.sensors[item.id]) return false;
			if (filters.groups && !filters.groups[item.id]) return false;
		}
		if (type=='facility') {
			if (filters.facilities && !filters.facilities[item.id]) return false;
		}
		return true;
	},
	
	filter_sensors :function(){
	
		var t = this;
		
		$('[data-f=sensors] .item').show().removeClass('dis');
		
		var f = this.get('facilities',this.current_facility_id);
		if (!f) return;
		
		var filters = this.gen_filters();
		delete filters.sensors;
		
		f.sensors.map(function(el){ el.type='sensor'; return el; }).concat(
		f.facilities.map(function(el){ el.type='facility'; return el; })).forEach(function(el){
			if(!t.check(filters,el,el.type)) $('[data-f=sensors]').find('.item[data-id='+el.id+']').hide().addClass('dis');
		});
	},
	
	// TABLE
	
	prepare_data_for_table: function(values){
		
		if (!values || !values.length) return null;
		
		var t = this;
		
		var filters = this.gen_filters();
		
		values = values.map(function(el){
			el.sensor = t.get('sensors',el.sensor_id);
			if (!el.sensor) {
				console.log('throw',el);
			}
			return el;
		}).filter(function(el){
			return t.check(filters,el.sensor,'sensor');
		});
		
		if (!values.length) return null;
		
		this.table_values = {}; // хеш параметров ячейки по коориданатам - для дальнейшего быстрого обращения и сохранения ячеек
		this.braid_values = {}; // хеш координаты y ячеек кос для определения средних температур, braid_values -> sensor_id -> deep = y
		
		var has_braid;				 // есть ли в таблице косы				
		var MP = 1;					 // максимальное число параметров для одного датчика на одну дату
		
		//определям has_braid и MP
		values = values.map(function(el){
			if (el.params_length>MP) MP=el.params_length;
			if (el.type=='braid') has_braid = 1;
			return el;
		}) // сортируем по моделям
		.sort(function(a,b){
			var a_order = t.get('AllowedModelType', a.sensor.allowed_model_type_id).ordering;
			var b_order = t.get('AllowedModelType', b.sensor.allowed_model_type_id).ordering;
			if (a.sensor.id==b.sensor.id) {
				if (a.type>b.type) return -1;
				if (a.type<b.type) return 1;
			}
			return  a_order - b_order;
		});
		
		var inc_flag = 0;			 // флаг того что шапка для инкринометричских датчиков уже есть
		var temp_flag = 0;			 // флаг того что шапка для НЕинкринометричских датчиков уже есть
		var braid_flag = 0;			 // флаг того что шапка для кос уже есть
		
		// хеш шапок по моделям - чтобы перед каждой моделью вывелась шапочка с названием значений ^__^ (кроме ГДМ - она бяка >p)
		var hats = {};
		var render_funcs = { '0':function(ins,td){$(td).addClass('th');} } //хеш функций кастомного рендинга по рядам
		
		var merges = []; 		// масив объединений
		var rows = [[]];		// масив рядов с готовым пустым массивом дат/шапки
		
		// функи
		
		function add_item(v,el,j,y,item,arr) { 	// полученная искусственным путем функа добавляющая ячейку со все подноготной
			var n = MP/el.params_length;   //колво объединений
			var x = (has_braid?2:1)+n*j;   //x координата в таблице
			t.repeat(n,function(){ item.push(v); });
			merges.push({row: y, col: x, rowspan:1, colspan:n });
			t.table_values[y+'_'+x] = {
				y:						y,
				x:						x,
				sensor_id:				el.sensor.id,
				date_use:				arr[0][x],
				allowed_value_type_id:	el.type=='braid'?undefined:el.avts[j%el.params_length],
				braid_id:				el.type=='braid'?el.sensor.deeps[item[1]]:undefined,
				deep:					item[1]
			}
			if (el.type=='braid') {
				if (!t.braid_values[el.sensor.id]) t.braid_values[el.sensor.id] = {};
				t.braid_values[el.sensor.id][item[1]] = y;
			}
		}
		
		function add_head(type,arr,avts,amt_id) { 								// добавляет ряд с заголовками
			// TODO - уменьшить кол-во аргументов
			if (hats[amt_id] && amt_id!=4 && amt_id!=12) return;
			hats[amt_id] = 1;
			
			if (type=='inc') {
				var item = [];
				t.repeat(has_braid?2:1,function(){ item.push(t.get('AllowedModelType',amt_id).name) }); //первые два/одно пустое значение
				merges.push({row: arr.length, col: 0, rowspan:1, colspan:has_braid?2:1 });
				values[0].dates.forEach(function(){
					item.push(t.get('AllowedValueType',avts[0]).name);
					item.push(t.get('AllowedValueType',avts[1]).name);
				});
				render_funcs[arr.length] = function(ins,td){ $(td).addClass('custheader'); }
			} else {
				var item = [];
				var amt = t.get('AllowedModelType',amt_id);
				console.log('GD!',amt);
				var braid_name = (amt.braid_measurer_code=='height' ? 'Высота, ':'Температура, ') + amt.braid_measurer_name;
				t.repeat(has_braid?2:1,function(){ item.push(amt.name) });
				merges.push({row:arr.length,col:0,rowspan:1,colspan:has_braid?2:1});
				values[0].dates.forEach(function(el,l){
					var measurer = type=='braid'? braid_name :  t.get('AllowedValueType',avts[0]).name;
					t.repeat(MP,function(){ item.push(measurer); });
					merges.push({row: arr.length, col: (has_braid?2:1)+MP*l, rowspan:1, colspan:MP });
				});
				render_funcs[arr.length] = function(ins,td){ $(td).addClass('custheader'); }
			}
			arr.push(item);
		}
		
		// ПОГНАЛИ
		
		// кастуем шапицу
		t.repeat(has_braid?2:1,function(){ rows[0].push('Элемент') }); //первые два/одно пустое значение
		merges.push({row: 0, col: 0, rowspan:1, colspan:has_braid?2:1 });
		
		//берем даты из данных первогог датчика (там всегда есть массив дат и он одинаков для всех)
		values[0].dates.forEach(function(el,i){
			t.repeat(MP,function(){ rows[0].push(el); });
			merges.push({row: 0, col: (has_braid?2:1)+MP*i, rowspan:1, colspan:MP });
		});
			
		// раскидываем значения по рядам
		// значения отсортированы по инклинометрическим и косам - поэтому шляпы добавляем только один раз
		for (var i=0;i<values.length;i++) {
			var el = values[i];
			
			if (el.type=='own') {
			
				if (el.params_length==1) add_head('temp',rows,el.avts,el.sensor.allowed_model_type_id); 
				if (el.params_length!=1) add_head('inc',rows,el.avts,el.sensor.allowed_model_type_id); 
				
				var item = [];
				t.repeat(has_braid?2:1,function(){ item.push(el.sensor.name) }); //первые два/одно пустое значение
				merges.push({row: rows.length, col: 0, rowspan:1, colspan:has_braid?2:1 });
				
				var y = rows.length;//y координата в таблице
				
				el.values.forEach(function(v,j){ add_item(v,el,j,y,item,rows); });
				rows.push(item);
			}
			if (el.type=='braid') {
				
				add_head('braid',rows,el.avts,el.sensor.allowed_model_type_id);
				
				merges.push({row: rows.length, col: 0, rowspan:el.values.length, colspan:1 });
				el.values.forEach(function(arr,j){
					var item = [];
					item.push(el.sensor.name);
					item.push(arr[0]);
					var y = rows.length;
					arr.forEach(function(v,k){ if(k) add_item(v,el,k-1,y,item,rows); });			
					rows.push(item);
				});
			}
		}
		
		return {
			rows:rows,
			merges:merges,
			render_funcs:render_funcs
		};
	},
	
	gen_table: function(data){
		var t = this;
		var cellProperties,cell_params;
		var table = new Handsontable(this.block('table')[0], {
			data: 		data.rows,
			height:		'auto',
			colHeaders: false,
			rowHeaders: false,
			stretchH: 	'all',
			mergeCells:	data.merges,
			className: "htRight",
			cells: function (row, col, prop) {
				cellProperties = {};
				if(data.render_funcs[row]) cellProperties.renderer = function(instance, td){
					Handsontable.renderers.TextRenderer.apply(this, arguments);
					data.render_funcs[row](instance, td);
				};
				cell_params = t.table_values[row+'_'+col];
				if(cell_params) {				
					cellProperties.type = 'numeric';
					cellProperties.format = '0.00'; // todo by accuracy
					
					var avt_id = cell_params.allowed_value_type_id;
					if (avt_id) {
						cellProperties.format = '0.'
						t.repeat(t.get('AllowedValueType',avt_id).accuracy,function(){ cellProperties.format+='0'; });
					}
					
					cellProperties.editor = 'text';
					cellProperties.renderer = function (instance, td, row, col, prop, value, cellProperties) {
						Handsontable.renderers.NumericRenderer.apply(this, arguments);
						t.check_value(cell_params,value,$(td));
					};
				} else cellProperties.editor = false;
				
				return cellProperties;
			},
			
			afterChange:function(cells){ if (t.save_data) t.save_data(cells); }
			
		});
		return table;
		
	},
	
	//normatives
	
	check_value:function(cell_data, value, tag){
		
		if (!this.table) return;
		
		var sensor = this.get('sensors',cell_data.sensor_id);
		
		if (cell_data.date_use == sensor.reference_date_rev) {
			tag.addClass('ref');
			return;
		}
		
		if (value==undefined) return;
		var facility = this.get('facilities',this.current_facility_id);
		
		if (!facility) return;
		
		// Для грунтовых реперов подвижка (высота 2-высота1=0мм) должна равняться 0мм. 
		if (cell_data.allowed_value_type_id == 1) {
			var prev_value = parseFloat(this.table.getDataAtCell(cell_data.y,cell_data.x-1));
			if (!prev_value) tag.addClass('undef');
			else if (prev_value!=value) tag.addClass('warning');
			return;	
		}
		
		// Уровень грунтовых вод должен быть ниже подошвы отсыпки.
		if (cell_data.allowed_value_type_id == 2) {  //for PS
			var norma = facility.dumping_depth;
			if (!norma) return;
			if (value>norma) tag.addClass('warning');
			return;	
		}
		
		// Для деформационных марок на сооружениях рассчитывается величина деформации Высота N - Высота реперный замер, и сравнивается с допустимой величиной деформации
		if (cell_data.allowed_value_type_id == 5 ||
			cell_data.allowed_value_type_id == 6 ||
			cell_data.allowed_value_type_id == 12) {
			var norma = facility.allowed_deformation;
			if (!norma) return;
			var ref_value = sensor.reference_value;
			if (!ref_value) tag.addClass('undef');
			if (Math.abs(value-ref_value) > norma) tag.addClass('warning');
			return;	
		}
				
		// done
		if (cell_data.braid_id) {
			var braids = this.braid_values[sensor.id];
			// Для оснований, построенных по II принципу, все датчики, лежащие ниже сезонно-мерзлого слоя должны показывать >0 С.
			if (facility.base_principle_id==2){ 
				for (deep in braids) if (this.table.getDataAtCell(braids[deep],cell_data.x)<0){ // сигнализируется вся коса
					tag.addClass('warning');
					return;	
				}
			}
			// среднее значение температуры на промежутке глубин от подошвы сезонно-талого/сезонно-мерзлого слоя до глубины заложения фундамента сравнивается с допустимой температурой. 
			var norma = facility.allowed_temperature;
			if (!norma) return;
			//var Ts = 0;
			//var counter = 0;
			//var coords;
			//
			//var flag = 0;
			//var foundation_depth = facility.foundation_depth || sensor.deep;
			//var frozen_depth = facility.frozen_depth || 0;
			//for (deep in braids) {
			//	if (deep<frozen_depth || deep>foundation_depth) continue;
			//	y = braids[deep];
			//	var temp = this.table.getDataAtCell(y,cell_data.x);
			//	Ts+=temp;
			//	counter++;
			//}
			//Ts/=counter;
			//if(Ts>norma) tag.addClass('warning');
			
			// каждый датчик
			console.log(value,norma,tag);
			if (value>norma) tag.addClass('warning');
			
			return;	
		}
	},
	
	// DATES
	pad: function(n){return n<10?'0'+n:n;},
	date_to_bd: function (date){ return date.getFullYear()+'-'+this.pad(date.getMonth()+1)+'-'+this.pad(date.getDate()); },
	date_to_js: function (date){ var arr = date.match(/(\d+).(\d+).(\d+)/);return new Date(arr[3],arr[2]-1,arr[1]); },
	
	//funcs
	repeat: function(n,func) { for (var l=0;l<n;l++) func(); },
	
}


// WIDGETS

var Popup = function(code,data,success){
	Popup.close();
	
	lnrr.popup = data || {};
	lnrr.type = code;
	
	var popup = $(GTM.view('main/Popup'));
	$('body').append(popup);
	
	Popup.render(code);
	if (success) success(popup);
}

Popup.render = function(code){
	
	var scroller = $('#popupscroller');
	if (!scroller.length) return;
	
	scroller.height('auto');
	
	var window = $('#window');
	
	if (['comments'].some(function(el){ return el==code; })) window.css('width','inherit');
	
	scroller.height('calc('+window.height()+'px - 2rem)');
	
	$('input,textarea',window).eq(0).focus();
	$('.to_focus',window).each(function(){ $('<input>').appendTo($(this)).focus().remove(); });
	
}

Popup.close = function(){
	$('#popup').remove();
}


var Context = {
	id:'context',
	init:function(){
		$('#'+this.cssclass).remove();
		this.target = $(GTM.view('main/Context'));
		$('body').append(this.target.attr('id',this.id));
		this.hide();
		this.init_action();
		return this;
	},
	init_action:function(){
		$('.item:not(.section)',this.target).on('click',function(e){
			e.stopPropagation();
		});	
	},
	hide:function(){
		if (this.target) this.target.hide();
	},
	show:function(e){
		this.target.show().css({
			'top':e.clientY+'px',
			'left':e.clientX+'px'
		});
	}
};

lnrr.exports_add([{
	_type:"controller",
	_config:{name:"GTM"},
	
	Field: function(data){ return GTM.view('main/Field',{field:data||{}}); }
	
	
}]);



