/**
 * Class: Facilities
 */

/**
 * Method: new
 */
function Facilities(facility_id, config){
	
	var data = JSON.parse(localStorage.getItem('data'));
	
	if (!facility_id) {
		this.facility = {};
		this.facilities = data.facilities;
	} else {
		this.facility = data.hash.facilities[facility_id];
		this.facilities = this.facility.facilities || [];	
	}
	
	this.facilities  = this.facilities.filter(function(el){ return !el.deleted; });
	console.log(this.facilities);
	
	
	config = config || {};
	config.title = facility_id ? this.facility.name : 'Выбор площадки';
	config.facility_id = facility_id;
	
	this.init(config);
}

Facilities.prototype = new Page();

/**
 * Method: my_name
 */
Facilities.prototype.my_name = function(){
	return 'Facilities';
}

/**
 * Method: before_open
 */
Facilities.prototype.before_open = function(){	
	lnrr.facility = this.facility;
	lnrr.facilities = this.facilities;
}

/**
 * Method: submit
 */
Facilities.prototype.submit = function(tag){
	
	var obj=LNMForms.get_object(tag);
	if (!obj) return;
	if (!obj.text) return this.error('Строка поиска пуста');
	
	var search_data = this.find(obj.text);
	
	pager.add_object(new Search(search_data));
	
}


/**
 * Method: find
 */
Facilities.prototype.find = function(text){
	
	var data = {
		text:text,
		facilities:[],
		sensors:[],
	};
	
	var regs = 	text
		.replace(/[\.\\-_]/g,' ')
		.replace(/\s+/g,' ')
		.replace(/^\s/g,'')
		.split(/\s/).map(function(el){ console.log('RegExp - ' + el); return new RegExp(el,'gi'); });
		
	var match = function(string){
		console.log('search in ' + string);
		return regs.some(function(reg){ return string.match(reg); });
	};
	
	var hash = JSON.parse(localStorage.getItem('data')).hash;
	['facilities','sensors'].forEach(function(k){
		for (id in hash[k]) {
			var item = 	hash[k][id];
			if (match(item.name)) data[k].push(item);
		}
	});
	
	lnrr.search_string = text; 
	
	return data;
	
	
}










