/**
 * Class: SaveComments
 */

/**
 * Method: new
 */
function SaveComments(){
	this.init({ title:'Сохранение комментариев/фото' });
}

SaveComments.prototype=new Page();

/**
 * Method: my_name
 */
SaveComments.prototype.my_name = function(){
	return 'SaveComments';
}

/**
 * Method: before_open
 */
SaveComments.prototype.before_open = function(){
	var comments = JSON.parse(window.localStorage.getItem('comments') || '0') || [];	
	comments = this.prepare_comments(comments);
	lnrr.comments = comments;
}

/**
 * Method: prepare_comments
 */
SaveComments.prototype.prepare_comments = function(arr){
	var data = JSON.parse(localStorage.getItem('data'));
	var arr2 = [];
	arr.forEach(function(el){
		var images = [];
		for (k in el.images) {
			images.push(k);
		}
		var item = data.hash[el.type][el.fid];
		arr2.push({
			info:'Комментарий к <span>' + item.name + '</span>',
			body:	el.body,
			images: images
		});	
	});
	return arr2;
}

/**
 * Method: send
 */
SaveComments.prototype.send = function(tag){
	
	var t = this;
	
	var params = {
		need_auth:	1,
		comments:		localStorage.getItem('comments')
	}
	
	this.request('save_comments', params, function(ret){
		t.clear_data();
		t.load_images(ret);
		setTimeout(function(){ pager.back(); },1500);
	});
}

/**
 * Method: clear_data
 */
SaveComments.prototype.clear_data = function(){
	localStorage.setItem("comments",'');
}

/**
 * Method: load_images
 */
SaveComments.prototype.load_images = function(comments){
	
	var t = this;
	
	var server = this.get_api_url('upload_comment_image');
	
	var images_to_send = [];
	var bad_images = [];
	
	console.log('So have comments: ',comments);
	
	comments.forEach(function(el){
		var images = el.images;
		for (image_path in images) {
			
			var options = {
				fileKey: 	 "file",
				fileName: 	 image_path.substr(image_path.lastIndexOf('/') + 1),
				mimeType: 	 "image/jpeg",
				chunkedMode: false,
				params: 	 t.fill_request_data({ need_auth:1, type:el.type, comment_id:el.id, image_path:image_path }),
				headers:	 { Connection: "close" }
			};
			
			images_to_send.push(options);
		}
	});
	
	console.log('Give all images from this comments: ',images_to_send.length);
	
	var load_next = function(){
		
		var img = images_to_send.shift();
		
		if (img && img._bad_load) {
			bad_images.push(img);
			load_next();
			return;
		}
		
		if (img) {
			console.log('Start to load img: ', img.fileName);		
			load_image(img);
			return;
		}
		
		console.log('All image loaded');			
		if(!bad_images.length) return;
		
		console.log('But...');		
		setTimeout(function(){
			
			images_to_send = bad_images.reduce(function(arr,el){
			
				console.log('have bad img: ', el.fileName);
				console.log('cause ', el._bad_load);
				
				// TODO parse error
				
				delete el._bad_load;
				
				arr.push(el);
				return arr;
			
			},[]);
			
			bad_images = [];
			
			console.log('...try to send bad images again', images_to_send.length);				
			load_next();
			
		},1500);			
		
	}
	
	var load_image = function(options){

		var ft = new FileTransfer();
		ft.upload(
			options.params.image_path,
			server,
			function(r){ load_success(r,options); },
			function(){ load_error(arguments,options); },
			options,
			false
		);

	};
	
	var load_success = function(r, img){
		
		console.log('loading done -> ' , arguments );
		
		try {
			r = JSON.parse(r.response);
			console.log('Image has loaded: ', img.fileName);
		} catch(e) {			
			console.log('No response for img: ', img.fileName);
			load_error(arguments,img);
			return;
		}
		
		if (r.image_path) {
			window.resolveLocalFileSystemURL(r.image_path, function (fileEntry) {
				fileEntry.remove(function(){
					console.log('R.I.P.: ',img.fileName);
					load_next();
				});
			}, function(e){
				console.log('Image try to live here forever: ',img.fileName);
				console.log('...who care?');
				load_next();
			});
			
		} else load_next();
		
	}
	
	var load_error = function(args, img){
		console.log('loading err -> ' , args, img );
		img._bad_load = args;		
		images_to_send.push(img);
		load_next();
	}
	
	load_next();	
}