var proc = require("process");

var default_check={
	email:		{ min:1, max:128, type:"email"},
	company:	{ min:4, max:128 },
	username:	{ min:8, max:128 },
	name:		{ min:4, max:32, regexp:/^[\w\-]+$/},
	phone:		{ type:'phone' }
};

exports.add=[{
	
	_type:"controller",
	_config:{
		name:"Demo",
	},
	
	save: function(config) {
		
		var errors=this.F("UserAuth","register_check",this.F("UserAuth","join_checks","check_register",config,default_check));
		if (errors) return JSON.stringify({errors:errors});
		
		var s = this.site.models.GTMSite.Get("get_by_name",{name:this.fields.name});
		if (s) return JSON.stringify({errors:{ name:this.LC("Name exists") }});		
			
		var s = this.site.models.GTMSite.Get("get_by_email",{ name:this.fields.email });
		if (s) return JSON.stringify({errors:{ email:this.LC("Email exists") }});
		
		var user = this.site.models.User.Get("get_of_login",{ login:this.fields.email.toLowerCase() });
		if (user) return JSON.stringify({errors:{ email:this.LC("Email exists") }});
		
		user = this.site.models.User.Create();
		user.login = user.email = this.fields.email.toLowerCase();
		user.calc_no_roles = 0;
		user.enabled = 1;
		user.password = this.F('UserAuth','mk_password',7);
		
		var name = this.fields.username.replace(/^\s+/,'').replace(/\s+/,' ').split(/\s/);
		
		user.first_name = name[1] || name[0];
		user.last_name = name[0];
		user.second_name = name[2];
		
		user.phone = this.fields.phone;
		
		user.SaveAll();
		
		var site = this.site.models.GTMSite.Create();
			site.name				= this.fields.name.toLowerCase();
			site.email				= this.fields.email.toLowerCase();
			site.free_days			= 10;
			site.payed_days			= 0;
			site.db					= this.fields.name.toLowerCase().replace(/-/g,"_");
//			site.erp_folder			= "vahvarh";
//			site.balance			= 0;
//			site.free_days			= 14;
//			site.discount_percent	= 0;
			site.enabled			= 1;
			site.initialized		= 0;
			site.company			= this.fields.company;
			site.username			= this.fields.username;
			site.user_id 			= user.id;
//			site.language			= 'ru';
			site.SaveAll();
			
		try {
			this.F('Builder','init',site);
		} catch(e) {
			
		}
			
		return JSON.stringify({ call:"form_ok", site_id:site.id, url:"http://"+site.name+".yamal.sgsystems.ru/" });
	},

	check: function() {
		var s = this.site.models.GTMSite.Get(this.fields.id);
		if (s.initialized) return JSON.stringify({ok:1});
		return JSON.stringify({});
	},
	
	build: function(){		
		return this.F('Builder','init_sites');
	}

},{
	
	_type:"functions",
	_section:"Demo",
	
	check: function(){
		var t = this;
		this.site.sql.execute_and_fetch('gtmsites/check').forEach(function(el){
			
			var site = t.M['GTMSite'].Get(el.id);			
			var user = t.site.models.User.Get(site.user_id);
			
			var mail = { site:site, user:user };
			
			t.F("Functions","send_mail","adminnotify", mail, 0);
			
		});	
	},
	
}];
