exports.config=[
	{
		"table": "tgtm_sites",
		"name": "GTMSite",
		"folder": "gtm_sites",
		"patches": {
			"columns": {
				"initialized": {
					"datatype": "boolean"
				},
				"user_text": {
					"datatype": "wysiwyg"
				}
			},
			"lists": [
				{
					"name": "list",
					"skip": {},
					"where": "",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count",
					"skip": {},
					"where": "",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "get_by_name",
					"where": "main.name=lower(:name)",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						"(main.date_cr + (interval '1 day')*(main.free_days+main.payed_days))::date as date_end",
						"(main.date_cr + (interval '1 day')*(main.free_days) >= now()) as _free",
						"main.date_cr::date as date_cr_rebuild"
					],
					"leftjoins": [
						""
					],
					"name": "get_by_email",
					"where": "main.email=lower(:email)",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_unitialized",
					"where": "main.initialized <> 1",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": "main.id"
				},
				{
					"name": "list_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"order_by": "main.id",
					"variant": "select",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": ""
				},
				{
					"name": "count_enabled",
					"skip": {},
					"where": "main.enabled=1",
					"variant": "count",
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"with": "",
					"start_with": "",
					"connect_by": "",
					"order_by": ""
				},
				{
					"skip": {},
					"add": [
						""
					],
					"leftjoins": [
						""
					],
					"name": "list_of_disabled_initialized",
					"where": "main.enabled = 0 and\nmain.initialized = 1",
					"with": "",
					"start_with": "",
					"connect_by": "",
					"variant": "select",
					"order_by": ""
				}
			],
			"extra_fields": [],
			"extra_fields_l10n": []
		},
		"columns": [
			{
				"name": "name",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "48"
			},
			{
				"name": "email",
				"not_null": 1,
				"datatype": "varchar",
				"maxsize": "256"
			},
			{
				"name": "date_cr",
				"not_null": 0,
				"skip_insupd": 1,
				"skip_edit": 1,
				"datatype": "timestamp"
			},
			{
				"name": "initialized",
				"not_null": 1,
				"default_value": "0",
				"datatype": "integer"
			},
			{
				"name": "company",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "username",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "128"
			},
			{
				"name": "user_password",
				"not_null": 0,
				"datatype": "varchar",
				"maxsize": "24"
			},
			{
				"name": "user_id",
				"not_null": 1,
				"datatype": "fk",
				"table": "Tusers",
				"fkid": "t__user"
			},
			{
				"name": "free_days",
				"not_null": 1,
				"default_value": "10",
				"datatype": "integer"
			},
			{
				"name": "payed_days",
				"not_null": 1,
				"default_value": "0",
				"datatype": "integer"
			},
			{
				"name": "enabled",
				"not_null": 0,
				"default_value": "0",
				"datatype": "boolean"
			},
			{
				"name": "user_text",
				"not_null": 0,
				"datatype": "text"
			}
		],
		"columns_l10n": [],
		"name_column": "main.name",
		"adminpanel": {
			"enabled": "1",
			"role": "settings",
			"section": "GTM",
			"label": "Заявки",
			"cols_through": "",
			"listname": "",
			"listhelperfunc": "",
			"edithelperfunc": "",
			"savehelperfunc": "",
			"prehelperfunc": "",
			"impexphelperfunc": "",
			"list_fk_column": ""
		}
	}
]