--
-- PostgreSQL database dump
--

-- Dumped from database version 9.5.0
-- Dumped by pg_dump version 9.5.0

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: pgcrypto; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS pgcrypto WITH SCHEMA public;


--
-- Name: EXTENSION pgcrypto; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION pgcrypto IS 'cryptographic functions';


--
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry, geography, and raster spatial types and functions';


SET search_path = public, pg_catalog;

--
-- Name: pcache_set(character varying, text); Type: FUNCTION; Schema: public; Owner: erp_gtm
--

CREATE FUNCTION pcache_set(lkey character varying, lvalue text) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare
    Lid bigint;
begin
    select max(id) into Lid from Tkvcache where key=Lkey;
    if Lid is not null then
        update Tkvcache set value=Lvalue where id=Lid;
    else
        insert into Tkvcache (key,value) values (Lkey,Lvalue);
    end if;
end;
$$;


ALTER FUNCTION public.pcache_set(lkey character varying, lvalue text) OWNER TO erp_gtm;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: tadmin_start_widgets; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tadmin_start_widgets (
    id bigint NOT NULL,
    controller_name character varying(64) NOT NULL,
    controller_mode character varying(64) NOT NULL,
    fullscreen integer DEFAULT 0 NOT NULL,
    ordering bigint NOT NULL
);


ALTER TABLE tadmin_start_widgets OWNER TO erp_gtm;

--
-- Name: tadmin_start_widgets_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tadmin_start_widgets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tadmin_start_widgets_id_seq OWNER TO erp_gtm;

--
-- Name: tadmin_start_widgets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tadmin_start_widgets_id_seq OWNED BY tadmin_start_widgets.id;


--
-- Name: tadmin_start_widgets_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tadmin_start_widgets_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tadmin_start_widgets_ordering_seq OWNER TO erp_gtm;

--
-- Name: tadmin_start_widgets_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tadmin_start_widgets_ordering_seq OWNED BY tadmin_start_widgets.ordering;


--
-- Name: tallowed_model_types; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tallowed_model_types (
    id bigint NOT NULL,
    sensor_model_id integer,
    sensor_model_type_id integer,
    code character varying(1024),
    has_braid integer,
    has_own_values integer,
    ordering integer,
    can_be_retranslator integer,
    name character varying(1024)
);


ALTER TABLE tallowed_model_types OWNER TO erp_gtm;

--
-- Name: tallowed_model_types_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tallowed_model_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tallowed_model_types_id_seq OWNER TO erp_gtm;

--
-- Name: tallowed_model_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tallowed_model_types_id_seq OWNED BY tallowed_model_types.id;


--
-- Name: tallowed_value_types; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tallowed_value_types (
    id bigint NOT NULL,
    measure_id integer,
    allowed_model_type_id integer,
    code character varying(64),
    accuracy integer,
    name character varying(1024)
);


ALTER TABLE tallowed_value_types OWNER TO erp_gtm;

--
-- Name: tallowed_value_types_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tallowed_value_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tallowed_value_types_id_seq OWNER TO erp_gtm;

--
-- Name: tallowed_value_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tallowed_value_types_id_seq OWNED BY tallowed_value_types.id;


--
-- Name: tanon_cookies; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tanon_cookies (
    id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_agent_id bigint NOT NULL,
    sid character varying(256) NOT NULL,
    ip inet NOT NULL
);


ALTER TABLE tanon_cookies OWNER TO erp_gtm;

--
-- Name: tanon_cookies_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tanon_cookies_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tanon_cookies_id_seq OWNER TO erp_gtm;

--
-- Name: tanon_cookies_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tanon_cookies_id_seq OWNED BY tanon_cookies.id;


--
-- Name: tarticle_categories; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tarticle_categories (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    groupcode character varying(32),
    has_abstract integer NOT NULL,
    has_image1 integer NOT NULL,
    has_image2 integer NOT NULL,
    has_gallery integer NOT NULL,
    image1_id bigint,
    image2_id bigint
);


ALTER TABLE tarticle_categories OWNER TO erp_gtm;

--
-- Name: tarticle_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tarticle_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tarticle_categories_id_seq OWNER TO erp_gtm;

--
-- Name: tarticle_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tarticle_categories_id_seq OWNED BY tarticle_categories.id;


--
-- Name: tarticle_categories_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tarticle_categories_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(64) NOT NULL,
    abstract text,
    body text
);


ALTER TABLE tarticle_categories_l10n OWNER TO erp_gtm;

--
-- Name: tarticle_categories_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tarticle_categories_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tarticle_categories_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tarticle_categories_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tarticle_categories_l10n_id_seq OWNED BY tarticle_categories_l10n.id;


--
-- Name: tarticles; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tarticles (
    id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    date_use date,
    date_show_start date,
    date_show_end date,
    category_id bigint NOT NULL,
    calc_code character varying(256) NOT NULL,
    image1_id bigint,
    image2_id bigint,
    image3_id bigint,
    folder_id bigint,
    enabled integer NOT NULL,
    featured integer DEFAULT 0 NOT NULL,
    user_cr_id bigint
);


ALTER TABLE tarticles OWNER TO erp_gtm;

--
-- Name: tarticles_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tarticles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tarticles_id_seq OWNER TO erp_gtm;

--
-- Name: tarticles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tarticles_id_seq OWNED BY tarticles.id;


--
-- Name: tarticles_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tarticles_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(4000) NOT NULL,
    abstract text,
    body text,
    disabled_l10n integer DEFAULT 0 NOT NULL,
    title character varying(4000),
    meta_abstract character varying(4000),
    meta_description character varying(4000)
);


ALTER TABLE tarticles_l10n OWNER TO erp_gtm;

--
-- Name: tarticles_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tarticles_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tarticles_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tarticles_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tarticles_l10n_id_seq OWNED BY tarticles_l10n.id;


--
-- Name: tbase_padding_principles; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tbase_padding_principles (
    id bigint NOT NULL,
    name character varying(1024)
);


ALTER TABLE tbase_padding_principles OWNER TO erp_gtm;

--
-- Name: tbase_padding_principles_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tbase_padding_principles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tbase_padding_principles_id_seq OWNER TO erp_gtm;

--
-- Name: tbase_padding_principles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tbase_padding_principles_id_seq OWNED BY tbase_padding_principles.id;


--
-- Name: tbraids; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tbraids (
    id bigint NOT NULL,
    sensor_id integer,
    deep numeric(10,1),
    enabled integer
);


ALTER TABLE tbraids OWNER TO erp_gtm;

--
-- Name: tbraids_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tbraids_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tbraids_id_seq OWNER TO erp_gtm;

--
-- Name: tbraids_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tbraids_id_seq OWNED BY tbraids.id;


--
-- Name: tcart_items; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcart_items (
    id bigint NOT NULL,
    cart_id bigint NOT NULL,
    market_item_id bigint,
    cnt integer DEFAULT 1 NOT NULL,
    other_ftype character varying(128),
    other_fid bigint,
    price numeric(30,2) NOT NULL,
    amount integer NOT NULL,
    CONSTRAINT tcart_items_item_or_fid CHECK (((market_item_id IS NULL) OR ((other_ftype IS NULL) AND (other_fid IS NULL))))
);


ALTER TABLE tcart_items OWNER TO erp_gtm;

--
-- Name: tcart_items_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcart_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcart_items_id_seq OWNER TO erp_gtm;

--
-- Name: tcart_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcart_items_id_seq OWNED BY tcart_items.id;


--
-- Name: tcart_payment_methods; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcart_payment_methods (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    func character varying(64),
    prepay integer NOT NULL,
    enabled integer NOT NULL
);


ALTER TABLE tcart_payment_methods OWNER TO erp_gtm;

--
-- Name: tcart_payment_methods_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcart_payment_methods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcart_payment_methods_id_seq OWNER TO erp_gtm;

--
-- Name: tcart_payment_methods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcart_payment_methods_id_seq OWNED BY tcart_payment_methods.id;


--
-- Name: tcart_payment_methods_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcart_payment_methods_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    body text
);


ALTER TABLE tcart_payment_methods_l10n OWNER TO erp_gtm;

--
-- Name: tcart_payment_methods_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcart_payment_methods_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcart_payment_methods_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tcart_payment_methods_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcart_payment_methods_l10n_id_seq OWNED BY tcart_payment_methods_l10n.id;


--
-- Name: tcart_states; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcart_states (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    cssclass character varying(32),
    do_calc_money integer NOT NULL
);


ALTER TABLE tcart_states OWNER TO erp_gtm;

--
-- Name: tcart_states_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcart_states_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcart_states_id_seq OWNER TO erp_gtm;

--
-- Name: tcart_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcart_states_id_seq OWNED BY tcart_states.id;


--
-- Name: tcart_states_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcart_states_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    body text
);


ALTER TABLE tcart_states_l10n OWNER TO erp_gtm;

--
-- Name: tcart_states_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcart_states_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcart_states_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tcart_states_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcart_states_l10n_id_seq OWNED BY tcart_states_l10n.id;


--
-- Name: tcarts; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcarts (
    id bigint NOT NULL,
    user_id bigint,
    sid character varying(128),
    state_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now(),
    date_mo timestamp without time zone DEFAULT now(),
    date_sent timestamp without time zone,
    date_state_change timestamp without time zone,
    payment_method_id bigint,
    manager_id bigint,
    calc_summ numeric(30,2) DEFAULT 0 NOT NULL,
    calc_items integer DEFAULT 0 NOT NULL,
    calc_amount integer DEFAULT 0 NOT NULL,
    address_postalindex character varying(16),
    address_city character varying(128),
    address_street character varying(128),
    address_phone character varying(64),
    address_comments character varying(4000),
    address_nearest character varying(128),
    address_flat character varying(128),
    address_porch character varying(128),
    address_floor character varying(128),
    address_password character varying(128),
    required_change character varying(128),
    real_payed numeric(30,2) DEFAULT 0 NOT NULL
);


ALTER TABLE tcarts OWNER TO erp_gtm;

--
-- Name: tcarts_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcarts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcarts_id_seq OWNER TO erp_gtm;

--
-- Name: tcarts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcarts_id_seq OWNED BY tcarts.id;


--
-- Name: tcells; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcells (
    id bigint NOT NULL,
    worksheet_id bigint NOT NULL,
    x integer NOT NULL,
    y integer NOT NULL,
    value text
);


ALTER TABLE tcells OWNER TO erp_gtm;

--
-- Name: tcells_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcells_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcells_id_seq OWNER TO erp_gtm;

--
-- Name: tcells_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcells_id_seq OWNED BY tcells.id;


--
-- Name: tcontent_boxes; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcontent_boxes (
    id bigint NOT NULL,
    group_id bigint NOT NULL,
    ordering bigint NOT NULL,
    image_id bigint,
    image2_id bigint,
    enabled integer NOT NULL
);


ALTER TABLE tcontent_boxes OWNER TO erp_gtm;

--
-- Name: tcontent_boxes_groups; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcontent_boxes_groups (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    name character varying(256) NOT NULL
);


ALTER TABLE tcontent_boxes_groups OWNER TO erp_gtm;

--
-- Name: tcontent_boxes_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcontent_boxes_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcontent_boxes_groups_id_seq OWNER TO erp_gtm;

--
-- Name: tcontent_boxes_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcontent_boxes_groups_id_seq OWNED BY tcontent_boxes_groups.id;


--
-- Name: tcontent_boxes_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcontent_boxes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcontent_boxes_id_seq OWNER TO erp_gtm;

--
-- Name: tcontent_boxes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcontent_boxes_id_seq OWNED BY tcontent_boxes.id;


--
-- Name: tcontent_boxes_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcontent_boxes_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    override_image_id bigint,
    name character varying(1024),
    name2 character varying(1024),
    name3 character varying(1024),
    url character varying(1024)
);


ALTER TABLE tcontent_boxes_l10n OWNER TO erp_gtm;

--
-- Name: tcontent_boxes_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcontent_boxes_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcontent_boxes_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tcontent_boxes_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcontent_boxes_l10n_id_seq OWNED BY tcontent_boxes_l10n.id;


--
-- Name: tcontent_boxes_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcontent_boxes_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcontent_boxes_ordering_seq OWNER TO erp_gtm;

--
-- Name: tcontent_boxes_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcontent_boxes_ordering_seq OWNED BY tcontent_boxes.ordering;


--
-- Name: tcustom_nav_items; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcustom_nav_items (
    id bigint NOT NULL,
    nav_id bigint,
    parent_id bigint,
    image_id bigint,
    href character varying(256),
    page_id bigint,
    enabled integer DEFAULT 1 NOT NULL,
    ordering bigint NOT NULL
);


ALTER TABLE tcustom_nav_items OWNER TO erp_gtm;

--
-- Name: tcustom_nav_items_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcustom_nav_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcustom_nav_items_id_seq OWNER TO erp_gtm;

--
-- Name: tcustom_nav_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcustom_nav_items_id_seq OWNED BY tcustom_nav_items.id;


--
-- Name: tcustom_nav_items_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcustom_nav_items_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128),
    description text
);


ALTER TABLE tcustom_nav_items_l10n OWNER TO erp_gtm;

--
-- Name: tcustom_nav_items_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcustom_nav_items_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcustom_nav_items_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tcustom_nav_items_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcustom_nav_items_l10n_id_seq OWNED BY tcustom_nav_items_l10n.id;


--
-- Name: tcustom_nav_items_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcustom_nav_items_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcustom_nav_items_ordering_seq OWNER TO erp_gtm;

--
-- Name: tcustom_nav_items_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcustom_nav_items_ordering_seq OWNED BY tcustom_nav_items.ordering;


--
-- Name: tcustom_navs; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tcustom_navs (
    id bigint NOT NULL,
    code character varying(128) NOT NULL,
    name character varying(128) NOT NULL,
    can_href integer NOT NULL,
    can_image integer NOT NULL,
    can_description integer NOT NULL
);


ALTER TABLE tcustom_navs OWNER TO erp_gtm;

--
-- Name: tcustom_navs_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tcustom_navs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tcustom_navs_id_seq OWNER TO erp_gtm;

--
-- Name: tcustom_navs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tcustom_navs_id_seq OWNED BY tcustom_navs.id;


--
-- Name: tdb_version; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tdb_version (
    version integer NOT NULL
);


ALTER TABLE tdb_version OWNER TO erp_gtm;

--
-- Name: tdebug_requests; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tdebug_requests (
    id bigint NOT NULL,
    login character varying(128),
    password character varying(128),
    url character varying(128),
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    params text,
    user_id bigint,
    user_agent_id bigint,
    error text,
    version character varying(32),
    charge double precision
);


ALTER TABLE tdebug_requests OWNER TO erp_gtm;

--
-- Name: tdebug_requests_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tdebug_requests_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tdebug_requests_id_seq OWNER TO erp_gtm;

--
-- Name: tdebug_requests_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tdebug_requests_id_seq OWNED BY tdebug_requests.id;


--
-- Name: tedit_histories; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tedit_histories (
    id integer NOT NULL,
    model_name name,
    text text,
    data text,
    facility_id integer,
    date_cr timestamp without time zone DEFAULT now(),
    user_id integer,
    model_id integer
);


ALTER TABLE tedit_histories OWNER TO erp_gtm;

--
-- Name: tedit_histories_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tedit_histories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tedit_histories_id_seq OWNER TO erp_gtm;

--
-- Name: tedit_histories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tedit_histories_id_seq OWNED BY tedit_histories.id;


--
-- Name: texplications; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE texplications (
    id bigint NOT NULL,
    facility_id integer,
    field01 character varying(1024),
    field02 character varying(1024),
    field03 character varying(1024),
    field04 character varying(1024),
    field05 character varying(1024),
    field06 character varying(1024),
    field07 character varying(1024),
    field08 character varying(1024),
    field09 character varying(1024),
    field10 character varying(1024),
    field11 character varying(1024),
    field12 character varying(1024)
);


ALTER TABLE texplications OWNER TO erp_gtm;

--
-- Name: texplications_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE texplications_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE texplications_id_seq OWNER TO erp_gtm;

--
-- Name: texplications_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE texplications_id_seq OWNED BY texplications.id;


--
-- Name: tfacilities; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfacilities (
    id bigint NOT NULL,
    parent_id bigint,
    name character varying(256) NOT NULL,
    ordering bigint NOT NULL,
    image_id bigint,
    code character varying(128),
    address character varying(1280),
    load_capacity numeric(30,4),
    protection character varying(128),
    base_type character varying(128),
    base_construction character varying(128),
    base_principle_id integer,
    location_x numeric(30,4),
    location_y numeric(30,4),
    state_id integer,
    width integer,
    height integer,
    foundation_depth numeric(20,1),
    frozen_depth numeric(20,1),
    clipmap character varying(2048),
    dumping_depth numeric(20,2),
    plan_id integer,
    view_data text,
    table_x numeric(10,2) DEFAULT 1,
    table_y numeric(10,2),
    element_size numeric(10,2) DEFAULT 1.00,
    table_size numeric(10,2),
    deleted integer,
    date_cr date DEFAULT now(),
    allowed_temperature numeric(30,2),
    allowed_deformation numeric(30,2),
    show_explication integer DEFAULT 0,
    show_convention integer DEFAULT 0,
    convention_x integer DEFAULT 0,
    convention_y integer DEFAULT 0,
    type character varying(1024),
    stamp_data text
);


ALTER TABLE tfacilities OWNER TO erp_gtm;

--
-- Name: tfacilities_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfacilities_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacilities_id_seq OWNER TO erp_gtm;

--
-- Name: tfacilities_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfacilities_id_seq OWNED BY tfacilities.id;


--
-- Name: tfacilities_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfacilities_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacilities_ordering_seq OWNER TO erp_gtm;

--
-- Name: tfacilities_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfacilities_ordering_seq OWNED BY tfacilities.ordering;


--
-- Name: tfacility_comment_images; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfacility_comment_images (
    id bigint NOT NULL,
    comment_id integer,
    image_id integer
);


ALTER TABLE tfacility_comment_images OWNER TO erp_gtm;

--
-- Name: tfacility_comment_images_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfacility_comment_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_comment_images_id_seq OWNER TO erp_gtm;

--
-- Name: tfacility_comment_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfacility_comment_images_id_seq OWNED BY tfacility_comment_images.id;


--
-- Name: tfacility_comments; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfacility_comments (
    id bigint NOT NULL,
    facility_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_cr_id bigint NOT NULL,
    body text,
    images_json text
);


ALTER TABLE tfacility_comments OWNER TO erp_gtm;

--
-- Name: tfacility_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfacility_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_comments_id_seq OWNER TO erp_gtm;

--
-- Name: tfacility_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfacility_comments_id_seq OWNED BY tfacility_comments.id;


--
-- Name: tfacility_groups; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfacility_groups (
    id bigint NOT NULL,
    facility_id integer,
    name character varying(1024)
);


ALTER TABLE tfacility_groups OWNER TO erp_gtm;

--
-- Name: tfacility_photos; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfacility_photos (
    id bigint NOT NULL,
    facility_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_cr_id bigint NOT NULL,
    image_id bigint NOT NULL,
    body text
);


ALTER TABLE tfacility_photos OWNER TO erp_gtm;

--
-- Name: tfacility_photos_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfacility_photos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_photos_id_seq OWNER TO erp_gtm;

--
-- Name: tfacility_photos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfacility_photos_id_seq OWNED BY tfacility_photos.id;


--
-- Name: tfacility_plans; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfacility_plans (
    id bigint NOT NULL,
    facility_id integer,
    urn character varying(1024),
    status_code character varying(64),
    dwg_id integer,
    objectid character varying(1024),
    error text
);


ALTER TABLE tfacility_plans OWNER TO erp_gtm;

--
-- Name: tfacility_plans_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfacility_plans_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_plans_id_seq OWNER TO erp_gtm;

--
-- Name: tfacility_plans_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfacility_plans_id_seq OWNED BY tfacility_plans.id;


--
-- Name: tfacility_states; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfacility_states (
    id bigint NOT NULL,
    name character varying(1024)
);


ALTER TABLE tfacility_states OWNER TO erp_gtm;

--
-- Name: tfacility_states_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfacility_states_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_states_id_seq OWNER TO erp_gtm;

--
-- Name: tfacility_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfacility_states_id_seq OWNED BY tfacility_states.id;


--
-- Name: tfacility_stats; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfacility_stats (
    id bigint NOT NULL,
    facility_id integer,
    date date,
    data text
);


ALTER TABLE tfacility_stats OWNER TO erp_gtm;

--
-- Name: tfacility_stats_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfacility_stats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_stats_id_seq OWNER TO erp_gtm;

--
-- Name: tfacility_stats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfacility_stats_id_seq OWNED BY tfacility_stats.id;


--
-- Name: tfacility_types; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfacility_types (
    id bigint NOT NULL,
    name character varying(1024)
);


ALTER TABLE tfacility_types OWNER TO erp_gtm;

--
-- Name: tfacility_types_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfacility_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfacility_types_id_seq OWNER TO erp_gtm;

--
-- Name: tfacility_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfacility_types_id_seq OWNED BY tfacility_types.id;


--
-- Name: tfile_folders; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfile_folders (
    id bigint NOT NULL,
    code character varying(64),
    parent_id bigint,
    user_cr_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    date_mo timestamp without time zone DEFAULT now() NOT NULL,
    ordering bigint NOT NULL
);


ALTER TABLE tfile_folders OWNER TO erp_gtm;

--
-- Name: tfile_folders_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfile_folders_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfile_folders_id_seq OWNER TO erp_gtm;

--
-- Name: tfile_folders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfile_folders_id_seq OWNED BY tfile_folders.id;


--
-- Name: tfile_folders_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfile_folders_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE tfile_folders_l10n OWNER TO erp_gtm;

--
-- Name: tfile_folders_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfile_folders_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfile_folders_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tfile_folders_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfile_folders_l10n_id_seq OWNED BY tfile_folders_l10n.id;


--
-- Name: tfile_folders_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfile_folders_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfile_folders_ordering_seq OWNER TO erp_gtm;

--
-- Name: tfile_folders_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfile_folders_ordering_seq OWNED BY tfile_folders.ordering;


--
-- Name: tfile_types; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfile_types (
    id bigint NOT NULL,
    code character varying(16) NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE tfile_types OWNER TO erp_gtm;

--
-- Name: tfile_types_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfile_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfile_types_id_seq OWNER TO erp_gtm;

--
-- Name: tfile_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfile_types_id_seq OWNED BY tfile_types.id;


--
-- Name: tfiles; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfiles (
    id bigint NOT NULL,
    type_id bigint NOT NULL,
    file_folder_id bigint NOT NULL,
    user_cr_id bigint,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    date_mo timestamp without time zone DEFAULT now() NOT NULL,
    orig_filename character varying(256) NOT NULL,
    ext character varying(16),
    width integer,
    height integer,
    filesize integer,
    seconds integer,
    ordering bigint NOT NULL
);


ALTER TABLE tfiles OWNER TO erp_gtm;

--
-- Name: tfiles_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfiles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfiles_id_seq OWNER TO erp_gtm;

--
-- Name: tfiles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfiles_id_seq OWNED BY tfiles.id;


--
-- Name: tfiles_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tfiles_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE tfiles_l10n OWNER TO erp_gtm;

--
-- Name: tfiles_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfiles_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfiles_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tfiles_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfiles_l10n_id_seq OWNED BY tfiles_l10n.id;


--
-- Name: tfiles_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfiles_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfiles_ordering_seq OWNER TO erp_gtm;

--
-- Name: tfiles_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfiles_ordering_seq OWNED BY tfiles.ordering;


--
-- Name: tmeasurement_periods; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmeasurement_periods (
    id bigint NOT NULL,
    facility_id integer,
    sensor_model_id integer,
    value integer
);


ALTER TABLE tmeasurement_periods OWNER TO erp_gtm;

--
-- Name: tfmeasurement_periods_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tfmeasurement_periods_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tfmeasurement_periods_id_seq OWNER TO erp_gtm;

--
-- Name: tfmeasurement_periods_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tfmeasurement_periods_id_seq OWNED BY tmeasurement_periods.id;


--
-- Name: tforms; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tforms (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    name character varying(128) NOT NULL,
    fields_not_null text,
    func_error character varying(128),
    func_ok character varying(1024),
    mail_template1_id bigint,
    mail_template2_id bigint
);


ALTER TABLE tforms OWNER TO erp_gtm;

--
-- Name: tforms_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tforms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tforms_id_seq OWNER TO erp_gtm;

--
-- Name: tforms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tforms_id_seq OWNED BY tforms.id;


--
-- Name: tguestbook_messages; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tguestbook_messages (
    id bigint NOT NULL,
    guestbook_id bigint NOT NULL,
    user_q_name character varying(128) NOT NULL,
    user_q_phone character varying(128),
    user_q_email character varying(128),
    user_q_avatar_id bigint,
    user_a_id bigint,
    question text,
    answer text,
    date_question timestamp without time zone DEFAULT now(),
    date_answer timestamp without time zone,
    moderated integer NOT NULL
);


ALTER TABLE tguestbook_messages OWNER TO erp_gtm;

--
-- Name: tguestbook_messages_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tguestbook_messages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tguestbook_messages_id_seq OWNER TO erp_gtm;

--
-- Name: tguestbook_messages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tguestbook_messages_id_seq OWNED BY tguestbook_messages.id;


--
-- Name: tguestbooks; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tguestbooks (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    name character varying(256) NOT NULL,
    premoderated integer NOT NULL,
    users_can_post integer NOT NULL,
    mail_code character varying(128)
);


ALTER TABLE tguestbooks OWNER TO erp_gtm;

--
-- Name: tguestbooks_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tguestbooks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tguestbooks_id_seq OWNER TO erp_gtm;

--
-- Name: tguestbooks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tguestbooks_id_seq OWNED BY tguestbooks.id;


--
-- Name: tkvcache; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tkvcache (
    id bigint NOT NULL,
    key character varying(4000) NOT NULL,
    value text
);


ALTER TABLE tkvcache OWNER TO erp_gtm;

--
-- Name: tkvcache_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tkvcache_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tkvcache_id_seq OWNER TO erp_gtm;

--
-- Name: tkvcache_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tkvcache_id_seq OWNED BY tkvcache.id;


--
-- Name: tl10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tl10n (
    id bigint NOT NULL,
    code character varying(16) NOT NULL,
    name character varying(160) NOT NULL,
    is_default integer NOT NULL
);


ALTER TABLE tl10n OWNER TO erp_gtm;

--
-- Name: tl10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tl10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tl10n_id_seq OWNER TO erp_gtm;

--
-- Name: tl10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tl10n_id_seq OWNED BY tl10n.id;


--
-- Name: tlogin_attempts; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tlogin_attempts (
    id bigint NOT NULL,
    login character varying(256),
    password character varying(256),
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_ip character varying(32),
    user_agent_id bigint NOT NULL,
    url character varying(1000),
    ok integer NOT NULL
);


ALTER TABLE tlogin_attempts OWNER TO erp_gtm;

--
-- Name: tlogin_attempts_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tlogin_attempts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tlogin_attempts_id_seq OWNER TO erp_gtm;

--
-- Name: tlogin_attempts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tlogin_attempts_id_seq OWNED BY tlogin_attempts.id;


--
-- Name: tmail_templates; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmail_templates (
    id bigint NOT NULL,
    code character varying(256) NOT NULL,
    name character varying(256),
    default_from character varying(256),
    default_to character varying(256),
    signature character varying(128)
);


ALTER TABLE tmail_templates OWNER TO erp_gtm;

--
-- Name: tmail_templates_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmail_templates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmail_templates_id_seq OWNER TO erp_gtm;

--
-- Name: tmail_templates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmail_templates_id_seq OWNED BY tmail_templates.id;


--
-- Name: tmail_templates_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmail_templates_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    subject character varying(1024),
    body text
);


ALTER TABLE tmail_templates_l10n OWNER TO erp_gtm;

--
-- Name: tmail_templates_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmail_templates_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmail_templates_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tmail_templates_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmail_templates_l10n_id_seq OWNED BY tmail_templates_l10n.id;


--
-- Name: tmarket_categories; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_categories (
    id bigint NOT NULL,
    code character varying(128) NOT NULL,
    parent_id bigint,
    image1_id bigint,
    image2_id bigint,
    enabled integer NOT NULL,
    ordering bigint NOT NULL,
    fid character varying(32),
    is_featured integer DEFAULT 0 NOT NULL,
    is_new integer DEFAULT 0 NOT NULL,
    is_recomended integer DEFAULT 0 NOT NULL,
    has_abstract integer DEFAULT 0 NOT NULL,
    has_body2 integer DEFAULT 0 NOT NULL
);


ALTER TABLE tmarket_categories OWNER TO erp_gtm;

--
-- Name: tmarket_categories_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_categories_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_categories_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_categories_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_categories_id_seq OWNED BY tmarket_categories.id;


--
-- Name: tmarket_categories_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_categories_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    abstract text,
    body text,
    body2 text,
    title character varying(4000),
    meta_abstract character varying(4000),
    meta_description character varying(4000)
);


ALTER TABLE tmarket_categories_l10n OWNER TO erp_gtm;

--
-- Name: tmarket_categories_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_categories_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_categories_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_categories_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_categories_l10n_id_seq OWNED BY tmarket_categories_l10n.id;


--
-- Name: tmarket_categories_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_categories_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_categories_ordering_seq OWNER TO erp_gtm;

--
-- Name: tmarket_categories_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_categories_ordering_seq OWNED BY tmarket_categories.ordering;


--
-- Name: tmarket_field_datatypes; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_field_datatypes (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    view_code character varying(32),
    name character varying(128) NOT NULL,
    prefix character varying(32),
    crsql character varying(128),
    has_l10n integer NOT NULL,
    has_enum integer NOT NULL
);


ALTER TABLE tmarket_field_datatypes OWNER TO erp_gtm;

--
-- Name: tmarket_field_datatypes_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_field_datatypes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_datatypes_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_field_datatypes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_field_datatypes_id_seq OWNED BY tmarket_field_datatypes.id;


--
-- Name: tmarket_field_enums; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_field_enums (
    id bigint NOT NULL,
    field_id bigint NOT NULL,
    value character varying(2000)
);


ALTER TABLE tmarket_field_enums OWNER TO erp_gtm;

--
-- Name: tmarket_field_enums_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_field_enums_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_enums_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_field_enums_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_field_enums_id_seq OWNED BY tmarket_field_enums.id;


--
-- Name: tmarket_field_enumsl; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_field_enumsl (
    id bigint NOT NULL,
    field_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    value character varying(2000)
);


ALTER TABLE tmarket_field_enumsl OWNER TO erp_gtm;

--
-- Name: tmarket_field_enumsl_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_field_enumsl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_enumsl_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_field_enumsl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_field_enumsl_id_seq OWNED BY tmarket_field_enumsl.id;


--
-- Name: tmarket_field_groups; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_field_groups (
    id bigint NOT NULL,
    ordering bigint NOT NULL,
    enabled integer NOT NULL,
    category_id bigint
);


ALTER TABLE tmarket_field_groups OWNER TO erp_gtm;

--
-- Name: tmarket_field_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_field_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_groups_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_field_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_field_groups_id_seq OWNED BY tmarket_field_groups.id;


--
-- Name: tmarket_field_groups_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_field_groups_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256)
);


ALTER TABLE tmarket_field_groups_l10n OWNER TO erp_gtm;

--
-- Name: tmarket_field_groups_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_field_groups_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_groups_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_field_groups_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_field_groups_l10n_id_seq OWNED BY tmarket_field_groups_l10n.id;


--
-- Name: tmarket_field_groups_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_field_groups_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_field_groups_ordering_seq OWNER TO erp_gtm;

--
-- Name: tmarket_field_groups_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_field_groups_ordering_seq OWNED BY tmarket_field_groups.ordering;


--
-- Name: tmarket_fields; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_fields (
    id bigint NOT NULL,
    group_id bigint NOT NULL,
    datatype_id bigint NOT NULL,
    view_level_id bigint NOT NULL,
    search_level_id bigint NOT NULL,
    enabled integer NOT NULL,
    ordering bigint NOT NULL,
    cid bigint,
    fid character varying(128)
);


ALTER TABLE tmarket_fields OWNER TO erp_gtm;

--
-- Name: tmarket_fields_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_fields_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_fields_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_fields_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_fields_id_seq OWNED BY tmarket_fields.id;


--
-- Name: tmarket_fields_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_fields_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256)
);


ALTER TABLE tmarket_fields_l10n OWNER TO erp_gtm;

--
-- Name: tmarket_fields_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_fields_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_fields_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_fields_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_fields_l10n_id_seq OWNED BY tmarket_fields_l10n.id;


--
-- Name: tmarket_fields_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_fields_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_fields_ordering_seq OWNER TO erp_gtm;

--
-- Name: tmarket_fields_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_fields_ordering_seq OWNED BY tmarket_fields.ordering;


--
-- Name: tmarket_item_fields_enums; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_item_fields_enums (
    id bigint NOT NULL,
    item_id bigint NOT NULL,
    field_id bigint NOT NULL,
    enum_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_enums OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_enums_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_enums_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_enums_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_enums_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_enums_id_seq OWNED BY tmarket_item_fields_enums.id;


--
-- Name: tmarket_item_fields_enumsl; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_item_fields_enumsl (
    id bigint NOT NULL,
    item_id bigint NOT NULL,
    field_id bigint NOT NULL,
    enum_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_enumsl OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_enumsl_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_enumsl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_enumsl_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_enumsl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_enumsl_id_seq OWNED BY tmarket_item_fields_enumsl.id;


--
-- Name: tmarket_item_fields_f; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_item_fields_f (
    id bigint NOT NULL,
    item_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_f OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_f_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_f_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_f_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_f_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_f_id_seq OWNED BY tmarket_item_fields_f.id;


--
-- Name: tmarket_item_fields_i; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_item_fields_i (
    id bigint NOT NULL,
    item_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_i OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_i_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_i_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_i_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_i_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_i_id_seq OWNED BY tmarket_item_fields_i.id;


--
-- Name: tmarket_item_fields_il; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_item_fields_il (
    id bigint NOT NULL,
    item_id bigint NOT NULL,
    fid_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_il OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_il_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_il_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_il_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_il_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_il_id_seq OWNED BY tmarket_item_fields_il.id;


--
-- Name: tmarket_item_fields_s; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_item_fields_s (
    id bigint NOT NULL,
    item_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_s OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_s_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_s_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_s_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_s_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_s_id_seq OWNED BY tmarket_item_fields_s.id;


--
-- Name: tmarket_item_fields_sl; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_item_fields_sl (
    id bigint NOT NULL,
    item_id bigint NOT NULL,
    fid_id bigint NOT NULL
);


ALTER TABLE tmarket_item_fields_sl OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_sl_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_item_fields_sl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_fields_sl_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_item_fields_sl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_item_fields_sl_id_seq OWNED BY tmarket_item_fields_sl.id;


--
-- Name: tmarket_item_groups; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_item_groups (
    id bigint NOT NULL,
    enabled integer NOT NULL,
    ordering bigint NOT NULL
);


ALTER TABLE tmarket_item_groups OWNER TO erp_gtm;

--
-- Name: tmarket_item_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_item_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_groups_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_item_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_item_groups_id_seq OWNED BY tmarket_item_groups.id;


--
-- Name: tmarket_item_groups_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_item_groups_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128)
);


ALTER TABLE tmarket_item_groups_l10n OWNER TO erp_gtm;

--
-- Name: tmarket_item_groups_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_item_groups_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_groups_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_item_groups_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_item_groups_l10n_id_seq OWNED BY tmarket_item_groups_l10n.id;


--
-- Name: tmarket_item_groups_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_item_groups_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_item_groups_ordering_seq OWNER TO erp_gtm;

--
-- Name: tmarket_item_groups_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_item_groups_ordering_seq OWNED BY tmarket_item_groups.ordering;


--
-- Name: tmarket_items; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_items (
    id bigint NOT NULL,
    code character varying(256) NOT NULL,
    date_cr timestamp without time zone DEFAULT now(),
    image1_id bigint,
    image2_id bigint,
    group_id bigint,
    category_id bigint NOT NULL,
    manufacturer_id bigint NOT NULL,
    enabled integer NOT NULL,
    in_stock integer NOT NULL,
    price numeric(30,2),
    ordering bigint NOT NULL,
    is_featured integer DEFAULT 0 NOT NULL,
    is_new integer DEFAULT 0 NOT NULL,
    is_recomended integer DEFAULT 0 NOT NULL,
    fid character varying(32),
    fid2 character varying(32),
    file_folder_id bigint,
    old_price numeric(30,2),
    base_price numeric(30,2),
    discount_value character varying(32),
    in_stock_count integer
);


ALTER TABLE tmarket_items OWNER TO erp_gtm;

--
-- Name: tmarket_items_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_items_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_items_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_items_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_items_id_seq OWNED BY tmarket_items.id;


--
-- Name: tmarket_items_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_items_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    abstract text,
    body text,
    body2 text
);


ALTER TABLE tmarket_items_l10n OWNER TO erp_gtm;

--
-- Name: tmarket_items_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_items_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_items_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_items_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_items_l10n_id_seq OWNED BY tmarket_items_l10n.id;


--
-- Name: tmarket_items_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_items_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_items_ordering_seq OWNER TO erp_gtm;

--
-- Name: tmarket_items_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_items_ordering_seq OWNED BY tmarket_items.ordering;


--
-- Name: tmarket_manufacturers; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_manufacturers (
    id bigint NOT NULL,
    code character varying(128) NOT NULL,
    image1_id bigint,
    image2_id bigint,
    enabled integer NOT NULL,
    ordering bigint NOT NULL,
    fid character varying(32),
    is_featured integer DEFAULT 0 NOT NULL,
    is_new integer DEFAULT 0 NOT NULL,
    is_recomended integer DEFAULT 0 NOT NULL
);


ALTER TABLE tmarket_manufacturers OWNER TO erp_gtm;

--
-- Name: tmarket_manufacturers_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_manufacturers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_manufacturers_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_manufacturers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_manufacturers_id_seq OWNED BY tmarket_manufacturers.id;


--
-- Name: tmarket_manufacturers_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_manufacturers_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    abstract text,
    body text,
    body2 text,
    title character varying(4000),
    meta_abstract character varying(4000),
    meta_description character varying(4000)
);


ALTER TABLE tmarket_manufacturers_l10n OWNER TO erp_gtm;

--
-- Name: tmarket_manufacturers_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_manufacturers_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_manufacturers_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_manufacturers_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_manufacturers_l10n_id_seq OWNED BY tmarket_manufacturers_l10n.id;


--
-- Name: tmarket_manufacturers_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_manufacturers_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_manufacturers_ordering_seq OWNER TO erp_gtm;

--
-- Name: tmarket_manufacturers_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_manufacturers_ordering_seq OWNED BY tmarket_manufacturers.ordering;


--
-- Name: tmarket_search_levels; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_search_levels (
    id bigint NOT NULL,
    code character varying(32) NOT NULL
);


ALTER TABLE tmarket_search_levels OWNER TO erp_gtm;

--
-- Name: tmarket_search_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_search_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_search_levels_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_search_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_search_levels_id_seq OWNED BY tmarket_search_levels.id;


--
-- Name: tmarket_search_levels_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_search_levels_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256)
);


ALTER TABLE tmarket_search_levels_l10n OWNER TO erp_gtm;

--
-- Name: tmarket_search_levels_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_search_levels_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_search_levels_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_search_levels_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_search_levels_l10n_id_seq OWNED BY tmarket_search_levels_l10n.id;


--
-- Name: tmarket_view_levels; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_view_levels (
    id bigint NOT NULL,
    code character varying(32) NOT NULL
);


ALTER TABLE tmarket_view_levels OWNER TO erp_gtm;

--
-- Name: tmarket_view_levels_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_view_levels_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_view_levels_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_view_levels_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_view_levels_id_seq OWNED BY tmarket_view_levels.id;


--
-- Name: tmarket_view_levels_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmarket_view_levels_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256)
);


ALTER TABLE tmarket_view_levels_l10n OWNER TO erp_gtm;

--
-- Name: tmarket_view_levels_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmarket_view_levels_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmarket_view_levels_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tmarket_view_levels_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmarket_view_levels_l10n_id_seq OWNED BY tmarket_view_levels_l10n.id;


--
-- Name: tmeasurement_modes; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmeasurement_modes (
    id bigint NOT NULL,
    name character varying(1024)
);


ALTER TABLE tmeasurement_modes OWNER TO erp_gtm;

--
-- Name: tmeasurement_modes_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmeasurement_modes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmeasurement_modes_id_seq OWNER TO erp_gtm;

--
-- Name: tmeasurement_modes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmeasurement_modes_id_seq OWNED BY tmeasurement_modes.id;


--
-- Name: tmeasurer_value_types; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmeasurer_value_types (
    id bigint NOT NULL,
    code character varying(128) NOT NULL,
    name character varying(256) NOT NULL
);


ALTER TABLE tmeasurer_value_types OWNER TO erp_gtm;

--
-- Name: tmeasurer_value_types_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmeasurer_value_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmeasurer_value_types_id_seq OWNER TO erp_gtm;

--
-- Name: tmeasurer_value_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmeasurer_value_types_id_seq OWNED BY tmeasurer_value_types.id;


--
-- Name: tmediums; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tmediums (
    id bigint NOT NULL,
    code character varying(16) NOT NULL,
    ordering bigint NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE tmediums OWNER TO erp_gtm;

--
-- Name: tmediums_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmediums_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmediums_id_seq OWNER TO erp_gtm;

--
-- Name: tmediums_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmediums_id_seq OWNED BY tmediums.id;


--
-- Name: tmediums_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tmediums_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tmediums_ordering_seq OWNER TO erp_gtm;

--
-- Name: tmediums_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tmediums_ordering_seq OWNED BY tmediums.ordering;


--
-- Name: tnormative_types; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tnormative_types (
    id bigint NOT NULL,
    name character varying(1024)
);


ALTER TABLE tnormative_types OWNER TO erp_gtm;

--
-- Name: tnormatives; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tnormatives (
    id bigint NOT NULL,
    facility_id integer,
    type_id integer,
    value numeric
);


ALTER TABLE tnormatives OWNER TO erp_gtm;

--
-- Name: tnormatives_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tnormatives_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tnormatives_id_seq OWNER TO erp_gtm;

--
-- Name: tnormatives_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tnormatives_id_seq OWNED BY tnormative_types.id;


--
-- Name: tnormatives_id_seq1; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tnormatives_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tnormatives_id_seq1 OWNER TO erp_gtm;

--
-- Name: tnormatives_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tnormatives_id_seq1 OWNED BY tnormatives.id;


--
-- Name: tpage_blocks; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tpage_blocks (
    id bigint NOT NULL,
    page_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    place_id bigint NOT NULL,
    medium_id bigint NOT NULL,
    body text
);


ALTER TABLE tpage_blocks OWNER TO erp_gtm;

--
-- Name: tpage_blocks_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tpage_blocks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpage_blocks_id_seq OWNER TO erp_gtm;

--
-- Name: tpage_blocks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tpage_blocks_id_seq OWNED BY tpage_blocks.id;


--
-- Name: tpages; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tpages (
    id bigint NOT NULL,
    parent_id bigint,
    alias character varying(128) NOT NULL,
    template_id bigint NOT NULL,
    prerun character varying(2048),
    prerun_param character varying(2048),
    show_in_nav integer DEFAULT 1 NOT NULL,
    ordering bigint NOT NULL,
    role_id bigint,
    hide_anon integer DEFAULT 0 NOT NULL,
    hide_reg integer DEFAULT 0 NOT NULL,
    cssclass character varying(64)
);


ALTER TABLE tpages OWNER TO erp_gtm;

--
-- Name: tpages_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tpages_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpages_id_seq OWNER TO erp_gtm;

--
-- Name: tpages_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tpages_id_seq OWNED BY tpages.id;


--
-- Name: tpages_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tpages_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(256),
    title character varying(2048),
    meta_description character varying(2048),
    meta_keywords character varying(2048),
    disabled_l10n integer DEFAULT 0 NOT NULL
);


ALTER TABLE tpages_l10n OWNER TO erp_gtm;

--
-- Name: tpages_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tpages_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpages_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tpages_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tpages_l10n_id_seq OWNED BY tpages_l10n.id;


--
-- Name: tpages_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tpages_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpages_ordering_seq OWNER TO erp_gtm;

--
-- Name: tpages_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tpages_ordering_seq OWNED BY tpages.ordering;


--
-- Name: tpayment_service_errors; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tpayment_service_errors (
    id bigint NOT NULL,
    psi_id bigint,
    amount numeric(30,2),
    error text,
    pay_remote_addr character varying(128) NOT NULL,
    pay_user_agent_id bigint,
    pay_data text
);


ALTER TABLE tpayment_service_errors OWNER TO erp_gtm;

--
-- Name: tpayment_service_errors_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tpayment_service_errors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpayment_service_errors_id_seq OWNER TO erp_gtm;

--
-- Name: tpayment_service_errors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tpayment_service_errors_id_seq OWNED BY tpayment_service_errors.id;


--
-- Name: tpayment_service_invoices; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tpayment_service_invoices (
    id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now(),
    date_pay timestamp without time zone DEFAULT now(),
    ask_remote_addr character varying(128) NOT NULL,
    ask_user_agent_id bigint,
    amount numeric(30,2) NOT NULL,
    user_id bigint,
    module_name character varying(128),
    module_fid bigint,
    module_data text,
    redirect character varying(1024),
    payed integer NOT NULL,
    service_name character varying(128),
    service_data text,
    pay_remote_addr character varying(128),
    pay_user_agent_id bigint,
    pay_data text
);


ALTER TABLE tpayment_service_invoices OWNER TO erp_gtm;

--
-- Name: tpayment_service_invoices_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tpayment_service_invoices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tpayment_service_invoices_id_seq OWNER TO erp_gtm;

--
-- Name: tpayment_service_invoices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tpayment_service_invoices_id_seq OWNED BY tpayment_service_invoices.id;


--
-- Name: tplan_formats; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tplan_formats (
    id bigint NOT NULL,
    name character varying(1024),
    width integer,
    height integer,
    dwg_id integer,
    pdf_id integer,
    explication_data text
);


ALTER TABLE tplan_formats OWNER TO erp_gtm;

--
-- Name: tplan_formats_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tplan_formats_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tplan_formats_id_seq OWNER TO erp_gtm;

--
-- Name: tplan_formats_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tplan_formats_id_seq OWNED BY tplan_formats.id;


--
-- Name: tplans; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tplans (
    id bigint NOT NULL,
    name character varying(1204),
    dwg_id integer,
    pdf_id integer,
    jpg_id integer,
    format_id integer,
    view_data text,
    width integer,
    height integer,
    status character varying(64),
    urn text,
    urn_encoded text,
    log text,
    calc_pdf_id integer,
	deleted integer
);


ALTER TABLE tplans OWNER TO erp_gtm;

--
-- Name: tplans_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tplans_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tplans_id_seq OWNER TO erp_gtm;

--
-- Name: tplans_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tplans_id_seq OWNED BY tplans.id;


--
-- Name: treferences; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE treferences (
    id bigint NOT NULL,
    parent_id integer,
    name character varying(1024),
    body text,
    ordering bigint NOT NULL
);


ALTER TABLE treferences OWNER TO erp_gtm;

--
-- Name: treferences_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE treferences_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE treferences_id_seq OWNER TO erp_gtm;

--
-- Name: treferences_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE treferences_id_seq OWNED BY treferences.id;


--
-- Name: treferences_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE treferences_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE treferences_ordering_seq OWNER TO erp_gtm;

--
-- Name: treferences_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE treferences_ordering_seq OWNED BY treferences.ordering;


--
-- Name: trewrites; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE trewrites (
    id bigint NOT NULL,
    regexp character varying(256) NOT NULL,
    fields character varying(128),
    page_id bigint,
    controller_name character varying(128),
    controller_mode character varying(128),
    signature character varying(128)
);


ALTER TABLE trewrites OWNER TO erp_gtm;

--
-- Name: trewrites_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE trewrites_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE trewrites_id_seq OWNER TO erp_gtm;

--
-- Name: trewrites_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE trewrites_id_seq OWNED BY trewrites.id;


--
-- Name: troles; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE troles (
    id bigint NOT NULL,
    code character varying(32) NOT NULL
);


ALTER TABLE troles OWNER TO erp_gtm;

--
-- Name: troles_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE troles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE troles_id_seq OWNER TO erp_gtm;

--
-- Name: troles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE troles_id_seq OWNED BY troles.id;


--
-- Name: troles_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE troles_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE troles_l10n OWNER TO erp_gtm;

--
-- Name: troles_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE troles_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE troles_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: troles_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE troles_l10n_id_seq OWNED BY troles_l10n.id;


--
-- Name: tsensor_comment_images; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsensor_comment_images (
    id bigint NOT NULL,
    image_id integer,
    comment_id integer
);


ALTER TABLE tsensor_comment_images OWNER TO erp_gtm;

--
-- Name: tsensor_comment_images_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_comment_images_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_comment_images_id_seq OWNER TO erp_gtm;

--
-- Name: tsensor_comment_images_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_comment_images_id_seq OWNED BY tsensor_comment_images.id;


--
-- Name: tsensor_comments; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsensor_comments (
    id bigint NOT NULL,
    sensor_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_cr_id bigint NOT NULL,
    body text,
    images_json text
);


ALTER TABLE tsensor_comments OWNER TO erp_gtm;

--
-- Name: tsensor_comments_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_comments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_comments_id_seq OWNER TO erp_gtm;

--
-- Name: tsensor_comments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_comments_id_seq OWNED BY tsensor_comments.id;


--
-- Name: tsensor_groups; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsensor_groups (
    id bigint NOT NULL,
    sensor_id integer,
    group_id integer
);


ALTER TABLE tsensor_groups OWNER TO erp_gtm;

--
-- Name: tsensor_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_groups_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_groups_id_seq OWNER TO erp_gtm;

--
-- Name: tsensor_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_groups_id_seq OWNED BY tfacility_groups.id;


--
-- Name: tsensor_groups_id_seq1; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_groups_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_groups_id_seq1 OWNER TO erp_gtm;

--
-- Name: tsensor_groups_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_groups_id_seq1 OWNED BY tsensor_groups.id;


--
-- Name: tsensor_model_measurers; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsensor_model_measurers (
    id bigint NOT NULL,
    sensor_model_id bigint NOT NULL,
    value_type_id bigint NOT NULL,
    name character varying(128),
    ordering bigint NOT NULL,
    accuracy character varying(24)
);


ALTER TABLE tsensor_model_measurers OWNER TO erp_gtm;

--
-- Name: tsensor_model_measurers_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_model_measurers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_model_measurers_id_seq OWNER TO erp_gtm;

--
-- Name: tsensor_model_measurers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_model_measurers_id_seq OWNED BY tsensor_model_measurers.id;


--
-- Name: tsensor_model_measurers_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_model_measurers_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_model_measurers_ordering_seq OWNER TO erp_gtm;

--
-- Name: tsensor_model_measurers_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_model_measurers_ordering_seq OWNED BY tsensor_model_measurers.ordering;


--
-- Name: tsensor_model_normatives; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsensor_model_normatives (
    id bigint NOT NULL,
    sensor_model_id integer,
    normative_id integer,
    value numeric(30,4),
    for_group integer
);


ALTER TABLE tsensor_model_normatives OWNER TO erp_gtm;

--
-- Name: tsensor_model_normatives_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_model_normatives_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_model_normatives_id_seq OWNER TO erp_gtm;

--
-- Name: tsensor_model_normatives_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_model_normatives_id_seq OWNED BY tsensor_model_normatives.id;


--
-- Name: tsensor_model_types; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsensor_model_types (
    id bigint NOT NULL,
    name character varying(1024)
);


ALTER TABLE tsensor_model_types OWNER TO erp_gtm;

--
-- Name: tsensor_model_types_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_model_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_model_types_id_seq OWNER TO erp_gtm;

--
-- Name: tsensor_model_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_model_types_id_seq OWNED BY tsensor_model_types.id;


--
-- Name: tsensor_models; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsensor_models (
    id bigint NOT NULL,
    code character varying(128) NOT NULL,
    name character varying(256) NOT NULL,
    name_short character varying(24),
    has_braid integer,
    has_own_values integer,
    has_angle integer
);


ALTER TABLE tsensor_models OWNER TO erp_gtm;

--
-- Name: tsensor_models_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_models_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_models_id_seq OWNER TO erp_gtm;

--
-- Name: tsensor_models_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_models_id_seq OWNED BY tsensor_models.id;


--
-- Name: tsensor_photos; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsensor_photos (
    id bigint NOT NULL,
    sensor_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    user_cr_id bigint NOT NULL,
    image_id bigint NOT NULL,
    body text
);


ALTER TABLE tsensor_photos OWNER TO erp_gtm;

--
-- Name: tsensor_photos_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_photos_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_photos_id_seq OWNER TO erp_gtm;

--
-- Name: tsensor_photos_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_photos_id_seq OWNED BY tsensor_photos.id;


--
-- Name: tsensor_states; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsensor_states (
    id bigint NOT NULL,
    name character varying(64),
    code character varying(32)
);


ALTER TABLE tsensor_states OWNER TO erp_gtm;

--
-- Name: tsensor_states_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_states_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_states_id_seq OWNER TO erp_gtm;

--
-- Name: tsensor_states_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_states_id_seq OWNED BY tsensor_states.id;


--
-- Name: tsensor_values; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsensor_values (
    id bigint NOT NULL,
    sensor_id bigint NOT NULL,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    value numeric(30,4),
    date_use date,
    braid_id integer,
    allowed_value_type_id integer,
    CONSTRAINT braid_or_allowed_value_type CHECK ((((allowed_value_type_id IS NULL) AND (braid_id IS NOT NULL)) OR ((allowed_value_type_id IS NOT NULL) AND (braid_id IS NULL))))
);


ALTER TABLE tsensor_values OWNER TO erp_gtm;

--
-- Name: tsensor_values_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensor_values_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensor_values_id_seq OWNER TO erp_gtm;

--
-- Name: tsensor_values_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensor_values_id_seq OWNED BY tsensor_values.id;


--
-- Name: tsensors; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsensors (
    id bigint NOT NULL,
    facility_id bigint NOT NULL,
    name character varying(256) NOT NULL,
    location_x numeric(30,2),
    location_y numeric(30,2),
    location_comments text,
    measurement_mode_id integer,
    allowed_model_type_id integer NOT NULL,
    state_id integer NOT NULL,
    is_retranslator integer,
    deep numeric(20,1),
    deep_step numeric(20,1),
    image_id integer,
    angle integer,
    deleted integer,
    pr_sensor_id integer,
    measurement_period character varying(1024),
    reference_date date,
    clipmap character varying(2048)
);


ALTER TABLE tsensors OWNER TO erp_gtm;

--
-- Name: tsensors_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsensors_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsensors_id_seq OWNER TO erp_gtm;

--
-- Name: tsensors_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsensors_id_seq OWNED BY tsensors.id;


--
-- Name: tsexes; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsexes (
    id bigint NOT NULL,
    code character varying(16) NOT NULL
);


ALTER TABLE tsexes OWNER TO erp_gtm;

--
-- Name: tsexes_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsexes_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsexes_id_seq OWNER TO erp_gtm;

--
-- Name: tsexes_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsexes_id_seq OWNED BY tsexes.id;


--
-- Name: tsexes_l10n; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsexes_l10n (
    id bigint NOT NULL,
    fid_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE tsexes_l10n OWNER TO erp_gtm;

--
-- Name: tsexes_l10n_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsexes_l10n_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsexes_l10n_id_seq OWNER TO erp_gtm;

--
-- Name: tsexes_l10n_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsexes_l10n_id_seq OWNED BY tsexes_l10n.id;


--
-- Name: tsocial_network_account_friends; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsocial_network_account_friends (
    id bigint NOT NULL,
    fid character varying(256) NOT NULL,
    email character varying(256),
    name character varying(256),
    date_birth character varying(256),
    avatar_id bigint,
    sex_id bigint,
    account_id bigint NOT NULL
);


ALTER TABLE tsocial_network_account_friends OWNER TO erp_gtm;

--
-- Name: tsocial_network_account_friends_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsocial_network_account_friends_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsocial_network_account_friends_id_seq OWNER TO erp_gtm;

--
-- Name: tsocial_network_account_friends_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsocial_network_account_friends_id_seq OWNED BY tsocial_network_account_friends.id;


--
-- Name: tsocial_network_accounts; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsocial_network_accounts (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    network_id bigint NOT NULL,
    fid character varying(256),
    access_token character varying(512),
    fid2 character varying(128),
    export_token character varying(1000),
    export_info text,
    export_expires timestamp without time zone,
    do_publish bigint DEFAULT 0 NOT NULL
);


ALTER TABLE tsocial_network_accounts OWNER TO erp_gtm;

--
-- Name: tsocial_network_accounts_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsocial_network_accounts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsocial_network_accounts_id_seq OWNER TO erp_gtm;

--
-- Name: tsocial_network_accounts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsocial_network_accounts_id_seq OWNED BY tsocial_network_accounts.id;


--
-- Name: tsocial_networks; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tsocial_networks (
    id bigint NOT NULL,
    code character varying(32) NOT NULL,
    name character varying(128) NOT NULL,
    can_post integer NOT NULL,
    can_auth integer NOT NULL,
    can_friends integer NOT NULL
);


ALTER TABLE tsocial_networks OWNER TO erp_gtm;

--
-- Name: tsocial_networks_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tsocial_networks_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tsocial_networks_id_seq OWNER TO erp_gtm;

--
-- Name: tsocial_networks_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tsocial_networks_id_seq OWNED BY tsocial_networks.id;


--
-- Name: tspreadsheets; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tspreadsheets (
    id bigint NOT NULL,
    name character varying(1000),
    file_id bigint,
    date_cr timestamp without time zone,
    generator character varying(64),
    fid bigint NOT NULL
);


ALTER TABLE tspreadsheets OWNER TO erp_gtm;

--
-- Name: tspreadsheets_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tspreadsheets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tspreadsheets_id_seq OWNER TO erp_gtm;

--
-- Name: tspreadsheets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tspreadsheets_id_seq OWNED BY tspreadsheets.id;


--
-- Name: ttemplate_place_types; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE ttemplate_place_types (
    id bigint NOT NULL,
    code character varying(16) NOT NULL,
    name character varying(128) NOT NULL
);


ALTER TABLE ttemplate_place_types OWNER TO erp_gtm;

--
-- Name: ttemplate_place_types_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE ttemplate_place_types_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ttemplate_place_types_id_seq OWNER TO erp_gtm;

--
-- Name: ttemplate_place_types_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE ttemplate_place_types_id_seq OWNED BY ttemplate_place_types.id;


--
-- Name: ttemplate_places; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE ttemplate_places (
    id bigint NOT NULL,
    template_id bigint NOT NULL,
    place_type_id bigint NOT NULL,
    ordering bigint NOT NULL,
    code character varying(16) NOT NULL,
    name character varying(64),
    admin_height integer DEFAULT 20 NOT NULL,
    templatewide integer DEFAULT 0 NOT NULL,
    preprocess integer DEFAULT 0 NOT NULL,
    href character varying(1024)
);


ALTER TABLE ttemplate_places OWNER TO erp_gtm;

--
-- Name: ttemplate_places_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE ttemplate_places_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ttemplate_places_id_seq OWNER TO erp_gtm;

--
-- Name: ttemplate_places_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE ttemplate_places_id_seq OWNED BY ttemplate_places.id;


--
-- Name: ttemplate_places_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE ttemplate_places_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ttemplate_places_ordering_seq OWNER TO erp_gtm;

--
-- Name: ttemplate_places_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE ttemplate_places_ordering_seq OWNED BY ttemplate_places.ordering;


--
-- Name: ttemplate_places_templatewide; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE ttemplate_places_templatewide (
    id bigint NOT NULL,
    place_id bigint NOT NULL,
    l10n_id bigint NOT NULL,
    medium_id bigint NOT NULL,
    body text
);


ALTER TABLE ttemplate_places_templatewide OWNER TO erp_gtm;

--
-- Name: ttemplate_places_templatewide_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE ttemplate_places_templatewide_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ttemplate_places_templatewide_id_seq OWNER TO erp_gtm;

--
-- Name: ttemplate_places_templatewide_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE ttemplate_places_templatewide_id_seq OWNED BY ttemplate_places_templatewide.id;


--
-- Name: ttemplates; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE ttemplates (
    id bigint NOT NULL,
    code character varying(128),
    name character varying(128) NOT NULL
);


ALTER TABLE ttemplates OWNER TO erp_gtm;

--
-- Name: ttemplates_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE ttemplates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ttemplates_id_seq OWNER TO erp_gtm;

--
-- Name: ttemplates_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE ttemplates_id_seq OWNED BY ttemplates.id;


--
-- Name: tuser_agents; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tuser_agents (
    id bigint NOT NULL,
    name character varying(1000) NOT NULL,
    is_robot integer NOT NULL,
    device_type integer NOT NULL
);


ALTER TABLE tuser_agents OWNER TO erp_gtm;

--
-- Name: tuser_agents_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tuser_agents_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tuser_agents_id_seq OWNER TO erp_gtm;

--
-- Name: tuser_agents_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tuser_agents_id_seq OWNED BY tuser_agents.id;


--
-- Name: tuser_sessions; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tuser_sessions (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    sid character varying(48) NOT NULL,
    date_exp timestamp without time zone NOT NULL
);


ALTER TABLE tuser_sessions OWNER TO erp_gtm;

--
-- Name: tuser_sessions_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tuser_sessions_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tuser_sessions_id_seq OWNER TO erp_gtm;

--
-- Name: tuser_sessions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tuser_sessions_id_seq OWNED BY tuser_sessions.id;


--
-- Name: tvisits; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tvisits (
    id bigint NOT NULL,
    user_id bigint,
    anon_id bigint,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    baseurl character varying(1000) NOT NULL,
    params character varying(1000),
    user_agent_id bigint NOT NULL,
    ip inet NOT NULL
);


ALTER TABLE tvisits OWNER TO erp_gtm;

--
-- Name: tuser_urls_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tuser_urls_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tuser_urls_id_seq OWNER TO erp_gtm;

--
-- Name: tuser_urls_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tuser_urls_id_seq OWNED BY tvisits.id;


--
-- Name: tusers; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tusers (
    id bigint NOT NULL,
    login character varying(64) NOT NULL,
    first_name character varying(64),
    second_name character varying(64),
    last_name character varying(64),
    calc_full_name character varying(256),
    password character varying(64),
    enabled integer NOT NULL,
    email character varying(64),
    calc_no_roles integer NOT NULL,
    sex_id bigint,
    date_cr timestamp without time zone DEFAULT now() NOT NULL,
    date_birth date,
    im_icq character varying(16),
    im_jabber character varying(48),
    im_msn character varying(48),
    im_skype character varying(48),
	im_telegram character varying(48),
    phone character varying(48),
    date_last_page timestamp without time zone,
    avatar_id bigint,
    about text,
    regsid character varying(64),
    prefer_l10n_id bigint
);


ALTER TABLE tusers OWNER TO erp_gtm;

--
-- Name: tusers_enrolled; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tusers_enrolled (
    id bigint NOT NULL,
    user_id bigint NOT NULL,
    role_id bigint NOT NULL
);


ALTER TABLE tusers_enrolled OWNER TO erp_gtm;

--
-- Name: tusers_enrolled_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tusers_enrolled_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tusers_enrolled_id_seq OWNER TO erp_gtm;

--
-- Name: tusers_enrolled_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tusers_enrolled_id_seq OWNED BY tusers_enrolled.id;


--
-- Name: tusers_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tusers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tusers_id_seq OWNER TO erp_gtm;

--
-- Name: tusers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tusers_id_seq OWNED BY tusers.id;


--
-- Name: tworksheets; Type: TABLE; Schema: public; Owner: erp_gtm
--

CREATE TABLE tworksheets (
    id bigint NOT NULL,
    spreadsheet_id bigint NOT NULL,
    name character varying(1000),
    ordering bigint NOT NULL
);


ALTER TABLE tworksheets OWNER TO erp_gtm;

--
-- Name: tworksheets_id_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tworksheets_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tworksheets_id_seq OWNER TO erp_gtm;

--
-- Name: tworksheets_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tworksheets_id_seq OWNED BY tworksheets.id;


--
-- Name: tworksheets_ordering_seq; Type: SEQUENCE; Schema: public; Owner: erp_gtm
--

CREATE SEQUENCE tworksheets_ordering_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE tworksheets_ordering_seq OWNER TO erp_gtm;

--
-- Name: tworksheets_ordering_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: erp_gtm
--

ALTER SEQUENCE tworksheets_ordering_seq OWNED BY tworksheets.ordering;


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tadmin_start_widgets ALTER COLUMN id SET DEFAULT nextval('tadmin_start_widgets_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tadmin_start_widgets ALTER COLUMN ordering SET DEFAULT nextval('tadmin_start_widgets_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tallowed_model_types ALTER COLUMN id SET DEFAULT nextval('tallowed_model_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tallowed_value_types ALTER COLUMN id SET DEFAULT nextval('tallowed_value_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tanon_cookies ALTER COLUMN id SET DEFAULT nextval('tanon_cookies_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticle_categories ALTER COLUMN id SET DEFAULT nextval('tarticle_categories_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticle_categories_l10n ALTER COLUMN id SET DEFAULT nextval('tarticle_categories_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles ALTER COLUMN id SET DEFAULT nextval('tarticles_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles_l10n ALTER COLUMN id SET DEFAULT nextval('tarticles_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tbase_padding_principles ALTER COLUMN id SET DEFAULT nextval('tbase_padding_principles_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tbraids ALTER COLUMN id SET DEFAULT nextval('tbraids_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_items ALTER COLUMN id SET DEFAULT nextval('tcart_items_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods ALTER COLUMN id SET DEFAULT nextval('tcart_payment_methods_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods_l10n ALTER COLUMN id SET DEFAULT nextval('tcart_payment_methods_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_states ALTER COLUMN id SET DEFAULT nextval('tcart_states_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_states_l10n ALTER COLUMN id SET DEFAULT nextval('tcart_states_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcarts ALTER COLUMN id SET DEFAULT nextval('tcarts_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcells ALTER COLUMN id SET DEFAULT nextval('tcells_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes ALTER COLUMN id SET DEFAULT nextval('tcontent_boxes_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes ALTER COLUMN ordering SET DEFAULT nextval('tcontent_boxes_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_groups ALTER COLUMN id SET DEFAULT nextval('tcontent_boxes_groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_l10n ALTER COLUMN id SET DEFAULT nextval('tcontent_boxes_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items ALTER COLUMN id SET DEFAULT nextval('tcustom_nav_items_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items ALTER COLUMN ordering SET DEFAULT nextval('tcustom_nav_items_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items_l10n ALTER COLUMN id SET DEFAULT nextval('tcustom_nav_items_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_navs ALTER COLUMN id SET DEFAULT nextval('tcustom_navs_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tdebug_requests ALTER COLUMN id SET DEFAULT nextval('tdebug_requests_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tedit_histories ALTER COLUMN id SET DEFAULT nextval('tedit_histories_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY texplications ALTER COLUMN id SET DEFAULT nextval('texplications_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacilities ALTER COLUMN id SET DEFAULT nextval('tfacilities_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacilities ALTER COLUMN ordering SET DEFAULT nextval('tfacilities_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_comment_images ALTER COLUMN id SET DEFAULT nextval('tfacility_comment_images_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_comments ALTER COLUMN id SET DEFAULT nextval('tfacility_comments_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_groups ALTER COLUMN id SET DEFAULT nextval('tsensor_groups_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_photos ALTER COLUMN id SET DEFAULT nextval('tfacility_photos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_plans ALTER COLUMN id SET DEFAULT nextval('tfacility_plans_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_states ALTER COLUMN id SET DEFAULT nextval('tfacility_states_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_stats ALTER COLUMN id SET DEFAULT nextval('tfacility_stats_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_types ALTER COLUMN id SET DEFAULT nextval('tfacility_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_folders ALTER COLUMN id SET DEFAULT nextval('tfile_folders_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_folders ALTER COLUMN ordering SET DEFAULT nextval('tfile_folders_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_folders_l10n ALTER COLUMN id SET DEFAULT nextval('tfile_folders_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_types ALTER COLUMN id SET DEFAULT nextval('tfile_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfiles ALTER COLUMN id SET DEFAULT nextval('tfiles_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfiles ALTER COLUMN ordering SET DEFAULT nextval('tfiles_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfiles_l10n ALTER COLUMN id SET DEFAULT nextval('tfiles_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tforms ALTER COLUMN id SET DEFAULT nextval('tforms_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tguestbook_messages ALTER COLUMN id SET DEFAULT nextval('tguestbook_messages_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tguestbooks ALTER COLUMN id SET DEFAULT nextval('tguestbooks_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tkvcache ALTER COLUMN id SET DEFAULT nextval('tkvcache_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tl10n ALTER COLUMN id SET DEFAULT nextval('tl10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tlogin_attempts ALTER COLUMN id SET DEFAULT nextval('tlogin_attempts_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmail_templates ALTER COLUMN id SET DEFAULT nextval('tmail_templates_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmail_templates_l10n ALTER COLUMN id SET DEFAULT nextval('tmail_templates_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories ALTER COLUMN id SET DEFAULT nextval('tmarket_categories_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories ALTER COLUMN ordering SET DEFAULT nextval('tmarket_categories_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_categories_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_datatypes ALTER COLUMN id SET DEFAULT nextval('tmarket_field_datatypes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_enums ALTER COLUMN id SET DEFAULT nextval('tmarket_field_enums_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_enumsl ALTER COLUMN id SET DEFAULT nextval('tmarket_field_enumsl_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups ALTER COLUMN id SET DEFAULT nextval('tmarket_field_groups_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups ALTER COLUMN ordering SET DEFAULT nextval('tmarket_field_groups_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_field_groups_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields ALTER COLUMN id SET DEFAULT nextval('tmarket_fields_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields ALTER COLUMN ordering SET DEFAULT nextval('tmarket_fields_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_fields_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enums ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_enums_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enumsl ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_enumsl_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_f ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_f_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_i ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_i_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_il ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_il_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_s ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_s_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_sl ALTER COLUMN id SET DEFAULT nextval('tmarket_item_fields_sl_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups ALTER COLUMN id SET DEFAULT nextval('tmarket_item_groups_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups ALTER COLUMN ordering SET DEFAULT nextval('tmarket_item_groups_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_item_groups_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items ALTER COLUMN id SET DEFAULT nextval('tmarket_items_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items ALTER COLUMN ordering SET DEFAULT nextval('tmarket_items_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_items_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers ALTER COLUMN id SET DEFAULT nextval('tmarket_manufacturers_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers ALTER COLUMN ordering SET DEFAULT nextval('tmarket_manufacturers_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_manufacturers_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels ALTER COLUMN id SET DEFAULT nextval('tmarket_search_levels_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_search_levels_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels ALTER COLUMN id SET DEFAULT nextval('tmarket_view_levels_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels_l10n ALTER COLUMN id SET DEFAULT nextval('tmarket_view_levels_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmeasurement_modes ALTER COLUMN id SET DEFAULT nextval('tmeasurement_modes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmeasurement_periods ALTER COLUMN id SET DEFAULT nextval('tfmeasurement_periods_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmeasurer_value_types ALTER COLUMN id SET DEFAULT nextval('tmeasurer_value_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmediums ALTER COLUMN id SET DEFAULT nextval('tmediums_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmediums ALTER COLUMN ordering SET DEFAULT nextval('tmediums_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tnormative_types ALTER COLUMN id SET DEFAULT nextval('tnormatives_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tnormatives ALTER COLUMN id SET DEFAULT nextval('tnormatives_id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpage_blocks ALTER COLUMN id SET DEFAULT nextval('tpage_blocks_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages ALTER COLUMN id SET DEFAULT nextval('tpages_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages ALTER COLUMN ordering SET DEFAULT nextval('tpages_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages_l10n ALTER COLUMN id SET DEFAULT nextval('tpages_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpayment_service_errors ALTER COLUMN id SET DEFAULT nextval('tpayment_service_errors_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpayment_service_invoices ALTER COLUMN id SET DEFAULT nextval('tpayment_service_invoices_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tplan_formats ALTER COLUMN id SET DEFAULT nextval('tplan_formats_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tplans ALTER COLUMN id SET DEFAULT nextval('tplans_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY treferences ALTER COLUMN id SET DEFAULT nextval('treferences_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY treferences ALTER COLUMN ordering SET DEFAULT nextval('treferences_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY trewrites ALTER COLUMN id SET DEFAULT nextval('trewrites_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY troles ALTER COLUMN id SET DEFAULT nextval('troles_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY troles_l10n ALTER COLUMN id SET DEFAULT nextval('troles_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_comment_images ALTER COLUMN id SET DEFAULT nextval('tsensor_comment_images_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_comments ALTER COLUMN id SET DEFAULT nextval('tsensor_comments_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_groups ALTER COLUMN id SET DEFAULT nextval('tsensor_groups_id_seq1'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers ALTER COLUMN id SET DEFAULT nextval('tsensor_model_measurers_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers ALTER COLUMN ordering SET DEFAULT nextval('tsensor_model_measurers_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_normatives ALTER COLUMN id SET DEFAULT nextval('tsensor_model_normatives_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_types ALTER COLUMN id SET DEFAULT nextval('tsensor_model_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_models ALTER COLUMN id SET DEFAULT nextval('tsensor_models_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_photos ALTER COLUMN id SET DEFAULT nextval('tsensor_photos_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_states ALTER COLUMN id SET DEFAULT nextval('tsensor_states_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_values ALTER COLUMN id SET DEFAULT nextval('tsensor_values_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensors ALTER COLUMN id SET DEFAULT nextval('tsensors_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsexes ALTER COLUMN id SET DEFAULT nextval('tsexes_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsexes_l10n ALTER COLUMN id SET DEFAULT nextval('tsexes_l10n_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_network_account_friends ALTER COLUMN id SET DEFAULT nextval('tsocial_network_account_friends_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_network_accounts ALTER COLUMN id SET DEFAULT nextval('tsocial_network_accounts_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_networks ALTER COLUMN id SET DEFAULT nextval('tsocial_networks_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tspreadsheets ALTER COLUMN id SET DEFAULT nextval('tspreadsheets_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_place_types ALTER COLUMN id SET DEFAULT nextval('ttemplate_place_types_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_places ALTER COLUMN id SET DEFAULT nextval('ttemplate_places_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_places ALTER COLUMN ordering SET DEFAULT nextval('ttemplate_places_ordering_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_places_templatewide ALTER COLUMN id SET DEFAULT nextval('ttemplate_places_templatewide_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplates ALTER COLUMN id SET DEFAULT nextval('ttemplates_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tuser_agents ALTER COLUMN id SET DEFAULT nextval('tuser_agents_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tuser_sessions ALTER COLUMN id SET DEFAULT nextval('tuser_sessions_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tusers ALTER COLUMN id SET DEFAULT nextval('tusers_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tusers_enrolled ALTER COLUMN id SET DEFAULT nextval('tusers_enrolled_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tvisits ALTER COLUMN id SET DEFAULT nextval('tuser_urls_id_seq'::regclass);


--
-- Name: id; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tworksheets ALTER COLUMN id SET DEFAULT nextval('tworksheets_id_seq'::regclass);


--
-- Name: ordering; Type: DEFAULT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tworksheets ALTER COLUMN ordering SET DEFAULT nextval('tworksheets_ordering_seq'::regclass);


--
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY spatial_ref_sys (srid, auth_name, auth_srid, srtext, proj4text) FROM stdin;
\.


--
-- Data for Name: tadmin_start_widgets; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tadmin_start_widgets (id, controller_name, controller_mode, fullscreen, ordering) FROM stdin;
1	AdminStart	coolbg	1	1
\.


--
-- Name: tadmin_start_widgets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tadmin_start_widgets_id_seq', 2, true);


--
-- Name: tadmin_start_widgets_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tadmin_start_widgets_ordering_seq', 2, true);


--
-- Data for Name: tallowed_model_types; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tallowed_model_types (id, sensor_model_id, sensor_model_type_id, code, has_braid, has_own_values, ordering, can_be_retranslator, name) FROM stdin;
1	8	1	rp	\N	1	1	1	Репер
2	9	1	ps	\N	1	5	\N	ПС
4	10	2	gdm_inc	1	1	7	\N	ГДМ(инкл)
5	13	3	dm_paint	\N	1	2	\N	ГДМ(краской)
6	13	4	dm_fatty	\N	1	3	\N	ГДМ(наварной)
7	13	2	dm_inc	\N	1	4	1	ДМ(инкл)
8	14	5	ts_vert	1	\N	8	1	ТС(вертикальная)
9	14	6	ts_hor	1	\N	9	1	ТС(горизонтальная)
11	14	7	ts_slop	1	\N	10	1	ТС
12	10	1	gdm	1	1	6	\N	ГДМ
\.


--
-- Name: tallowed_model_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tallowed_model_types_id_seq', 12, true);


--
-- Data for Name: tallowed_value_types; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tallowed_value_types (id, measure_id, allowed_model_type_id, code, accuracy, name) FROM stdin;
4	6	4	s	4	Угол 2
5	5	5	h	4	Высота
6	5	6	h	4	Высота
8	6	7	s	4	Угол 2
7	6	7	h	4	Угол 1
12	5	12	h	4	Высота
3	6	4	h	4	Угол 1
2	7	2	h	2	УГВ
1	5	1	h	4	Высота
\.


--
-- Name: tallowed_value_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tallowed_value_types_id_seq', 12, true);


--
-- Data for Name: tanon_cookies; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tanon_cookies (id, date_cr, user_agent_id, sid, ip) FROM stdin;
\.


--
-- Name: tanon_cookies_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tanon_cookies_id_seq', 1, false);


--
-- Data for Name: tarticle_categories; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tarticle_categories (id, code, groupcode, has_abstract, has_image1, has_image2, has_gallery, image1_id, image2_id) FROM stdin;
\.


--
-- Name: tarticle_categories_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tarticle_categories_id_seq', 1, false);


--
-- Data for Name: tarticle_categories_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tarticle_categories_l10n (id, fid_id, l10n_id, name, abstract, body) FROM stdin;
\.


--
-- Name: tarticle_categories_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tarticle_categories_l10n_id_seq', 1, false);


--
-- Data for Name: tarticles; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tarticles (id, date_cr, date_use, date_show_start, date_show_end, category_id, calc_code, image1_id, image2_id, image3_id, folder_id, enabled, featured, user_cr_id) FROM stdin;
\.


--
-- Name: tarticles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tarticles_id_seq', 1, false);


--
-- Data for Name: tarticles_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tarticles_l10n (id, fid_id, l10n_id, name, abstract, body, disabled_l10n, title, meta_abstract, meta_description) FROM stdin;
\.


--
-- Name: tarticles_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tarticles_l10n_id_seq', 1, false);


--
-- Data for Name: tbase_padding_principles; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tbase_padding_principles (id, name) FROM stdin;
1	&#8544;
2	&#8545;
\.


--
-- Name: tbase_padding_principles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tbase_padding_principles_id_seq', 1, true);


--
-- Data for Name: tbraids; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tbraids (id, sensor_id, deep, enabled) FROM stdin;
\.


--
-- Name: tbraids_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tbraids_id_seq', 493, true);


--
-- Data for Name: tcart_items; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcart_items (id, cart_id, market_item_id, cnt, other_ftype, other_fid, price, amount) FROM stdin;
\.


--
-- Name: tcart_items_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcart_items_id_seq', 1, false);


--
-- Data for Name: tcart_payment_methods; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcart_payment_methods (id, code, func, prepay, enabled) FROM stdin;
1	courier	\N	0	1
2	robokassa	robokassa	1	1
\.


--
-- Name: tcart_payment_methods_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcart_payment_methods_id_seq', 2, true);


--
-- Data for Name: tcart_payment_methods_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcart_payment_methods_l10n (id, fid_id, l10n_id, name, body) FROM stdin;
\.


--
-- Name: tcart_payment_methods_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcart_payment_methods_l10n_id_seq', 1, false);


--
-- Data for Name: tcart_states; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcart_states (id, code, cssclass, do_calc_money) FROM stdin;
1	fill	cart-fill	0
2	sent	cart-sent	1
3	checked	cart-checked	1
4	assemble	cart-assemble	1
5	transfer	cart-transfer	1
6	done	cart-done	1
7	canceled	cart-canceled	0
\.


--
-- Name: tcart_states_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcart_states_id_seq', 7, true);


--
-- Data for Name: tcart_states_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcart_states_l10n (id, fid_id, l10n_id, name, body) FROM stdin;
1	1	1	Наполняется	\N
2	2	1	Отправлена менеджеру	\N
3	3	1	Проверена менеджером	\N
4	4	1	Собирается на складе	\N
5	5	1	Доставляется	\N
6	6	1	Доставлена	\N
7	7	1	Отменена	\N
\.


--
-- Name: tcart_states_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcart_states_l10n_id_seq', 7, true);


--
-- Data for Name: tcarts; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcarts (id, user_id, sid, state_id, date_cr, date_mo, date_sent, date_state_change, payment_method_id, manager_id, calc_summ, calc_items, calc_amount, address_postalindex, address_city, address_street, address_phone, address_comments, address_nearest, address_flat, address_porch, address_floor, address_password, required_change, real_payed) FROM stdin;
\.


--
-- Name: tcarts_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcarts_id_seq', 1, false);


--
-- Data for Name: tcells; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcells (id, worksheet_id, x, y, value) FROM stdin;
\.


--
-- Name: tcells_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcells_id_seq', 1, false);


--
-- Data for Name: tcontent_boxes; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcontent_boxes (id, group_id, ordering, image_id, image2_id, enabled) FROM stdin;
\.


--
-- Data for Name: tcontent_boxes_groups; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcontent_boxes_groups (id, code, name) FROM stdin;
\.


--
-- Name: tcontent_boxes_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcontent_boxes_groups_id_seq', 1, false);


--
-- Name: tcontent_boxes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcontent_boxes_id_seq', 1, false);


--
-- Data for Name: tcontent_boxes_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcontent_boxes_l10n (id, fid_id, l10n_id, override_image_id, name, name2, name3, url) FROM stdin;
\.


--
-- Name: tcontent_boxes_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcontent_boxes_l10n_id_seq', 1, false);


--
-- Name: tcontent_boxes_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcontent_boxes_ordering_seq', 1, false);


--
-- Data for Name: tcustom_nav_items; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcustom_nav_items (id, nav_id, parent_id, image_id, href, page_id, enabled, ordering) FROM stdin;
\.


--
-- Name: tcustom_nav_items_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcustom_nav_items_id_seq', 1, false);


--
-- Data for Name: tcustom_nav_items_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcustom_nav_items_l10n (id, fid_id, l10n_id, name, description) FROM stdin;
\.


--
-- Name: tcustom_nav_items_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcustom_nav_items_l10n_id_seq', 1, false);


--
-- Name: tcustom_nav_items_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcustom_nav_items_ordering_seq', 1, false);


--
-- Data for Name: tcustom_navs; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tcustom_navs (id, code, name, can_href, can_image, can_description) FROM stdin;
\.


--
-- Name: tcustom_navs_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tcustom_navs_id_seq', 1, false);


--
-- Data for Name: tdb_version; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tdb_version (version) FROM stdin;
1
\.


--
-- Data for Name: tdebug_requests; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tdebug_requests (id, login, password, url, date_cr, params, user_id, user_agent_id, error, version, charge) FROM stdin;
\.


--
-- Name: tdebug_requests_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tdebug_requests_id_seq', 1, false);


--
-- Data for Name: tedit_histories; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tedit_histories (id, model_name, text, data, facility_id, date_cr, user_id, model_id) FROM stdin;
\.


--
-- Name: tedit_histories_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tedit_histories_id_seq', 6239, true);


--
-- Data for Name: texplications; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY texplications (id, facility_id, field01, field02, field03, field04, field05, field06, field07, field08, field09, field10, field11, field12) FROM stdin;
\.


--
-- Name: texplications_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('texplications_id_seq', 3, true);


--
-- Data for Name: tfacilities; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfacilities (id, parent_id, name, ordering, image_id, code, address, load_capacity, protection, base_type, base_construction, base_principle_id, location_x, location_y, state_id, width, height, foundation_depth, frozen_depth, clipmap, dumping_depth, plan_id, view_data, table_x, table_y, element_size, table_size, deleted, date_cr, allowed_temperature, allowed_deformation, show_explication, show_convention, convention_x, convention_y, type, stamp_data) FROM stdin;
\.


--
-- Name: tfacilities_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfacilities_id_seq', 115, true);


--
-- Name: tfacilities_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfacilities_ordering_seq', 115, true);


--
-- Data for Name: tfacility_comment_images; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfacility_comment_images (id, comment_id, image_id) FROM stdin;
\.


--
-- Name: tfacility_comment_images_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfacility_comment_images_id_seq', 104, true);


--
-- Data for Name: tfacility_comments; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfacility_comments (id, facility_id, date_cr, user_cr_id, body, images_json) FROM stdin;
\.


--
-- Name: tfacility_comments_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfacility_comments_id_seq', 99, true);


--
-- Data for Name: tfacility_groups; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfacility_groups (id, facility_id, name) FROM stdin;
\.


--
-- Data for Name: tfacility_photos; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfacility_photos (id, facility_id, date_cr, user_cr_id, image_id, body) FROM stdin;
\.


--
-- Name: tfacility_photos_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfacility_photos_id_seq', 4, true);


--
-- Data for Name: tfacility_plans; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfacility_plans (id, facility_id, urn, status_code, dwg_id, objectid, error) FROM stdin;
\.


--
-- Name: tfacility_plans_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfacility_plans_id_seq', 31, true);


--
-- Data for Name: tfacility_states; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfacility_states (id, name) FROM stdin;
1	Готов
2	Строится
3	Демонтирован
\.


--
-- Name: tfacility_states_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfacility_states_id_seq', 3, true);


--
-- Data for Name: tfacility_stats; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfacility_stats (id, facility_id, date, data) FROM stdin;
\.


--
-- Name: tfacility_stats_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfacility_stats_id_seq', 159, true);


--
-- Data for Name: tfacility_types; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfacility_types (id, name) FROM stdin;
1	Строение
2	Скважина
\.


--
-- Name: tfacility_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfacility_types_id_seq', 2, true);


--
-- Data for Name: tfile_folders; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfile_folders (id, code, parent_id, user_cr_id, date_cr, date_mo, ordering) FROM stdin;
1	avatars	\N	1	2015-08-20 09:00:43.202674	2015-08-20 09:00:43.202674	1
2	galleries	\N	1	2015-08-20 09:00:43.204839	2015-08-20 09:00:43.204839	2
3	news	\N	1	2015-08-20 09:00:43.205254	2015-08-20 09:00:43.205254	3
4	images	\N	1	2015-08-20 09:00:43.205584	2015-08-20 09:00:43.205584	4
5	market_items	\N	1	2015-08-20 09:00:43.20598	2015-08-20 09:00:43.20598	5
6	\N	\N	3	2015-08-24 15:21:09.666889	2015-08-24 15:21:09.666889	6
7	\N	\N	3	2015-08-26 11:40:22.099897	2015-08-26 11:40:22.099897	7
8	\N	7	3	2015-08-26 11:40:29.645833	2015-08-26 11:40:29.645833	8
9	\N	8	3	2015-08-26 11:40:35.557888	2015-08-26 11:40:35.557888	9
12	\N	11	3	2015-12-30 13:30:09.084951	2015-12-30 13:30:09.084951	12
13	\N	11	3	2015-12-30 13:30:16.574481	2015-12-30 13:30:16.574481	13
11	\N	\N	3	2015-12-30 13:29:51.256183	2015-12-30 14:36:45.646278	11
14	\N	\N	3	2015-12-30 14:36:59.720915	2015-12-30 14:36:59.720915	14
15	\N	11	3	2016-03-10 18:07:20.08403	2016-03-10 18:07:20.08403	15
\.


--
-- Name: tfile_folders_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfile_folders_id_seq', 15, true);


--
-- Data for Name: tfile_folders_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfile_folders_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	Аватары
2	2	1	Галереи сайта
3	3	1	Статьи
4	4	1	Изображения
5	5	1	Позиции каталога
6	6	1	Объекты
7	7	1	Карта
8	8	1	Элементы
9	9	1	Датчики
12	12	1	PDF_formats
13	13	1	DWG_templates
11	11	1	Шаблоны чертежей
14	14	1	Чертежи
15	15	1	CORRECT
\.


--
-- Name: tfile_folders_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfile_folders_l10n_id_seq', 15, true);


--
-- Name: tfile_folders_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfile_folders_ordering_seq', 15, true);


--
-- Data for Name: tfile_types; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfile_types (id, code, name) FROM stdin;
1	image	Изображение
2	video	Видео
3	sound	Звук
4	other	Файл
\.


--
-- Name: tfile_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfile_types_id_seq', 4, true);


--
-- Data for Name: tfiles; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfiles (id, type_id, file_folder_id, user_cr_id, date_cr, date_mo, orig_filename, ext, width, height, filesize, seconds, ordering) FROM stdin;
1	1	4	3	2015-08-24 14:49:26.643313	2015-08-24 14:49:26.643313	img3	jpg	500	378	33409	\N	1
2	1	6	3	2015-08-24 15:23:05.163139	2015-08-24 15:23:05.163139	img3	jpg	500	378	33409	\N	2
3	1	6	3	2015-08-24 15:25:04.377426	2015-08-24 15:25:04.377426	img3	jpg	500	378	33409	\N	3
33	1	6	3	2015-09-08 15:55:43.485269	2015-09-08 15:55:43.485269	test4	gif	621	348	3185279	\N	33
6	1	6	3	2015-08-24 16:16:46.444128	2015-08-24 16:16:46.444128	img3	jpg	500	378	33409	\N	6
7	1	6	3	2015-08-24 16:17:05.20495	2015-08-24 16:17:05.20495	анжер	jpg	2000	2000	1076007	\N	7
8	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	dm_ico50_50	png	50	50	2445	\N	8
9	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	gdm_ico50_50	png	50	50	2989	\N	9
10	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	gr_ico50_50	png	50	50	3946	\N	10
11	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	ps_ico50_50	png	50	50	4529	\N	11
12	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	tdg_ico50_50	png	50	50	3976	\N	12
13	1	9	3	2015-08-26 11:41:47.443146	2015-08-26 11:41:47.443146	ts_ico50_50	png	50	50	3800	\N	13
14	1	8	3	2015-08-26 11:42:09.753258	2015-08-26 11:42:09.753258	photo_ico50_50	png	50	50	3177	\N	14
15	1	8	3	2015-08-26 11:42:09.753258	2015-08-26 11:42:09.753258	subfac_ico50_50	png	50	50	3761	\N	15
16	1	6	3	2015-08-26 11:55:33.487677	2015-08-26 11:55:33.487677	6	jpg	973	685	331661	\N	16
17	1	6	3	2015-08-26 13:24:59.902091	2015-08-26 13:24:59.902091	6	jpg	973	685	331661	\N	17
18	1	6	3	2015-08-26 13:51:06.444671	2015-08-26 13:51:06.444671	6	jpg	973	685	331661	\N	18
19	1	6	3	2015-08-26 13:51:23.590513	2015-08-26 13:51:23.590513	img3	jpg	500	378	33409	\N	19
20	1	6	3	2015-08-31 20:42:40.425597	2015-08-31 20:42:40.425597	объект_1	jpg	2560	791	365765	\N	20
21	1	6	3	2015-08-31 20:47:36.38649	2015-08-31 20:47:36.38649	объект_1	jpg	6918	2139	2653827	\N	21
22	1	6	3	2015-09-07 18:28:26.470352	2015-09-07 18:28:26.470352	test4	gif	621	348	3185279	\N	22
23	1	6	3	2015-09-07 18:29:43.214367	2015-09-07 18:29:43.214367	test3	gif	621	348	3708740	\N	23
24	1	6	3	2015-09-07 18:30:03.732969	2015-09-07 18:30:03.732969	test3	gif	621	348	3708740	\N	24
25	1	6	3	2015-09-07 18:30:55.648225	2015-09-07 18:30:55.648225	test3	gif	621	348	3708740	\N	25
26	1	6	3	2015-09-07 18:31:28.320028	2015-09-07 18:31:28.320028	test4	gif	621	348	3185279	\N	26
27	1	6	3	2015-09-07 18:32:04.946264	2015-09-07 18:32:04.946264	test3	gif	621	348	3708740	\N	27
28	1	6	3	2015-09-07 18:37:09.731483	2015-09-07 18:37:09.731483	test2	gif	621	348	4630740	\N	28
29	1	6	3	2015-09-07 18:38:30.797686	2015-09-07 18:38:30.797686	test	gif	621	348	224262	\N	29
30	1	6	3	2015-09-08 15:46:12.902901	2015-09-08 15:46:12.902901	test2	gif	621	348	4630740	\N	30
31	1	6	3	2015-09-08 15:49:39.182762	2015-09-08 15:49:39.182762	test2	gif	621	348	4630740	\N	31
32	1	6	3	2015-09-08 15:54:56.964146	2015-09-08 15:54:56.964146	test2	gif	621	348	4630740	\N	32
34	1	6	3	2015-09-08 16:03:01.383919	2015-09-08 16:03:01.383919	test2	gif	621	348	4630740	\N	34
35	1	6	3	2015-09-08 16:03:38.201915	2015-09-08 16:03:38.201915	avatar	jpg	200	216	57465	\N	35
36	1	6	3	2015-09-08 16:04:14.370635	2015-09-08 16:04:14.370635	avatar	jpg	200	216	57465	\N	36
37	1	6	3	2015-09-08 16:09:14.447998	2015-09-08 16:09:14.447998	avatar	jpg	200	216	57465	\N	37
38	1	6	3	2015-09-08 16:12:00.578615	2015-09-08 16:12:00.578615	test2	gif	621	348	4630740	\N	38
39	1	6	3	2015-09-08 18:02:12.298169	2015-09-08 18:02:12.298169	avatar	jpg	200	216	57465	\N	39
40	1	6	3	2015-09-08 18:03:24.105654	2015-09-08 18:03:24.105654	test2	gif	621	348	4630740	\N	40
41	1	6	3	2015-09-08 18:03:41.675144	2015-09-08 18:03:41.675144	avatar	jpg	200	216	57465	\N	41
42	1	6	3	2015-09-08 18:04:09.949336	2015-09-08 18:04:09.949336	объект_1	jpg	6918	2139	2653827	\N	42
43	1	6	3	2015-09-08 18:06:20.961969	2015-09-08 18:06:20.961969	element_sheet	jpg	4396	3038	2099033	\N	43
44	1	6	3	2015-09-09 11:36:26.69785	2015-09-09 11:36:26.69785	объект_1	jpg	6918	2139	2653827	\N	44
45	1	6	3	2015-09-09 11:41:43.210538	2015-09-09 11:41:43.210538	объект_1	jpg	6918	2139	2653827	\N	45
46	1	6	3	2015-09-10 14:30:49.737896	2015-09-10 14:30:49.737896	объект_1	jpg	6918	2139	2653827	\N	46
47	1	6	3	2015-09-14 14:32:02.261057	2015-09-14 14:32:02.261057	объект_1	jpg	6918	2139	2653827	\N	47
48	1	6	3	2015-09-14 14:35:12.935628	2015-09-14 14:35:12.935628	объект_1	jpg	6918	2139	2653827	\N	48
49	1	6	3	2015-09-15 11:56:47.902547	2015-09-15 11:56:47.902547	объект_1	jpg	6918	2139	2653827	\N	49
50	1	6	3	2015-09-16 15:50:12.765439	2015-09-16 15:50:12.765439	avatar	jpg	200	216	57465	\N	50
51	1	6	3	2015-09-16 18:28:17.987815	2015-09-16 18:28:17.987815	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	51
52	1	6	3	2015-09-16 18:28:18.615261	2015-09-16 18:28:18.615261	carottage5	jpg	320	451	77278	\N	52
53	1	6	3	2015-09-16 18:28:18.615264	2015-09-16 18:28:18.615264	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	53
54	1	6	3	2015-09-16 18:28:18.73294	2015-09-16 18:28:18.73294	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	54
55	1	6	3	2015-09-16 18:28:18.944046	2015-09-16 18:28:18.944046	boif-djd2-gh	gif	800	800	105601	\N	55
56	1	6	3	2015-09-16 18:29:11.692028	2015-09-16 18:29:11.692028	boif-djd2-gh	gif	800	800	105601	\N	56
57	1	6	3	2015-09-16 18:29:26.843049	2015-09-16 18:29:26.843049	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	57
58	1	6	3	2015-09-16 18:29:41.205801	2015-09-16 18:29:41.205801	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	58
59	1	6	3	2015-09-16 18:29:41.457271	2015-09-16 18:29:41.457271	carottage5	jpg	320	451	77278	\N	59
60	1	6	3	2015-09-16 18:29:41.526113	2015-09-16 18:29:41.526113	boif-djd2-gh	gif	800	800	105601	\N	60
61	1	6	3	2015-09-16 18:29:41.559923	2015-09-16 18:29:41.559923	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	61
62	1	6	3	2015-09-16 18:29:41.731038	2015-09-16 18:29:41.731038	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	62
63	1	6	3	2015-09-16 18:30:38.459839	2015-09-16 18:30:38.459839	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	63
64	1	6	3	2015-09-16 18:30:38.698332	2015-09-16 18:30:38.698332	boif-djd2-gh	gif	800	800	105601	\N	64
65	1	6	3	2015-09-16 18:30:38.858253	2015-09-16 18:30:38.858253	carottage5	jpg	320	451	77278	\N	65
66	1	6	3	2015-09-16 18:30:38.882293	2015-09-16 18:30:38.882293	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	66
67	1	6	3	2015-09-16 18:30:38.945472	2015-09-16 18:30:38.945472	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	67
68	1	6	3	2015-09-16 18:34:56.399099	2015-09-16 18:34:56.399099	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	68
69	1	6	3	2015-09-16 18:34:56.476456	2015-09-16 18:34:56.476456	carottage5	jpg	320	451	77278	\N	69
70	1	6	3	2015-09-16 18:34:56.51143	2015-09-16 18:34:56.51143	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	70
71	1	6	3	2015-09-16 18:34:56.554638	2015-09-16 18:34:56.554638	boif-djd2-gh	gif	800	800	105601	\N	71
72	1	6	3	2015-09-16 18:34:57.177572	2015-09-16 18:34:57.177572	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	72
73	1	6	3	2015-09-16 18:38:43.691998	2015-09-16 18:38:43.691998	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	73
74	1	6	3	2015-09-16 18:38:43.713857	2015-09-16 18:38:43.713857	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	74
75	1	6	3	2015-09-16 18:38:43.798925	2015-09-16 18:38:43.798925	boif-djd2-gh	gif	800	800	105601	\N	75
76	1	6	3	2015-09-16 18:38:44.098715	2015-09-16 18:38:44.098715	carottage5	jpg	320	451	77278	\N	76
77	1	6	3	2015-09-16 18:38:44.651002	2015-09-16 18:38:44.651002	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	77
78	1	6	3	2015-09-16 18:39:32.915052	2015-09-16 18:39:32.915052	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	78
79	1	6	3	2015-09-16 18:39:33.074676	2015-09-16 18:39:33.074676	carottage5	jpg	320	451	77278	\N	79
80	1	6	3	2015-09-16 18:39:33.109203	2015-09-16 18:39:33.109203	boif-djd2-gh	gif	800	800	105601	\N	80
81	1	6	3	2015-09-16 18:39:33.128269	2015-09-16 18:39:33.128269	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	81
82	1	6	3	2015-09-16 18:39:33.188936	2015-09-16 18:39:33.188936	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	82
83	1	6	3	2015-09-16 18:45:51.457671	2015-09-16 18:45:51.457671	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	83
84	1	6	3	2015-09-16 18:45:51.597894	2015-09-16 18:45:51.597894	carottage5	jpg	320	451	77278	\N	84
85	1	6	3	2015-09-16 18:45:51.679049	2015-09-16 18:45:51.679049	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	85
86	1	6	3	2015-09-16 18:45:51.703988	2015-09-16 18:45:51.703988	boif-djd2-gh	gif	800	800	105601	\N	86
87	1	6	3	2015-09-16 18:45:51.807192	2015-09-16 18:45:51.807192	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	87
88	1	6	3	2015-09-16 18:48:32.087523	2015-09-16 18:48:32.087523	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	88
89	1	6	3	2015-09-16 18:48:32.384578	2015-09-16 18:48:32.384578	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	89
90	1	6	3	2015-09-16 18:48:32.399493	2015-09-16 18:48:32.399493	carottage5	jpg	320	451	77278	\N	90
91	1	6	3	2015-09-16 18:48:32.424412	2015-09-16 18:48:32.424412	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	91
92	1	6	3	2015-09-16 18:48:32.491621	2015-09-16 18:48:32.491621	boif-djd2-gh	gif	800	800	105601	\N	92
93	1	6	3	2015-09-16 18:51:31.885482	2015-09-16 18:51:31.885482	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	93
95	1	6	3	2015-09-16 18:51:32.399869	2015-09-16 18:51:32.399869	carottage5	jpg	320	451	77278	\N	95
94	1	6	3	2015-09-16 18:51:32.399464	2015-09-16 18:51:32.399464	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	94
96	1	6	3	2015-09-16 18:51:32.564829	2015-09-16 18:51:32.564829	boif-djd2-gh	gif	800	800	105601	\N	96
97	1	6	3	2015-09-16 18:51:32.711416	2015-09-16 18:51:32.711416	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	97
98	1	6	3	2015-09-16 19:02:09.389993	2015-09-16 19:02:09.389993	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	98
99	1	6	3	2015-09-16 19:02:09.548159	2015-09-16 19:02:09.548159	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	99
100	1	6	3	2015-09-16 19:02:09.600831	2015-09-16 19:02:09.600831	boif-djd2-gh	gif	800	800	105601	\N	100
101	1	6	3	2015-09-16 19:02:09.681987	2015-09-16 19:02:09.681987	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	101
102	1	6	3	2015-09-16 19:02:09.72506	2015-09-16 19:02:09.72506	carottage5	jpg	320	451	77278	\N	102
103	1	6	3	2015-09-16 19:02:15.638822	2015-09-16 19:02:15.638822	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	103
104	1	6	3	2015-09-16 19:02:15.730486	2015-09-16 19:02:15.730486	carottage5	jpg	320	451	77278	\N	104
105	1	6	3	2015-09-16 19:02:15.733409	2015-09-16 19:02:15.733409	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	105
106	1	6	3	2015-09-16 19:02:15.807035	2015-09-16 19:02:15.807035	boif-djd2-gh	gif	800	800	105601	\N	106
107	1	6	3	2015-09-16 19:02:15.826875	2015-09-16 19:02:15.826875	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	107
108	1	6	3	2015-09-16 19:02:21.947414	2015-09-16 19:02:21.947414	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	108
109	1	6	3	2015-09-16 19:02:22.12404	2015-09-16 19:02:22.12404	carottage5	jpg	320	451	77278	\N	109
110	1	6	3	2015-09-16 19:02:22.128252	2015-09-16 19:02:22.128252	boif-djd2-gh	gif	800	800	105601	\N	110
111	1	6	3	2015-09-16 19:02:22.342338	2015-09-16 19:02:22.342338	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	111
112	1	6	3	2015-09-16 19:02:22.417471	2015-09-16 19:02:22.417471	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	112
113	1	6	3	2015-09-16 19:19:44.707195	2015-09-16 19:19:44.707195	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	113
114	1	6	3	2015-09-21 12:27:16.734223	2015-09-21 12:27:16.734223	carottage5	jpg	320	451	77278	\N	114
115	1	6	3	2015-09-21 12:27:16.768582	2015-09-21 12:27:16.768582	boif-djd2-gh	gif	800	800	105601	\N	115
116	1	6	3	2015-09-21 12:27:16.818422	2015-09-21 12:27:16.818422	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	116
117	1	6	3	2015-09-21 12:27:16.957348	2015-09-21 12:27:16.957348	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	117
118	1	6	3	2015-09-21 14:15:57.652581	2015-09-21 14:15:57.652581	объект_1	jpg	6918	2139	2653827	\N	118
119	1	6	3	2015-10-05 17:58:57.121693	2015-10-05 17:58:57.121693	объект_1	jpg	6918	2139	2653827	\N	119
120	1	6	3	2015-10-07 13:38:24.513835	2015-10-07 13:38:24.513835	trollface	png	469	428	99320	\N	120
121	1	6	3	2015-10-07 13:39:14.095502	2015-10-07 13:39:14.095502	trollface	png	469	428	99320	\N	121
122	1	6	3	2015-10-07 13:40:46.594823	2015-10-07 13:40:46.594823	carottage5	jpg	320	451	77278	\N	122
124	1	6	3	2015-10-07 13:40:46.625088	2015-10-07 13:40:46.625088	engineering-and-geodetic-surveys	jpg	450	675	87950	\N	124
123	1	6	3	2015-10-07 13:40:46.624212	2015-10-07 13:40:46.624212	boif-djd2-gh	gif	800	800	105601	\N	123
125	1	6	3	2015-10-07 13:42:12.983104	2015-10-07 13:42:12.983104	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	125
126	1	6	3	2015-10-07 13:43:24.563816	2015-10-07 13:43:24.563816	403ds-multi-purge-manifold-pr-600px	jpg	600	606	22122	\N	126
127	1	6	3	2015-10-07 13:43:25.526474	2015-10-07 13:43:25.526474	boif-djd2-gh	gif	800	800	105601	\N	127
128	1	6	3	2015-10-07 13:43:25.948362	2015-10-07 13:43:25.948362	51232801ac79590c7f03cba5[1]	png	377	377	228519	\N	128
129	1	6	3	2015-10-07 13:47:51.399788	2015-10-07 13:47:51.399788	объект_1	jpg	6918	2139	2653827	\N	129
130	1	6	10	2015-10-13 15:13:00.083498	2015-10-13 15:13:00.083498	desert	jpg	1024	768	845941	\N	130
131	1	6	10	2015-10-20 09:21:48.227128	2015-10-20 09:21:48.227128	снимок	jpg	867	810	161607	\N	131
132	1	6	10	2015-10-20 09:23:18.679573	2015-10-20 09:23:18.679573	снимок	jpg	867	810	161607	\N	132
133	1	6	10	2015-10-20 09:24:12.809607	2015-10-20 09:24:12.809607	снимок	jpg	867	810	161607	\N	133
134	1	6	10	2015-10-20 09:28:24.107818	2015-10-20 09:28:24.107818	снимок	jpg	867	810	161607	\N	134
135	1	6	10	2015-10-20 10:05:33.157261	2015-10-20 10:05:33.157261	снимок	jpg	867	810	161607	\N	135
136	1	6	10	2015-10-20 11:32:23.970314	2015-10-20 11:32:23.970314	013 приложение д схема расположения элементов сети гтм	jpg	3309	4678	1225525	\N	136
151	4	6	3	2015-11-11 17:53:30.612634	2015-11-11 17:53:30.612634	1.общая схема кц	dxf	\N	\N	84365174	\N	151
138	1	6	10	2015-10-21 13:39:35.440439	2015-10-21 13:39:35.440439	013 приложение д схема расположения элементов сети гтм	jpg	1900	830	197839	\N	138
139	1	6	10	2015-10-21 13:55:27.400279	2015-10-21 13:55:27.400279	7тест	jpg	13200	10200	3817309	\N	139
140	1	6	10	2015-10-21 13:56:15.911598	2015-10-21 13:56:15.911598	7тест	jpg	13200	10200	3817309	\N	140
141	1	6	10	2015-10-21 13:59:39.97624	2015-10-21 13:59:39.97624	8тест	jpg	6600	5100	1350332	\N	141
142	1	6	3	2015-10-27 18:48:52.407586	2015-10-27 18:48:52.407586	blank_1	jpg	850	1203	369940	\N	142
143	1	6	3	2015-10-29 11:57:49.253473	2015-10-29 11:57:49.253473	объект_1	jpg	6918	2139	2653827	\N	143
144	1	6	3	2015-10-29 17:55:05.732488	2015-10-29 17:55:05.732488	объект_1	jpg	6918	2139	2653827	\N	144
145	1	6	3	2015-10-31 10:26:28.134226	2015-10-31 10:26:28.134226	image	jpg	2592	1936	1599324	\N	145
146	4	6	3	2015-11-11 14:22:33.652412	2015-11-11 14:22:33.652412	лист.2-44	dwg	\N	\N	3366285	\N	146
147	4	6	3	2015-11-11 14:24:08.006297	2015-11-11 14:24:08.006297	лист.2-44	dwg	\N	\N	3366285	\N	147
148	4	6	3	2015-11-11 14:25:10.600607	2015-11-11 14:25:10.600607	лист.2-44	dwg	\N	\N	3366285	\N	148
149	4	6	3	2015-11-11 16:03:30.273989	2015-11-11 16:03:30.273989	1.общая схема кц	dwg	\N	\N	12052299	\N	149
150	4	6	3	2015-11-11 17:48:41.519343	2015-11-11 17:48:41.519343	чертеж8	dwg	\N	\N	377633	\N	150
152	4	6	3	2015-11-11 18:00:00.534623	2015-11-11 18:00:00.534623	лист.2-44	dwg	\N	\N	3366285	\N	152
153	4	6	3	2015-11-11 18:30:31.160801	2015-11-11 18:30:31.160801	лист 17 поз.5.4	pdf	\N	\N	81512	\N	153
154	1	6	3	2015-11-12 13:49:58.691604	2015-11-12 13:49:58.691604	orion_hubble_6000	jpg	6000	6000	2697142	\N	154
155	1	6	3	2015-11-13 12:56:11.702693	2015-11-13 12:56:11.702693	orion_hubble_6000	jpg	6000	6000	2697142	\N	155
156	1	6	3	2015-11-13 12:58:07.463617	2015-11-13 12:58:07.463617	chart	jpeg	1200	800	66704	\N	156
157	1	6	3	2015-11-13 14:13:53.620079	2015-11-13 14:13:53.620079	desert	jpg	1024	768	845941	\N	157
170	1	6	3	2015-11-18 20:03:55.752084	2015-11-18 20:03:55.752084	img_20151118_192946	jpg	1440	2560	62089	\N	170
171	1	6	3	2015-11-18 20:03:55.763807	2015-11-18 20:03:55.763807	img_20151118_192813	jpg	1440	2560	72633	\N	171
172	1	6	3	2015-11-18 20:03:55.807547	2015-11-18 20:03:55.807547	img_20151118_192830	jpg	1440	2560	90477	\N	172
173	1	6	3	2015-11-18 20:04:40.07685	2015-11-18 20:04:40.07685	img_20151118_192813	jpg	1440	2560	72633	\N	173
174	1	6	3	2015-11-18 20:04:40.088784	2015-11-18 20:04:40.088784	img_20151118_192946	jpg	1440	2560	62089	\N	174
175	1	6	3	2015-11-18 20:04:40.100167	2015-11-18 20:04:40.100167	img_20151118_192830	jpg	1440	2560	90477	\N	175
187	1	6	3	2015-11-19 13:40:37.956295	2015-11-19 13:40:37.956295	img_20151119_135415	jpg	2560	1440	177646	\N	187
182	1	6	3	2015-11-19 13:19:26.683184	2015-11-19 13:19:26.683184	img_20151119_135415	jpg	2560	1440	177646	\N	182
183	1	6	3	2015-11-19 13:20:50.663698	2015-11-19 13:20:50.663698	img_20151119_135415	jpg	2560	1440	177646	\N	183
184	1	6	3	2015-11-19 13:20:50.748435	2015-11-19 13:20:50.748435	img_20151119_135404	jpg	1440	2560	176829	\N	184
185	1	6	3	2015-11-19 13:37:32.380532	2015-11-19 13:37:32.380532	img_20151119_135415	jpg	2560	1440	177646	\N	185
186	1	6	3	2015-11-19 13:40:37.867832	2015-11-19 13:40:37.867832	img_20151119_135404	jpg	1440	2560	176829	\N	186
188	1	6	3	2015-11-19 13:43:18.436295	2015-11-19 13:43:18.436295	img_20151119_135415	jpg	2560	1440	177646	\N	188
189	1	6	3	2015-11-19 13:51:04.729303	2015-11-19 13:51:04.729303	img_20151119_144826	jpg	1440	2560	155127	\N	189
190	1	6	3	2015-11-19 13:51:04.772263	2015-11-19 13:51:04.772263	img_20151119_144831	jpg	2560	1440	152306	\N	190
191	1	6	3	2015-11-19 13:51:04.822302	2015-11-19 13:51:04.822302	img_20151119_144858	jpg	1440	2560	169356	\N	191
192	1	6	3	2015-11-19 13:51:04.83607	2015-11-19 13:51:04.83607	img_20151119_144906	jpg	1440	2560	158445	\N	192
194	1	6	3	2015-11-19 13:59:52.983582	2015-11-19 13:59:52.983582	img_20151119_145757	jpg	1440	2560	122964	\N	194
193	1	6	3	2015-11-19 13:59:52.983283	2015-11-19 13:59:52.983283	img_20151119_145803	jpg	1440	2560	110234	\N	193
195	1	6	3	2015-11-19 13:59:52.989877	2015-11-19 13:59:52.989877	img_20151119_145740	jpg	1440	2560	119976	\N	195
197	1	6	3	2015-11-19 14:33:39.687804	2015-11-19 14:33:39.687804	img_20151119_152107	jpg	1440	2560	128382	\N	197
198	1	6	3	2015-11-19 14:33:40.319651	2015-11-19 14:33:40.319651	img_20151119_152112	jpg	1440	2560	138530	\N	198
199	1	6	3	2015-11-19 14:33:40.95175	2015-11-19 14:33:40.95175	img_20151119_152133	jpg	1440	2560	147734	\N	199
200	1	6	3	2015-11-19 14:33:41.584221	2015-11-19 14:33:41.584221	img_20151119_152138	jpg	1440	2560	159638	\N	200
201	1	6	3	2015-11-19 14:54:15.634969	2015-11-19 14:54:15.634969	img_20151119_152102	jpg	1440	2560	103101	\N	201
202	1	6	3	2015-11-19 14:57:47.443188	2015-11-19 14:57:47.443188	img_20151119_155517	jpg	1440	2560	153852	\N	202
203	1	6	3	2015-11-19 14:57:47.989414	2015-11-19 14:57:47.989414	img_20151119_155523	jpg	1440	2560	72835	\N	203
204	1	6	3	2015-11-19 14:57:48.604411	2015-11-19 14:57:48.604411	img_20151119_155530	jpg	1440	2560	132085	\N	204
205	1	6	3	2015-11-19 14:57:49.186756	2015-11-19 14:57:49.186756	img_20151119_155555	jpg	1440	2560	112793	\N	205
206	1	6	3	2015-11-19 14:57:49.731732	2015-11-19 14:57:49.731732	img_20151119_155605	jpg	1440	2560	106060	\N	206
207	1	6	3	2015-11-19 15:08:18.072942	2015-11-19 15:08:18.072942	img_20151119_160643	jpg	480	640	16256	\N	207
208	1	6	3	2015-11-19 15:08:18.421504	2015-11-19 15:08:18.421504	img_20151119_160652	jpg	480	640	12102	\N	208
209	1	6	3	2015-11-19 15:16:25.695672	2015-11-19 15:16:25.695672	img_20151119_161406	jpg	1440	2560	162425	\N	209
210	1	6	3	2015-11-19 15:16:26.38922	2015-11-19 15:16:26.38922	img_20151119_161421	jpg	1440	2560	158951	\N	210
211	1	6	3	2015-11-19 15:16:27.066826	2015-11-19 15:16:27.066826	img_20151119_161426	jpg	1440	2560	169615	\N	211
212	1	6	3	2015-11-19 15:16:27.61824	2015-11-19 15:16:27.61824	img_20151119_161431	jpg	1440	2560	113410	\N	212
213	1	6	3	2015-11-19 15:16:28.373225	2015-11-19 15:16:28.373225	img_20151119_161449	jpg	1440	2560	170505	\N	213
214	1	6	3	2015-11-19 18:32:40.188417	2015-11-19 18:32:40.188417	img_20151119_193049	jpg	480	640	16804	\N	214
215	1	6	3	2015-11-19 18:39:51.783123	2015-11-19 18:39:51.783123	img_20151119_193751	jpg	1440	2560	94476	\N	215
216	1	6	3	2015-11-19 18:39:52.513215	2015-11-19 18:39:52.513215	img_20151119_193757	jpg	1440	2560	102561	\N	216
217	1	6	3	2015-11-19 18:43:59.757383	2015-11-19 18:43:59.757383	img_20151119_194218	jpg	1440	2560	186195	\N	217
218	1	6	3	2015-11-19 18:44:00.426861	2015-11-19 18:44:00.426861	img_20151119_194223	jpg	1440	2560	97561	\N	218
219	1	6	3	2015-11-19 18:47:14.067431	2015-11-19 18:47:14.067431	img_20151119_194533	jpg	1440	2560	112149	\N	219
220	1	6	3	2015-11-19 18:47:14.666656	2015-11-19 18:47:14.666656	img_20151119_194538	jpg	1440	2560	111519	\N	220
221	1	6	3	2015-11-19 18:54:47.317804	2015-11-19 18:54:47.317804	img_20151119_195228	jpg	1440	2560	102812	\N	221
222	1	6	3	2015-11-19 18:54:48.003862	2015-11-19 18:54:48.003862	img_20151119_195234	jpg	1440	2560	136880	\N	222
223	1	6	3	2015-11-19 18:54:50.375036	2015-11-19 18:54:50.375036	img_20151119_195223	jpg	1440	2560	90446	\N	223
224	1	6	3	2015-11-19 18:59:38.532161	2015-11-19 18:59:38.532161	img_20151119_195754	jpg	1440	2560	98058	\N	224
225	1	6	3	2015-11-19 18:59:39.723695	2015-11-19 18:59:39.723695	img_20151119_195759	jpg	1440	2560	99399	\N	225
226	1	6	3	2015-11-19 18:59:41.963643	2015-11-19 18:59:41.963643	img_20151119_195749	jpg	1440	2560	97678	\N	226
227	1	6	3	2015-11-19 19:06:08.348886	2015-11-19 19:06:08.348886	img_20151119_200424	jpg	1440	2560	152869	\N	227
228	1	6	3	2015-11-19 19:06:09.014179	2015-11-19 19:06:09.014179	img_20151119_200433	jpg	1440	2560	140833	\N	228
229	1	6	3	2015-11-19 19:06:11.271936	2015-11-19 19:06:11.271936	img_20151119_200418	jpg	1440	2560	150957	\N	229
230	1	6	3	2015-11-19 19:18:12.300029	2015-11-19 19:18:12.300029	img_20151119_201433	jpg	1440	2560	118808	\N	230
231	1	6	3	2015-11-19 19:18:12.937322	2015-11-19 19:18:12.937322	img_20151119_201504	jpg	1440	2560	113423	\N	231
232	1	6	3	2015-11-19 19:18:13.483156	2015-11-19 19:18:13.483156	img_20151119_201620	jpg	1440	2560	81375	\N	232
233	1	6	3	2015-11-19 19:18:15.609009	2015-11-19 19:18:15.609009	img_20151119_201348	jpg	1440	2560	115579	\N	233
234	1	6	3	2015-11-19 19:22:24.710108	2015-11-19 19:22:24.710108	img_20151119_201956	jpg	1440	2560	105548	\N	234
235	1	6	3	2015-11-19 19:22:25.350393	2015-11-19 19:22:25.350393	img_20151119_202002	jpg	1440	2560	143987	\N	235
236	1	6	3	2015-11-19 19:22:26.026287	2015-11-19 19:22:26.026287	img_20151119_202021	jpg	1440	2560	146584	\N	236
237	1	6	3	2015-11-19 19:22:26.646964	2015-11-19 19:22:26.646964	img_20151119_202027	jpg	1440	2560	130645	\N	237
238	1	6	3	2015-11-19 19:22:27.304421	2015-11-19 19:22:27.304421	img_20151119_202034	jpg	1440	2560	121126	\N	238
239	1	6	3	2015-11-19 19:22:29.414186	2015-11-19 19:22:29.414186	img_20151119_201951	jpg	1440	2560	107621	\N	239
240	1	6	3	2015-11-22 19:41:15.789349	2015-11-22 19:41:15.789349	img_20151122_203622	jpg	480	640	14638	\N	240
241	1	6	3	2015-11-22 20:29:42.915979	2015-11-22 20:29:42.915979	img_20151122_212611	jpg	480	640	14959	\N	241
242	1	6	3	2015-11-22 20:29:44.796029	2015-11-22 20:29:44.796029	img_20151122_212606	jpg	480	640	14115	\N	242
243	1	6	3	2015-11-23 12:44:08.205715	2015-11-23 12:44:08.205715	img_20151123_133116	jpg	480	640	14854	\N	243
244	1	6	3	2015-11-23 12:44:08.619209	2015-11-23 12:44:08.619209	img_20151123_133134	jpg	480	640	18444	\N	244
245	1	6	3	2015-11-23 12:44:08.928692	2015-11-23 12:44:08.928692	img_20151123_133214	jpg	480	640	12763	\N	245
246	1	6	3	2015-11-23 12:44:09.495826	2015-11-23 12:44:09.495826	img_20151123_133224	jpg	1440	2560	146255	\N	246
247	1	6	3	2015-11-23 12:44:10.148044	2015-11-23 12:44:10.148044	img_20151123_133230	jpg	1440	2560	178041	\N	247
248	1	6	3	2015-11-23 12:44:10.682614	2015-11-23 12:44:10.682614	img_20151123_133236	jpg	1440	2560	104903	\N	248
249	1	6	3	2015-11-23 12:44:12.537276	2015-11-23 12:44:12.537276	img_20151123_133101	jpg	480	640	12259	\N	249
250	1	6	3	2015-11-23 14:00:36.051713	2015-11-23 14:00:36.051713	img_20151123_145852	jpg	1440	2560	111044	\N	250
251	1	6	3	2015-11-23 14:00:36.697016	2015-11-23 14:00:36.697016	img_20151123_145858	jpg	1440	2560	120563	\N	251
252	1	6	3	2015-11-23 14:00:38.929396	2015-11-23 14:00:38.929396	img_20151123_145847	jpg	1440	2560	151630	\N	252
253	1	6	3	2015-11-23 15:14:31.531554	2015-11-23 15:14:31.531554	img_20151123_161302	jpg	1440	2560	83976	\N	253
254	1	6	3	2015-11-23 17:14:42.16015	2015-11-23 17:14:42.16015	img_20151123_181257	jpg	1440	2560	169334	\N	254
255	1	6	3	2015-11-24 16:08:42.401745	2015-11-24 16:08:42.401745	yamal	png	1358	3991	1043870	\N	255
256	1	6	3	2015-11-24 16:09:20.159336	2015-11-24 16:09:20.159336	yamal	png	1358	3991	1043870	\N	256
257	1	6	3	2015-11-24 16:09:44.438386	2015-11-24 16:09:44.438386	yamal	png	1358	3991	1043870	\N	257
258	1	6	3	2015-11-24 16:15:52.405527	2015-11-24 16:15:52.405527	yamal	png	1358	3991	1043870	\N	258
259	1	6	3	2015-11-24 16:16:55.307755	2015-11-24 16:16:55.307755	yamal	png	1358	3991	1043870	\N	259
260	1	6	3	2015-11-24 16:27:48.483278	2015-11-24 16:27:48.483278	yamal	png	1358	3991	1043870	\N	260
261	1	6	3	2015-11-24 16:59:23.962594	2015-11-24 16:59:23.962594	yamal	png	1358	3991	1043870	\N	261
262	1	6	3	2015-11-24 17:00:36.387744	2015-11-24 17:00:36.387744	yamal	png	1358	3991	1043870	\N	262
263	1	6	3	2015-11-24 17:02:20.276613	2015-11-24 17:02:20.276613	yamal	png	1358	3991	1043870	\N	263
264	1	6	3	2015-11-24 17:19:28.289469	2015-11-24 17:19:28.289469	2015-10-24-428	png	647	1961	586951	\N	264
265	1	6	3	2015-11-24 17:20:31.264319	2015-11-24 17:20:31.264319	yamal	png	1358	3991	1043870	\N	265
266	1	6	3	2015-11-24 17:20:55.673256	2015-11-24 17:20:55.673256	2015-10-24-428	png	647	1961	586951	\N	266
267	1	6	3	2015-11-24 17:21:18.387404	2015-11-24 17:21:18.387404	yamal	png	1358	3991	1043870	\N	267
270	1	6	3	2015-11-24 18:38:19.789468	2015-11-24 18:38:19.789468	yamal	png	1358	3991	1043870	\N	270
271	1	6	3	2015-11-24 18:39:43.613685	2015-11-24 18:39:43.613685	yamal	png	1358	3991	1043870	\N	271
272	1	6	3	2015-11-24 18:40:37.620738	2015-11-24 18:40:37.620738	yamal	png	1358	3991	1043870	\N	272
273	1	6	3	2015-11-24 23:56:58.36765	2015-11-24 23:56:58.36765	снимок экрана 2015-09-10 в 23.02.35	png	1920	906	455503	\N	273
274	1	6	3	2015-11-25 00:00:18.741271	2015-11-25 00:00:18.741271	снимок экрана 2015-09-18 в 2.00.41	png	1920	882	356722	\N	274
275	1	6	3	2015-11-25 00:03:19.10139	2015-11-25 00:03:19.10139	снимок экрана 2015-09-18 в 2.06.49	png	1920	883	357888	\N	275
276	1	6	3	2015-11-25 00:03:55.710862	2015-11-25 00:03:55.710862	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	276
277	1	6	3	2015-11-25 00:06:54.396058	2015-11-25 00:06:54.396058	b-day	jpg	720	480	51195	\N	277
278	1	6	3	2015-11-25 00:07:39.330353	2015-11-25 00:07:39.330353	tlh-1jnorxk	jpg	50	50	1730	\N	278
279	1	6	3	2015-11-25 00:08:28.457426	2015-11-25 00:08:28.457426	k1evq-yyw-w	jpg	403	604	25088	\N	279
280	1	6	3	2015-11-25 00:09:12.666875	2015-11-25 00:09:12.666875	снимок экрана 2015-10-04 в 18.25.14	png	642	321	8876	\N	280
281	1	6	3	2015-11-25 00:09:23.020396	2015-11-25 00:09:23.020396	снимок экрана 2015-09-18 в 2.00.41	png	1920	882	356722	\N	281
282	1	6	3	2015-11-25 00:10:46.811601	2015-11-25 00:10:46.811601	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	282
283	1	6	3	2015-11-25 00:11:56.563091	2015-11-25 00:11:56.563091	tlh-1jnorxk	jpg	50	50	1730	\N	283
284	1	6	3	2015-11-25 00:19:36.39817	2015-11-25 00:19:36.39817	снимок экрана 2015-09-10 в 23.02.35	png	1920	906	455503	\N	284
285	1	6	3	2015-11-25 00:19:51.891756	2015-11-25 00:19:51.891756	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	285
286	1	6	3	2015-11-25 00:22:20.631184	2015-11-25 00:22:20.631184	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	286
287	1	6	3	2015-11-25 00:25:07.12081	2015-11-25 00:25:07.12081	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	287
288	1	6	3	2015-11-25 00:30:45.680103	2015-11-25 00:30:45.680103	снимок экрана 2015-10-18 в 1.31.45	png	371	502	53096	\N	288
289	1	6	3	2015-11-25 11:37:14.744808	2015-11-25 11:37:14.744808	back	png	90	156	2521	\N	289
290	1	6	3	2015-11-25 11:38:28.588302	2015-11-25 11:38:28.588302	back	png	90	156	2521	\N	290
291	1	6	3	2015-11-25 11:38:54.023655	2015-11-25 11:38:54.023655	back	png	90	156	2521	\N	291
292	1	6	3	2015-11-25 11:41:34.717261	2015-11-25 11:41:34.717261	back	png	90	156	2521	\N	292
293	1	6	3	2015-11-25 11:42:07.718793	2015-11-25 11:42:07.718793	back	png	90	156	2521	\N	293
294	1	6	3	2015-11-25 11:46:48.996542	2015-11-25 11:46:48.996542	back	png	90	156	2521	\N	294
295	1	6	3	2015-11-25 11:47:14.813737	2015-11-25 11:47:14.813737	bg1	png	2560	2245	925553	\N	295
296	1	6	3	2015-11-25 11:50:38.131376	2015-11-25 11:50:38.131376	bg1	png	2560	2245	925553	\N	296
297	1	6	3	2015-11-25 11:52:59.66525	2015-11-25 11:52:59.66525	bg1	png	2560	2245	925553	\N	297
298	1	6	3	2015-11-25 11:54:02.13417	2015-11-25 11:54:02.13417	bg1	png	2560	2245	925553	\N	298
299	1	6	3	2015-11-25 12:35:52.79634	2015-11-25 12:35:52.79634	forward	png	90	156	4578	\N	299
300	1	6	3	2015-11-25 16:05:00.012287	2015-11-25 16:05:00.012287	back	png	90	156	2521	\N	300
301	1	6	3	2015-11-25 16:30:44.088797	2015-11-25 16:30:44.088797	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	301
302	1	6	3	2015-11-25 16:37:48.001876	2015-11-25 16:37:48.001876	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	302
303	1	6	3	2015-11-26 13:33:15.158959	2015-11-26 13:33:15.158959	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	303
304	1	6	3	2015-11-28 16:24:50.734833	2015-11-28 16:24:50.734833	img_20151128_162049	jpg	1536	2048	128367	\N	304
305	1	6	3	2015-12-08 16:06:08.087211	2015-12-08 16:06:08.087211	img_20151208_170422	jpg	1440	2560	128616	\N	305
306	1	6	3	2015-12-08 16:09:42.112078	2015-12-08 16:09:42.112078	img_20151208_170653	jpg	1440	2560	183940	\N	306
307	1	6	3	2015-12-08 16:25:25.996314	2015-12-08 16:25:25.996314	284	jpg	2560	1440	134529	\N	307
308	1	6	3	2015-12-08 17:38:16.885242	2015-12-08 17:38:16.885242	8	jpg	200	216	57465	\N	308
309	1	6	3	2015-12-08 17:39:33.231276	2015-12-08 17:39:33.231276	10	jpg	200	216	57465	\N	309
310	1	6	3	2015-12-08 17:42:37.935235	2015-12-08 17:42:37.935235	8	jpg	2640	3960	4243136	\N	310
311	1	6	3	2015-12-08 19:42:06.559013	2015-12-08 19:42:06.559013	10	jpg	2640	3960	4243136	\N	311
312	1	6	3	2015-12-09 14:20:21.892453	2015-12-09 14:20:21.892453	img_20151209_151755	jpg	1440	2560	154641	\N	312
313	1	6	3	2015-12-09 18:16:30.673369	2015-12-09 18:16:30.673369	img_20151209_191113	jpg	1440	2560	113749	\N	313
314	1	6	3	2015-12-09 18:16:31.35145	2015-12-09 18:16:31.35145	img_20151209_191120	jpg	1440	2560	99941	\N	314
315	1	6	3	2015-12-09 18:16:32.025536	2015-12-09 18:16:32.025536	img_20151209_191125	jpg	1440	2560	115056	\N	315
316	1	6	3	2015-12-09 18:16:32.71331	2015-12-09 18:16:32.71331	img_20151209_191130	jpg	1440	2560	111303	\N	316
317	1	6	3	2015-12-09 18:16:33.394143	2015-12-09 18:16:33.394143	img_20151209_191136	jpg	1440	2560	116419	\N	317
318	1	6	3	2015-12-09 18:16:34.199692	2015-12-09 18:16:34.199692	img_20151209_191141	jpg	1440	2560	112407	\N	318
319	1	6	3	2015-12-09 18:16:34.872667	2015-12-09 18:16:34.872667	img_20151209_191146	jpg	1440	2560	108461	\N	319
320	1	6	3	2015-12-09 18:16:35.677884	2015-12-09 18:16:35.677884	img_20151209_191200	jpg	1440	2560	119204	\N	320
321	1	6	3	2015-12-09 18:16:36.623475	2015-12-09 18:16:36.623475	img_20151209_191205	jpg	1440	2560	119845	\N	321
322	1	6	3	2015-12-09 23:44:08.335646	2015-12-09 23:44:08.335646	8	jpg	2592	1936	1186816	\N	322
323	1	6	3	2015-12-10 14:08:17.0972	2015-12-10 14:08:17.0972	img_20151210_150432	jpg	480	640	9205	\N	323
324	1	6	3	2015-12-10 15:37:16.883355	2015-12-10 15:37:16.883355	8	jpg	1024	768	780831	\N	324
325	1	6	3	2015-12-14 13:21:15.429478	2015-12-14 13:21:15.429478	img_20151214_141923	jpg	1440	2560	119274	\N	325
326	1	6	3	2015-12-14 13:21:16.160667	2015-12-14 13:21:16.160667	img_20151214_141928	jpg	1440	2560	135247	\N	326
327	1	6	3	2015-12-14 13:21:18.555034	2015-12-14 13:21:18.555034	img_20151214_141916	jpg	1440	2560	111274	\N	327
328	1	6	3	2015-12-14 13:25:14.274133	2015-12-14 13:25:14.274133	8	jpg	2560	1600	2399175	\N	328
329	1	6	3	2015-12-14 13:25:16.249343	2015-12-14 13:25:16.249343	10	jpg	4800	3000	1304017	\N	329
330	4	6	3	2015-12-21 19:25:19.47295	2015-12-21 19:25:19.47295	приложение б	dwg	\N	\N	15461059	\N	330
331	4	6	3	2015-12-21 19:26:06.989072	2015-12-21 19:26:06.989072	приложение б	dwg	\N	\N	15461059	\N	331
332	4	6	3	2015-12-22 13:09:09.466709	2015-12-22 13:09:09.466709	приложение б	dwg	\N	\N	15461059	\N	332
333	4	6	3	2015-12-22 13:36:34.740157	2015-12-22 13:36:34.740157	приложение б	dwg	\N	\N	15461059	\N	333
334	4	6	3	2015-12-22 13:37:27.273956	2015-12-22 13:37:27.273956	приложение б	dwg	\N	\N	15461059	\N	334
335	4	6	3	2015-12-22 13:41:15.627411	2015-12-22 13:41:15.627411	приложение б	dwg	\N	\N	15461059	\N	335
337	4	6	3	2015-12-22 13:48:42.187309	2015-12-22 13:48:42.187309	приложение б	dwg	\N	\N	15461059	\N	337
338	4	6	3	2015-12-22 13:59:37.893656	2015-12-22 13:59:37.893656	приложение б	dwg	\N	\N	15461059	\N	338
339	4	6	3	2015-12-22 14:04:19.748399	2015-12-22 14:04:19.748399	1.общая схема кц	dwg	\N	\N	12052299	\N	339
340	4	6	3	2015-12-22 14:10:12.22835	2015-12-22 14:10:12.22835	1.общая схема кц	dxf	\N	\N	84365174	\N	340
341	4	6	3	2015-12-22 14:15:33.242315	2015-12-22 14:15:33.242315	приложение б	dwg	\N	\N	15461059	\N	341
342	4	6	3	2015-12-22 14:17:18.65481	2015-12-22 14:17:18.65481	приложение б	dwg	\N	\N	15461059	\N	342
343	4	6	3	2015-12-22 14:24:02.846038	2015-12-22 14:24:02.846038	test_1	dwg	\N	\N	15461059	\N	343
344	4	6	3	2015-12-22 14:41:57.147326	2015-12-22 14:41:57.147326	test_2	dwg	\N	\N	15507024	\N	344
345	4	6	3	2015-12-22 16:07:14.566556	2015-12-22 16:07:14.566556	test_3	dwg	\N	\N	7754354	\N	345
346	4	6	3	2015-12-22 16:21:22.146797	2015-12-22 16:21:22.146797	test_4	dwg	\N	\N	12052299	\N	346
347	4	6	3	2015-12-22 19:17:04.194015	2015-12-22 19:17:04.194015	test_5	dwg	\N	\N	2696778	\N	347
348	4	6	3	2015-12-23 13:43:22.608365	2015-12-23 13:43:22.608365	test_6pdf	pdf	\N	\N	65549	\N	348
349	4	6	3	2015-12-23 14:15:29.951988	2015-12-23 14:15:29.951988	test_7pdf	pdf	\N	\N	2616300	\N	349
350	4	6	3	2015-12-23 15:11:33.971728	2015-12-23 15:11:33.971728	test_6_1pdf	pdf	\N	\N	64827	\N	350
351	4	6	3	2015-12-23 15:59:37.690069	2015-12-23 15:59:37.690069	кс-4 гтп_ книга 2 приложение в тсг	dwg	\N	\N	4230017	\N	351
352	4	6	3	2015-12-23 16:01:12.369318	2015-12-23 16:01:12.369318	кс-4 гтп_ книга 2 приложение в тсг	dwg	\N	\N	4230017	\N	352
353	4	6	3	2015-12-23 17:41:15.742578	2015-12-23 17:41:15.742578	приложение	dwg	\N	\N	193802	\N	353
354	4	6	3	2015-12-23 17:43:05.035249	2015-12-23 17:43:05.035249	приложение	dwg	\N	\N	1813462	\N	354
355	1	6	3	2015-12-23 17:44:13.667549	2015-12-23 17:44:13.667549	поз.18 оси после 17	png	4981	1536	907974	\N	355
356	4	6	3	2015-12-23 17:47:31.243319	2015-12-23 17:47:31.243319	приложение 3 схема расположения сети гтм_2.1	dwg	\N	\N	1164469	\N	356
357	4	6	3	2015-12-23 17:47:44.173952	2015-12-23 17:47:44.173952	приложение 3 схема расположения сети гтм_2.3	dwg	\N	\N	1029504	\N	357
358	4	6	3	2015-12-23 17:47:53.97896	2015-12-23 17:47:53.97896	приложение 3 схема расположения сети гтм_2.5	dwg	\N	\N	1082144	\N	358
359	4	6	3	2015-12-23 17:48:05.292988	2015-12-23 17:48:05.292988	приложение 3 схема расположения сети гтм_общая схема	dwg	\N	\N	1203488	\N	359
360	4	6	3	2015-12-23 17:48:16.97628	2015-12-23 17:48:16.97628	приложение 4  конструкция термометрической скважины тс, l=10м	dwg	\N	\N	448808	\N	360
361	4	6	3	2015-12-23 17:48:26.740848	2015-12-23 17:48:26.740848	приложение 5  конструкция грунтового геодезического репера	dwg	\N	\N	150120	\N	361
362	4	6	3	2015-12-23 17:48:35.130618	2015-12-23 17:48:35.130618	приложение 6  конструкция и спецификация деформационной марки на оголовке сваи (тип б)	dwg	\N	\N	157290	\N	362
363	4	6	3	2015-12-23 17:48:43.279919	2015-12-23 17:48:43.279919	приложение 7   деформационная марка тип г	dwg	\N	\N	132979	\N	363
364	4	6	3	2015-12-23 17:56:29.617019	2015-12-23 17:56:29.617019	приложение б	dwg	\N	\N	15461059	\N	364
365	4	6	3	2015-12-23 18:04:34.219558	2015-12-23 18:04:34.219558	приложение б л.1-5	dwg	\N	\N	15507024	\N	365
366	4	6	3	2015-12-23 18:05:45.89001	2015-12-23 18:05:45.89001	приложение б л.6-53	dwg	\N	\N	1757388	\N	366
367	4	6	3	2015-12-23 18:06:05.906045	2015-12-23 18:06:05.906045	приложение б. л.54-71	dwg	\N	\N	1780785	\N	367
368	4	6	3	2015-12-23 18:08:50.088358	2015-12-23 18:08:50.088358	лист 1	dwg	\N	\N	7750965	\N	368
369	4	6	3	2015-12-23 18:10:36.97084	2015-12-23 18:10:36.97084	лист 2	dwg	\N	\N	7754354	\N	369
370	4	6	3	2015-12-23 18:17:20.986076	2015-12-23 18:17:20.986076	кс-4 гтп_ книга 2 приложение в тсг	dwg	\N	\N	4230017	\N	370
371	4	6	3	2015-12-23 18:17:36.974038	2015-12-23 18:17:36.974038	кс-4 гтп_ книга 2 приложение а - копия	dwg	\N	\N	2696778	\N	371
372	4	6	3	2015-12-23 18:17:56.380801	2015-12-23 18:17:56.380801	кс-4 гтп книга 2 приложение б	dwg	\N	\N	5981350	\N	372
373	4	6	3	2015-12-23 18:23:57.830608	2015-12-23 18:23:57.830608	приложение	dwg	\N	\N	193802	\N	373
374	4	6	3	2015-12-23 18:25:51.601333	2015-12-23 18:25:51.601333	приложение	dwg	\N	\N	1813462	\N	374
375	4	6	3	2015-12-23 18:26:04.005941	2015-12-23 18:26:04.005941	приложение а_лист 1	dwg	\N	\N	377833	\N	375
376	4	6	3	2015-12-23 18:26:13.065899	2015-12-23 18:26:13.065899	приложение а_лист 2	dwg	\N	\N	342321	\N	376
377	4	6	3	2015-12-23 18:26:21.398948	2015-12-23 18:26:21.398948	приложение а_лист 3	dwg	\N	\N	344780	\N	377
378	4	6	3	2015-12-23 18:26:29.069987	2015-12-23 18:26:29.069987	приложение а_лист 4	dwg	\N	\N	373895	\N	378
379	4	6	3	2015-12-23 18:26:38.49176	2015-12-23 18:26:38.49176	приложение а_лист 5	dwg	\N	\N	395383	\N	379
380	4	6	3	2015-12-23 18:26:46.292266	2015-12-23 18:26:46.292266	приложение а_лист 6	dwg	\N	\N	393127	\N	380
381	4	6	3	2015-12-23 18:26:53.838055	2015-12-23 18:26:53.838055	приложение а_лист 7	dwg	\N	\N	390978	\N	381
382	4	6	3	2015-12-23 18:27:20.755065	2015-12-23 18:27:20.755065	приложение а_лист 9	dwg	\N	\N	381482	\N	382
383	4	6	3	2015-12-23 18:28:07.490087	2015-12-23 18:28:07.490087	приложение а_лист 8	dwg	\N	\N	386040	\N	383
384	4	6	3	2015-12-23 18:53:09.376156	2015-12-23 18:53:09.376156	приложение 3 схема расположения сети гтм_2.1	dwg	\N	\N	1164469	\N	384
385	4	6	3	2015-12-23 19:01:05.478293	2015-12-23 19:01:05.478293	а0_в	dwg	\N	\N	94976	\N	385
386	4	6	3	2015-12-23 19:55:05.629074	2015-12-23 19:55:05.629074	а4_в_t1	dwg	\N	\N	43899	\N	386
387	4	6	3	2015-12-24 13:01:55.520889	2015-12-24 13:01:55.520889	приложение а_лист 1_dwg	dwg	\N	\N	330528	\N	387
388	4	6	3	2015-12-24 13:22:11.662156	2015-12-24 13:22:11.662156	test_format_a4	dwg	\N	\N	29196	\N	388
389	4	6	3	2015-12-24 13:22:59.964269	2015-12-24 13:22:59.964269	test_format_a4	dwg	\N	\N	59617	\N	389
390	4	6	3	2015-12-24 17:40:15.500874	2015-12-24 17:40:15.500874	format_a4	dwg	\N	\N	44890	\N	390
391	4	6	3	2015-12-24 17:42:19.180195	2015-12-24 17:42:19.180195	а4_в_pdf4	dwg	\N	\N	53510	\N	391
392	4	6	3	2015-12-24 17:56:11.374834	2015-12-24 17:56:11.374834	а4_в_dwg5	dwg	\N	\N	55238	\N	392
401	1	6	3	2015-12-25 13:27:55.07479	2015-12-25 13:27:55.07479	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	401
394	1	6	3	2015-12-25 13:06:59.643664	2015-12-25 13:06:59.643664	ff9941ce-c9c4-433a-9f45-c43626f123a1	png	4205	5945	835342	\N	394
395	1	6	3	2015-12-25 13:18:43.813434	2015-12-25 13:18:43.813434	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	395
396	1	6	3	2015-12-25 13:23:42.889653	2015-12-25 13:23:42.889653	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	396
397	1	6	3	2015-12-25 13:24:29.642477	2015-12-25 13:24:29.642477	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	397
398	1	6	3	2015-12-25 13:24:37.307281	2015-12-25 13:24:37.307281	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	398
399	1	6	3	2015-12-25 13:24:50.389813	2015-12-25 13:24:50.389813	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	399
400	1	6	3	2015-12-25 13:25:11.543877	2015-12-25 13:25:11.543877	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	400
402	1	6	3	2015-12-25 13:31:05.052551	2015-12-25 13:31:05.052551	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	402
403	1	6	3	2015-12-25 13:31:11.273263	2015-12-25 13:31:11.273263	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	403
404	1	6	3	2015-12-25 13:31:31.46995	2015-12-25 13:31:31.46995	bfb33d1f-d0aa-4fcd-a599-5a2da9238941	png	2100	2970	255427	\N	404
405	1	6	3	2015-12-25 14:40:17.016689	2015-12-25 14:40:17.016689	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	405
406	1	6	3	2015-12-25 15:50:23.70017	2015-12-25 15:50:23.70017	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	406
407	1	6	3	2015-12-25 15:50:30.264996	2015-12-25 15:50:30.264996	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	407
408	1	6	3	2015-12-25 15:53:41.058936	2015-12-25 15:53:41.058936	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	408
409	1	6	3	2015-12-25 15:54:07.766862	2015-12-25 15:54:07.766862	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	409
410	1	6	3	2015-12-25 15:56:25.53544	2015-12-25 15:56:25.53544	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	410
411	1	6	3	2015-12-25 15:56:48.116263	2015-12-25 15:56:48.116263	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	411
412	1	6	3	2015-12-25 15:57:20.580476	2015-12-25 15:57:20.580476	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	412
413	1	6	3	2015-12-25 15:58:20.589598	2015-12-25 15:58:20.589598	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	413
414	1	6	3	2015-12-25 15:58:30.540984	2015-12-25 15:58:30.540984	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	414
415	1	6	3	2015-12-25 15:58:48.038595	2015-12-25 15:58:48.038595	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	415
416	1	6	3	2015-12-25 15:59:31.704434	2015-12-25 15:59:31.704434	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	416
417	1	6	3	2015-12-25 15:59:46.908331	2015-12-25 15:59:46.908331	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	417
418	1	6	3	2015-12-25 16:01:12.5738	2015-12-25 16:01:12.5738	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	418
419	1	6	3	2015-12-25 16:02:01.234811	2015-12-25 16:02:01.234811	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	419
420	1	6	3	2015-12-25 16:02:21.64306	2015-12-25 16:02:21.64306	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	420
421	1	6	3	2015-12-25 16:02:44.931294	2015-12-25 16:02:44.931294	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d	png	4205	5945	693635	\N	421
422	4	6	3	2015-12-25 19:48:24.911792	2015-12-25 19:48:24.911792	чертеж8	dwg	\N	\N	377633	\N	422
423	1	6	3	2015-12-25 19:53:41.275725	2015-12-25 19:53:41.275725	1a6c79a3-5876-483c-b1c5-728b51e5305a	png	4205	5945	1247626	\N	423
424	1	6	3	2015-12-25 19:55:28.063781	2015-12-25 19:55:28.063781	1a6c79a3-5876-483c-b1c5-728b51e5305a	png	4205	5945	1247626	\N	424
425	4	6	3	2015-12-25 19:56:00.227458	2015-12-25 19:56:00.227458	приложение а_лист 1_dwg	dwg	\N	\N	330528	\N	425
427	1	6	3	2015-12-25 20:04:15.521031	2015-12-25 20:04:15.521031	3b85113a-d1cf-4a3c-bd5d-fa48ba353fb4	png	5046	7134	1382338	\N	427
428	1	6	3	2015-12-25 20:04:53.578717	2015-12-25 20:04:53.578717	3b85113a-d1cf-4a3c-bd5d-fa48ba353fb4	png	5046	7134	1382338	\N	428
429	4	6	3	2015-12-28 15:13:45.241743	2015-12-28 15:13:45.241743	а4_в_test1	dwg	\N	\N	63714	\N	429
430	4	6	3	2015-12-28 17:07:02.446435	2015-12-28 17:07:02.446435	а4_в_test1	dwg	\N	\N	121874	\N	430
431	4	6	3	2015-12-28 17:08:16.197913	2015-12-28 17:08:16.197913	а4_в_test1	dwg	\N	\N	121874	\N	431
432	4	6	3	2015-12-28 17:09:02.17262	2015-12-28 17:09:02.17262	а4_в_test1_2	dwg	\N	\N	121874	\N	432
433	4	6	3	2015-12-28 17:14:44.340287	2015-12-28 17:14:44.340287	а4_в_test1_3	dwg	\N	\N	116098	\N	433
440	4	14	3	2016-01-11 12:39:57.923182	2016-01-11 12:39:57.923182	model_1pdf	pdf	\N	\N	10200	\N	440
441	4	14	3	2016-01-11 12:39:57.923182	2016-01-11 12:39:57.923182	model_1dwg	dwg	\N	\N	49433	\N	441
442	4	14	3	2016-01-11 12:46:55.394792	2016-01-11 12:46:55.394792	model_1pdf	pdf	\N	\N	10200	\N	442
443	4	14	3	2016-01-11 12:46:55.394792	2016-01-11 12:46:55.394792	model_1dwg	dwg	\N	\N	49433	\N	443
444	4	14	3	2016-01-11 12:48:14.987702	2016-01-11 12:48:14.987702	model_1pdf	pdf	\N	\N	10200	\N	444
445	4	14	3	2016-01-11 12:48:14.987702	2016-01-11 12:48:14.987702	model_1dwg	dwg	\N	\N	49433	\N	445
446	4	14	3	2016-01-11 12:48:43.834068	2016-01-11 12:48:43.834068	model_1pdf	pdf	\N	\N	10200	\N	446
447	4	14	3	2016-01-11 12:48:43.834068	2016-01-11 12:48:43.834068	model_1dwg	dwg	\N	\N	49433	\N	447
448	4	14	3	2016-01-11 13:50:19.334884	2016-01-11 13:50:19.334884	model_1pdf	pdf	\N	\N	10206	\N	448
449	4	14	3	2016-01-11 13:50:19.334884	2016-01-11 13:50:19.334884	model_1pdf	dwg	\N	\N	57507	\N	449
450	4	14	3	2016-01-11 14:26:05.616687	2016-01-11 14:26:05.616687	model_1pdf	pdf	\N	\N	10206	\N	450
451	4	14	3	2016-01-11 14:26:05.616687	2016-01-11 14:26:05.616687	model_1dwg	dwg	\N	\N	69113	\N	451
487	1	6	3	2016-01-13 17:31:13.339233	2016-01-13 17:31:13.339233	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	487
484	1	6	3	2016-01-13 17:27:56.575795	2016-01-13 17:27:56.575795	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	484
483	1	6	3	2016-01-13 17:27:56.545875	2016-01-13 17:27:56.545875	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	483
485	1	6	3	2016-01-13 17:28:03.421963	2016-01-13 17:28:03.421963	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	485
486	1	6	3	2016-01-13 17:30:34.268925	2016-01-13 17:30:34.268925	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	486
488	1	6	3	2016-01-13 17:34:09.019321	2016-01-13 17:34:09.019321	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	488
489	1	6	3	2016-01-13 17:36:00.399721	2016-01-13 17:36:00.399721	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	489
490	1	6	3	2016-01-13 17:37:51.225682	2016-01-13 17:37:51.225682	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	490
491	1	6	3	2016-01-13 17:38:31.521436	2016-01-13 17:38:31.521436	beautiful_stream-widescreen_wallpapers	jpg	2560	1600	2399175	\N	491
492	1	6	3	2016-01-13 17:45:00.171032	2016-01-13 17:45:00.171032	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	492
493	1	6	3	2016-01-13 17:45:01.404507	2016-01-13 17:45:01.404507	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	493
494	1	6	3	2016-01-13 17:45:02.896115	2016-01-13 17:45:02.896115	beautiful_stream-widescreen_wallpapers	jpg	2560	1600	2399175	\N	494
530	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a3x5_g_1486x420	dwg	\N	\N	41660	\N	530
500	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a1_g_841x594	pdf	\N	\N	9237	\N	500
501	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a1_v_594x841	pdf	\N	\N	9229	\N	501
502	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a1x2_594x1682_v	pdf	\N	\N	9228	\N	502
503	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a1x2_g_841x1189	pdf	\N	\N	9244	\N	503
504	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a1x3_g_1783x841	pdf	\N	\N	9230	\N	504
505	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a2_g_594x420	pdf	\N	\N	9231	\N	505
506	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a2_v_420x594	pdf	\N	\N	9164	\N	506
507	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a2x3_1261x594	pdf	\N	\N	9213	\N	507
508	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a2x3_v_594x1260	pdf	\N	\N	9218	\N	508
509	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a3_v_297x420	pdf	\N	\N	9166	\N	509
510	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a3x3_g_891x420	pdf	\N	\N	9226	\N	510
511	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a3x4_g_1189x420	pdf	\N	\N	9234	\N	511
512	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a3x5_g_1486x420	pdf	\N	\N	9210	\N	512
513	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a3x6_g_1682x420	pdf	\N	\N	9211	\N	513
514	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a4_v_210x297	pdf	\N	\N	9121	\N	514
515	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a4x3_g_630x297	pdf	\N	\N	9231	\N	515
516	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a4x6_g_1260x297	pdf	\N	\N	9226	\N	516
517	4	12	11	2016-01-15 18:13:44.315093	2016-01-15 18:13:44.315093	a4x8_g_1680x297	pdf	\N	\N	9220	\N	517
518	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a1_g_841x594	dwg	\N	\N	41182	\N	518
519	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a1_v_594x841	dwg	\N	\N	41114	\N	519
520	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a1x2_594x1682_v	dwg	\N	\N	41500	\N	520
521	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a1x2_g_841x1189	dwg	\N	\N	41213	\N	521
522	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a1x3_g_1783x841	dwg	\N	\N	41502	\N	522
523	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a2_g_594x420	dwg	\N	\N	41146	\N	523
524	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a2_v_420x594	dwg	\N	\N	41820	\N	524
525	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a2x3_1261x594	dwg	\N	\N	41630	\N	525
526	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a2x3_v_594x1260	dwg	\N	\N	41566	\N	526
527	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a3_v_297x420	dwg	\N	\N	41560	\N	527
528	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a3x3_g_891x420	dwg	\N	\N	41564	\N	528
529	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a3x4_g_1189x420	dwg	\N	\N	41434	\N	529
531	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a3x6_g_1682x420	dwg	\N	\N	41501	\N	531
532	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a4_v_210x297	dwg	\N	\N	41370	\N	532
533	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a4x3_g_630x297	dwg	\N	\N	41721	\N	533
534	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a4x6_g_1260x297	dwg	\N	\N	42842	\N	534
535	4	13	11	2016-01-15 18:14:18.863104	2016-01-15 18:14:18.863104	a4x8_g_1680x297	dwg	\N	\N	41534	\N	535
536	4	14	3	2016-01-15 19:17:16.43725	2016-01-15 19:17:16.43725	a1_g_test_pdf	pdf	\N	\N	284855	\N	536
537	4	14	3	2016-01-15 19:17:16.43725	2016-01-15 19:17:16.43725	a1_g_test_dwg	dwg	\N	\N	147889	\N	537
538	4	14	3	2016-01-15 19:23:56.051979	2016-01-15 19:23:56.051979	a3x6_test_pdf	pdf	\N	\N	234849	\N	538
539	4	14	3	2016-01-15 19:23:56.051979	2016-01-15 19:23:56.051979	a3x6_test_dwg	dwg	\N	\N	335284	\N	539
540	4	14	3	2016-01-16 18:56:33.40192	2016-01-16 18:56:33.40192	a2x3_v_pdf	pdf	\N	\N	9812	\N	540
541	4	14	3	2016-01-16 18:56:33.40192	2016-01-16 18:56:33.40192	a2x3_v_dwg	dwg	\N	\N	72820	\N	541
542	4	14	3	2016-01-18 16:12:29.335377	2016-01-18 16:12:29.335377	a1x2_g_pdf	pdf	\N	\N	165747	\N	542
543	4	14	3	2016-01-18 16:12:29.335377	2016-01-18 16:12:29.335377	a1x2_g_dwg	dwg	\N	\N	118722	\N	543
544	4	14	3	2016-01-18 17:00:43.145247	2016-01-18 17:00:43.145247	a1x2_g_pdf	pdf	\N	\N	165747	\N	544
545	4	14	3	2016-01-18 17:00:43.145247	2016-01-18 17:00:43.145247	a1x2_g_dwg_2	dwg	\N	\N	136874	\N	545
546	4	14	3	2016-01-18 17:34:20.521152	2016-01-18 17:34:20.521152	a1_g_data_pdf	pdf	\N	\N	1205	\N	546
547	4	14	3	2016-01-18 17:34:20.521152	2016-01-18 17:34:20.521152	a1_g_data_dwg	dwg	\N	\N	41050	\N	547
548	4	14	3	2016-01-18 17:40:04.81076	2016-01-18 17:40:04.81076	a1_g_data_pdf	pdf	\N	\N	1205	\N	548
549	4	14	3	2016-01-18 17:40:04.81076	2016-01-18 17:40:04.81076	a1_g_data_dwg	dwg	\N	\N	41050	\N	549
550	4	14	3	2016-01-18 18:47:04.310489	2016-01-18 18:47:04.310489	a3x3_g_test_pdf	pdf	\N	\N	93219	\N	550
551	4	14	3	2016-01-18 18:47:04.310489	2016-01-18 18:47:04.310489	a3x3_g_test_dwg	dxf	\N	\N	636425	\N	551
552	4	14	3	2016-01-19 12:32:13.090002	2016-01-19 12:32:13.090002	тестовый_a3x5_g_pdf	pdf	\N	\N	232055	\N	552
553	4	14	3	2016-01-19 12:32:13.090002	2016-01-19 12:32:13.090002	тестовый_a3x5_g_dwg	dwg	\N	\N	334523	\N	553
554	4	14	3	2016-01-19 13:48:31.875751	2016-01-19 13:48:31.875751	a2_v_test_pdf	pdf	\N	\N	143587	\N	554
555	4	14	3	2016-01-19 13:48:31.875751	2016-01-19 13:48:31.875751	a2_v_test_dwg	dwg	\N	\N	82606	\N	555
556	4	14	3	2016-01-19 15:15:57.048263	2016-01-19 15:15:57.048263	525	pdf	\N	\N	66212	\N	556
557	4	14	3	2016-01-19 15:15:57.048263	2016-01-19 15:15:57.048263	525	dwg	\N	\N	249722	\N	557
558	4	14	3	2016-01-25 18:13:05.183301	2016-01-25 18:13:05.183301	тестовый_a3x5_g_pdf	pdf	\N	\N	232055	\N	558
559	4	14	3	2016-01-29 16:47:56.577496	2016-01-29 16:47:56.577496	a1_g_test_pdf	pdf	\N	\N	284855	\N	559
560	4	14	3	2016-02-03 16:12:51.465416	2016-02-03 16:12:51.465416	a3x3_g_test_pdf	pdf	\N	\N	93219	\N	560
561	4	14	3	2016-02-03 16:21:49.131192	2016-02-03 16:21:49.131192	a1x2_g_pdf	pdf	\N	\N	165747	\N	561
562	4	14	3	2016-02-03 16:26:30.09111	2016-02-03 16:26:30.09111	a2x3_v_pdf	pdf	\N	\N	9812	\N	562
563	4	14	3	2016-02-05 16:42:36.153821	2016-02-05 16:42:36.153821	тестовый_a3x5_g_pdf	pdf	\N	\N	232055	\N	563
564	1	14	3	2016-02-05 17:57:18.457435	2016-02-05 17:57:18.457435	undefinedtmp_img	jpg	2526	1191	149921	\N	564
594	1	6	3	2016-02-08 15:14:13.335632	2016-02-08 15:14:13.335632	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	594
595	1	6	3	2016-02-08 15:14:13.335632	2016-02-08 15:14:13.335632	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	595
570	4	14	3	2016-02-05 18:11:20.154202	2016-02-05 18:11:20.154202	a1_g_test_pdf	pdf	\N	\N	284855	\N	570
571	1	14	3	2016-02-05 18:11:20.154202	2016-02-05 18:11:20.154202	undefinedtmp_img	jpg	2384	1684	90964	\N	571
572	4	14	3	2016-02-05 18:54:09.912462	2016-02-05 18:54:09.912462	a2x3_v_pdf	pdf	\N	\N	9812	\N	572
573	1	14	3	2016-02-05 18:54:09.912462	2016-02-05 18:54:09.912462	undefinedtmp_img	jpg	1684	3572	103391	\N	573
574	4	14	3	2016-02-05 18:54:32.878676	2016-02-05 18:54:32.878676	a2_v_test_pdf	pdf	\N	\N	143587	\N	574
575	1	14	3	2016-02-05 18:54:32.878676	2016-02-05 18:54:32.878676	undefinedtmp_img	jpg	1191	1684	73609	\N	575
576	4	14	3	2016-02-05 18:54:58.93275	2016-02-05 18:54:58.93275	a2x3_v_pdf	pdf	\N	\N	9812	\N	576
577	1	14	3	2016-02-05 18:54:58.93275	2016-02-05 18:54:58.93275	undefinedtmp_img	jpg	1684	3572	103391	\N	577
596	1	6	3	2016-02-08 15:14:13.335632	2016-02-08 15:14:13.335632	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	596
597	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	239188_zakat_les_vecher_priroda_leto_3005x2005_(www.gdefon.ru)	jpg	3005	2005	1680341	\N	597
598	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	735154_utrenniy_tuman_v_lesu	jpg	2560	1600	2823189	\N	598
599	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	beautiful_stream-widescreen_wallpapers	jpg	2560	1600	2399175	\N	599
587	1	6	3	2016-02-08 15:04:41.160261	2016-02-08 15:04:41.160261	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	587
588	1	6	3	2016-02-08 15:05:40.582097	2016-02-08 15:05:40.582097	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	588
589	1	6	3	2016-02-08 15:06:42.644165	2016-02-08 15:06:42.644165	735154_utrenniy_tuman_v_lesu	jpg	2560	1600	2823189	\N	589
590	1	6	3	2016-02-08 15:06:42.644165	2016-02-08 15:06:42.644165	beautiful_stream-widescreen_wallpapers	jpg	2560	1600	2399175	\N	590
591	1	6	3	2016-02-08 15:10:45.085277	2016-02-08 15:10:45.085277	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	591
592	1	6	3	2016-02-08 15:10:45.085277	2016-02-08 15:10:45.085277	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	592
593	1	6	3	2016-02-08 15:10:45.085277	2016-02-08 15:10:45.085277	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	593
600	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	600
601	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	601
602	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	602
603	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	603
604	1	6	3	2016-02-08 15:15:35.986847	2016-02-08 15:15:35.986847	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	604
605	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	239188_zakat_les_vecher_priroda_leto_3005x2005_(www.gdefon.ru)	jpg	3005	2005	1680341	\N	605
606	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	735154_utrenniy_tuman_v_lesu	jpg	2560	1600	2823189	\N	606
607	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	beautiful_stream-widescreen_wallpapers	jpg	2560	1600	2399175	\N	607
608	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	bezyimyannyij-b80uvk	jpg	650	510	125152	\N	608
609	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	609
610	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	610
611	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	611
612	1	6	3	2016-02-08 15:16:59.336368	2016-02-08 15:16:59.336368	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	612
613	1	6	3	2016-02-08 15:19:17.847558	2016-02-08 15:19:17.847558	cb54c619700f4eb583152fb8451	jpg	4800	3000	1304017	\N	613
614	1	6	3	2016-02-08 15:19:17.847558	2016-02-08 15:19:17.847558	nature-snow-trees-winter-2544954-1920x1200	jpg	1920	1200	774871	\N	614
615	1	6	3	2016-02-08 15:19:17.847558	2016-02-08 15:19:17.847558	polar_mesospheric_clouds-other	jpg	3200	2000	1120907	\N	615
616	1	6	3	2016-02-08 15:19:17.847558	2016-02-08 15:19:17.847558	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya	jpg	5760	3298	4775006	\N	616
617	4	14	3	2016-02-09 14:31:34.630792	2016-02-09 14:31:34.630792	test_7pdf	pdf	\N	\N	2616300	\N	617
618	4	14	3	2016-02-09 14:32:14.564521	2016-02-09 14:32:14.564521	test_7pdf	pdf	\N	\N	2616300	\N	618
619	4	14	3	2016-02-09 14:34:23.544104	2016-02-09 14:34:23.544104	test_7pdf	pdf	\N	\N	2616300	\N	619
620	4	14	3	2016-02-09 14:36:40.138903	2016-02-09 14:36:40.138903	test_7pdf	pdf	\N	\N	2616300	\N	620
621	4	14	3	2016-02-09 14:37:30.976426	2016-02-09 14:37:30.976426	test_7pdf	pdf	\N	\N	2616300	\N	621
622	4	14	3	2016-02-09 14:38:28.723743	2016-02-09 14:38:28.723743	test_7pdf	pdf	\N	\N	2616300	\N	622
623	4	14	3	2016-02-09 14:38:29.300325	2016-02-09 14:38:29.300325	test_7pdf	pdf	\N	\N	2616300	\N	623
624	4	14	3	2016-02-09 14:39:24.657219	2016-02-09 14:39:24.657219	test_7pdf	pdf	\N	\N	2616300	\N	624
625	4	14	3	2016-02-09 14:40:16.456616	2016-02-09 14:40:16.456616	test_7pdf	pdf	\N	\N	2616300	\N	625
626	4	14	3	2016-02-09 14:41:02.445019	2016-02-09 14:41:02.445019	test_7pdf	pdf	\N	\N	2616300	\N	626
627	4	14	3	2016-02-09 14:42:12.844856	2016-02-09 14:42:12.844856	test_7pdf	pdf	\N	\N	2616300	\N	627
628	4	14	3	2016-02-09 14:42:12.844856	2016-02-09 14:42:12.844856	undefinedtmp2	pdf	\N	\N	2621140	\N	628
629	1	14	3	2016-02-09 14:42:12.844856	2016-02-09 14:42:12.844856	undefinedtmp_img	jpg	2384	1684	601535	\N	629
630	4	14	3	2016-02-09 14:48:52.916346	2016-02-09 14:48:52.916346	a1_g_test_pdf	pdf	\N	\N	284855	\N	630
631	4	14	3	2016-02-09 14:48:52.916346	2016-02-09 14:48:52.916346	undefinedtmp2	pdf	\N	\N	203268	\N	631
632	1	14	3	2016-02-09 14:48:52.916346	2016-02-09 14:48:52.916346	undefinedtmp_img	jpg	2384	1684	90964	\N	632
633	4	14	3	2016-02-11 17:19:21.275309	2016-02-11 17:19:21.275309	снимок экрана 2016-02-11 в 17.18.15	pdf	\N	\N	308863	\N	633
634	4	14	3	2016-02-11 17:19:21.275309	2016-02-11 17:19:21.275309	undefinedtmp2	pdf	\N	\N	314761	\N	634
635	1	14	3	2016-02-11 17:19:21.275309	2016-02-11 17:19:21.275309	undefinedtmp_img	jpg	792	655	77489	\N	635
636	4	14	3	2016-02-11 17:20:55.246517	2016-02-11 17:20:55.246517	снимок экрана 2016-02-11 в 17.18.15	pdf	\N	\N	308863	\N	636
637	4	14	3	2016-02-11 17:20:55.246517	2016-02-11 17:20:55.246517	undefinedtmp2	pdf	\N	\N	314755	\N	637
638	1	14	3	2016-02-11 17:20:55.246517	2016-02-11 17:20:55.246517	undefinedtmp_img	jpg	792	655	77489	\N	638
639	4	14	3	2016-02-11 17:30:52.957577	2016-02-11 17:30:52.957577	a3x6_test_pdf	pdf	\N	\N	234849	\N	639
640	4	14	3	2016-02-11 17:30:52.957577	2016-02-11 17:30:52.957577	undefinedtmp2	pdf	\N	\N	174075	\N	640
641	1	14	3	2016-02-11 17:30:52.957577	2016-02-11 17:30:52.957577	undefinedtmp_img	jpg	4768	1191	217032	\N	641
642	4	14	3	2016-02-11 17:31:35.130147	2016-02-11 17:31:35.130147	a3x6_test_pdf	pdf	\N	\N	234849	\N	642
643	4	14	3	2016-02-11 17:31:35.130147	2016-02-11 17:31:35.130147	undefinedtmp2	pdf	\N	\N	174104	\N	643
644	1	14	3	2016-02-11 17:31:35.130147	2016-02-11 17:31:35.130147	undefinedtmp_img	jpg	4768	1191	217032	\N	644
645	4	14	3	2016-02-11 17:35:15.450972	2016-02-11 17:35:15.450972	тестовый_a3x5_g_pdf	pdf	\N	\N	232055	\N	645
646	4	14	3	2016-02-11 17:35:15.450972	2016-02-11 17:35:15.450972	undefinedtmp2	pdf	\N	\N	172492	\N	646
647	1	14	3	2016-02-11 17:35:15.450972	2016-02-11 17:35:15.450972	undefinedtmp_img	jpg	4768	1191	217252	\N	647
648	4	14	3	2016-02-11 17:36:13.388044	2016-02-11 17:36:13.388044	a3x3_g_test_pdf	pdf	\N	\N	93219	\N	648
649	4	14	3	2016-02-11 17:36:13.388044	2016-02-11 17:36:13.388044	undefinedtmp2	pdf	\N	\N	81980	\N	649
650	1	14	3	2016-02-11 17:36:13.388044	2016-02-11 17:36:13.388044	undefinedtmp_img	jpg	2526	1191	149921	\N	650
651	4	14	3	2016-02-11 17:38:49.989566	2016-02-11 17:38:49.989566	a2_v_test_pdf	pdf	\N	\N	143587	\N	651
652	4	14	3	2016-02-11 17:38:49.989566	2016-02-11 17:38:49.989566	undefinedtmp2	pdf	\N	\N	97429	\N	652
653	1	14	3	2016-02-11 17:38:49.989566	2016-02-11 17:38:49.989566	undefinedtmp_img	jpg	1191	1684	73609	\N	653
654	4	14	3	2016-02-11 17:39:21.045879	2016-02-11 17:39:21.045879	a2x3_v_pdf	pdf	\N	\N	9812	\N	654
655	4	14	3	2016-02-11 17:39:21.045879	2016-02-11 17:39:21.045879	undefinedtmp2	pdf	\N	\N	16343	\N	655
656	1	14	3	2016-02-11 17:39:21.045879	2016-02-11 17:39:21.045879	undefinedtmp_img	jpg	1684	3572	103391	\N	656
657	4	14	3	2016-02-11 17:40:34.717465	2016-02-11 17:40:34.717465	a1x2_g_pdf	pdf	\N	\N	165747	\N	657
658	4	14	3	2016-02-11 17:40:34.717465	2016-02-11 17:40:34.717465	undefinedtmp2	pdf	\N	\N	118353	\N	658
659	1	14	3	2016-02-11 17:40:34.717465	2016-02-11 17:40:34.717465	undefinedtmp_img	jpg	2384	3370	206355	\N	659
660	4	14	3	2016-02-11 17:41:31.167153	2016-02-11 17:41:31.167153	a1x2_g_pdf	pdf	\N	\N	165747	\N	660
661	4	14	3	2016-02-11 17:41:31.167153	2016-02-11 17:41:31.167153	undefinedtmp2	pdf	\N	\N	118358	\N	661
662	1	14	3	2016-02-11 17:41:31.167153	2016-02-11 17:41:31.167153	undefinedtmp_img	jpg	2384	3370	206355	\N	662
663	4	14	10	2016-02-16 16:43:18.944011	2016-02-16 16:43:18.944011	523_кс-2ярынская	pdf	\N	\N	122645	\N	663
664	4	14	10	2016-02-16 16:43:18.944011	2016-02-16 16:43:18.944011	undefinedtmp2	pdf	\N	\N	129992	\N	664
665	1	14	10	2016-02-16 16:43:18.944011	2016-02-16 16:43:18.944011	undefinedtmp_img	jpg	1684	1191	174326	\N	665
666	4	14	10	2016-02-16 16:43:18.944011	2016-02-16 16:43:18.944011	523_кс-2ярынская	dwg	\N	\N	326601	\N	666
667	4	14	10	2016-02-16 16:49:53.658979	2016-02-16 16:49:53.658979	поз. 1.3	pdf	\N	\N	300233	\N	667
668	4	14	10	2016-02-16 16:49:53.658979	2016-02-16 16:49:53.658979	undefinedtmp2	pdf	\N	\N	305466	\N	668
669	1	14	10	2016-02-16 16:49:53.658979	2016-02-16 16:49:53.658979	undefinedtmp_img	jpg	1786	842	157453	\N	669
670	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a0_v	dwg	\N	\N	41498	\N	670
671	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a0_v	pdf	\N	\N	7474	\N	671
672	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1_h	dwg	\N	\N	40955	\N	672
673	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1_h	pdf	\N	\N	7474	\N	673
674	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1_v	dwg	\N	\N	41210	\N	674
675	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1_v	pdf	\N	\N	7457	\N	675
676	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1x3_h	dwg	\N	\N	41371	\N	676
677	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a1x3_h	pdf	\N	\N	7468	\N	677
678	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2_h	dwg	\N	\N	41019	\N	678
679	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2_h	pdf	\N	\N	7477	\N	679
680	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2_v	dwg	\N	\N	41467	\N	680
681	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2_v	pdf	\N	\N	7486	\N	681
682	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2×4_v	dwg	\N	\N	41053	\N	682
683	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2×4_v	pdf	\N	\N	7475	\N	683
684	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2x3_h	dwg	\N	\N	41051	\N	684
685	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2x3_h	pdf	\N	\N	7451	\N	685
686	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2x3_v	dwg	\N	\N	41019	\N	686
687	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a2x3_v	pdf	\N	\N	7457	\N	687
688	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3_h	dwg	\N	\N	41402	\N	688
689	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3_h	pdf	\N	\N	7479	\N	689
690	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3_v	dwg	\N	\N	41594	\N	690
691	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3_v	pdf	\N	\N	7735	\N	691
692	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x3_h	dwg	\N	\N	41626	\N	692
693	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x3_h	pdf	\N	\N	7470	\N	693
694	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x4_h	dwg	\N	\N	41562	\N	694
695	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x4_h	pdf	\N	\N	7482	\N	695
696	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x5_h	dwg	\N	\N	41597	\N	696
697	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x5_h	pdf	\N	\N	7460	\N	697
698	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x6_h	dwg	\N	\N	41563	\N	698
699	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a3x6_h	pdf	\N	\N	7486	\N	699
700	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4_v	dwg	\N	\N	41688	\N	700
701	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4_v	pdf	\N	\N	7472	\N	701
702	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x3_h	dwg	\N	\N	41724	\N	702
703	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x3_h	pdf	\N	\N	7475	\N	703
704	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x6_h	dwg	\N	\N	41466	\N	704
705	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x6_h	pdf	\N	\N	7724	\N	705
706	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x8_h	dwg	\N	\N	41275	\N	706
707	4	15	3	2016-03-10 18:08:19.401703	2016-03-10 18:08:19.401703	a4x8_h	pdf	\N	\N	7466	\N	707
708	4	14	3	2016-03-10 18:47:15.010235	2016-03-10 18:47:15.010235	small_pdf	pdf	\N	\N	4209	\N	708
709	4	14	3	2016-03-10 18:47:15.010235	2016-03-10 18:47:15.010235	undefinedtmp2	pdf	\N	\N	10260	\N	709
710	1	14	3	2016-03-10 18:47:15.010235	2016-03-10 18:47:15.010235	undefinedtmp_img	jpg	283	283	615	\N	710
711	4	14	3	2016-03-10 18:48:37.331446	2016-03-10 18:48:37.331446	small_pdf	pdf	\N	\N	4209	\N	711
712	4	14	3	2016-03-10 18:48:37.331446	2016-03-10 18:48:37.331446	undefinedtmp2	pdf	\N	\N	10260	\N	712
713	1	14	3	2016-03-10 18:48:37.331446	2016-03-10 18:48:37.331446	undefinedtmp_img	jpg	283	283	615	\N	713
714	4	14	3	2016-03-10 18:49:34.676334	2016-03-10 18:49:34.676334	small_pdf	pdf	\N	\N	4209	\N	714
715	4	14	3	2016-03-10 18:49:34.676334	2016-03-10 18:49:34.676334	undefinedtmp2	pdf	\N	\N	10274	\N	715
716	1	14	3	2016-03-10 18:49:34.676334	2016-03-10 18:49:34.676334	undefinedtmp_img	jpg	283	283	615	\N	716
717	4	14	3	2016-03-10 18:50:04.923383	2016-03-10 18:50:04.923383	small_pdf	pdf	\N	\N	4209	\N	717
718	4	14	3	2016-03-10 18:50:04.923383	2016-03-10 18:50:04.923383	undefinedtmp2	pdf	\N	\N	10279	\N	718
719	1	14	3	2016-03-10 18:50:04.923383	2016-03-10 18:50:04.923383	undefinedtmp_img	jpg	283	283	615	\N	719
720	4	14	3	2016-03-10 18:50:22.964364	2016-03-10 18:50:22.964364	small_pdf	pdf	\N	\N	4209	\N	720
721	4	14	3	2016-03-10 18:50:22.964364	2016-03-10 18:50:22.964364	undefinedtmp2	pdf	\N	\N	10262	\N	721
722	1	14	3	2016-03-10 18:50:22.964364	2016-03-10 18:50:22.964364	undefinedtmp_img	jpg	283	283	615	\N	722
723	4	14	3	2016-03-10 18:56:19.679714	2016-03-10 18:56:19.679714	small_pdf	pdf	\N	\N	4209	\N	723
724	4	14	3	2016-03-10 18:56:19.679714	2016-03-10 18:56:19.679714	undefinedtmp2	pdf	\N	\N	10260	\N	724
725	1	14	3	2016-03-10 18:56:19.679714	2016-03-10 18:56:19.679714	undefinedtmp_img	jpg	283	283	615	\N	725
726	4	14	3	2016-03-10 18:56:39.144306	2016-03-10 18:56:39.144306	small_pdf	pdf	\N	\N	4209	\N	726
727	4	14	3	2016-03-10 18:56:39.144306	2016-03-10 18:56:39.144306	undefinedtmp2	pdf	\N	\N	10274	\N	727
728	1	14	3	2016-03-10 18:56:39.144306	2016-03-10 18:56:39.144306	undefinedtmp_img	jpg	283	283	615	\N	728
729	4	14	3	2016-03-10 18:56:53.12485	2016-03-10 18:56:53.12485	small_pdf	pdf	\N	\N	4209	\N	729
730	4	14	3	2016-03-10 18:56:53.12485	2016-03-10 18:56:53.12485	undefinedtmp2	pdf	\N	\N	10279	\N	730
731	1	14	3	2016-03-10 18:56:53.12485	2016-03-10 18:56:53.12485	undefinedtmp_img	jpg	283	283	615	\N	731
732	4	14	3	2016-03-10 18:57:09.011757	2016-03-10 18:57:09.011757	small_pdf	pdf	\N	\N	4209	\N	732
733	4	14	3	2016-03-10 18:57:09.011757	2016-03-10 18:57:09.011757	undefinedtmp2	pdf	\N	\N	10262	\N	733
734	1	14	3	2016-03-10 18:57:09.011757	2016-03-10 18:57:09.011757	undefinedtmp_img	jpg	283	283	615	\N	734
735	4	14	3	2016-03-10 18:57:25.72539	2016-03-10 18:57:25.72539	small_pdf	pdf	\N	\N	4209	\N	735
736	4	14	3	2016-03-10 18:57:25.72539	2016-03-10 18:57:25.72539	undefinedtmp2	pdf	\N	\N	10263	\N	736
737	1	14	3	2016-03-10 18:57:25.72539	2016-03-10 18:57:25.72539	undefinedtmp_img	jpg	283	283	615	\N	737
738	4	14	3	2016-03-10 18:58:21.437694	2016-03-10 18:58:21.437694	small_pdf	pdf	\N	\N	4209	\N	738
739	4	14	3	2016-03-10 18:58:21.437694	2016-03-10 18:58:21.437694	undefinedtmp2	pdf	\N	\N	10262	\N	739
740	1	14	3	2016-03-10 18:58:21.437694	2016-03-10 18:58:21.437694	undefinedtmp_img	jpg	283	283	615	\N	740
741	4	14	3	2016-03-10 18:58:39.552119	2016-03-10 18:58:39.552119	small_pdf	pdf	\N	\N	4209	\N	741
742	4	14	3	2016-03-10 18:58:39.552119	2016-03-10 18:58:39.552119	undefinedtmp2	pdf	\N	\N	10271	\N	742
743	1	14	3	2016-03-10 18:58:39.552119	2016-03-10 18:58:39.552119	undefinedtmp_img	jpg	283	283	615	\N	743
744	4	14	3	2016-03-10 18:58:58.574096	2016-03-10 18:58:58.574096	small_pdf	pdf	\N	\N	4209	\N	744
745	4	14	3	2016-03-10 18:58:58.574096	2016-03-10 18:58:58.574096	undefinedtmp2	pdf	\N	\N	10255	\N	745
746	1	14	3	2016-03-10 18:58:58.574096	2016-03-10 18:58:58.574096	undefinedtmp_img	jpg	283	283	615	\N	746
747	4	14	3	2016-03-10 18:59:26.901306	2016-03-10 18:59:26.901306	small_pdf	pdf	\N	\N	4209	\N	747
748	4	14	3	2016-03-10 18:59:26.901306	2016-03-10 18:59:26.901306	undefinedtmp2	pdf	\N	\N	11647	\N	748
749	1	14	3	2016-03-10 18:59:26.901306	2016-03-10 18:59:26.901306	undefinedtmp_img	jpg	283	283	615	\N	749
750	4	14	3	2016-03-10 19:01:50.948214	2016-03-10 19:01:50.948214	small_pdf	pdf	\N	\N	4209	\N	750
751	4	14	3	2016-03-10 19:01:50.948214	2016-03-10 19:01:50.948214	undefinedtmp2	pdf	\N	\N	11647	\N	751
752	1	14	3	2016-03-10 19:01:50.948214	2016-03-10 19:01:50.948214	undefinedtmp_img	jpg	283	283	615	\N	752
753	4	14	3	2016-03-10 19:03:01.619666	2016-03-10 19:03:01.619666	small_pdf	pdf	\N	\N	4209	\N	753
754	4	14	3	2016-03-10 19:03:01.619666	2016-03-10 19:03:01.619666	undefinedtmp2	pdf	\N	\N	10242	\N	754
755	1	14	3	2016-03-10 19:03:01.619666	2016-03-10 19:03:01.619666	undefinedtmp_img	jpg	283	283	615	\N	755
756	4	14	3	2016-03-10 19:03:23.913258	2016-03-10 19:03:23.913258	small_pdf	pdf	\N	\N	4209	\N	756
757	4	14	3	2016-03-10 19:03:23.913258	2016-03-10 19:03:23.913258	undefinedtmp2	pdf	\N	\N	10272	\N	757
758	1	14	3	2016-03-10 19:03:23.913258	2016-03-10 19:03:23.913258	undefinedtmp_img	jpg	283	283	615	\N	758
759	4	14	3	2016-03-10 19:03:41.218982	2016-03-10 19:03:41.218982	small_pdf	pdf	\N	\N	4209	\N	759
760	4	14	3	2016-03-10 19:03:41.218982	2016-03-10 19:03:41.218982	undefinedtmp2	pdf	\N	\N	10258	\N	760
761	1	14	3	2016-03-10 19:03:41.218982	2016-03-10 19:03:41.218982	undefinedtmp_img	jpg	283	283	615	\N	761
762	4	14	3	2016-03-10 19:03:56.516886	2016-03-10 19:03:56.516886	small_pdf	pdf	\N	\N	4209	\N	762
763	4	14	3	2016-03-10 19:03:56.516886	2016-03-10 19:03:56.516886	undefinedtmp2	pdf	\N	\N	10268	\N	763
764	1	14	3	2016-03-10 19:03:56.516886	2016-03-10 19:03:56.516886	undefinedtmp_img	jpg	283	283	615	\N	764
765	4	14	3	2016-03-10 19:04:19.676891	2016-03-10 19:04:19.676891	small_pdf	pdf	\N	\N	4209	\N	765
766	4	14	3	2016-03-10 19:04:19.676891	2016-03-10 19:04:19.676891	undefinedtmp2	pdf	\N	\N	10269	\N	766
767	1	14	3	2016-03-10 19:04:19.676891	2016-03-10 19:04:19.676891	undefinedtmp_img	jpg	283	283	615	\N	767
768	4	14	3	2016-03-10 19:04:43.948159	2016-03-10 19:04:43.948159	small_pdf	pdf	\N	\N	4209	\N	768
769	4	14	3	2016-03-10 19:04:43.948159	2016-03-10 19:04:43.948159	undefinedtmp2	pdf	\N	\N	10274	\N	769
770	1	14	3	2016-03-10 19:04:43.948159	2016-03-10 19:04:43.948159	undefinedtmp_img	jpg	283	283	615	\N	770
771	4	14	3	2016-03-10 19:05:06.770728	2016-03-10 19:05:06.770728	small_pdf	pdf	\N	\N	4209	\N	771
772	4	14	3	2016-03-10 19:05:06.770728	2016-03-10 19:05:06.770728	undefinedtmp2	pdf	\N	\N	10267	\N	772
773	1	14	3	2016-03-10 19:05:06.770728	2016-03-10 19:05:06.770728	undefinedtmp_img	jpg	283	283	615	\N	773
774	4	14	3	2016-03-10 19:05:38.575136	2016-03-10 19:05:38.575136	small_pdf	pdf	\N	\N	4209	\N	774
775	4	14	3	2016-03-10 19:05:38.575136	2016-03-10 19:05:38.575136	undefinedtmp2	pdf	\N	\N	10266	\N	775
776	1	14	3	2016-03-10 19:05:38.575136	2016-03-10 19:05:38.575136	undefinedtmp_img	jpg	283	283	615	\N	776
777	4	14	3	2016-03-10 19:05:57.538428	2016-03-10 19:05:57.538428	small_pdf	pdf	\N	\N	4209	\N	777
778	4	14	3	2016-03-10 19:05:57.538428	2016-03-10 19:05:57.538428	undefinedtmp2	pdf	\N	\N	10265	\N	778
779	1	14	3	2016-03-10 19:05:57.538428	2016-03-10 19:05:57.538428	undefinedtmp_img	jpg	283	283	615	\N	779
780	4	14	3	2016-03-10 19:06:22.077227	2016-03-10 19:06:22.077227	small_pdf	pdf	\N	\N	4209	\N	780
781	4	14	3	2016-03-10 19:06:22.077227	2016-03-10 19:06:22.077227	undefinedtmp2	pdf	\N	\N	10267	\N	781
782	1	14	3	2016-03-10 19:06:22.077227	2016-03-10 19:06:22.077227	undefinedtmp_img	jpg	283	283	615	\N	782
783	4	14	3	2016-03-10 19:06:47.259425	2016-03-10 19:06:47.259425	small_pdf	pdf	\N	\N	4209	\N	783
784	4	14	3	2016-03-10 19:06:47.259425	2016-03-10 19:06:47.259425	undefinedtmp2	pdf	\N	\N	10242	\N	784
785	1	14	3	2016-03-10 19:06:47.259425	2016-03-10 19:06:47.259425	undefinedtmp_img	jpg	283	283	615	\N	785
\.


--
-- Name: tfiles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfiles_id_seq', 785, true);


--
-- Data for Name: tfiles_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tfiles_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	img3
2	2	1	facility_1440418985165
3	3	1	facility_1440419104378
6	6	1	img3
7	7	1	анжер
8	8	1	dm_ico50_50
9	9	1	gdm_ico50_50
10	10	1	gr_ico50_50
11	11	1	ps_ico50_50
12	12	1	tdg_ico50_50
13	13	1	ts_ico50_50
14	14	1	photo_ico50_50
15	15	1	subfac_ico50_50
16	16	1	6
17	17	1	6
18	18	1	6
19	19	1	img3
20	20	1	объект_1
21	21	1	объект_1
22	22	1	test4
23	23	1	test3
24	24	1	test3
25	25	1	test3
26	26	1	test4
27	27	1	test3
28	28	1	test2
29	29	1	test
30	30	1	test2
31	31	1	test2
32	32	1	test2
33	33	1	test4
34	34	1	test2
35	35	1	avatar
36	36	1	avatar
37	37	1	avatar
38	38	1	test2
39	39	1	avatar
40	40	1	test2
41	41	1	avatar
42	42	1	объект_1
43	43	1	element_sheet
44	44	1	объект_1
45	45	1	объект_1
46	46	1	объект_1
47	47	1	объект_1
48	48	1	объект_1
49	49	1	объект_1
50	50	1	avatar
51	51	1	403ds-multi-purge-manifold-pr-600px
52	53	1	engineering-and-geodetic-surveys
53	52	1	carottage5
54	54	1	51232801ac79590c7f03cba5[1]
55	55	1	boif-djd2-gh
56	56	1	boif-djd2-gh
57	57	1	engineering-and-geodetic-surveys
58	58	1	403ds-multi-purge-manifold-pr-600px
59	59	1	carottage5
60	60	1	boif-djd2-gh
61	61	1	51232801ac79590c7f03cba5[1]
62	62	1	engineering-and-geodetic-surveys
63	63	1	403ds-multi-purge-manifold-pr-600px
64	64	1	boif-djd2-gh
65	65	1	carottage5
66	66	1	engineering-and-geodetic-surveys
67	67	1	51232801ac79590c7f03cba5[1]
68	68	1	403ds-multi-purge-manifold-pr-600px
69	69	1	carottage5
70	70	1	engineering-and-geodetic-surveys
71	71	1	boif-djd2-gh
72	72	1	51232801ac79590c7f03cba5[1]
73	73	1	403ds-multi-purge-manifold-pr-600px
74	74	1	engineering-and-geodetic-surveys
75	75	1	boif-djd2-gh
76	76	1	carottage5
77	77	1	51232801ac79590c7f03cba5[1]
78	78	1	403ds-multi-purge-manifold-pr-600px
79	79	1	carottage5
80	80	1	boif-djd2-gh
81	81	1	engineering-and-geodetic-surveys
82	82	1	51232801ac79590c7f03cba5[1]
83	83	1	403ds-multi-purge-manifold-pr-600px
84	84	1	carottage5
85	85	1	engineering-and-geodetic-surveys
86	86	1	boif-djd2-gh
87	87	1	51232801ac79590c7f03cba5[1]
88	88	1	403ds-multi-purge-manifold-pr-600px
89	89	1	engineering-and-geodetic-surveys
90	90	1	carottage5
91	91	1	51232801ac79590c7f03cba5[1]
92	92	1	boif-djd2-gh
93	93	1	403ds-multi-purge-manifold-pr-600px
94	94	1	engineering-and-geodetic-surveys
95	95	1	carottage5
96	96	1	boif-djd2-gh
97	97	1	51232801ac79590c7f03cba5[1]
98	98	1	403ds-multi-purge-manifold-pr-600px
99	99	1	engineering-and-geodetic-surveys
100	100	1	boif-djd2-gh
101	101	1	51232801ac79590c7f03cba5[1]
102	102	1	carottage5
103	103	1	403ds-multi-purge-manifold-pr-600px
104	104	1	carottage5
105	105	1	engineering-and-geodetic-surveys
106	106	1	boif-djd2-gh
107	107	1	51232801ac79590c7f03cba5[1]
108	108	1	403ds-multi-purge-manifold-pr-600px
109	109	1	carottage5
110	110	1	boif-djd2-gh
111	111	1	51232801ac79590c7f03cba5[1]
432	445	1	model_1dwg
112	112	1	engineering-and-geodetic-surveys
113	113	1	engineering-and-geodetic-surveys
114	114	1	carottage5
115	115	1	boif-djd2-gh
116	116	1	51232801ac79590c7f03cba5[1]
117	117	1	engineering-and-geodetic-surveys
118	118	1	объект_1
119	119	1	объект_1
120	120	1	trollface
121	121	1	trollface
122	122	1	carottage5
123	123	1	boif-djd2-gh
124	124	1	engineering-and-geodetic-surveys
125	125	1	51232801ac79590c7f03cba5[1]
126	126	1	403ds-multi-purge-manifold-pr-600px
127	127	1	boif-djd2-gh
128	128	1	51232801ac79590c7f03cba5[1]
129	129	1	объект_1
130	130	1	desert
131	131	1	снимок
132	132	1	снимок
133	133	1	снимок
134	134	1	снимок
135	135	1	снимок
136	136	1	013 приложение д схема расположения элементов сети гтм
138	138	1	013 приложение д схема расположения элементов сети гтм
139	139	1	7тест
140	140	1	7тест
141	141	1	8тест
142	142	1	blank_1
143	143	1	объект_1
144	144	1	объект_1
145	145	1	image
146	146	1	лист.2-44
147	147	1	лист.2-44
148	148	1	лист.2-44
149	149	1	1.общая схема кц
150	150	1	чертеж8
151	151	1	1.общая схема кц
152	152	1	лист.2-44
153	153	1	лист 17 поз.5.4
154	154	1	orion_hubble_6000
155	155	1	orion_hubble_6000
156	156	1	chart
157	157	1	desert
158	170	1	img_20151118_192946
159	171	1	img_20151118_192813
160	172	1	img_20151118_192830
161	173	1	img_20151118_192813
162	174	1	img_20151118_192946
163	175	1	img_20151118_192830
170	182	1	img_20151119_135415
171	183	1	img_20151119_135415
172	184	1	img_20151119_135404
173	185	1	img_20151119_135415
174	186	1	img_20151119_135404
175	187	1	img_20151119_135415
176	188	1	img_20151119_135415
177	189	1	img_20151119_144826
178	190	1	img_20151119_144831
179	191	1	img_20151119_144858
180	192	1	img_20151119_144906
181	194	1	img_20151119_145757
182	193	1	img_20151119_145803
183	195	1	img_20151119_145740
185	197	1	img_20151119_152107
186	198	1	img_20151119_152112
187	199	1	img_20151119_152133
188	200	1	img_20151119_152138
189	201	1	img_20151119_152102
190	202	1	img_20151119_155517
191	203	1	img_20151119_155523
192	204	1	img_20151119_155530
193	205	1	img_20151119_155555
194	206	1	img_20151119_155605
195	207	1	img_20151119_160643
196	208	1	img_20151119_160652
197	209	1	img_20151119_161406
198	210	1	img_20151119_161421
199	211	1	img_20151119_161426
200	212	1	img_20151119_161431
201	213	1	img_20151119_161449
202	214	1	img_20151119_193049
203	215	1	img_20151119_193751
204	216	1	img_20151119_193757
205	217	1	img_20151119_194218
206	218	1	img_20151119_194223
207	219	1	img_20151119_194533
208	220	1	img_20151119_194538
209	221	1	img_20151119_195228
210	222	1	img_20151119_195234
211	223	1	img_20151119_195223
212	224	1	img_20151119_195754
213	225	1	img_20151119_195759
214	226	1	img_20151119_195749
215	227	1	img_20151119_200424
216	228	1	img_20151119_200433
217	229	1	img_20151119_200418
218	230	1	img_20151119_201433
219	231	1	img_20151119_201504
220	232	1	img_20151119_201620
221	233	1	img_20151119_201348
222	234	1	img_20151119_201956
223	235	1	img_20151119_202002
224	236	1	img_20151119_202021
225	237	1	img_20151119_202027
226	238	1	img_20151119_202034
227	239	1	img_20151119_201951
228	240	1	img_20151122_203622
229	241	1	img_20151122_212611
230	242	1	img_20151122_212606
231	243	1	img_20151123_133116
232	244	1	img_20151123_133134
233	245	1	img_20151123_133214
234	246	1	img_20151123_133224
235	247	1	img_20151123_133230
236	248	1	img_20151123_133236
237	249	1	img_20151123_133101
238	250	1	img_20151123_145852
239	251	1	img_20151123_145858
240	252	1	img_20151123_145847
241	253	1	img_20151123_161302
242	254	1	img_20151123_181257
243	255	1	yamal
244	256	1	yamal
245	257	1	yamal
246	258	1	yamal
247	259	1	yamal
248	260	1	yamal
249	261	1	yamal
250	262	1	yamal
251	263	1	yamal
252	264	1	2015-10-24-428
253	265	1	yamal
254	266	1	2015-10-24-428
255	267	1	yamal
258	270	1	yamal
259	271	1	yamal
260	272	1	yamal
261	273	1	снимок экрана 2015-09-10 в 23.02.35
262	274	1	снимок экрана 2015-09-18 в 2.00.41
263	275	1	снимок экрана 2015-09-18 в 2.06.49
264	276	1	снимок экрана 2015-10-18 в 1.31.45
265	277	1	b-day
266	278	1	tlh-1jnorxk
267	279	1	k1evq-yyw-w
268	280	1	снимок экрана 2015-10-04 в 18.25.14
269	281	1	снимок экрана 2015-09-18 в 2.00.41
270	282	1	снимок экрана 2015-10-18 в 1.31.45
271	283	1	tlh-1jnorxk
272	284	1	снимок экрана 2015-09-10 в 23.02.35
273	285	1	снимок экрана 2015-10-18 в 1.31.45
274	286	1	снимок экрана 2015-10-18 в 1.31.45
275	287	1	снимок экрана 2015-10-18 в 1.31.45
276	288	1	снимок экрана 2015-10-18 в 1.31.45
277	289	1	back
278	290	1	back
279	291	1	back
280	292	1	back
281	293	1	back
282	294	1	back
283	295	1	bg1
284	296	1	bg1
285	297	1	bg1
286	298	1	bg1
287	299	1	forward
288	300	1	back
289	301	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
290	302	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
291	303	1	polar_mesospheric_clouds-other
292	304	1	img_20151128_162049
293	305	1	img_20151208_170422
294	306	1	img_20151208_170653
295	307	1	284
296	308	1	8
297	309	1	10
298	310	1	8
299	311	1	10
300	312	1	img_20151209_151755
301	313	1	img_20151209_191113
302	314	1	img_20151209_191120
303	315	1	img_20151209_191125
304	316	1	img_20151209_191130
305	317	1	img_20151209_191136
306	318	1	img_20151209_191141
307	319	1	img_20151209_191146
308	320	1	img_20151209_191200
309	321	1	img_20151209_191205
310	322	1	8
311	323	1	img_20151210_150432
312	324	1	8
313	325	1	img_20151214_141923
314	326	1	img_20151214_141928
315	327	1	img_20151214_141916
316	328	1	8
317	329	1	10
318	330	1	приложение б
319	331	1	приложение б
320	332	1	приложение б
321	333	1	приложение б
322	334	1	приложение б
323	335	1	приложение б
325	337	1	приложение б
326	338	1	приложение б
327	339	1	1.общая схема кц
328	340	1	1.общая схема кц
329	341	1	приложение б
330	342	1	приложение б
331	343	1	test_1
332	344	1	test_2
333	345	1	test_3
334	346	1	test_4
335	347	1	test_5
336	348	1	test_6pdf
337	349	1	test_7pdf
338	350	1	test_6_1pdf
339	351	1	кс-4 гтп_ книга 2 приложение в тсг
340	352	1	кс-4 гтп_ книга 2 приложение в тсг
341	353	1	приложение
342	354	1	приложение
343	355	1	поз.18 оси после 17
344	356	1	приложение 3 схема расположения сети гтм_2.1
345	357	1	приложение 3 схема расположения сети гтм_2.3
346	358	1	приложение 3 схема расположения сети гтм_2.5
347	359	1	приложение 3 схема расположения сети гтм_общая схема
348	360	1	приложение 4  конструкция термометрической скважины тс, l=10м
349	361	1	приложение 5  конструкция грунтового геодезического репера
350	362	1	приложение 6  конструкция и спецификация деформационной марки на оголовке сваи (тип б)
351	363	1	приложение 7   деформационная марка тип г
352	364	1	приложение б
353	365	1	приложение б л.1-5
354	366	1	приложение б л.6-53
355	367	1	приложение б. л.54-71
356	368	1	лист 1
357	369	1	лист 2
358	370	1	кс-4 гтп_ книга 2 приложение в тсг
359	371	1	кс-4 гтп_ книга 2 приложение а - копия
360	372	1	кс-4 гтп книга 2 приложение б
361	373	1	приложение
362	374	1	приложение
363	375	1	приложение а_лист 1
364	376	1	приложение а_лист 2
365	377	1	приложение а_лист 3
366	378	1	приложение а_лист 4
367	379	1	приложение а_лист 5
368	380	1	приложение а_лист 6
369	381	1	приложение а_лист 7
370	382	1	приложение а_лист 9
371	383	1	приложение а_лист 8
372	384	1	приложение 3 схема расположения сети гтм_2.1
373	385	1	а0_в
374	386	1	а4_в_t1
375	387	1	приложение а_лист 1_dwg
376	388	1	test_format_a4
377	389	1	test_format_a4
378	390	1	format_a4
379	391	1	а4_в_pdf4
380	392	1	а4_в_dwg5
382	394	1	ff9941ce-c9c4-433a-9f45-c43626f123a1
383	395	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
384	396	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
385	397	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
386	398	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
387	399	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
388	400	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
389	401	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
390	402	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
391	403	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
392	404	1	bfb33d1f-d0aa-4fcd-a599-5a2da9238941
393	405	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
394	406	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
395	407	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
396	408	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
397	409	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
398	410	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
399	411	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
400	412	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
401	413	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
402	414	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
403	415	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
404	416	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
405	417	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
406	418	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
407	419	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
408	420	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
409	421	1	96d2cf23-d813-4f4f-ab7e-0ad24f5b9c2d
410	422	1	чертеж8
411	423	1	1a6c79a3-5876-483c-b1c5-728b51e5305a
412	424	1	1a6c79a3-5876-483c-b1c5-728b51e5305a
413	425	1	приложение а_лист 1_dwg
414	427	1	3b85113a-d1cf-4a3c-bd5d-fa48ba353fb4
415	428	1	3b85113a-d1cf-4a3c-bd5d-fa48ba353fb4
416	429	1	а4_в_test1
417	430	1	а4_в_test1
418	431	1	а4_в_test1
419	432	1	а4_в_test1_2
420	433	1	а4_в_test1_3
427	440	1	model_1pdf
428	441	1	model_1dwg
429	442	1	model_1pdf
430	443	1	model_1dwg
431	444	1	model_1pdf
433	446	1	model_1pdf
434	447	1	model_1dwg
435	448	1	model_1pdf
436	449	1	model_1pdf
437	450	1	model_1pdf
438	451	1	model_1dwg
535	548	1	a1_g_data_pdf
536	549	1	a1_g_data_dwg
537	550	1	a3x3_g_test_pdf
470	483	1	polar_mesospheric_clouds-other
471	484	1	nature-snow-trees-winter-2544954-1920x1200
472	485	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
473	486	1	nature-snow-trees-winter-2544954-1920x1200
474	487	1	polar_mesospheric_clouds-other
475	488	1	cb54c619700f4eb583152fb8451
476	489	1	bezyimyannyij-b80uvk
477	490	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
478	491	1	beautiful_stream-widescreen_wallpapers
479	492	1	bezyimyannyij-b80uvk
480	493	1	cb54c619700f4eb583152fb8451
481	494	1	beautiful_stream-widescreen_wallpapers
487	500	1	a1_g_841x594
488	501	1	a1_v_594x841
489	502	1	a1x2_594x1682_v
490	503	1	a1x2_g_841x1189
491	504	1	a1x3_g_1783x841
492	505	1	a2_g_594x420
493	506	1	a2_v_420x594
494	507	1	a2x3_1261x594
495	508	1	a2x3_v_594x1260
496	509	1	a3_v_297x420
497	510	1	a3x3_g_891x420
498	511	1	a3x4_g_1189x420
499	512	1	a3x5_g_1486x420
500	513	1	a3x6_g_1682x420
501	514	1	a4_v_210x297
502	515	1	a4x3_g_630x297
503	516	1	a4x6_g_1260x297
504	517	1	a4x8_g_1680x297
505	518	1	a1_g_841x594
506	519	1	a1_v_594x841
507	520	1	a1x2_594x1682_v
508	521	1	a1x2_g_841x1189
509	522	1	a1x3_g_1783x841
510	523	1	a2_g_594x420
511	524	1	a2_v_420x594
512	525	1	a2x3_1261x594
513	526	1	a2x3_v_594x1260
514	527	1	a3_v_297x420
515	528	1	a3x3_g_891x420
516	529	1	a3x4_g_1189x420
517	530	1	a3x5_g_1486x420
518	531	1	a3x6_g_1682x420
519	532	1	a4_v_210x297
520	533	1	a4x3_g_630x297
521	534	1	a4x6_g_1260x297
522	535	1	a4x8_g_1680x297
523	536	1	a1_g_test_pdf
524	537	1	a1_g_test_dwg
525	538	1	a3x6_test_pdf
526	539	1	a3x6_test_dwg
527	540	1	a2x3_v_pdf
528	541	1	a2x3_v_dwg
529	542	1	a1x2_g_pdf
530	543	1	a1x2_g_dwg
531	544	1	a1x2_g_pdf
532	545	1	a1x2_g_dwg_2
533	546	1	a1_g_data_pdf
534	547	1	a1_g_data_dwg
538	551	1	a3x3_g_test_dwg
539	552	1	тестовый_a3x5_g_pdf
540	553	1	тестовый_a3x5_g_dwg
541	554	1	a2_v_test_pdf
542	555	1	a2_v_test_dwg
543	556	1	525
544	557	1	525
545	558	1	тестовый_a3x5_g_pdf
546	559	1	a1_g_test_pdf
547	560	1	a3x3_g_test_pdf
548	561	1	a1x2_g_pdf
549	562	1	a2x3_v_pdf
550	563	1	тестовый_a3x5_g_pdf
551	564	1	undefinedtmp_img
557	570	1	a1_g_test_pdf
558	571	1	undefinedtmp_img
559	572	1	a2x3_v_pdf
560	573	1	undefinedtmp_img
561	574	1	a2_v_test_pdf
562	575	1	undefinedtmp_img
563	576	1	a2x3_v_pdf
564	577	1	undefinedtmp_img
574	587	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
575	588	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
576	589	1	735154_utrenniy_tuman_v_lesu
577	590	1	beautiful_stream-widescreen_wallpapers
578	591	1	bezyimyannyij-b80uvk
579	592	1	cb54c619700f4eb583152fb8451
580	593	1	nature-snow-trees-winter-2544954-1920x1200
581	594	1	bezyimyannyij-b80uvk
582	595	1	cb54c619700f4eb583152fb8451
583	596	1	nature-snow-trees-winter-2544954-1920x1200
584	597	1	239188_zakat_les_vecher_priroda_leto_3005x2005_(www.gdefon.ru)
585	598	1	735154_utrenniy_tuman_v_lesu
586	599	1	beautiful_stream-widescreen_wallpapers
587	600	1	bezyimyannyij-b80uvk
588	601	1	cb54c619700f4eb583152fb8451
589	602	1	nature-snow-trees-winter-2544954-1920x1200
590	603	1	polar_mesospheric_clouds-other
591	604	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
592	605	1	239188_zakat_les_vecher_priroda_leto_3005x2005_(www.gdefon.ru)
593	606	1	735154_utrenniy_tuman_v_lesu
594	607	1	beautiful_stream-widescreen_wallpapers
595	608	1	bezyimyannyij-b80uvk
596	609	1	cb54c619700f4eb583152fb8451
597	610	1	nature-snow-trees-winter-2544954-1920x1200
598	611	1	polar_mesospheric_clouds-other
599	612	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
600	613	1	cb54c619700f4eb583152fb8451
601	614	1	nature-snow-trees-winter-2544954-1920x1200
602	615	1	polar_mesospheric_clouds-other
603	616	1	xh7nkl-photo_1p5_ru-luzhi-priroda-les-derevya
604	617	1	test_7pdf
605	618	1	test_7pdf
606	619	1	test_7pdf
607	620	1	test_7pdf
608	621	1	test_7pdf
609	622	1	test_7pdf
610	623	1	test_7pdf
611	624	1	test_7pdf
612	625	1	test_7pdf
613	626	1	test_7pdf
614	627	1	test_7pdf
615	628	1	undefinedtmp2
616	629	1	undefinedtmp_img
617	630	1	a1_g_test_pdf
618	631	1	undefinedtmp2
619	632	1	undefinedtmp_img
620	633	1	снимок экрана 2016-02-11 в 17.18.15
621	634	1	undefinedtmp2
622	635	1	undefinedtmp_img
623	636	1	снимок экрана 2016-02-11 в 17.18.15
624	637	1	undefinedtmp2
625	638	1	undefinedtmp_img
626	639	1	a3x6_test_pdf
627	640	1	undefinedtmp2
628	641	1	undefinedtmp_img
629	642	1	a3x6_test_pdf
630	643	1	undefinedtmp2
631	644	1	undefinedtmp_img
632	645	1	тестовый_a3x5_g_pdf
633	646	1	undefinedtmp2
634	647	1	undefinedtmp_img
635	648	1	a3x3_g_test_pdf
636	649	1	undefinedtmp2
637	650	1	undefinedtmp_img
638	651	1	a2_v_test_pdf
639	652	1	undefinedtmp2
640	653	1	undefinedtmp_img
641	654	1	a2x3_v_pdf
642	655	1	undefinedtmp2
643	656	1	undefinedtmp_img
644	657	1	a1x2_g_pdf
645	658	1	undefinedtmp2
646	659	1	undefinedtmp_img
647	660	1	a1x2_g_pdf
648	661	1	undefinedtmp2
649	662	1	undefinedtmp_img
650	663	1	523_кс-2ярынская
651	664	1	undefinedtmp2
652	665	1	undefinedtmp_img
653	666	1	523_кс-2ярынская
654	667	1	поз. 1.3
655	668	1	undefinedtmp2
656	669	1	undefinedtmp_img
657	670	1	a0_v
658	671	1	a0_v
659	672	1	a1_h
660	673	1	a1_h
661	674	1	a1_v
662	675	1	a1_v
663	676	1	a1x3_h
664	677	1	a1x3_h
665	678	1	a2_h
666	679	1	a2_h
667	680	1	a2_v
668	681	1	a2_v
669	682	1	a2×4_v
670	683	1	a2×4_v
671	684	1	a2x3_h
672	685	1	a2x3_h
673	686	1	a2x3_v
674	687	1	a2x3_v
675	688	1	a3_h
676	689	1	a3_h
677	690	1	a3_v
678	691	1	a3_v
679	692	1	a3x3_h
680	693	1	a3x3_h
681	694	1	a3x4_h
682	695	1	a3x4_h
683	696	1	a3x5_h
684	697	1	a3x5_h
685	698	1	a3x6_h
686	699	1	a3x6_h
687	700	1	a4_v
688	701	1	a4_v
689	702	1	a4x3_h
690	703	1	a4x3_h
691	704	1	a4x6_h
692	705	1	a4x6_h
693	706	1	a4x8_h
694	707	1	a4x8_h
695	708	1	small_pdf
696	709	1	undefinedtmp2
697	710	1	undefinedtmp_img
698	711	1	small_pdf
699	712	1	undefinedtmp2
700	713	1	undefinedtmp_img
701	714	1	small_pdf
702	715	1	undefinedtmp2
703	716	1	undefinedtmp_img
704	717	1	small_pdf
705	718	1	undefinedtmp2
706	719	1	undefinedtmp_img
707	720	1	small_pdf
708	721	1	undefinedtmp2
709	722	1	undefinedtmp_img
710	723	1	small_pdf
711	724	1	undefinedtmp2
712	725	1	undefinedtmp_img
713	726	1	small_pdf
714	727	1	undefinedtmp2
715	728	1	undefinedtmp_img
716	729	1	small_pdf
717	730	1	undefinedtmp2
718	731	1	undefinedtmp_img
719	732	1	small_pdf
720	733	1	undefinedtmp2
721	734	1	undefinedtmp_img
722	735	1	small_pdf
723	736	1	undefinedtmp2
724	737	1	undefinedtmp_img
725	738	1	small_pdf
726	739	1	undefinedtmp2
727	740	1	undefinedtmp_img
728	741	1	small_pdf
729	742	1	undefinedtmp2
730	743	1	undefinedtmp_img
731	744	1	small_pdf
732	745	1	undefinedtmp2
733	746	1	undefinedtmp_img
734	747	1	small_pdf
735	748	1	undefinedtmp2
736	749	1	undefinedtmp_img
737	750	1	small_pdf
738	751	1	undefinedtmp2
739	752	1	undefinedtmp_img
740	753	1	small_pdf
741	754	1	undefinedtmp2
742	755	1	undefinedtmp_img
743	756	1	small_pdf
744	757	1	undefinedtmp2
745	758	1	undefinedtmp_img
746	759	1	small_pdf
747	760	1	undefinedtmp2
748	761	1	undefinedtmp_img
749	762	1	small_pdf
750	763	1	undefinedtmp2
751	764	1	undefinedtmp_img
752	765	1	small_pdf
753	766	1	undefinedtmp2
754	767	1	undefinedtmp_img
755	768	1	small_pdf
756	769	1	undefinedtmp2
757	770	1	undefinedtmp_img
758	771	1	small_pdf
759	772	1	undefinedtmp2
760	773	1	undefinedtmp_img
761	774	1	small_pdf
762	775	1	undefinedtmp2
763	776	1	undefinedtmp_img
764	777	1	small_pdf
765	778	1	undefinedtmp2
766	779	1	undefinedtmp_img
767	780	1	small_pdf
768	781	1	undefinedtmp2
769	782	1	undefinedtmp_img
770	783	1	small_pdf
771	784	1	undefinedtmp2
772	785	1	undefinedtmp_img
\.


--
-- Name: tfiles_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfiles_l10n_id_seq', 772, true);


--
-- Name: tfiles_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfiles_ordering_seq', 785, true);


--
-- Name: tfmeasurement_periods_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tfmeasurement_periods_id_seq', 110, true);


--
-- Data for Name: tforms; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tforms (id, code, name, fields_not_null, func_error, func_ok, mail_template1_id, mail_template2_id) FROM stdin;
\.


--
-- Name: tforms_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tforms_id_seq', 1, false);


--
-- Data for Name: tguestbook_messages; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tguestbook_messages (id, guestbook_id, user_q_name, user_q_phone, user_q_email, user_q_avatar_id, user_a_id, question, answer, date_question, date_answer, moderated) FROM stdin;
\.


--
-- Name: tguestbook_messages_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tguestbook_messages_id_seq', 1, false);


--
-- Data for Name: tguestbooks; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tguestbooks (id, code, name, premoderated, users_can_post, mail_code) FROM stdin;
\.


--
-- Name: tguestbooks_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tguestbooks_id_seq', 1, false);


--
-- Data for Name: tkvcache; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tkvcache (id, key, value) FROM stdin;
\.


--
-- Name: tkvcache_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tkvcache_id_seq', 1, false);


--
-- Data for Name: tl10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tl10n (id, code, name, is_default) FROM stdin;
1	ru	Русский	1
\.


--
-- Name: tl10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tl10n_id_seq', 1, true);


--
-- Data for Name: tlogin_attempts; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tlogin_attempts (id, login, password, date_cr, user_ip, user_agent_id, url, ok) FROM stdin;
\.


--
-- Name: tlogin_attempts_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tlogin_attempts_id_seq', 1, false);


--
-- Data for Name: tmail_templates; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmail_templates (id, code, name, default_from, default_to, signature) FROM stdin;
1	test	test	robot@erp-gtm.relsyst.ru	\N	\N
\.


--
-- Name: tmail_templates_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmail_templates_id_seq', 1, true);


--
-- Data for Name: tmail_templates_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmail_templates_l10n (id, fid_id, l10n_id, subject, body) FROM stdin;
1	1	1	Hello world	<p>Ура уии уии ;)</p>\n<p><span>Ура уии уии ;)</span></p>\n<p><span><span>Ура уии уии ;)</span></span></p>\n<p><span><span></span></span></p>
\.


--
-- Name: tmail_templates_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmail_templates_l10n_id_seq', 1, true);


--
-- Data for Name: tmarket_categories; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_categories (id, code, parent_id, image1_id, image2_id, enabled, ordering, fid, is_featured, is_new, is_recomended, has_abstract, has_body2) FROM stdin;
\.


--
-- Name: tmarket_categories_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_categories_id_seq', 1, false);


--
-- Data for Name: tmarket_categories_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_categories_l10n (id, fid_id, l10n_id, name, abstract, body, body2, title, meta_abstract, meta_description) FROM stdin;
\.


--
-- Name: tmarket_categories_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_categories_l10n_id_seq', 1, false);


--
-- Name: tmarket_categories_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_categories_ordering_seq', 1, false);


--
-- Data for Name: tmarket_field_datatypes; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_field_datatypes (id, code, view_code, name, prefix, crsql, has_l10n, has_enum) FROM stdin;
1	integer	range	Целое число	i	integer	0	0
2	float	range	Дробное число	f	float	0	0
3	string	\N	Строка	s	varchar(2000)	0	0
4	lstring	\N	Локализованная строка	sl	varchar(2000)	1	0
5	enum	checkbox	Одно из перечисленных значений	i	integer	0	1
6	lenum	checkbox	Одно из локализованных перечисленных значений	i	integer	1	1
7	enums	checkbox	Несколько из перечисленных значений	\N	\N	0	1
8	lenums	checkbox	Несколько из локализованных перечисленных значений	\N	\N	1	1
\.


--
-- Name: tmarket_field_datatypes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_datatypes_id_seq', 8, true);


--
-- Data for Name: tmarket_field_enums; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_field_enums (id, field_id, value) FROM stdin;
\.


--
-- Name: tmarket_field_enums_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_enums_id_seq', 1, false);


--
-- Data for Name: tmarket_field_enumsl; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_field_enumsl (id, field_id, l10n_id, value) FROM stdin;
\.


--
-- Name: tmarket_field_enumsl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_enumsl_id_seq', 1, false);


--
-- Data for Name: tmarket_field_groups; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_field_groups (id, ordering, enabled, category_id) FROM stdin;
\.


--
-- Name: tmarket_field_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_groups_id_seq', 1, false);


--
-- Data for Name: tmarket_field_groups_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_field_groups_l10n (id, fid_id, l10n_id, name) FROM stdin;
\.


--
-- Name: tmarket_field_groups_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_groups_l10n_id_seq', 1, false);


--
-- Name: tmarket_field_groups_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_field_groups_ordering_seq', 1, false);


--
-- Data for Name: tmarket_fields; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_fields (id, group_id, datatype_id, view_level_id, search_level_id, enabled, ordering, cid, fid) FROM stdin;
\.


--
-- Name: tmarket_fields_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_fields_id_seq', 1, false);


--
-- Data for Name: tmarket_fields_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_fields_l10n (id, fid_id, l10n_id, name) FROM stdin;
\.


--
-- Name: tmarket_fields_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_fields_l10n_id_seq', 1, false);


--
-- Name: tmarket_fields_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_fields_ordering_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_enums; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_item_fields_enums (id, item_id, field_id, enum_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_enums_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_enums_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_enumsl; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_item_fields_enumsl (id, item_id, field_id, enum_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_enumsl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_enumsl_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_f; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_item_fields_f (id, item_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_f_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_f_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_i; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_item_fields_i (id, item_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_i_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_i_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_il; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_item_fields_il (id, item_id, fid_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_il_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_il_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_s; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_item_fields_s (id, item_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_s_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_s_id_seq', 1, false);


--
-- Data for Name: tmarket_item_fields_sl; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_item_fields_sl (id, item_id, fid_id) FROM stdin;
\.


--
-- Name: tmarket_item_fields_sl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_fields_sl_id_seq', 1, false);


--
-- Data for Name: tmarket_item_groups; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_item_groups (id, enabled, ordering) FROM stdin;
\.


--
-- Name: tmarket_item_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_groups_id_seq', 1, false);


--
-- Data for Name: tmarket_item_groups_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_item_groups_l10n (id, fid_id, l10n_id, name) FROM stdin;
\.


--
-- Name: tmarket_item_groups_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_groups_l10n_id_seq', 1, false);


--
-- Name: tmarket_item_groups_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_item_groups_ordering_seq', 1, false);


--
-- Data for Name: tmarket_items; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_items (id, code, date_cr, image1_id, image2_id, group_id, category_id, manufacturer_id, enabled, in_stock, price, ordering, is_featured, is_new, is_recomended, fid, fid2, file_folder_id, old_price, base_price, discount_value, in_stock_count) FROM stdin;
\.


--
-- Name: tmarket_items_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_items_id_seq', 1, false);


--
-- Data for Name: tmarket_items_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_items_l10n (id, fid_id, l10n_id, name, abstract, body, body2) FROM stdin;
\.


--
-- Name: tmarket_items_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_items_l10n_id_seq', 1, false);


--
-- Name: tmarket_items_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_items_ordering_seq', 1, false);


--
-- Data for Name: tmarket_manufacturers; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_manufacturers (id, code, image1_id, image2_id, enabled, ordering, fid, is_featured, is_new, is_recomended) FROM stdin;
\.


--
-- Name: tmarket_manufacturers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_manufacturers_id_seq', 1, false);


--
-- Data for Name: tmarket_manufacturers_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_manufacturers_l10n (id, fid_id, l10n_id, name, abstract, body, body2, title, meta_abstract, meta_description) FROM stdin;
\.


--
-- Name: tmarket_manufacturers_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_manufacturers_l10n_id_seq', 1, false);


--
-- Name: tmarket_manufacturers_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_manufacturers_ordering_seq', 1, false);


--
-- Data for Name: tmarket_search_levels; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_search_levels (id, code) FROM stdin;
1	no
2	basic
3	short
4	advanced
5	full
\.


--
-- Name: tmarket_search_levels_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_search_levels_id_seq', 5, true);


--
-- Data for Name: tmarket_search_levels_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_search_levels_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	Не показывать
2	2	1	Простой режим
3	3	1	Краткий режим
4	4	1	Расширенный режим
5	5	1	Полный режим
\.


--
-- Name: tmarket_search_levels_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_search_levels_l10n_id_seq', 5, true);


--
-- Data for Name: tmarket_view_levels; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_view_levels (id, code) FROM stdin;
1	no
2	list
3	short
4	full
\.


--
-- Name: tmarket_view_levels_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_view_levels_id_seq', 4, true);


--
-- Data for Name: tmarket_view_levels_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmarket_view_levels_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	Не показывать
2	2	1	В списке
3	3	1	Краткий вариант
4	4	1	Полный вариант
\.


--
-- Name: tmarket_view_levels_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmarket_view_levels_l10n_id_seq', 4, true);


--
-- Data for Name: tmeasurement_modes; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmeasurement_modes (id, name) FROM stdin;
1	Ручной
2	Автоматический
\.


--
-- Name: tmeasurement_modes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmeasurement_modes_id_seq', 2, true);


--
-- Data for Name: tmeasurement_periods; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmeasurement_periods (id, facility_id, sensor_model_id, value) FROM stdin;
\.


--
-- Data for Name: tmeasurer_value_types; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmeasurer_value_types (id, code, name) FROM stdin;
5	height	мм
2	temperature	°C
6	grad	°
7	level	м
\.


--
-- Name: tmeasurer_value_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmeasurer_value_types_id_seq', 7, true);


--
-- Data for Name: tmediums; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tmediums (id, code, ordering, name) FROM stdin;
1	desktop	1	Десктоп
2	mobile	2	Мобильный
\.


--
-- Name: tmediums_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmediums_id_seq', 2, true);


--
-- Name: tmediums_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tmediums_ordering_seq', 2, true);


--
-- Data for Name: tnormative_types; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tnormative_types (id, name) FROM stdin;
13	Высота подошвы отсыпки 
12	Максимальная допустимая температура
11	Допустимая величина деформации
\.


--
-- Data for Name: tnormatives; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tnormatives (id, facility_id, type_id, value) FROM stdin;
\.


--
-- Name: tnormatives_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tnormatives_id_seq', 13, true);


--
-- Name: tnormatives_id_seq1; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tnormatives_id_seq1', 24, true);


--
-- Data for Name: tpage_blocks; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tpage_blocks (id, page_id, l10n_id, place_id, medium_id, body) FROM stdin;
4	1	1	1	1	\N
2	16	1	1	1	plans
7	12	1	1	1	dashboard
1	15	1	1	1	users
3	17	1	1	1	reference
6	8	1	1	1	analytics
\.


--
-- Name: tpage_blocks_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tpage_blocks_id_seq', 7, true);


--
-- Data for Name: tpages; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tpages (id, parent_id, alias, template_id, prerun, prerun_param, show_in_nav, ordering, role_id, hide_anon, hide_reg, cssclass) FROM stdin;
1	\N	/index/	4	\N	\N	0	1	\N	1	0	\N
16	\N	/plans/	4	GTM	\N	1	13	\N	0	0	\N
12	\N	/dashboard/	4	\N	\N	1	14	\N	1	0	\N
15	\N	/users/	4	\N	\N	1	16	\N	0	0	\N
17	\N	/reference/	4	\N	\N	1	17	\N	0	0	\N
8	\N	/analytics/	4	Analytics	\N	1	15	12	0	0	\N
\.


--
-- Name: tpages_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tpages_id_seq', 17, true);


--
-- Data for Name: tpages_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tpages_l10n (id, fid_id, l10n_id, name, title, meta_description, meta_keywords, disabled_l10n) FROM stdin;
1	1	1	Главная	\N	\N	\N	0
16	16	1	Чертежи	\N	\N	\N	0
12	12	1	Рабочая панель	\N	\N	\N	0
15	15	1	Пользователи	\N	\N	\N	0
17	17	1	Справка	\N	\N	\N	0
8	8	1	Аналитика	\N	\N	\N	0
\.


--
-- Name: tpages_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tpages_l10n_id_seq', 17, true);


--
-- Name: tpages_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tpages_ordering_seq', 17, true);


--
-- Data for Name: tpayment_service_errors; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tpayment_service_errors (id, psi_id, amount, error, pay_remote_addr, pay_user_agent_id, pay_data) FROM stdin;
\.


--
-- Name: tpayment_service_errors_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tpayment_service_errors_id_seq', 1, false);


--
-- Data for Name: tpayment_service_invoices; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tpayment_service_invoices (id, date_cr, date_pay, ask_remote_addr, ask_user_agent_id, amount, user_id, module_name, module_fid, module_data, redirect, payed, service_name, service_data, pay_remote_addr, pay_user_agent_id, pay_data) FROM stdin;
\.


--
-- Name: tpayment_service_invoices_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tpayment_service_invoices_id_seq', 1, false);


--
-- Data for Name: tplan_formats; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tplan_formats (id, name, width, height, dwg_id, pdf_id, explication_data) FROM stdin;
13	A1x3_H	1783	841	676	677	{"size":0.7,"x":4517,"y":2216}
14	A2_H	594	420	678	679	{"size":0.7,"x":1145,"y":1021}
16	A2_V	420	594	680	681	{"size":0.7,"x":652,"y":1514}
17	A2x3_H	1261	594	684	685	{"size":0.7,"x":3036,"y":1515}
19	A3_V	297	420	690	691	{"size":0.7,"x":302,"y":1021}
20	A3x3_H	892	420	692	693	{"size":0.65,"x":1986,"y":1021}
21	A3x4_H	1189	420	694	695	{"size":0.7,"x":2832,"y":1021}
22	A3x5_H	1487	420	696	697	{"size":0.7,"x":3673,"y":1021}
23	A3x6_H	1682	420	698	699	{"size":0.7,"x":4228,"y":1021}
24	A4_V	210	297	700	701	{"size":0.7,"x":56,"y":672}
25	A4x3_H	631	297	702	703	{"size":0.7,"x":1246,"y":672}
26	A4x6_H	1261	297	704	705	{"size":0.7,"x":3033,"y":672}
27	A4x8_G	1682	297	706	707	{"size":0.7,"x":4224,"y":672}
28	A2x3_V	594	1261	686	687	{"size":0.7,"x":1145,"y":3406}
9	A1_H	841	594	672	673	{"size":0.7,"x":1845,"y":1514}
12	A0_V	841	1189	670	671	{"size":0.7,"x":1844,"y":3200}
18	A2x3_V	594	1260	686	687	{"size":0.7,"x":1144,"y":3404}
10	A1_V	594	841	674	675	{"size":0.7,"x":1144,"y":2215}
11	A2×4_V	594	1682	682	683	{"size":0.7,"x":1144,"y":4599}
\.


--
-- Name: tplan_formats_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tplan_formats_id_seq', 28, true);


--
-- Data for Name: tplans; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tplans (id, name, dwg_id, pdf_id, jpg_id, format_id, view_data, width, height, status, urn, urn_encoded, log, calc_pdf_id) FROM stdin;
\.


--
-- Name: tplans_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tplans_id_seq', 64, true);


--
-- Data for Name: treferences; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY treferences (id, parent_id, name, body, ordering) FROM stdin;
12	28	Редактирование групп	\N	36
53	6	Панель управления	\N	17
9	28	Редактирование объекта	\N	24
27	28	Редактирование области подобъекта	\N	25
11	28	Редактирование элементов	\N	26
45	11	Модели датчиков	\N	28
46	45	ГР	\N	29
47	45	ТС	\N	30
48	45	ПС	\N	31
49	45	ГДМ	\N	32
50	45	ДМ	\N	33
32	28	Редактирование кос	\N	34
26	28	Добавление комментариев и фотографий	\N	37
24	28	Просмотр истории изменений	\N	38
33	28	Генерация PDF 	\N	40
18	42	Экспликация	\N	42
19	42	Условные обозначения	\N	43
17	42	Позиционирование элементов	\N	44
25	42	Редактирование штампа чертежа	\N	45
31	43	Импорт значений	\N	47
30	43	Экспорт значений	\N	48
34	43	Сигнализация значений	\N	49
35	6	Аналитика	\N	50
36	35	Статистика	\N	51
37	35	Построение графиков	\N	53
28	53	Работа с объектами	\N	18
42	53	Работа с картой	\N	41
43	53	Работа с табличными данными	\N	46
16	16	Редактирование элементов	\N	20
8	\N	Описание системы	<div class="name">ИАС Геолого-технического мониторинга</div>\n<div class="abstract">Комплексная система для ручного и автоматизированного контроля, сбора, хранения, а также анализа и учета показателей датчиков разных типов на местности в рамках ГТМ</div>	6
38	8	Авторизация в системе	\N	7
51	8	Общий вид системы	\N	8
52	8	Права доступа	\N	9
6	\N	Руководство пользователя	\N	11
40	6	Работа с чертежами	\N	12
7	40	Добавление чертежей	\N	13
21	7	Форматы чертежей	\N	16
\.


--
-- Name: treferences_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('treferences_id_seq', 53, true);


--
-- Name: treferences_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('treferences_ordering_seq', 53, true);


--
-- Data for Name: trewrites; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY trewrites (id, regexp, fields, page_id, controller_name, controller_mode, signature) FROM stdin;
1	^/ajaj/([\\w\\-]+)/?$	mode	\N	Ajaj	\N	\N
3	^/api/mobile/([\\w\\-]+)/?$	mode	\N	ApiMobile	\N	\N
4	^/api/autodesk/([\\w\\-]+)/?$	mode	\N	ApiAutodesk	\N	\N
6	^/GTM/([\\w\\-]+)/?$	mode	\N	GTM	\N	\N
7	^/stamp_gen/(\\d+)/(\\d+)/(\\d+)/?$	facility_id,width,height	\N	GTM	stamp_gen	\N
\.


--
-- Name: trewrites_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('trewrites_id_seq', 7, true);


--
-- Data for Name: troles; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY troles (id, code) FROM stdin;
1	pages
2	articles
3	design
4	settings
5	files
6	market
7	guestbooks
8	users
9	admin_start
10	gtm_settings
11	gtm_input
12	gtm_analytics
14	seomp
13	gtm_edit
\.


--
-- Name: troles_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('troles_id_seq', 14, true);


--
-- Data for Name: troles_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY troles_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	Страницы
2	2	1	Статьи
3	3	1	Дизайн
4	4	1	Настройки
5	5	1	Файлы
6	6	1	Магазин
7	7	1	Гостевые книги
8	8	1	Пользователи
9	9	1	Доступ в админ-панель
10	10	1	Создание пользователей
11	11	1	Ввод данных
12	12	1	Аналитика
14	14	1	SEOMP
13	13	1	Редактирование объектов
\.


--
-- Name: troles_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('troles_l10n_id_seq', 14, true);


--
-- Data for Name: tsensor_comment_images; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsensor_comment_images (id, image_id, comment_id) FROM stdin;
\.


--
-- Name: tsensor_comment_images_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_comment_images_id_seq', 76, true);


--
-- Data for Name: tsensor_comments; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsensor_comments (id, sensor_id, date_cr, user_cr_id, body, images_json) FROM stdin;
\.


--
-- Name: tsensor_comments_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_comments_id_seq', 43, true);


--
-- Data for Name: tsensor_groups; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsensor_groups (id, sensor_id, group_id) FROM stdin;
\.


--
-- Name: tsensor_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_groups_id_seq', 26, true);


--
-- Name: tsensor_groups_id_seq1; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_groups_id_seq1', 160, true);


--
-- Data for Name: tsensor_model_measurers; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsensor_model_measurers (id, sensor_model_id, value_type_id, name, ordering, accuracy) FROM stdin;
\.


--
-- Name: tsensor_model_measurers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_model_measurers_id_seq', 10, true);


--
-- Name: tsensor_model_measurers_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_model_measurers_ordering_seq', 10, true);


--
-- Data for Name: tsensor_model_normatives; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsensor_model_normatives (id, sensor_model_id, normative_id, value, for_group) FROM stdin;
\.


--
-- Name: tsensor_model_normatives_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_model_normatives_id_seq', 19, true);


--
-- Data for Name: tsensor_model_types; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsensor_model_types (id, name) FROM stdin;
2	c инклинометром
3	краской
4	наварная
5	вертикальная
6	горизонтальная
7	наклонная
1	 
\.


--
-- Name: tsensor_model_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_model_types_id_seq', 7, true);


--
-- Data for Name: tsensor_models; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsensor_models (id, code, name, name_short, has_braid, has_own_values, has_angle) FROM stdin;
14	ts	Термометрическая скважина 	ТС	1	\N	\N
8	rp	Геодезический репер	РП	\N	1	\N
9	ps	Пьезометрическая скважина	ПС	\N	1	\N
10	gdm	Грунтовая деформационная марка	ГДМ	1	1	1
13	dm	Деформационная марка	ДМ	\N	1	1
\.


--
-- Name: tsensor_models_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_models_id_seq', 14, true);


--
-- Data for Name: tsensor_photos; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsensor_photos (id, sensor_id, date_cr, user_cr_id, image_id, body) FROM stdin;
\.


--
-- Name: tsensor_photos_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_photos_id_seq', 1, false);


--
-- Data for Name: tsensor_states; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsensor_states (id, name, code) FROM stdin;
1	Рабочее	work
2	Поврежден	damaged
3	Не смонитрован	unmount
4	Не оборудован	unequip
5	Не доступен	unavailable
6	Демонтирован	dismantle
\.


--
-- Name: tsensor_states_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_states_id_seq', 6, true);


--
-- Data for Name: tsensor_values; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsensor_values (id, sensor_id, date_cr, value, date_use, braid_id, allowed_value_type_id) FROM stdin;
\.


--
-- Name: tsensor_values_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensor_values_id_seq', 4044, true);


--
-- Data for Name: tsensors; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsensors (id, facility_id, name, location_x, location_y, location_comments, measurement_mode_id, allowed_model_type_id, state_id, is_retranslator, deep, deep_step, image_id, angle, deleted, pr_sensor_id, measurement_period, reference_date, clipmap) FROM stdin;
\.


--
-- Name: tsensors_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsensors_id_seq', 377, true);


--
-- Data for Name: tsexes; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsexes (id, code) FROM stdin;
1	M
2	F
\.


--
-- Name: tsexes_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsexes_id_seq', 2, true);


--
-- Data for Name: tsexes_l10n; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsexes_l10n (id, fid_id, l10n_id, name) FROM stdin;
1	1	1	Мужской
2	2	1	Женский
\.


--
-- Name: tsexes_l10n_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsexes_l10n_id_seq', 2, true);


--
-- Data for Name: tsocial_network_account_friends; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsocial_network_account_friends (id, fid, email, name, date_birth, avatar_id, sex_id, account_id) FROM stdin;
\.


--
-- Name: tsocial_network_account_friends_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsocial_network_account_friends_id_seq', 1, false);


--
-- Data for Name: tsocial_network_accounts; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsocial_network_accounts (id, user_id, network_id, fid, access_token, fid2, export_token, export_info, export_expires, do_publish) FROM stdin;
\.


--
-- Name: tsocial_network_accounts_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsocial_network_accounts_id_seq', 1, false);


--
-- Data for Name: tsocial_networks; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tsocial_networks (id, code, name, can_post, can_auth, can_friends) FROM stdin;
1	fb	facebook	1	1	1
2	vk	vkontakte	1	1	1
3	ok	odnoklasniki	1	1	1
4	gmail	gmail	0	0	1
5	gplus	gplus	0	1	1
\.


--
-- Name: tsocial_networks_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tsocial_networks_id_seq', 5, true);


--
-- Data for Name: tspreadsheets; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tspreadsheets (id, name, file_id, date_cr, generator, fid) FROM stdin;
\.


--
-- Name: tspreadsheets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tspreadsheets_id_seq', 1, false);


--
-- Data for Name: ttemplate_place_types; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY ttemplate_place_types (id, code, name) FROM stdin;
1	text	Простой текст
2	html	Текст с форматированием
3	image	Изображение
4	href	Ссылка (для удобства)
\.


--
-- Name: ttemplate_place_types_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('ttemplate_place_types_id_seq', 4, true);


--
-- Data for Name: ttemplate_places; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY ttemplate_places (id, template_id, place_type_id, ordering, code, name, admin_height, templatewide, preprocess, href) FROM stdin;
1	4	1	1	section	Режим	1	0	0	\N
\.


--
-- Name: ttemplate_places_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('ttemplate_places_id_seq', 1, true);


--
-- Name: ttemplate_places_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('ttemplate_places_ordering_seq', 1, true);


--
-- Data for Name: ttemplate_places_templatewide; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY ttemplate_places_templatewide (id, place_id, l10n_id, medium_id, body) FROM stdin;
\.


--
-- Name: ttemplate_places_templatewide_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('ttemplate_places_templatewide_id_seq', 1, false);


--
-- Data for Name: ttemplates; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY ttemplates (id, code, name) FROM stdin;
4	\N	Base
\.


--
-- Name: ttemplates_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('ttemplates_id_seq', 4, true);


--
-- Data for Name: tuser_agents; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tuser_agents (id, name, is_robot, device_type) FROM stdin;
\.


--
-- Name: tuser_agents_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tuser_agents_id_seq', 1, false);


--
-- Data for Name: tuser_sessions; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tuser_sessions (id, user_id, sid, date_exp) FROM stdin;
\.


--
-- Name: tuser_sessions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tuser_sessions_id_seq', 851, true);


--
-- Name: tuser_urls_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tuser_urls_id_seq', 1, false);


--
-- Data for Name: tusers; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tusers (id, login, first_name, second_name, last_name, calc_full_name, password, enabled, email, calc_no_roles, sex_id, date_cr, date_birth, im_icq, im_jabber, im_msn, im_skype, phone, date_last_page, avatar_id, about, regsid, prefer_l10n_id) FROM stdin;
1	vahvarh	Владимир	\N	Оленин	Владимир Оленин	$2a$06$Z4zI/UUejzuqwHPnUWVZVevVbMXWuVlmR/NcD2Vk./.tiDfgoHnwm	1	\N	0	\N	2015-08-20 09:00:43.228902	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
2	gonchdog	Георгий	\N	Духовенский	Василий Духовенский	$2a$06$OaYXR2kBvRY7WkODvwoRYu4KVHAoeTRKPLdsXvucxQ1hT5Ps6MwIa	1	\N	0	\N	2015-08-20 09:00:51.760216	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N	\N
\.


--
-- Data for Name: tusers_enrolled; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tusers_enrolled (id, user_id, role_id) FROM stdin;
1	1	1
2	1	2
3	1	3
4	1	4
5	1	5
6	1	6
7	1	7
8	1	8
9	1	9
10	1	10
11	1	11
12	1	12
13	1	13
14	1	14
15	2	1
16	2	2
17	2	3
18	2	4
19	2	5
20	2	6
21	2	7
22	2	8
23	2	9
24	2	10
25	2	11
26	2	12
27	2	13
28	2	14
\.


--
-- Name: tusers_enrolled_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tusers_enrolled_id_seq', 147, true);


--
-- Name: tusers_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tusers_id_seq', 12, true);


--
-- Data for Name: tvisits; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tvisits (id, user_id, anon_id, date_cr, baseurl, params, user_agent_id, ip) FROM stdin;
\.


--
-- Data for Name: tworksheets; Type: TABLE DATA; Schema: public; Owner: erp_gtm
--

COPY tworksheets (id, spreadsheet_id, name, ordering) FROM stdin;
\.


--
-- Name: tworksheets_id_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tworksheets_id_seq', 1, false);


--
-- Name: tworksheets_ordering_seq; Type: SEQUENCE SET; Schema: public; Owner: erp_gtm
--

SELECT pg_catalog.setval('tworksheets_ordering_seq', 1, false);


--
-- Name: tadmin_start_widgets_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tadmin_start_widgets
    ADD CONSTRAINT tadmin_start_widgets_ordering_key UNIQUE (ordering);


--
-- Name: tadmin_start_widgets_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tadmin_start_widgets
    ADD CONSTRAINT tadmin_start_widgets_pkey PRIMARY KEY (id);


--
-- Name: tallowed_model_types_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tallowed_model_types
    ADD CONSTRAINT tallowed_model_types_pkey PRIMARY KEY (id);


--
-- Name: tallowed_value_types_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tallowed_value_types
    ADD CONSTRAINT tallowed_value_types_pkey PRIMARY KEY (id);


--
-- Name: tanon_cookies_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tanon_cookies
    ADD CONSTRAINT tanon_cookies_pkey PRIMARY KEY (id);


--
-- Name: tanon_cookies_sid_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tanon_cookies
    ADD CONSTRAINT tanon_cookies_sid_key UNIQUE (sid);


--
-- Name: tarticle_categories_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticle_categories
    ADD CONSTRAINT tarticle_categories_code_key UNIQUE (code);


--
-- Name: tarticle_categories_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticle_categories_l10n
    ADD CONSTRAINT tarticle_categories_l10n_pkey PRIMARY KEY (id);


--
-- Name: tarticle_categories_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticle_categories
    ADD CONSTRAINT tarticle_categories_pkey PRIMARY KEY (id);


--
-- Name: tarticles_calc_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_calc_code_key UNIQUE (calc_code);


--
-- Name: tarticles_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles_l10n
    ADD CONSTRAINT tarticles_l10n_pkey PRIMARY KEY (id);


--
-- Name: tarticles_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_pkey PRIMARY KEY (id);


--
-- Name: tbase_padding_principles_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tbase_padding_principles
    ADD CONSTRAINT tbase_padding_principles_pkey PRIMARY KEY (id);


--
-- Name: tbraids_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tbraids
    ADD CONSTRAINT tbraids_pkey PRIMARY KEY (id);


--
-- Name: tcart_items_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_items
    ADD CONSTRAINT tcart_items_pkey PRIMARY KEY (id);


--
-- Name: tcart_payment_methods_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods
    ADD CONSTRAINT tcart_payment_methods_code_key UNIQUE (code);


--
-- Name: tcart_payment_methods_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods_l10n
    ADD CONSTRAINT tcart_payment_methods_l10n_pkey PRIMARY KEY (id);


--
-- Name: tcart_payment_methods_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods
    ADD CONSTRAINT tcart_payment_methods_pkey PRIMARY KEY (id);


--
-- Name: tcart_states_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_states
    ADD CONSTRAINT tcart_states_code_key UNIQUE (code);


--
-- Name: tcart_states_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_states_l10n
    ADD CONSTRAINT tcart_states_l10n_pkey PRIMARY KEY (id);


--
-- Name: tcart_states_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_states
    ADD CONSTRAINT tcart_states_pkey PRIMARY KEY (id);


--
-- Name: tcarts_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_pkey PRIMARY KEY (id);


--
-- Name: tcarts_sid_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_sid_key UNIQUE (sid);


--
-- Name: tcells_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcells
    ADD CONSTRAINT tcells_pkey PRIMARY KEY (id);


--
-- Name: tcontent_boxes_groups_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_groups
    ADD CONSTRAINT tcontent_boxes_groups_code_key UNIQUE (code);


--
-- Name: tcontent_boxes_groups_name_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_groups
    ADD CONSTRAINT tcontent_boxes_groups_name_key UNIQUE (name);


--
-- Name: tcontent_boxes_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_groups
    ADD CONSTRAINT tcontent_boxes_groups_pkey PRIMARY KEY (id);


--
-- Name: tcontent_boxes_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_l10n
    ADD CONSTRAINT tcontent_boxes_l10n_pkey PRIMARY KEY (id);


--
-- Name: tcontent_boxes_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes
    ADD CONSTRAINT tcontent_boxes_ordering_key UNIQUE (ordering);


--
-- Name: tcontent_boxes_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes
    ADD CONSTRAINT tcontent_boxes_pkey PRIMARY KEY (id);


--
-- Name: tcustom_nav_items_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items_l10n
    ADD CONSTRAINT tcustom_nav_items_l10n_pkey PRIMARY KEY (id);


--
-- Name: tcustom_nav_items_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_ordering_key UNIQUE (ordering);


--
-- Name: tcustom_nav_items_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_pkey PRIMARY KEY (id);


--
-- Name: tcustom_navs_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_navs
    ADD CONSTRAINT tcustom_navs_code_key UNIQUE (code);


--
-- Name: tcustom_navs_name_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_navs
    ADD CONSTRAINT tcustom_navs_name_key UNIQUE (name);


--
-- Name: tcustom_navs_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_navs
    ADD CONSTRAINT tcustom_navs_pkey PRIMARY KEY (id);


--
-- Name: tdebug_requests_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tdebug_requests
    ADD CONSTRAINT tdebug_requests_pkey PRIMARY KEY (id);


--
-- Name: tedit_histories_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tedit_histories
    ADD CONSTRAINT tedit_histories_pkey PRIMARY KEY (id);


--
-- Name: texplications_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY texplications
    ADD CONSTRAINT texplications_pkey PRIMARY KEY (id);


--
-- Name: tfacilities_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_ordering_key UNIQUE (ordering);


--
-- Name: tfacilities_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_pkey PRIMARY KEY (id);


--
-- Name: tfacility_comment_images_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_comment_images
    ADD CONSTRAINT tfacility_comment_images_pkey PRIMARY KEY (id);


--
-- Name: tfacility_comments_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_comments
    ADD CONSTRAINT tfacility_comments_pkey PRIMARY KEY (id);


--
-- Name: tfacility_photos_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_photos
    ADD CONSTRAINT tfacility_photos_pkey PRIMARY KEY (id);


--
-- Name: tfacility_plans_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_plans
    ADD CONSTRAINT tfacility_plans_pkey PRIMARY KEY (id);


--
-- Name: tfacility_states_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_states
    ADD CONSTRAINT tfacility_states_pkey PRIMARY KEY (id);


--
-- Name: tfacility_stats_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_stats
    ADD CONSTRAINT tfacility_stats_pkey PRIMARY KEY (id);


--
-- Name: tfacility_types_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_types
    ADD CONSTRAINT tfacility_types_pkey PRIMARY KEY (id);


--
-- Name: tfile_folders_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_folders
    ADD CONSTRAINT tfile_folders_code_key UNIQUE (code);


--
-- Name: tfile_folders_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_folders_l10n
    ADD CONSTRAINT tfile_folders_l10n_pkey PRIMARY KEY (id);


--
-- Name: tfile_folders_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_folders
    ADD CONSTRAINT tfile_folders_ordering_key UNIQUE (ordering);


--
-- Name: tfile_folders_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_folders
    ADD CONSTRAINT tfile_folders_pkey PRIMARY KEY (id);


--
-- Name: tfile_types_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_types
    ADD CONSTRAINT tfile_types_code_key UNIQUE (code);


--
-- Name: tfile_types_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_types
    ADD CONSTRAINT tfile_types_pkey PRIMARY KEY (id);


--
-- Name: tfiles_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfiles_l10n
    ADD CONSTRAINT tfiles_l10n_pkey PRIMARY KEY (id);


--
-- Name: tfiles_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfiles
    ADD CONSTRAINT tfiles_ordering_key UNIQUE (ordering);


--
-- Name: tfiles_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfiles
    ADD CONSTRAINT tfiles_pkey PRIMARY KEY (id);


--
-- Name: tfmeasurement_periods_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmeasurement_periods
    ADD CONSTRAINT tfmeasurement_periods_pkey PRIMARY KEY (id);


--
-- Name: tforms_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tforms
    ADD CONSTRAINT tforms_code_key UNIQUE (code);


--
-- Name: tforms_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tforms
    ADD CONSTRAINT tforms_pkey PRIMARY KEY (id);


--
-- Name: tguestbook_messages_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tguestbook_messages
    ADD CONSTRAINT tguestbook_messages_pkey PRIMARY KEY (id);


--
-- Name: tguestbooks_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tguestbooks
    ADD CONSTRAINT tguestbooks_code_key UNIQUE (code);


--
-- Name: tguestbooks_name_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tguestbooks
    ADD CONSTRAINT tguestbooks_name_key UNIQUE (name);


--
-- Name: tguestbooks_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tguestbooks
    ADD CONSTRAINT tguestbooks_pkey PRIMARY KEY (id);


--
-- Name: tkvcache_key_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tkvcache
    ADD CONSTRAINT tkvcache_key_key UNIQUE (key);


--
-- Name: tkvcache_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tkvcache
    ADD CONSTRAINT tkvcache_pkey PRIMARY KEY (id);


--
-- Name: tl10n_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tl10n
    ADD CONSTRAINT tl10n_code_key UNIQUE (code);


--
-- Name: tl10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tl10n
    ADD CONSTRAINT tl10n_pkey PRIMARY KEY (id);


--
-- Name: tlogin_attempts_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tlogin_attempts
    ADD CONSTRAINT tlogin_attempts_pkey PRIMARY KEY (id);


--
-- Name: tmail_templates_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmail_templates
    ADD CONSTRAINT tmail_templates_code_key UNIQUE (code);


--
-- Name: tmail_templates_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmail_templates_l10n
    ADD CONSTRAINT tmail_templates_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmail_templates_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmail_templates
    ADD CONSTRAINT tmail_templates_pkey PRIMARY KEY (id);


--
-- Name: tmarket_categories_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_code_key UNIQUE (code);


--
-- Name: tmarket_categories_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories_l10n
    ADD CONSTRAINT tmarket_categories_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_categories_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_categories_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_pkey PRIMARY KEY (id);


--
-- Name: tmarket_field_datatypes_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_datatypes
    ADD CONSTRAINT tmarket_field_datatypes_code_key UNIQUE (code);


--
-- Name: tmarket_field_datatypes_name_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_datatypes
    ADD CONSTRAINT tmarket_field_datatypes_name_key UNIQUE (name);


--
-- Name: tmarket_field_datatypes_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_datatypes
    ADD CONSTRAINT tmarket_field_datatypes_pkey PRIMARY KEY (id);


--
-- Name: tmarket_field_enums_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_enums
    ADD CONSTRAINT tmarket_field_enums_pkey PRIMARY KEY (id);


--
-- Name: tmarket_field_enumsl_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_enumsl
    ADD CONSTRAINT tmarket_field_enumsl_pkey PRIMARY KEY (id);


--
-- Name: tmarket_field_groups_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups_l10n
    ADD CONSTRAINT tmarket_field_groups_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_field_groups_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups
    ADD CONSTRAINT tmarket_field_groups_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_field_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups
    ADD CONSTRAINT tmarket_field_groups_pkey PRIMARY KEY (id);


--
-- Name: tmarket_fields_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields_l10n
    ADD CONSTRAINT tmarket_fields_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_fields_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_fields_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_enums_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enums
    ADD CONSTRAINT tmarket_item_fields_enums_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_enumsl_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enumsl
    ADD CONSTRAINT tmarket_item_fields_enumsl_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_f_item_id_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_f
    ADD CONSTRAINT tmarket_item_fields_f_item_id_key UNIQUE (item_id);


--
-- Name: tmarket_item_fields_f_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_f
    ADD CONSTRAINT tmarket_item_fields_f_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_i_item_id_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_i
    ADD CONSTRAINT tmarket_item_fields_i_item_id_key UNIQUE (item_id);


--
-- Name: tmarket_item_fields_i_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_i
    ADD CONSTRAINT tmarket_item_fields_i_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_il_item_id_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_il
    ADD CONSTRAINT tmarket_item_fields_il_item_id_key UNIQUE (item_id);


--
-- Name: tmarket_item_fields_il_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_il
    ADD CONSTRAINT tmarket_item_fields_il_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_s_item_id_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_s
    ADD CONSTRAINT tmarket_item_fields_s_item_id_key UNIQUE (item_id);


--
-- Name: tmarket_item_fields_s_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_s
    ADD CONSTRAINT tmarket_item_fields_s_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_fields_sl_item_id_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_sl
    ADD CONSTRAINT tmarket_item_fields_sl_item_id_key UNIQUE (item_id);


--
-- Name: tmarket_item_fields_sl_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_sl
    ADD CONSTRAINT tmarket_item_fields_sl_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_groups_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups_l10n
    ADD CONSTRAINT tmarket_item_groups_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_item_groups_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups
    ADD CONSTRAINT tmarket_item_groups_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_item_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups
    ADD CONSTRAINT tmarket_item_groups_pkey PRIMARY KEY (id);


--
-- Name: tmarket_items_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_code_key UNIQUE (code);


--
-- Name: tmarket_items_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items_l10n
    ADD CONSTRAINT tmarket_items_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_items_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_items_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_pkey PRIMARY KEY (id);


--
-- Name: tmarket_manufacturers_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers
    ADD CONSTRAINT tmarket_manufacturers_code_key UNIQUE (code);


--
-- Name: tmarket_manufacturers_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers_l10n
    ADD CONSTRAINT tmarket_manufacturers_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_manufacturers_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers
    ADD CONSTRAINT tmarket_manufacturers_ordering_key UNIQUE (ordering);


--
-- Name: tmarket_manufacturers_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers
    ADD CONSTRAINT tmarket_manufacturers_pkey PRIMARY KEY (id);


--
-- Name: tmarket_search_levels_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels
    ADD CONSTRAINT tmarket_search_levels_code_key UNIQUE (code);


--
-- Name: tmarket_search_levels_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels_l10n
    ADD CONSTRAINT tmarket_search_levels_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_search_levels_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels
    ADD CONSTRAINT tmarket_search_levels_pkey PRIMARY KEY (id);


--
-- Name: tmarket_view_levels_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels
    ADD CONSTRAINT tmarket_view_levels_code_key UNIQUE (code);


--
-- Name: tmarket_view_levels_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels_l10n
    ADD CONSTRAINT tmarket_view_levels_l10n_pkey PRIMARY KEY (id);


--
-- Name: tmarket_view_levels_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels
    ADD CONSTRAINT tmarket_view_levels_pkey PRIMARY KEY (id);


--
-- Name: tmeasurement_modes_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmeasurement_modes
    ADD CONSTRAINT tmeasurement_modes_pkey PRIMARY KEY (id);


--
-- Name: tmeasurer_value_types_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmeasurer_value_types
    ADD CONSTRAINT tmeasurer_value_types_code_key UNIQUE (code);


--
-- Name: tmeasurer_value_types_name_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmeasurer_value_types
    ADD CONSTRAINT tmeasurer_value_types_name_key UNIQUE (name);


--
-- Name: tmeasurer_value_types_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmeasurer_value_types
    ADD CONSTRAINT tmeasurer_value_types_pkey PRIMARY KEY (id);


--
-- Name: tmediums_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmediums
    ADD CONSTRAINT tmediums_code_key UNIQUE (code);


--
-- Name: tmediums_name_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmediums
    ADD CONSTRAINT tmediums_name_key UNIQUE (name);


--
-- Name: tmediums_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmediums
    ADD CONSTRAINT tmediums_ordering_key UNIQUE (ordering);


--
-- Name: tmediums_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmediums
    ADD CONSTRAINT tmediums_pkey PRIMARY KEY (id);


--
-- Name: tnormatives_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tnormative_types
    ADD CONSTRAINT tnormatives_pkey PRIMARY KEY (id);


--
-- Name: tnormatives_pkey1; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tnormatives
    ADD CONSTRAINT tnormatives_pkey1 PRIMARY KEY (id);


--
-- Name: tpage_blocks_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpage_blocks
    ADD CONSTRAINT tpage_blocks_pkey PRIMARY KEY (id);


--
-- Name: tpages_alias_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_alias_key UNIQUE (alias);


--
-- Name: tpages_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages_l10n
    ADD CONSTRAINT tpages_l10n_pkey PRIMARY KEY (id);


--
-- Name: tpages_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_ordering_key UNIQUE (ordering);


--
-- Name: tpages_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_pkey PRIMARY KEY (id);


--
-- Name: tpayment_service_errors_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpayment_service_errors
    ADD CONSTRAINT tpayment_service_errors_pkey PRIMARY KEY (id);


--
-- Name: tpayment_service_invoices_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpayment_service_invoices
    ADD CONSTRAINT tpayment_service_invoices_pkey PRIMARY KEY (id);


--
-- Name: tplan_formats_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tplan_formats
    ADD CONSTRAINT tplan_formats_pkey PRIMARY KEY (id);


--
-- Name: tplans_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_pkey PRIMARY KEY (id);


--
-- Name: treferences_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY treferences
    ADD CONSTRAINT treferences_ordering_key UNIQUE (ordering);


--
-- Name: treferences_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY treferences
    ADD CONSTRAINT treferences_pkey PRIMARY KEY (id);


--
-- Name: trewrites_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY trewrites
    ADD CONSTRAINT trewrites_pkey PRIMARY KEY (id);


--
-- Name: trewrites_regexp_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY trewrites
    ADD CONSTRAINT trewrites_regexp_key UNIQUE (regexp);


--
-- Name: troles_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY troles
    ADD CONSTRAINT troles_code_key UNIQUE (code);


--
-- Name: troles_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY troles_l10n
    ADD CONSTRAINT troles_l10n_pkey PRIMARY KEY (id);


--
-- Name: troles_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY troles
    ADD CONSTRAINT troles_pkey PRIMARY KEY (id);


--
-- Name: tsensor_comment_images_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_comment_images
    ADD CONSTRAINT tsensor_comment_images_pkey PRIMARY KEY (id);


--
-- Name: tsensor_comments_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_comments
    ADD CONSTRAINT tsensor_comments_pkey PRIMARY KEY (id);


--
-- Name: tsensor_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_groups
    ADD CONSTRAINT tsensor_groups_pkey PRIMARY KEY (id);


--
-- Name: tsensor_groups_pkey1; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_groups
    ADD CONSTRAINT tsensor_groups_pkey1 PRIMARY KEY (id);


--
-- Name: tsensor_model_measurers_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers
    ADD CONSTRAINT tsensor_model_measurers_ordering_key UNIQUE (ordering);


--
-- Name: tsensor_model_measurers_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers
    ADD CONSTRAINT tsensor_model_measurers_pkey PRIMARY KEY (id);


--
-- Name: tsensor_model_normatives_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_normatives
    ADD CONSTRAINT tsensor_model_normatives_pkey PRIMARY KEY (id);


--
-- Name: tsensor_model_types_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_types
    ADD CONSTRAINT tsensor_model_types_pkey PRIMARY KEY (id);


--
-- Name: tsensor_models_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_models
    ADD CONSTRAINT tsensor_models_code_key UNIQUE (code);


--
-- Name: tsensor_models_name_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_models
    ADD CONSTRAINT tsensor_models_name_key UNIQUE (name);


--
-- Name: tsensor_models_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_models
    ADD CONSTRAINT tsensor_models_pkey PRIMARY KEY (id);


--
-- Name: tsensor_photos_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_photos
    ADD CONSTRAINT tsensor_photos_pkey PRIMARY KEY (id);


--
-- Name: tsensor_states_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_states
    ADD CONSTRAINT tsensor_states_pkey PRIMARY KEY (id);


--
-- Name: tsensor_values_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_values
    ADD CONSTRAINT tsensor_values_pkey PRIMARY KEY (id);


--
-- Name: tsensors_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_pkey PRIMARY KEY (id);


--
-- Name: tsexes_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsexes
    ADD CONSTRAINT tsexes_code_key UNIQUE (code);


--
-- Name: tsexes_l10n_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsexes_l10n
    ADD CONSTRAINT tsexes_l10n_pkey PRIMARY KEY (id);


--
-- Name: tsexes_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsexes
    ADD CONSTRAINT tsexes_pkey PRIMARY KEY (id);


--
-- Name: tsocial_network_account_friends_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_network_account_friends
    ADD CONSTRAINT tsocial_network_account_friends_pkey PRIMARY KEY (id);


--
-- Name: tsocial_network_accounts_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_network_accounts
    ADD CONSTRAINT tsocial_network_accounts_pkey PRIMARY KEY (id);


--
-- Name: tsocial_networks_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_networks
    ADD CONSTRAINT tsocial_networks_code_key UNIQUE (code);


--
-- Name: tsocial_networks_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_networks
    ADD CONSTRAINT tsocial_networks_pkey PRIMARY KEY (id);


--
-- Name: tspreadsheets_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tspreadsheets
    ADD CONSTRAINT tspreadsheets_pkey PRIMARY KEY (id);


--
-- Name: ttemplate_place_types_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_place_types
    ADD CONSTRAINT ttemplate_place_types_code_key UNIQUE (code);


--
-- Name: ttemplate_place_types_name_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_place_types
    ADD CONSTRAINT ttemplate_place_types_name_key UNIQUE (name);


--
-- Name: ttemplate_place_types_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_place_types
    ADD CONSTRAINT ttemplate_place_types_pkey PRIMARY KEY (id);


--
-- Name: ttemplate_places_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_places
    ADD CONSTRAINT ttemplate_places_ordering_key UNIQUE (ordering);


--
-- Name: ttemplate_places_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_places
    ADD CONSTRAINT ttemplate_places_pkey PRIMARY KEY (id);


--
-- Name: ttemplate_places_templatewide_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_places_templatewide
    ADD CONSTRAINT ttemplate_places_templatewide_pkey PRIMARY KEY (id);


--
-- Name: ttemplates_code_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplates
    ADD CONSTRAINT ttemplates_code_key UNIQUE (code);


--
-- Name: ttemplates_name_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplates
    ADD CONSTRAINT ttemplates_name_key UNIQUE (name);


--
-- Name: ttemplates_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplates
    ADD CONSTRAINT ttemplates_pkey PRIMARY KEY (id);


--
-- Name: tuser_agents_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tuser_agents
    ADD CONSTRAINT tuser_agents_pkey PRIMARY KEY (id);


--
-- Name: tuser_sessions_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tuser_sessions
    ADD CONSTRAINT tuser_sessions_pkey PRIMARY KEY (id);


--
-- Name: tuser_sessions_sid_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tuser_sessions
    ADD CONSTRAINT tuser_sessions_sid_key UNIQUE (sid);


--
-- Name: tuser_urls_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tvisits
    ADD CONSTRAINT tuser_urls_pkey PRIMARY KEY (id);


--
-- Name: tusers_enrolled_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tusers_enrolled
    ADD CONSTRAINT tusers_enrolled_pkey PRIMARY KEY (id);


--
-- Name: tusers_login_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_login_key UNIQUE (login);


--
-- Name: tusers_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_pkey PRIMARY KEY (id);


--
-- Name: tusers_regsid_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_regsid_key UNIQUE (regsid);


--
-- Name: tworksheets_ordering_key; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tworksheets
    ADD CONSTRAINT tworksheets_ordering_key UNIQUE (ordering);


--
-- Name: tworksheets_pkey; Type: CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tworksheets
    ADD CONSTRAINT tworksheets_pkey PRIMARY KEY (id);


--
-- Name: iarticle_categories_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX iarticle_categories_l10n ON tarticle_categories_l10n USING btree (fid_id, l10n_id);


--
-- Name: iarticles_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX iarticles_l10n ON tarticles_l10n USING btree (fid_id, l10n_id);


--
-- Name: icart_items1; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX icart_items1 ON tcart_items USING btree (cart_id, market_item_id);


--
-- Name: icart_items2; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX icart_items2 ON tcart_items USING btree (cart_id, other_ftype, other_fid);


--
-- Name: icontent_boxes_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX icontent_boxes_l10n ON tcontent_boxes_l10n USING btree (fid_id, l10n_id);


--
-- Name: icustom_nav_items_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX icustom_nav_items_l10n ON tcustom_nav_items_l10n USING btree (fid_id, l10n_id);


--
-- Name: iedit_histories_indx1; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE INDEX iedit_histories_indx1 ON tedit_histories USING btree (model_name, facility_id);


--
-- Name: ifile_folders_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX ifile_folders_l10n ON tfile_folders_l10n USING btree (fid_id, l10n_id);


--
-- Name: ifiles_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX ifiles_l10n ON tfiles_l10n USING btree (fid_id, l10n_id);


--
-- Name: imail_templates_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX imail_templates_l10n ON tmail_templates_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_categories_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX imarket_categories_l10n ON tmarket_categories_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_field_enums; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX imarket_field_enums ON tmarket_field_enums USING btree (field_id, value);


--
-- Name: imarket_field_enumsl; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX imarket_field_enumsl ON tmarket_field_enumsl USING btree (field_id, value);


--
-- Name: imarket_field_groups_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX imarket_field_groups_l10n ON tmarket_field_groups_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_fields_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX imarket_fields_l10n ON tmarket_fields_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_item_groups_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX imarket_item_groups_l10n ON tmarket_item_groups_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_items_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX imarket_items_l10n ON tmarket_items_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_manufacturers_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX imarket_manufacturers_l10n ON tmarket_manufacturers_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_search_levels_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX imarket_search_levels_l10n ON tmarket_search_levels_l10n USING btree (fid_id, l10n_id);


--
-- Name: imarket_view_levels_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX imarket_view_levels_l10n ON tmarket_view_levels_l10n USING btree (fid_id, l10n_id);


--
-- Name: ipage_blocks; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX ipage_blocks ON tpage_blocks USING btree (page_id, l10n_id, medium_id, place_id);


--
-- Name: ipages1; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE INDEX ipages1 ON tpages USING btree (parent_id);


--
-- Name: ipages2; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX ipages2 ON tpages USING btree (parent_id, ordering);


--
-- Name: ipages_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX ipages_l10n ON tpages_l10n USING btree (fid_id, l10n_id);


--
-- Name: iroles_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX iroles_l10n ON troles_l10n USING btree (fid_id, l10n_id);


--
-- Name: isexes_l10n; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX isexes_l10n ON tsexes_l10n USING btree (fid_id, l10n_id);


--
-- Name: isocial_network_accounts1; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX isocial_network_accounts1 ON tsocial_network_accounts USING btree (network_id, fid);


--
-- Name: itemplate_places; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX itemplate_places ON ttemplate_places USING btree (template_id, code);


--
-- Name: itemplate_places_templatewide; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX itemplate_places_templatewide ON ttemplate_places_templatewide USING btree (place_id, medium_id, l10n_id);


--
-- Name: iuser_sessions1; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE INDEX iuser_sessions1 ON tuser_sessions USING btree (date_exp);


--
-- Name: iusers_enrolled; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX iusers_enrolled ON tusers_enrolled USING btree (user_id, role_id);


--
-- Name: iusers_enrolled1; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE INDEX iusers_enrolled1 ON tusers_enrolled USING btree (user_id);


--
-- Name: tarticle_categories_groupcode_key; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE INDEX tarticle_categories_groupcode_key ON tarticle_categories USING btree (groupcode);


--
-- Name: tbraids_index1; Type: INDEX; Schema: public; Owner: erp_gtm
--

CREATE UNIQUE INDEX tbraids_index1 ON tbraids USING btree (deep, sensor_id);


--
-- Name: tallowed_model_types_sensor_model_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tallowed_model_types
    ADD CONSTRAINT tallowed_model_types_sensor_model_id_fkey FOREIGN KEY (sensor_model_id) REFERENCES tsensor_models(id);


--
-- Name: tallowed_model_types_sensor_model_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tallowed_model_types
    ADD CONSTRAINT tallowed_model_types_sensor_model_type_id_fkey FOREIGN KEY (sensor_model_type_id) REFERENCES tsensor_model_types(id);


--
-- Name: tallowed_value_types_allowed_model_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tallowed_value_types
    ADD CONSTRAINT tallowed_value_types_allowed_model_type_id_fkey FOREIGN KEY (allowed_model_type_id) REFERENCES tallowed_model_types(id);


--
-- Name: tallowed_value_types_measure_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tallowed_value_types
    ADD CONSTRAINT tallowed_value_types_measure_id_fkey FOREIGN KEY (measure_id) REFERENCES tmeasurer_value_types(id);


--
-- Name: tanon_cookies_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tanon_cookies
    ADD CONSTRAINT tanon_cookies_user_agent_id_fkey FOREIGN KEY (user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tarticle_categories_image1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticle_categories
    ADD CONSTRAINT tarticle_categories_image1_id_fkey FOREIGN KEY (image1_id) REFERENCES tfiles(id);


--
-- Name: tarticle_categories_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticle_categories
    ADD CONSTRAINT tarticle_categories_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tarticle_categories_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticle_categories_l10n
    ADD CONSTRAINT tarticle_categories_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tarticle_categories(id);


--
-- Name: tarticle_categories_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticle_categories_l10n
    ADD CONSTRAINT tarticle_categories_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tarticles_category_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_category_id_fkey FOREIGN KEY (category_id) REFERENCES tarticle_categories(id);


--
-- Name: tarticles_folder_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_folder_id_fkey FOREIGN KEY (folder_id) REFERENCES tfile_folders(id);


--
-- Name: tarticles_image1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_image1_id_fkey FOREIGN KEY (image1_id) REFERENCES tfiles(id);


--
-- Name: tarticles_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tarticles_image3_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_image3_id_fkey FOREIGN KEY (image3_id) REFERENCES tfiles(id);


--
-- Name: tarticles_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles_l10n
    ADD CONSTRAINT tarticles_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tarticles(id);


--
-- Name: tarticles_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles_l10n
    ADD CONSTRAINT tarticles_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tarticles_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tarticles
    ADD CONSTRAINT tarticles_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tbraids_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tbraids
    ADD CONSTRAINT tbraids_sensor_id_fkey FOREIGN KEY (sensor_id) REFERENCES tsensors(id);


--
-- Name: tcart_items_cart_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_items
    ADD CONSTRAINT tcart_items_cart_id_fkey FOREIGN KEY (cart_id) REFERENCES tcarts(id);


--
-- Name: tcart_items_market_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_items
    ADD CONSTRAINT tcart_items_market_item_id_fkey FOREIGN KEY (market_item_id) REFERENCES tmarket_items(id);


--
-- Name: tcart_payment_methods_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods_l10n
    ADD CONSTRAINT tcart_payment_methods_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tcart_payment_methods(id);


--
-- Name: tcart_payment_methods_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_payment_methods_l10n
    ADD CONSTRAINT tcart_payment_methods_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tcart_states_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_states_l10n
    ADD CONSTRAINT tcart_states_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tcart_states(id);


--
-- Name: tcart_states_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcart_states_l10n
    ADD CONSTRAINT tcart_states_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tcarts_manager_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_manager_id_fkey FOREIGN KEY (manager_id) REFERENCES tusers(id);


--
-- Name: tcarts_payment_method_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_payment_method_id_fkey FOREIGN KEY (payment_method_id) REFERENCES tcart_payment_methods(id);


--
-- Name: tcarts_state_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_state_id_fkey FOREIGN KEY (state_id) REFERENCES tcart_states(id);


--
-- Name: tcarts_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcarts
    ADD CONSTRAINT tcarts_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tcells_worksheet_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcells
    ADD CONSTRAINT tcells_worksheet_id_fkey FOREIGN KEY (worksheet_id) REFERENCES tworksheets(id);


--
-- Name: tcontent_boxes_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes
    ADD CONSTRAINT tcontent_boxes_group_id_fkey FOREIGN KEY (group_id) REFERENCES tcontent_boxes_groups(id);


--
-- Name: tcontent_boxes_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes
    ADD CONSTRAINT tcontent_boxes_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tcontent_boxes_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes
    ADD CONSTRAINT tcontent_boxes_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tcontent_boxes_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_l10n
    ADD CONSTRAINT tcontent_boxes_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tcontent_boxes(id);


--
-- Name: tcontent_boxes_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_l10n
    ADD CONSTRAINT tcontent_boxes_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tcontent_boxes_l10n_override_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcontent_boxes_l10n
    ADD CONSTRAINT tcontent_boxes_l10n_override_image_id_fkey FOREIGN KEY (override_image_id) REFERENCES tfiles(id);


--
-- Name: tcustom_nav_items_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tcustom_nav_items_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items_l10n
    ADD CONSTRAINT tcustom_nav_items_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tcustom_nav_items(id);


--
-- Name: tcustom_nav_items_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items_l10n
    ADD CONSTRAINT tcustom_nav_items_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tcustom_nav_items_nav_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_nav_id_fkey FOREIGN KEY (nav_id) REFERENCES tcustom_navs(id);


--
-- Name: tcustom_nav_items_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_page_id_fkey FOREIGN KEY (page_id) REFERENCES tpages(id);


--
-- Name: tcustom_nav_items_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tcustom_nav_items
    ADD CONSTRAINT tcustom_nav_items_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES tcustom_nav_items(id);


--
-- Name: tdebug_requests_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tdebug_requests
    ADD CONSTRAINT tdebug_requests_user_agent_id_fkey FOREIGN KEY (user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tdebug_requests_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tdebug_requests
    ADD CONSTRAINT tdebug_requests_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tedit_histories_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tedit_histories
    ADD CONSTRAINT tedit_histories_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tedit_histories_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tedit_histories
    ADD CONSTRAINT tedit_histories_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: texplications_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY texplications
    ADD CONSTRAINT texplications_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tfacilities_base_principle_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_base_principle_id_fkey FOREIGN KEY (base_principle_id) REFERENCES tbase_padding_principles(id);


--
-- Name: tfacilities_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tfacilities_plan_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_plan_id_fkey FOREIGN KEY (plan_id) REFERENCES tplans(id);


--
-- Name: tfacilities_state_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacilities
    ADD CONSTRAINT tfacilities_state_id_fkey FOREIGN KEY (state_id) REFERENCES tfacility_states(id);


--
-- Name: tfacility_comment_images_comment_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_comment_images
    ADD CONSTRAINT tfacility_comment_images_comment_id_fkey FOREIGN KEY (comment_id) REFERENCES tfacility_comments(id);


--
-- Name: tfacility_comment_images_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_comment_images
    ADD CONSTRAINT tfacility_comment_images_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tfacility_comments_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_comments
    ADD CONSTRAINT tfacility_comments_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tfacility_comments_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_comments
    ADD CONSTRAINT tfacility_comments_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tfacility_photos_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_photos
    ADD CONSTRAINT tfacility_photos_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tfacility_photos_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_photos
    ADD CONSTRAINT tfacility_photos_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tfacility_photos_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_photos
    ADD CONSTRAINT tfacility_photos_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tfacility_plans_dwg_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_plans
    ADD CONSTRAINT tfacility_plans_dwg_id_fkey FOREIGN KEY (dwg_id) REFERENCES tfiles(id);


--
-- Name: tfacility_plans_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_plans
    ADD CONSTRAINT tfacility_plans_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tfacility_stats_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_stats
    ADD CONSTRAINT tfacility_stats_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tfile_folders_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_folders_l10n
    ADD CONSTRAINT tfile_folders_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tfile_folders(id);


--
-- Name: tfile_folders_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_folders_l10n
    ADD CONSTRAINT tfile_folders_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tfile_folders_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_folders
    ADD CONSTRAINT tfile_folders_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES tfile_folders(id);


--
-- Name: tfile_folders_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfile_folders
    ADD CONSTRAINT tfile_folders_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tfiles_file_folder_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfiles
    ADD CONSTRAINT tfiles_file_folder_id_fkey FOREIGN KEY (file_folder_id) REFERENCES tfile_folders(id);


--
-- Name: tfiles_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfiles_l10n
    ADD CONSTRAINT tfiles_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tfiles(id);


--
-- Name: tfiles_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfiles_l10n
    ADD CONSTRAINT tfiles_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tfiles_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfiles
    ADD CONSTRAINT tfiles_type_id_fkey FOREIGN KEY (type_id) REFERENCES tfile_types(id);


--
-- Name: tfiles_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfiles
    ADD CONSTRAINT tfiles_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tfmeasurement_periods_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmeasurement_periods
    ADD CONSTRAINT tfmeasurement_periods_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tfmeasurement_periods_sensor_model_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmeasurement_periods
    ADD CONSTRAINT tfmeasurement_periods_sensor_model_id_fkey FOREIGN KEY (sensor_model_id) REFERENCES tsensor_models(id);


--
-- Name: tforms_mail_template1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tforms
    ADD CONSTRAINT tforms_mail_template1_id_fkey FOREIGN KEY (mail_template1_id) REFERENCES tmail_templates(id);


--
-- Name: tforms_mail_template2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tforms
    ADD CONSTRAINT tforms_mail_template2_id_fkey FOREIGN KEY (mail_template2_id) REFERENCES tmail_templates(id);


--
-- Name: tguestbook_messages_guestbook_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tguestbook_messages
    ADD CONSTRAINT tguestbook_messages_guestbook_id_fkey FOREIGN KEY (guestbook_id) REFERENCES tguestbooks(id);


--
-- Name: tguestbook_messages_user_a_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tguestbook_messages
    ADD CONSTRAINT tguestbook_messages_user_a_id_fkey FOREIGN KEY (user_a_id) REFERENCES tusers(id);


--
-- Name: tguestbook_messages_user_q_avatar_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tguestbook_messages
    ADD CONSTRAINT tguestbook_messages_user_q_avatar_id_fkey FOREIGN KEY (user_q_avatar_id) REFERENCES tfiles(id);


--
-- Name: tlogin_attempts_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tlogin_attempts
    ADD CONSTRAINT tlogin_attempts_user_agent_id_fkey FOREIGN KEY (user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tmail_templates_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmail_templates_l10n
    ADD CONSTRAINT tmail_templates_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmail_templates(id);


--
-- Name: tmail_templates_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmail_templates_l10n
    ADD CONSTRAINT tmail_templates_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_categories_image1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_image1_id_fkey FOREIGN KEY (image1_id) REFERENCES tfiles(id);


--
-- Name: tmarket_categories_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tmarket_categories_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories_l10n
    ADD CONSTRAINT tmarket_categories_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_categories(id);


--
-- Name: tmarket_categories_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories_l10n
    ADD CONSTRAINT tmarket_categories_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_categories_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_categories
    ADD CONSTRAINT tmarket_categories_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES tmarket_categories(id);


--
-- Name: tmarket_field_enums_field_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_enums
    ADD CONSTRAINT tmarket_field_enums_field_id_fkey FOREIGN KEY (field_id) REFERENCES tmarket_fields(id);


--
-- Name: tmarket_field_enumsl_field_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_enumsl
    ADD CONSTRAINT tmarket_field_enumsl_field_id_fkey FOREIGN KEY (field_id) REFERENCES tmarket_fields(id);


--
-- Name: tmarket_field_enumsl_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_enumsl
    ADD CONSTRAINT tmarket_field_enumsl_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_field_groups_category_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups
    ADD CONSTRAINT tmarket_field_groups_category_id_fkey FOREIGN KEY (category_id) REFERENCES tmarket_categories(id);


--
-- Name: tmarket_field_groups_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups_l10n
    ADD CONSTRAINT tmarket_field_groups_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_field_groups(id);


--
-- Name: tmarket_field_groups_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_field_groups_l10n
    ADD CONSTRAINT tmarket_field_groups_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_fields_datatype_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_datatype_id_fkey FOREIGN KEY (datatype_id) REFERENCES tmarket_field_datatypes(id);


--
-- Name: tmarket_fields_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_group_id_fkey FOREIGN KEY (group_id) REFERENCES tmarket_field_groups(id);


--
-- Name: tmarket_fields_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields_l10n
    ADD CONSTRAINT tmarket_fields_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_fields(id);


--
-- Name: tmarket_fields_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields_l10n
    ADD CONSTRAINT tmarket_fields_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_fields_search_level_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_search_level_id_fkey FOREIGN KEY (search_level_id) REFERENCES tmarket_search_levels(id);


--
-- Name: tmarket_fields_view_level_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_fields
    ADD CONSTRAINT tmarket_fields_view_level_id_fkey FOREIGN KEY (view_level_id) REFERENCES tmarket_view_levels(id);


--
-- Name: tmarket_item_fields_enums_enum_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enums
    ADD CONSTRAINT tmarket_item_fields_enums_enum_id_fkey FOREIGN KEY (enum_id) REFERENCES tmarket_field_enums(id);


--
-- Name: tmarket_item_fields_enums_field_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enums
    ADD CONSTRAINT tmarket_item_fields_enums_field_id_fkey FOREIGN KEY (field_id) REFERENCES tmarket_fields(id);


--
-- Name: tmarket_item_fields_enums_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enums
    ADD CONSTRAINT tmarket_item_fields_enums_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_enumsl_enum_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enumsl
    ADD CONSTRAINT tmarket_item_fields_enumsl_enum_id_fkey FOREIGN KEY (enum_id) REFERENCES tmarket_field_enumsl(id);


--
-- Name: tmarket_item_fields_enumsl_field_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enumsl
    ADD CONSTRAINT tmarket_item_fields_enumsl_field_id_fkey FOREIGN KEY (field_id) REFERENCES tmarket_fields(id);


--
-- Name: tmarket_item_fields_enumsl_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_enumsl
    ADD CONSTRAINT tmarket_item_fields_enumsl_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_f_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_f
    ADD CONSTRAINT tmarket_item_fields_f_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_i_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_i
    ADD CONSTRAINT tmarket_item_fields_i_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_il_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_il
    ADD CONSTRAINT tmarket_item_fields_il_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_il_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_il
    ADD CONSTRAINT tmarket_item_fields_il_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_s_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_s
    ADD CONSTRAINT tmarket_item_fields_s_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_sl_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_sl
    ADD CONSTRAINT tmarket_item_fields_sl_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_fields_sl_item_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_fields_sl
    ADD CONSTRAINT tmarket_item_fields_sl_item_id_fkey FOREIGN KEY (item_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_item_groups_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups_l10n
    ADD CONSTRAINT tmarket_item_groups_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_item_groups(id);


--
-- Name: tmarket_item_groups_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_item_groups_l10n
    ADD CONSTRAINT tmarket_item_groups_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_items_category_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_category_id_fkey FOREIGN KEY (category_id) REFERENCES tmarket_categories(id);


--
-- Name: tmarket_items_file_folder_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_file_folder_id_fkey FOREIGN KEY (file_folder_id) REFERENCES tfile_folders(id);


--
-- Name: tmarket_items_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_group_id_fkey FOREIGN KEY (group_id) REFERENCES tmarket_item_groups(id);


--
-- Name: tmarket_items_image1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_image1_id_fkey FOREIGN KEY (image1_id) REFERENCES tfiles(id);


--
-- Name: tmarket_items_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tmarket_items_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items_l10n
    ADD CONSTRAINT tmarket_items_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_items(id);


--
-- Name: tmarket_items_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items_l10n
    ADD CONSTRAINT tmarket_items_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_items_manufacturer_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_items
    ADD CONSTRAINT tmarket_items_manufacturer_id_fkey FOREIGN KEY (manufacturer_id) REFERENCES tmarket_manufacturers(id);


--
-- Name: tmarket_manufacturers_image1_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers
    ADD CONSTRAINT tmarket_manufacturers_image1_id_fkey FOREIGN KEY (image1_id) REFERENCES tfiles(id);


--
-- Name: tmarket_manufacturers_image2_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers
    ADD CONSTRAINT tmarket_manufacturers_image2_id_fkey FOREIGN KEY (image2_id) REFERENCES tfiles(id);


--
-- Name: tmarket_manufacturers_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers_l10n
    ADD CONSTRAINT tmarket_manufacturers_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_manufacturers(id);


--
-- Name: tmarket_manufacturers_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_manufacturers_l10n
    ADD CONSTRAINT tmarket_manufacturers_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_search_levels_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels_l10n
    ADD CONSTRAINT tmarket_search_levels_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_search_levels(id);


--
-- Name: tmarket_search_levels_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_search_levels_l10n
    ADD CONSTRAINT tmarket_search_levels_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tmarket_view_levels_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels_l10n
    ADD CONSTRAINT tmarket_view_levels_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tmarket_view_levels(id);


--
-- Name: tmarket_view_levels_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tmarket_view_levels_l10n
    ADD CONSTRAINT tmarket_view_levels_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tnormatives_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tnormatives
    ADD CONSTRAINT tnormatives_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tnormatives_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tnormatives
    ADD CONSTRAINT tnormatives_type_id_fkey FOREIGN KEY (type_id) REFERENCES tnormative_types(id);


--
-- Name: tpage_blocks_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpage_blocks
    ADD CONSTRAINT tpage_blocks_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tpage_blocks_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpage_blocks
    ADD CONSTRAINT tpage_blocks_page_id_fkey FOREIGN KEY (page_id) REFERENCES tpages(id);


--
-- Name: tpage_blocks_place_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpage_blocks
    ADD CONSTRAINT tpage_blocks_place_id_fkey FOREIGN KEY (place_id) REFERENCES ttemplate_places(id);


--
-- Name: tpages_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages_l10n
    ADD CONSTRAINT tpages_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tpages(id);


--
-- Name: tpages_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages_l10n
    ADD CONSTRAINT tpages_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tpages_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES tpages(id);


--
-- Name: tpages_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_role_id_fkey FOREIGN KEY (role_id) REFERENCES troles(id);


--
-- Name: tpages_template_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpages
    ADD CONSTRAINT tpages_template_id_fkey FOREIGN KEY (template_id) REFERENCES ttemplates(id);


--
-- Name: tpayment_service_errors_pay_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpayment_service_errors
    ADD CONSTRAINT tpayment_service_errors_pay_user_agent_id_fkey FOREIGN KEY (pay_user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tpayment_service_invoices_ask_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpayment_service_invoices
    ADD CONSTRAINT tpayment_service_invoices_ask_user_agent_id_fkey FOREIGN KEY (ask_user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tpayment_service_invoices_pay_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpayment_service_invoices
    ADD CONSTRAINT tpayment_service_invoices_pay_user_agent_id_fkey FOREIGN KEY (pay_user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tpayment_service_invoices_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tpayment_service_invoices
    ADD CONSTRAINT tpayment_service_invoices_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tplan_formats_file_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tplan_formats
    ADD CONSTRAINT tplan_formats_file_id_fkey FOREIGN KEY (dwg_id) REFERENCES tfiles(id);


--
-- Name: tplan_formats_stamp_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tplan_formats
    ADD CONSTRAINT tplan_formats_stamp_id_fkey FOREIGN KEY (pdf_id) REFERENCES tfiles(id);


--
-- Name: tplans_calc_pdf_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_calc_pdf_id_fkey FOREIGN KEY (calc_pdf_id) REFERENCES tfiles(id);


--
-- Name: tplans_dwg_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_dwg_id_fkey FOREIGN KEY (dwg_id) REFERENCES tfiles(id);


--
-- Name: tplans_format_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_format_id_fkey FOREIGN KEY (format_id) REFERENCES tplan_formats(id);


--
-- Name: tplans_jpg_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_jpg_id_fkey FOREIGN KEY (jpg_id) REFERENCES tfiles(id);


--
-- Name: tplans_pdf_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tplans
    ADD CONSTRAINT tplans_pdf_id_fkey FOREIGN KEY (pdf_id) REFERENCES tfiles(id);


--
-- Name: treferences_parent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY treferences
    ADD CONSTRAINT treferences_parent_id_fkey FOREIGN KEY (parent_id) REFERENCES treferences(id);


--
-- Name: trewrites_page_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY trewrites
    ADD CONSTRAINT trewrites_page_id_fkey FOREIGN KEY (page_id) REFERENCES tpages(id);


--
-- Name: troles_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY troles_l10n
    ADD CONSTRAINT troles_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES troles(id);


--
-- Name: troles_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY troles_l10n
    ADD CONSTRAINT troles_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tsensor_comment_images_comment_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_comment_images
    ADD CONSTRAINT tsensor_comment_images_comment_id_fkey FOREIGN KEY (comment_id) REFERENCES tsensor_comments(id);


--
-- Name: tsensor_comment_images_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_comment_images
    ADD CONSTRAINT tsensor_comment_images_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tsensor_comments_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_comments
    ADD CONSTRAINT tsensor_comments_sensor_id_fkey FOREIGN KEY (sensor_id) REFERENCES tsensors(id);


--
-- Name: tsensor_comments_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_comments
    ADD CONSTRAINT tsensor_comments_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tsensor_groups_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tfacility_groups
    ADD CONSTRAINT tsensor_groups_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tsensor_groups_group_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_groups
    ADD CONSTRAINT tsensor_groups_group_id_fkey FOREIGN KEY (group_id) REFERENCES tfacility_groups(id);


--
-- Name: tsensor_groups_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_groups
    ADD CONSTRAINT tsensor_groups_sensor_id_fkey FOREIGN KEY (sensor_id) REFERENCES tsensors(id);


--
-- Name: tsensor_model_measurers_sensor_model_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers
    ADD CONSTRAINT tsensor_model_measurers_sensor_model_id_fkey FOREIGN KEY (sensor_model_id) REFERENCES tsensor_models(id);


--
-- Name: tsensor_model_measurers_value_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_measurers
    ADD CONSTRAINT tsensor_model_measurers_value_type_id_fkey FOREIGN KEY (value_type_id) REFERENCES tmeasurer_value_types(id);


--
-- Name: tsensor_model_normatives_normative_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_normatives
    ADD CONSTRAINT tsensor_model_normatives_normative_id_fkey FOREIGN KEY (normative_id) REFERENCES tnormative_types(id);


--
-- Name: tsensor_model_normatives_sensor_model_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_model_normatives
    ADD CONSTRAINT tsensor_model_normatives_sensor_model_id_fkey FOREIGN KEY (sensor_model_id) REFERENCES tsensor_models(id);


--
-- Name: tsensor_photos_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_photos
    ADD CONSTRAINT tsensor_photos_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tsensor_photos_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_photos
    ADD CONSTRAINT tsensor_photos_sensor_id_fkey FOREIGN KEY (sensor_id) REFERENCES tsensors(id);


--
-- Name: tsensor_photos_user_cr_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_photos
    ADD CONSTRAINT tsensor_photos_user_cr_id_fkey FOREIGN KEY (user_cr_id) REFERENCES tusers(id);


--
-- Name: tsensor_values_allowed_value_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_values
    ADD CONSTRAINT tsensor_values_allowed_value_type_id_fkey FOREIGN KEY (allowed_value_type_id) REFERENCES tallowed_value_types(id);


--
-- Name: tsensor_values_braid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_values
    ADD CONSTRAINT tsensor_values_braid_id_fkey FOREIGN KEY (braid_id) REFERENCES tbraids(id);


--
-- Name: tsensor_values_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensor_values
    ADD CONSTRAINT tsensor_values_sensor_id_fkey FOREIGN KEY (sensor_id) REFERENCES tsensors(id);


--
-- Name: tsensors_allowed_model_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_allowed_model_type_id_fkey FOREIGN KEY (allowed_model_type_id) REFERENCES tallowed_model_types(id);


--
-- Name: tsensors_facility_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_facility_id_fkey FOREIGN KEY (facility_id) REFERENCES tfacilities(id);


--
-- Name: tsensors_image_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_image_id_fkey FOREIGN KEY (image_id) REFERENCES tfiles(id);


--
-- Name: tsensors_measurement_mode_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_measurement_mode_id_fkey FOREIGN KEY (measurement_mode_id) REFERENCES tmeasurement_modes(id);


--
-- Name: tsensors_pr_sensor_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_pr_sensor_id_fkey FOREIGN KEY (pr_sensor_id) REFERENCES tsensors(id);


--
-- Name: tsensors_state_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsensors
    ADD CONSTRAINT tsensors_state_id_fkey FOREIGN KEY (state_id) REFERENCES tsensor_states(id);


--
-- Name: tsexes_l10n_fid_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsexes_l10n
    ADD CONSTRAINT tsexes_l10n_fid_id_fkey FOREIGN KEY (fid_id) REFERENCES tsexes(id);


--
-- Name: tsexes_l10n_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsexes_l10n
    ADD CONSTRAINT tsexes_l10n_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: tsocial_network_account_friends_account_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_network_account_friends
    ADD CONSTRAINT tsocial_network_account_friends_account_id_fkey FOREIGN KEY (account_id) REFERENCES tsocial_network_accounts(id);


--
-- Name: tsocial_network_account_friends_avatar_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_network_account_friends
    ADD CONSTRAINT tsocial_network_account_friends_avatar_id_fkey FOREIGN KEY (avatar_id) REFERENCES tfiles(id);


--
-- Name: tsocial_network_account_friends_sex_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_network_account_friends
    ADD CONSTRAINT tsocial_network_account_friends_sex_id_fkey FOREIGN KEY (sex_id) REFERENCES tsexes(id);


--
-- Name: tsocial_network_accounts_network_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_network_accounts
    ADD CONSTRAINT tsocial_network_accounts_network_id_fkey FOREIGN KEY (network_id) REFERENCES tsocial_networks(id);


--
-- Name: tsocial_network_accounts_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tsocial_network_accounts
    ADD CONSTRAINT tsocial_network_accounts_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: ttemplate_places_place_type_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_places
    ADD CONSTRAINT ttemplate_places_place_type_id_fkey FOREIGN KEY (place_type_id) REFERENCES ttemplate_place_types(id);


--
-- Name: ttemplate_places_template_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_places
    ADD CONSTRAINT ttemplate_places_template_id_fkey FOREIGN KEY (template_id) REFERENCES ttemplates(id);


--
-- Name: ttemplate_places_templatewide_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_places_templatewide
    ADD CONSTRAINT ttemplate_places_templatewide_l10n_id_fkey FOREIGN KEY (l10n_id) REFERENCES tl10n(id);


--
-- Name: ttemplate_places_templatewide_medium_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_places_templatewide
    ADD CONSTRAINT ttemplate_places_templatewide_medium_id_fkey FOREIGN KEY (medium_id) REFERENCES tmediums(id);


--
-- Name: ttemplate_places_templatewide_place_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY ttemplate_places_templatewide
    ADD CONSTRAINT ttemplate_places_templatewide_place_id_fkey FOREIGN KEY (place_id) REFERENCES ttemplate_places(id);


--
-- Name: tuser_sessions_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tuser_sessions
    ADD CONSTRAINT tuser_sessions_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tuser_urls_anon_cookie_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tvisits
    ADD CONSTRAINT tuser_urls_anon_cookie_id_fkey FOREIGN KEY (anon_id) REFERENCES tanon_cookies(id);


--
-- Name: tuser_urls_user_agent_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tvisits
    ADD CONSTRAINT tuser_urls_user_agent_id_fkey FOREIGN KEY (user_agent_id) REFERENCES tuser_agents(id);


--
-- Name: tuser_urls_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tvisits
    ADD CONSTRAINT tuser_urls_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tusers_avatar_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_avatar_id_fkey FOREIGN KEY (avatar_id) REFERENCES tfiles(id);


--
-- Name: tusers_enrolled_role_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tusers_enrolled
    ADD CONSTRAINT tusers_enrolled_role_id_fkey FOREIGN KEY (role_id) REFERENCES troles(id);


--
-- Name: tusers_enrolled_user_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tusers_enrolled
    ADD CONSTRAINT tusers_enrolled_user_id_fkey FOREIGN KEY (user_id) REFERENCES tusers(id);


--
-- Name: tusers_prefer_l10n_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_prefer_l10n_id_fkey FOREIGN KEY (prefer_l10n_id) REFERENCES tl10n(id);


--
-- Name: tusers_sex_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tusers
    ADD CONSTRAINT tusers_sex_id_fkey FOREIGN KEY (sex_id) REFERENCES tsexes(id);


--
-- Name: tworksheets_spreadsheet_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: erp_gtm
--

ALTER TABLE ONLY tworksheets
    ADD CONSTRAINT tworksheets_spreadsheet_id_fkey FOREIGN KEY (spreadsheet_id) REFERENCES tspreadsheets(id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

