/**
 * Class: Gallery
 */
function Gallery(tag,start_index,options){
	
	var t = this;
	this.tag = tag;
	this.images = [];
	
	var cache = this.LS.get('images') || {};
	
	$(tag).closest('.images').find('img').each(function(){
	
		var url = this.src;
		var id = $(this).attr('data-id');
		var _loaded = cache[id];
		url = _loaded || url;
		t.images.push({
			id:id,
			src:this.src,			
			url:url,
			_loaded:_loaded
		});
	});
	
	this.start = start_index || 0;
	
	options = options || {};
	options.title = 'Просмотр изображений';
	
	this._no_load = options.no_load;
		
	this.init(options);
}

Gallery.prototype = new Page();

/**
 * Method: my_name
 */
Gallery.prototype.my_name = function(){
	return 'Gallery';
}

/**
 * Method: gen_layout_custom
 */
Gallery.prototype.gen_layout_custom = function(ret){
	ret.bottom = {
		buttons:[
			{ pos:100, name:"", cssclass:"button image forward", click:function(){ pager.fire('next'); } },
			{ pos:50, name:"", cssclass:"_counter" },
			{ pos:0, name:"", cssclass:"button back image", click:function(){ pager.fire('prev'); } }		 
		]	
	};
	return ret;
}

/**
 * Method: before_open
 */
Gallery.prototype.before_open = function(v){
	lnrr.images = this.images;
	lnrr._no_load = this._no_load;
}

/**
 * Method: after_page_added
 */
Gallery.prototype.after_page_added = function(){
	this['switch'](this.start);
}

/**
 * Method: go
 */
Gallery.prototype.go = function(index){
	$('.images .item',this.html).removeClass('A');
	$('.images .item',this.html).eq(index).addClass('A');
	this.refresh_counter();
}

/**
 * Method: refresh_counter
 */
Gallery.prototype.refresh_counter = function(){
	$('._counter',this.page).html((this.index+1)+'/'+this.images.length);
}

/**
 * Method: switch
 */
Gallery.prototype['switch'] = function(index){
	var l = $('.images .item',this.html).length;
	if (index>l-1) index = 0;
	if (index<0) index = l - 1;
	this.index = index;
	this.go(index);
}

/**
 * Method: next
 */
Gallery.prototype.next = function(index){
	this.inc(+1);	
}

/**
 * Method: prev
 */
Gallery.prototype.prev = function(index){
	this.inc(-1);
}

/**
 * Method: prev
 */
Gallery.prototype.inc = function(v){
	var index = ($('.images .item.A',this.html).index() || 0) + v;
	this['switch'](index); 
}

/**
 * Method: load_image
 */
Gallery.prototype.load_image = function(image){
	
	var t = this;
	
	this.save_image({
		id: 	image.id,
		url:	image.src,
	},function(){
		pager.add_object(new Gallery(t.tag, t.index, { page_index:pager.pages-1, no_load:t._no_load }));
	});
}